/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.impl.CsvImportExport;
import org.exoplatform.calendar.service.impl.ICalendarImportExport;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarServiceImpl
implements CalendarService,
Startable {
    public static final String ICALENDAR = "ICalendar(.ics)".intern();
    public static final String EXPORTEDCSV = "ExportedCsv(.csv)".intern();
    private RepositoryService repositorySerivce_;
    private JCRDataStorage storage_;
    private Map<String, CalendarImportExport> calendarImportExport_ = new LinkedHashMap<String, CalendarImportExport>();
    protected List<CalendarUpdateEventListener> listeners_ = new ArrayList<CalendarUpdateEventListener>(3);

    public CalendarServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
        this.calendarImportExport_.put(ICALENDAR, new ICalendarImportExport(this.storage_));
        this.calendarImportExport_.put(EXPORTEDCSV, new CsvImportExport(this.storage_));
    }

    @Override
    public List<CalendarCategory> getCategories(String username) throws Exception {
        return this.storage_.getCategories(username);
    }

    @Override
    public List<GroupCalendarData> getCalendarCategories(String username, boolean isShowAll) throws Exception {
        return this.storage_.getCalendarCategories(username, isShowAll);
    }

    @Override
    public CalendarCategory getCalendarCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.getCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public void saveCalendarCategory(String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        this.storage_.saveCalendarCategory(username, calendarCategory, isNew);
    }

    @Override
    public CalendarCategory removeCalendarCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.removeCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public Calendar getUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.getUserCalendar(username, calendarId);
    }

    @Override
    public List<Calendar> getUserCalendars(String username, boolean isShowAll) throws Exception {
        return this.storage_.getUserCalendars(username, isShowAll);
    }

    @Override
    public List<Calendar> getUserCalendarsByCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.getUserCalendarsByCategory(username, calendarCategoryId);
    }

    @Override
    public void saveUserCalendar(String username, Calendar calendar, boolean isNew) throws Exception {
        this.storage_.saveUserCalendar(username, calendar, isNew);
    }

    @Override
    public Calendar removeUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.removeUserCalendar(username, calendarId);
    }

    @Override
    public Calendar getGroupCalendar(String calendarId) throws Exception {
        return this.storage_.getGroupCalendar(calendarId);
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(String[] groupIds, boolean isShowAll, String username) throws Exception {
        return this.storage_.getGroupCalendars(groupIds, isShowAll, username);
    }

    @Override
    public void savePublicCalendar(Calendar calendar, boolean isNew, String username) throws Exception {
        this.storage_.savePublicCalendar(calendar, isNew, username);
    }

    @Override
    public Calendar removePublicCalendar(String calendarId) throws Exception {
        return this.storage_.removeGroupCalendar(calendarId);
    }

    @Override
    public List<EventCategory> getEventCategories(String username) throws Exception {
        return this.storage_.getEventCategories(username);
    }

    @Override
    public void saveEventCategory(String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.storage_.saveEventCategory(username, eventCategory, values, isNew);
    }

    @Override
    public void removeEventCategory(String username, String eventCategoryName) throws Exception {
        this.storage_.removeEventCategory(username, eventCategoryName);
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(String username, List<String> calendarIds) throws Exception {
        return this.storage_.getUserEventByCalendar(username, calendarIds);
    }

    @Override
    public List<CalendarEvent> getUserEvents(String username, EventQuery eventQuery) throws Exception {
        return this.storage_.getUserEvents(username, eventQuery);
    }

    @Override
    public void saveUserEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveUserEvent(username, calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removeUserEvent(String username, String calendarId, String eventId) throws Exception {
        return this.storage_.removeUserEvent(username, calendarId, eventId);
    }

    @Override
    public CalendarEvent getGroupEvent(String calendarId, String eventId) throws Exception {
        return this.storage_.getGroupEvent(calendarId, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(List<String> calendarIds) throws Exception {
        return this.storage_.getGroupEventByCalendar(calendarIds);
    }

    @Override
    public List<CalendarEvent> getPublicEvents(EventQuery eventQuery) throws Exception {
        return this.storage_.getPublicEvents(eventQuery);
    }

    @Override
    public void savePublicEvent(String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.savePublicEvent(calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removePublicEvent(String calendarId, String eventId) throws Exception {
        return this.storage_.removePublicEvent(calendarId, eventId);
    }

    @Override
    public CalendarImportExport getCalendarImportExports(String type) {
        return this.calendarImportExport_.get(type);
    }

    @Override
    public String[] getExportImportType() throws Exception {
        return this.calendarImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public void saveCalendarSetting(String username, CalendarSetting setting) throws Exception {
        this.storage_.saveCalendarSetting(username, setting);
    }

    @Override
    public CalendarSetting getCalendarSetting(String username) throws Exception {
        return this.storage_.getCalendarSetting(username);
    }

    @Override
    public int generateRss(String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateRss(username, calendarIds, rssData, this.calendarImportExport_.get(ICALENDAR));
    }

    @Override
    public int generateCalDav(String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateCalDav(username, calendarIds, rssData, this.calendarImportExport_.get(ICALENDAR));
    }

    @Override
    public List<FeedData> getFeeds(String username) throws Exception {
        return this.storage_.getFeeds(username);
    }

    @Override
    public Node getRssHome(String username) throws Exception {
        return this.storage_.getRssHome(username);
    }

    @Override
    public EventPageList searchEvent(String username, EventQuery query, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchEvent(username, query, publicCalendarIds);
    }

    @Override
    public EventCategory getEventCategory(String username, String eventCategoryId) throws Exception {
        return this.storage_.getEventCategory(username, eventCategoryId);
    }

    @Override
    public Map<Integer, String> searchHightLightEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchHightLightEvent(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void shareCalendar(String username, String calendarId, List<String> receiverUsers) throws Exception {
        this.storage_.shareCalendar(username, calendarId, receiverUsers);
    }

    @Override
    public GroupCalendarData getSharedCalendars(String username, boolean isShowAll) throws Exception {
        return this.storage_.getSharedCalendars(username, isShowAll);
    }

    @Override
    public List<CalendarEvent> getEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.getEvents(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void removeSharedCalendar(String username, String calendarId) throws Exception {
        this.storage_.removeSharedCalendar(username, calendarId);
    }

    @Override
    public void saveEventToSharedCalendar(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveEventToSharedCalendar(username, calendarId, event, isNew);
    }

    @Override
    public Map<String, String> checkFreeBusy(EventQuery eventQuery) throws Exception {
        return this.storage_.checkFreeBusy(eventQuery);
    }

    @Override
    public void saveSharedCalendar(String username, Calendar calendar) throws Exception {
        this.storage_.saveSharedCalendar(username, calendar);
    }

    @Override
    public void removeSharedEvent(String username, String calendarId, String eventId) throws Exception {
        this.storage_.removeSharedEvent(username, calendarId, eventId);
    }

    @Override
    public void moveEvent(String formCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        this.storage_.moveEvent(formCalendar, toCalendar, fromType, toType, calEvents, username);
    }

    @Override
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) throws Exception {
        this.storage_.confirmInvitation(fromUserId, toUserId, calType, calendarId, eventId, answer);
    }

    public void start() {
        for (CalendarUpdateEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(CalendarUpdateEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public Map<String, String> checkFreeBusy(SessionProvider systemSession, EventQuery eventQuery) throws Exception {
        return this.checkFreeBusy(eventQuery);
    }

    @Override
    public int generateCalDav(SessionProvider systemSession, String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.generateCalDav(username, calendarIds, rssData);
    }

    @Override
    public int generateRss(SessionProvider systemSession, String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.generateRss(username, calendarIds, rssData);
    }

    @Override
    public List<GroupCalendarData> getCalendarCategories(SessionProvider userSession, String username, boolean isShowAll) throws Exception {
        return this.getCalendarCategories(username, isShowAll);
    }

    @Override
    public CalendarCategory getCalendarCategory(SessionProvider userSession, String username, String calendarCategoryId) throws Exception {
        return this.getCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public CalendarSetting getCalendarSetting(SessionProvider userSession, String username) throws Exception {
        return this.getCalendarSetting(username);
    }

    @Override
    public List<CalendarCategory> getCategories(SessionProvider userSession, String username) throws Exception {
        return this.getCategories(username);
    }

    @Override
    public List<EventCategory> getEventCategories(SessionProvider userSession, String username) throws Exception {
        return this.getEventCategories(username);
    }

    @Override
    public EventCategory getEventCategory(SessionProvider userSession, String username, String eventCategoryId) throws Exception {
        return this.getEventCategory(username, eventCategoryId);
    }

    @Override
    public List<CalendarEvent> getEvents(SessionProvider userSession, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.getEvents(username, eventQuery, publicCalendarIds);
    }

    @Override
    public List<FeedData> getFeeds(SessionProvider systemSession, String username) throws Exception {
        return this.getFeeds(username);
    }

    @Override
    public Calendar getGroupCalendar(SessionProvider systemSession, String calendarId) throws Exception {
        return this.getGroupCalendar(calendarId);
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(SessionProvider systemSession, String[] groupIds, boolean isShowAll, String username) throws Exception {
        return this.getGroupCalendars(groupIds, isShowAll, username);
    }

    @Override
    public CalendarEvent getGroupEvent(SessionProvider systemSession, String calendarId, String eventId) throws Exception {
        return this.getGroupEvent(calendarId, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(SessionProvider systemSession, List<String> calendarIds) throws Exception {
        return this.getGroupEventByCalendar(calendarIds);
    }

    @Override
    public List<CalendarEvent> getPublicEvents(SessionProvider systemSession, EventQuery eventQuery) throws Exception {
        return this.getPublicEvents(eventQuery);
    }

    @Override
    public Node getRssHome(SessionProvider systemSession, String username) throws Exception {
        return this.getRssHome(username);
    }

    @Override
    public GroupCalendarData getSharedCalendars(SessionProvider systemSession, String username, boolean isShowAll) throws Exception {
        return this.getSharedCalendars(username, isShowAll);
    }

    @Override
    public Calendar getUserCalendar(SessionProvider userSession, String username, String calendarId) throws Exception {
        return this.getUserCalendar(username, calendarId);
    }

    @Override
    public List<Calendar> getUserCalendars(SessionProvider userSession, String username, boolean isShowAll) throws Exception {
        return this.getUserCalendars(username, isShowAll);
    }

    @Override
    public List<Calendar> getUserCalendarsByCategory(SessionProvider userSession, String username, String calendarCategoryId) throws Exception {
        return this.getUserCalendarsByCategory(username, calendarCategoryId);
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(SessionProvider userSession, String username, List<String> calendarIds) throws Exception {
        return this.getUserEventByCalendar(username, calendarIds);
    }

    @Override
    public List<CalendarEvent> getUserEvents(SessionProvider userSession, String username, EventQuery eventQuery) throws Exception {
        return this.getUserEvents(username, eventQuery);
    }

    @Override
    public void moveEvent(SessionProvider userSession, String formCalendar, String toCalendar, String formType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        this.moveEvent(formCalendar, toCalendar, formType, toType, calEvents, username);
    }

    @Override
    public CalendarCategory removeCalendarCategory(SessionProvider userSession, String username, String calendarCategoryId) throws Exception {
        return this.removeCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public void removeEventCategory(SessionProvider userSession, String username, String eventCategoryName) throws Exception {
        this.removeEventCategory(username, eventCategoryName);
    }

    @Override
    public Calendar removePublicCalendar(SessionProvider systemSession, String calendarId) throws Exception {
        return this.removePublicCalendar(calendarId);
    }

    @Override
    public CalendarEvent removePublicEvent(SessionProvider systemSession, String calendarId, String eventId) throws Exception {
        return this.removePublicEvent(calendarId, eventId);
    }

    @Override
    public void removeSharedCalendar(SessionProvider systemSesssion, String username, String calendarId) throws Exception {
        this.removeSharedCalendar(username, calendarId);
    }

    @Override
    public void removeSharedEvent(SessionProvider systemSession, String username, String calendarId, String eventId) throws Exception {
        this.removeSharedEvent(username, calendarId, eventId);
    }

    @Override
    public Calendar removeUserCalendar(SessionProvider userSession, String username, String calendarId) throws Exception {
        return this.removeUserCalendar(username, calendarId);
    }

    @Override
    public CalendarEvent removeUserEvent(SessionProvider userSession, String username, String calendarId, String eventId) throws Exception {
        return this.removeUserEvent(username, calendarId, eventId);
    }

    @Override
    public void saveCalendarCategory(SessionProvider userSession, String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        this.saveCalendarCategory(username, calendarCategory, isNew);
    }

    @Override
    public void saveCalendarSetting(SessionProvider userSession, String username, CalendarSetting setting) throws Exception {
        this.saveCalendarSetting(username, setting);
    }

    @Override
    public void saveEventCategory(SessionProvider userSession, String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.saveEventCategory(username, eventCategory, values, isNew);
    }

    @Override
    public void saveEventToSharedCalendar(SessionProvider systemSession, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.saveEventToSharedCalendar(username, calendarId, event, isNew);
    }

    @Override
    public void savePublicCalendar(SessionProvider systemSession, Calendar calendar, boolean isNew, String username) throws Exception {
        this.savePublicCalendar(calendar, isNew, username);
    }

    @Override
    public void savePublicEvent(SessionProvider systemSession, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.savePublicEvent(calendarId, event, isNew);
    }

    @Override
    public void saveSharedCalendar(SessionProvider systemSession, String username, Calendar calendar) throws Exception {
        this.saveSharedCalendar(username, calendar);
    }

    @Override
    public void saveUserCalendar(SessionProvider userSession, String username, Calendar calendar, boolean isNew) throws Exception {
        this.saveUserCalendar(username, calendar, isNew);
    }

    @Override
    public void saveUserEvent(SessionProvider userSession, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.saveUserEvent(username, calendarId, event, isNew);
    }

    @Override
    public EventPageList searchEvent(SessionProvider userSession, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.searchEvent(username, eventQuery, publicCalendarIds);
    }

    @Override
    public Map<Integer, String> searchHightLightEvent(SessionProvider userSession, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.searchHightLightEvent(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void shareCalendar(SessionProvider systemSession, String username, String calendarId, List<String> receiverUsers) throws Exception {
        this.shareCalendar(username, calendarId, receiverUsers);
    }
}

