/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private static final String CALENDARS = "calendars".intern();
    private static final String SHARED_CALENDAR = "sharedCalendars".intern();
    private static final String EVENTS = "events".intern();
    private static final String TASKS = "tasks".intern();
    private static final String CALENDAR_CATEGORIES = "categories".intern();
    private static final String FEED = "eXoCalendarFeed".intern();
    private static final String CALENDAR_GROUPS = "groups".intern();
    private static final String CALENDAR_EVENT = "events".intern();
    private static final String CALENDAR_SETTING = "calendarSetting".intern();
    private static final String EVENT_CATEGORIES = "eventCategories".intern();
    private static final String VALUE = "value".intern();
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    @Deprecated
    public Node getPublicCalendarServiceHome(SessionProvider sProvider) throws Exception {
        return this.getPublicCalendarServiceHome();
    }

    public Node getPublicCalendarServiceHome() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node publicApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return publicApp.getNode(Utils.CALENDAR_APP);
        }
        catch (Exception e) {
            Node calendarApp = publicApp.addNode(Utils.CALENDAR_APP, Utils.NT_UNSTRUCTURED);
            publicApp.getSession().save();
            return calendarApp;
        }
    }

    @Deprecated
    private Node getSharedCalendarHome(SessionProvider sProvider) throws Exception {
        return this.getSharedCalendarHome();
    }

    private Node getSharedCalendarHome() throws Exception {
        SessionProvider sProvider = this.createSessionProvider();
        Node calendarServiceHome = this.getPublicCalendarServiceHome(sProvider);
        try {
            return calendarServiceHome.getNode(SHARED_CALENDAR);
        }
        catch (Exception e) {
            Node sharedCal = calendarServiceHome.addNode(SHARED_CALENDAR, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return sharedCal;
        }
    }

    private Node getPublicRoot(SessionProvider sysProvider) throws Exception {
        return this.getPublicRoot();
    }

    private Node getPublicRoot() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        return this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
    }

    @Deprecated
    private Node getUserCalendarServiceHome(SessionProvider removeme, String username) throws Exception {
        return this.getUserCalendarServiceHome(username);
    }

    private Node getUserCalendarServiceHome(String username) throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username);
        try {
            return userApp.getNode(Utils.CALENDAR_APP);
        }
        catch (Exception e) {
            Node calendarRoot = userApp.addNode(Utils.CALENDAR_APP, Utils.NT_UNSTRUCTURED);
            if (!calendarRoot.hasNode(CALENDAR_SETTING)) {
                this.addCalendarSetting(calendarRoot, new CalendarSetting());
            }
            userApp.getSession().save();
            return calendarRoot;
        }
    }

    @Deprecated
    private Node getPublicCalendarHome(SessionProvider sProvider) throws Exception {
        return this.getPublicCalendarHome();
    }

    private Node getPublicCalendarHome() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node calendarServiceHome = this.getPublicCalendarServiceHome(sProvider);
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node cal = calendarServiceHome.addNode(CALENDARS, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return cal;
        }
    }

    private Node getUserCalendarHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node calendars = calendarServiceHome.addNode(CALENDARS, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return calendars;
        }
    }

    public Node getRssHome(String username) throws Exception {
        Node calendarServiceHome = this.getSharedCalendarHome();
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    private Node getCalDavHome() throws Exception {
        Node calendarServiceHome = this.getPublicCalendarHome();
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    protected Node getCalendarCategoryHome(SessionProvider sProvider, String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(CALENDAR_CATEGORIES);
        }
        catch (Exception e) {
            Node calCat = calendarServiceHome.addNode(CALENDAR_CATEGORIES, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return calCat;
        }
    }

    protected Node getEventCategoryHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(EVENT_CATEGORIES);
        }
        catch (Exception e) {
            Node eventCat = calendarServiceHome.addNode(EVENT_CATEGORIES, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return eventCat;
        }
    }

    public Calendar getUserCalendar(String username, String calendarId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        return this.getCalendar(new String[]{calendarId}, username, calendarNode, true);
    }

    public List<Calendar> getUserCalendars(String username, boolean isShowAll) throws Exception {
        NodeIterator iter = this.getUserCalendarHome(username).getNodes();
        ArrayList<Calendar> calList = new ArrayList<Calendar>();
        String[] defaultCalendars = null;
        if (this.getCalendarSetting(username) != null) {
            defaultCalendars = this.getCalendarSetting(username).getFilterPrivateCalendars();
        }
        while (iter.hasNext()) {
            calList.add(this.getCalendar(defaultCalendars, username, iter.nextNode(), isShowAll));
        }
        return calList;
    }

    public List<Calendar> getUserCalendarsByCategory(String username, String calendarCategoryId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:categoryId='").append(calendarCategoryId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        ArrayList<Calendar> calendares = new ArrayList<Calendar>();
        String[] defaultCalendars = null;
        if (this.getCalendarSetting(username) != null) {
            defaultCalendars = this.getCalendarSetting(username).getFilterPrivateCalendars();
        }
        while (it.hasNext()) {
            calendares.add(this.getCalendar(defaultCalendars, username, it.nextNode(), true));
        }
        return calendares;
    }

    public void saveUserCalendar(String username, Calendar calendar, boolean isNew) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getUserCalendarHome(username);
        if (isNew) {
            try {
                calendarNode = calendarHome.getNode(calendar.getId());
            }
            catch (Exception e) {
                calendarNode = calendarHome.addNode(calendar.getId(), Utils.EXO_CALENDAR);
                calendarNode.setProperty(Utils.EXO_ID, calendar.getId());
                if (calendar.isDataInit()) {
                    this.reparePermissions(calendarNode, username);
                }
            }
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        calendarNode.setProperty(Utils.EXO_NAME, calendar.getName());
        calendarNode.setProperty(Utils.EXO_DESCRIPTION, calendar.getDescription());
        calendarNode.setProperty(Utils.EXO_CATEGORY_ID, calendar.getCategoryId());
        calendarNode.setProperty(Utils.EXO_VIEW_PERMISSIONS, calendar.getViewPermission());
        calendarNode.setProperty(Utils.EXO_EDIT_PERMISSIONS, calendar.getEditPermission());
        calendarNode.setProperty(Utils.EXO_GROUPS, calendar.getGroups());
        calendarNode.setProperty(Utils.EXO_LOCALE, calendar.getLocale());
        calendarNode.setProperty(Utils.EXO_TIMEZONE, calendar.getTimeZone());
        calendarNode.setProperty(Utils.EXO_CALENDAR_COLOR, calendar.getCalendarColor());
        calendarNode.setProperty(Utils.EXO_CALENDAR_OWNER, calendar.getCalendarOwner());
        calendarHome.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar removeUserCalendar(String username, String calendarId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        if (calendarHome.hasNode(calendarId)) {
            Node calNode = calendarHome.getNode(calendarId);
            Calendar calendar = this.getCalendar(new String[]{calendarId}, username, calNode, true);
            NodeIterator iter = calNode.getNodes();
            SessionProvider provider = SessionProvider.createSystemProvider();
            try {
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    Node eventFolder = this.getEventFolder(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
                    this.syncRemoveEvent(eventFolder, eventNode.getName());
                    this.removeReminder(eventNode);
                }
                calNode.remove();
                calendarHome.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                provider.close();
            }
            try {
                this.removeFeed(username, calendarId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return calendar;
        }
        return null;
    }

    public Calendar getGroupCalendar(String calendarId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        return this.getCalendar(new String[]{calendarId}, null, calendarNode, true);
    }

    public List<GroupCalendarData> getGroupCalendars(String[] groupIds, boolean isShowAll, String username) throws Exception {
        Node calendarHome = this.getPublicCalendarHome();
        ArrayList<GroupCalendarData> groupCalendars = new ArrayList<GroupCalendarData>();
        String[] defaultCalendars = null;
        if (username != null && this.getCalendarSetting(username) != null) {
            defaultCalendars = this.getCalendarSetting(username).getFilterPublicCalendars();
        }
        for (String groupId : groupIds) {
            StringBuffer queryString;
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:groups='").append(groupId).append("']")).toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            if (!it.hasNext()) continue;
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            while (it.hasNext()) {
                Node calNode = it.nextNode();
                Calendar cal = this.getCalendar(defaultCalendars, null, calNode, isShowAll);
                if (cal == null) continue;
                calendars.add(cal);
            }
            groupCalendars.add(new GroupCalendarData(groupId, groupId, calendars));
        }
        return groupCalendars;
    }

    public void savePublicCalendar(Calendar calendar, boolean isNew, String username) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getPublicCalendarHome();
        if (isNew) {
            if (calendarHome.hasNode(calendar.getId())) {
                throw new Exception("This calendar is already exists");
            }
            calendarNode = calendarHome.addNode(calendar.getId(), Utils.EXO_CALENDAR);
            calendarNode.setProperty(Utils.EXO_ID, calendar.getId());
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        calendarNode.setProperty(Utils.EXO_NAME, calendar.getName());
        calendarNode.setProperty(Utils.EXO_DESCRIPTION, calendar.getDescription());
        calendarNode.setProperty(Utils.EXO_CATEGORY_ID, calendar.getCategoryId());
        calendarNode.setProperty(Utils.EXO_VIEW_PERMISSIONS, calendar.getViewPermission());
        calendarNode.setProperty(Utils.EXO_EDIT_PERMISSIONS, calendar.getEditPermission());
        calendarNode.setProperty(Utils.EXO_LOCALE, calendar.getLocale());
        calendarNode.setProperty(Utils.EXO_TIMEZONE, calendar.getTimeZone());
        calendarNode.setProperty(Utils.EXO_CALENDAR_OWNER, calendar.getCalendarOwner());
        calendarNode.setProperty(Utils.EXO_GROUPS, calendar.getGroups());
        calendarNode.setProperty(Utils.EXO_CALENDAR_COLOR, calendar.getCalendarColor());
        calendarHome.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar removeGroupCalendar(String calendarId) throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        try {
            Node calendarHome = this.getPublicCalendarHome(sProvider);
            if (calendarHome.hasNode(calendarId)) {
                Node calNode = calendarHome.getNode(calendarId);
                Calendar calendar = this.getCalendar(new String[]{calendarId}, null, calNode, true);
                NodeIterator iter = calNode.getNodes();
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    Node eventFolder = this.getEventFolder(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
                    this.removeReminder(eventNode);
                    this.syncRemoveEvent(eventFolder, eventNode.getName());
                }
                calNode.remove();
                calendarHome.getSession().save();
                try {
                    this.removeFeed(null, calendarId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Calendar calendar2 = calendar;
                return calendar2;
            }
            Calendar calendar = null;
            return calendar;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    private Calendar getCalendar(String[] defaultFilterCalendars, String username, Node calNode, boolean isShowAll) throws Exception {
        Calendar calendar = null;
        if (isShowAll) {
            calendar = new Calendar();
            if (calNode.hasProperty(Utils.EXO_ID)) {
                calendar.setId(calNode.getProperty(Utils.EXO_ID).getString());
            }
            if (calNode.hasProperty(Utils.EXO_NAME)) {
                calendar.setName(calNode.getProperty(Utils.EXO_NAME).getString());
            }
            if (calNode.hasProperty(Utils.EXO_DESCRIPTION)) {
                calendar.setDescription(calNode.getProperty(Utils.EXO_DESCRIPTION).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CATEGORY_ID)) {
                calendar.setCategoryId(calNode.getProperty(Utils.EXO_CATEGORY_ID).getString());
            }
            if (calNode.hasProperty(Utils.EXO_LOCALE)) {
                calendar.setLocale(calNode.getProperty(Utils.EXO_LOCALE).getString());
            }
            if (calNode.hasProperty(Utils.EXO_TIMEZONE)) {
                calendar.setTimeZone(calNode.getProperty(Utils.EXO_TIMEZONE).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CALENDAR_COLOR)) {
                calendar.setCalendarColor(calNode.getProperty(Utils.EXO_CALENDAR_COLOR).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CALENDAR_OWNER)) {
                calendar.setCalendarOwner(calNode.getProperty(Utils.EXO_CALENDAR_OWNER).getString());
            }
            if (!calendar.isPublic()) {
                if (calNode.hasProperty(Utils.EXO_GROUPS)) {
                    Value[] values = calNode.getProperty(Utils.EXO_GROUPS).getValues();
                    ArrayList<String> groups = new ArrayList<String>();
                    for (Value v : values) {
                        groups.add(v.getString());
                    }
                    calendar.setGroups(groups.toArray(new String[groups.size()]));
                }
                if (calNode.hasProperty(Utils.EXO_VIEW_PERMISSIONS)) {
                    Value[] viewValues = calNode.getProperty(Utils.EXO_VIEW_PERMISSIONS).getValues();
                    ArrayList<String> viewPerms = new ArrayList<String>();
                    for (Value v : viewValues) {
                        viewPerms.add(v.getString());
                    }
                    calendar.setViewPermission(viewPerms.toArray(new String[viewPerms.size()]));
                }
                if (calNode.hasProperty(Utils.EXO_EDIT_PERMISSIONS)) {
                    Value[] editValues = calNode.getProperty(Utils.EXO_EDIT_PERMISSIONS).getValues();
                    ArrayList<String> editPerms = new ArrayList<String>();
                    for (Value v : editValues) {
                        editPerms.add(v.getString());
                    }
                    calendar.setEditPermission(editPerms.toArray(new String[editPerms.size()]));
                }
            }
        } else if (defaultFilterCalendars == null || !Arrays.asList(defaultFilterCalendars).contains(calNode.getName())) {
            calendar = new Calendar();
            if (calNode.hasProperty(Utils.EXO_ID)) {
                calendar.setId(calNode.getProperty(Utils.EXO_ID).getString());
            }
            if (calNode.hasProperty(Utils.EXO_NAME)) {
                calendar.setName(calNode.getProperty(Utils.EXO_NAME).getString());
            }
            if (calNode.hasProperty(Utils.EXO_DESCRIPTION)) {
                calendar.setDescription(calNode.getProperty(Utils.EXO_DESCRIPTION).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CATEGORY_ID)) {
                calendar.setCategoryId(calNode.getProperty(Utils.EXO_CATEGORY_ID).getString());
            }
            if (calNode.hasProperty(Utils.EXO_LOCALE)) {
                calendar.setLocale(calNode.getProperty(Utils.EXO_LOCALE).getString());
            }
            if (calNode.hasProperty(Utils.EXO_TIMEZONE)) {
                calendar.setTimeZone(calNode.getProperty(Utils.EXO_TIMEZONE).getString());
            }
            if (calNode.hasProperty(Utils.EXO_SHARED_COLOR)) {
                calendar.setCalendarColor(calNode.getProperty(Utils.EXO_SHARED_COLOR).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CALENDAR_COLOR)) {
                calendar.setCalendarColor(calNode.getProperty(Utils.EXO_CALENDAR_COLOR).getString());
            }
            if (calNode.hasProperty(Utils.EXO_CALENDAR_OWNER)) {
                calendar.setCalendarOwner(calNode.getProperty(Utils.EXO_CALENDAR_OWNER).getString());
            }
            if (!calendar.isPublic()) {
                if (calNode.hasProperty(Utils.EXO_GROUPS)) {
                    Value[] values = calNode.getProperty(Utils.EXO_GROUPS).getValues();
                    ArrayList<String> groups = new ArrayList<String>();
                    for (Value v : values) {
                        groups.add(v.getString());
                    }
                    calendar.setGroups(groups.toArray(new String[groups.size()]));
                }
                if (calNode.hasProperty(Utils.EXO_VIEW_PERMISSIONS)) {
                    Value[] viewValues = calNode.getProperty(Utils.EXO_VIEW_PERMISSIONS).getValues();
                    ArrayList<String> viewPerms = new ArrayList<String>();
                    for (Value v : viewValues) {
                        viewPerms.add(v.getString());
                    }
                    calendar.setViewPermission(viewPerms.toArray(new String[viewPerms.size()]));
                }
                if (calNode.hasProperty(Utils.EXO_EDIT_PERMISSIONS)) {
                    Value[] editValues = calNode.getProperty(Utils.EXO_EDIT_PERMISSIONS).getValues();
                    ArrayList<String> editPerms = new ArrayList<String>();
                    for (Value v : editValues) {
                        editPerms.add(v.getString());
                    }
                    calendar.setEditPermission(editPerms.toArray(new String[editPerms.size()]));
                }
            }
        }
        return calendar;
    }

    public List<GroupCalendarData> getCalendarCategories(String username, boolean isShowAll) throws Exception {
        SessionProvider sProvider = this.createSessionProvider();
        Node calendarHome = this.getUserCalendarHome(username);
        NodeIterator iter = this.getCalendarCategoryHome(sProvider, username).getNodes();
        ArrayList<GroupCalendarData> calendarCategories = new ArrayList<GroupCalendarData>();
        calendarHome.getSession().refresh(false);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        String[] defaultCalendars = null;
        CalendarSetting calSetting = this.getCalendarSetting(username);
        if (calSetting != null) {
            defaultCalendars = calSetting.getFilterPrivateCalendars();
        }
        while (iter.hasNext()) {
            Node categoryNode = iter.nextNode();
            String categoryId = categoryNode.getProperty(Utils.EXO_ID).getString();
            StringBuffer queryString = new StringBuffer("/jcr:root" + calendarHome.getPath() + "//element(*,exo:calendar)[@exo:categoryId='").append(categoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Calendar cal = this.getCalendar(defaultCalendars, username, it.nextNode(), isShowAll);
                    if (cal == null) continue;
                    calendars.add(cal);
                }
            }
            calendarCategories.add(new GroupCalendarData(categoryId, categoryNode.getProperty(Utils.EXO_NAME).getString(), calendars));
        }
        return calendarCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarCategory> getCategories(String username) throws Exception {
        SessionProvider sProvider = this.createSessionProvider();
        try {
            Node calendarCategoryHome = this.getCalendarCategoryHome(sProvider, username);
            NodeIterator iter = calendarCategoryHome.getNodes();
            ArrayList<CalendarCategory> calendarCategories = new ArrayList<CalendarCategory>();
            while (iter.hasNext()) {
                calendarCategories.add(this.getCalendarCategory(iter.nextNode()));
            }
            ArrayList<CalendarCategory> arrayList = calendarCategories;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    public CalendarCategory getCalendarCategory(String username, String calendarCategoryId) throws Exception {
        Node calendarCategoryHome = this.getCalendarCategoryHome(null, username);
        return this.getCalendarCategory(calendarCategoryHome.getNode(calendarCategoryId));
    }

    public void saveCalendarCategory(String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        Node calCategoryNode;
        Node calCategoryHome = this.getCalendarCategoryHome(null, username);
        if (isNew) {
            if (calCategoryHome.hasNode(calendarCategory.getId())) {
                throw new Exception("This calendar category is already exists! ");
            }
            calCategoryNode = calCategoryHome.addNode(calendarCategory.getId(), Utils.EXO_CALENDAR_CATEGORY);
            calCategoryNode.setProperty(Utils.EXO_ID, calendarCategory.getId());
            if (calendarCategory.isDataInit()) {
                this.reparePermissions(calCategoryNode, username);
            }
        } else {
            calCategoryNode = calCategoryHome.getNode(calendarCategory.getId());
        }
        calCategoryNode.setProperty(Utils.EXO_NAME, calendarCategory.getName());
        calCategoryNode.setProperty(Utils.EXO_DESCRIPTION, calendarCategory.getDescription());
        this.reparePermissions(calCategoryHome, username);
        calCategoryHome.getSession().save();
    }

    private void reparePermissions(Node node, String owner) throws Exception {
    }

    public CalendarCategory removeCalendarCategory(String username, String calendarCategoryId) throws Exception {
        Node calCategoryHome = this.getCalendarCategoryHome(null, username);
        Node calCategoryNode = calCategoryHome.getNode(calendarCategoryId);
        CalendarCategory calCategory = this.getCalendarCategory(calCategoryNode);
        calCategoryNode.remove();
        for (Calendar cal : this.getUserCalendarsByCategory(username, calendarCategoryId)) {
            this.removeUserCalendar(username, cal.getId());
        }
        calCategoryHome.save();
        calCategoryHome.getSession().save();
        return calCategory;
    }

    private CalendarCategory getCalendarCategory(Node calCategoryNode) throws Exception {
        CalendarCategory calCategory = new CalendarCategory();
        if (calCategoryNode.hasProperty(Utils.EXO_ID)) {
            calCategory.setId(calCategoryNode.getProperty(Utils.EXO_ID).getString());
        }
        if (calCategoryNode.hasProperty(Utils.EXO_NAME)) {
            calCategory.setName(calCategoryNode.getProperty(Utils.EXO_NAME).getString());
        }
        if (calCategoryNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            calCategory.setDescription(calCategoryNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        return calCategory;
    }

    public List<EventCategory> getEventCategories(String username) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        NodeIterator iter = eventCategoryHome.getNodes();
        ArrayList<EventCategory> categories = new ArrayList<EventCategory>();
        while (iter.hasNext()) {
            categories.add(this.getEventCategory(iter.nextNode()));
        }
        return categories;
    }

    public void saveEventCategory(String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        Node eventCategoryNode = null;
        if (isNew) {
            NodeIterator iter = eventCategoryHome.getNodes();
            while (iter.hasNext()) {
                Node eCategiryNode = iter.nextNode();
                if (!eventCategory.getName().trim().equalsIgnoreCase(eCategiryNode.getProperty(Utils.EXO_NAME).getString().trim())) continue;
                throw new ItemExistsException();
            }
            eventCategoryNode = eventCategoryHome.addNode(eventCategory.getId(), Utils.EXO_EVENT_CATEGORY);
            if (eventCategory.isDataInit()) {
                this.reparePermissions(eventCategoryNode, username);
            }
        } else {
            NodeIterator iter = eventCategoryHome.getNodes();
            while (iter.hasNext()) {
                Node eCategiryNode = iter.nextNode();
                if (eCategiryNode.getName().equalsIgnoreCase(eventCategory.getId()) || !eventCategory.getName().trim().equalsIgnoreCase(eCategiryNode.getProperty(Utils.EXO_NAME).getString().trim())) continue;
                throw new ItemExistsException();
            }
            eventCategoryNode = eventCategoryHome.getNode(eventCategory.getId());
            Node calendarHome = this.getUserCalendarHome(username);
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            NodeIterator calIter = calendarHome.getNodes();
            while (calIter.hasNext()) {
                StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategory.getId()).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Node eventNode = it.nextNode();
                    eventNode.setProperty(Utils.EXO_EVENT_CATEGORY_NAME, eventCategory.getName());
                }
            }
            if (this.getSharedCalendarHome().hasNode(username)) {
                PropertyIterator iterPro = this.getSharedCalendarHome().getNode(username).getReferences();
                while (iterPro.hasNext()) {
                    try {
                        Node calendar = iterPro.nextProperty().getParent();
                        NodeIterator it = calendar.getNodes();
                        while (it.hasNext()) {
                            Node eventNode = it.nextNode();
                            if (!eventNode.getProperty(Utils.EXO_EVENT_CATEGORYID).getString().equals(eventCategory.getId())) continue;
                            eventNode.setProperty(Utils.EXO_EVENT_CATEGORY_NAME, eventCategory.getName());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        eventCategoryNode.setProperty(Utils.EXO_ID, eventCategory.getId());
        eventCategoryNode.setProperty(Utils.EXO_NAME, eventCategory.getName());
        eventCategoryNode.setProperty(Utils.EXO_DESCRIPTION, eventCategory.getDescription());
        eventCategoryHome.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventCategory(String username, String eventCategoryName) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        if (eventCategoryHome.hasNode(eventCategoryName)) {
            Node eventCategoryNode = eventCategoryHome.getNode(eventCategoryName);
            for (CalendarEvent ce : this.getUserEventByCategory(username, eventCategoryName)) {
                this.removeUserEvent(username, ce.getCalendarId(), ce.getId());
            }
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            try {
                for (CalendarEvent ce : this.getSharedEventByCategory(username, eventCategoryName)) {
                    this.removeSharedEvent(username, ce.getCalendarId(), ce.getId());
                }
                for (CalendarEvent ce : this.getPublicEventByCategory(username, eventCategoryName)) {
                    this.removePublicEvent(ce.getCalendarId(), ce.getId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                systemSession.close();
            }
            eventCategoryNode.remove();
            eventCategoryHome.save();
            eventCategoryHome.getSession().save();
        }
    }

    private EventCategory getEventCategory(Node eventCatNode) throws Exception {
        EventCategory eventCategory = new EventCategory();
        if (eventCatNode.hasProperty(Utils.EXO_ID)) {
            eventCategory.setId(eventCatNode.getProperty(Utils.EXO_ID).getString());
        }
        if (eventCatNode.hasProperty(Utils.EXO_NAME)) {
            eventCategory.setName(eventCatNode.getProperty(Utils.EXO_NAME).getString());
        }
        if (eventCatNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            eventCategory.setDescription(eventCatNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        return eventCategory;
    }

    public EventCategory getEventCategory(String username, String eventCategoryName) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        return this.getEventCategory(eventCategoryHome.getNode(eventCategoryName));
    }

    public CalendarEvent getUserEvent(String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        return this.getEvent(calendarNode.getNode(eventId));
    }

    public List<CalendarEvent> getUserEventByCalendar(String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(it.nextNode()));
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CalendarEvent> getPublicEventByCategory(String username, String eventCategoryId) throws Exception {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        Node publicCalendarHome = this.getPublicCalendarHome(systemSession);
        QueryManager qm = publicCalendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        try {
            NodeIterator calIter = publicCalendarHome.getNodes();
            while (calIter.hasNext()) {
                StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    events.add(this.getEvent(it.nextNode()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CalendarEvent> getSharedEventByCategory(String username, String eventCategoryId) throws Exception {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        try {
            if (this.getSharedCalendarHome(systemSession).hasNode(username)) {
                PropertyIterator iterPro = this.getSharedCalendarHome(systemSession).getNode(username).getReferences();
                while (iterPro.hasNext()) {
                    try {
                        Node calendar = iterPro.nextProperty().getParent();
                        NodeIterator it = calendar.getNodes();
                        while (it.hasNext()) {
                            Node eventNode = it.nextNode();
                            if (!eventNode.getProperty(Utils.EXO_EVENT_CATEGORYID).getString().equals(eventCategoryId)) continue;
                            events.add(this.getEvent(eventNode));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        return events;
    }

    public List<CalendarEvent> getUserEventByCategory(String username, String eventCategoryId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        NodeIterator calIter = calendarHome.getNodes();
        while (calIter.hasNext()) {
            StringBuffer queryString = new StringBuffer("/jcr:root" + calIter.nextNode().getPath() + "//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(it.nextNode()));
            }
        }
        return events;
    }

    public List<CalendarEvent> getUserEvents(String username, EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        eventQuery.setCalendarPath(calendarHome.getPath());
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.getEvent(it.nextNode());
            calEvent.setCalType(String.valueOf(0));
            events.add(calEvent);
            if (eventQuery.getLimitedItems() != it.getPosition()) continue;
            break;
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        if (event.getReminders() != null && event.getReminders().size() > 0) {
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            try {
                Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                this.saveEvent(calendarNode, event, reminderFolder, isNew);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                systemSession.close();
            }
        } else {
            this.saveEvent(calendarNode, event, null, isNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarEvent removeUserEvent(String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            Node eventNode = calendarNode.getNode(eventId);
            CalendarEvent event = this.getEvent(eventNode);
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            try {
                Node eventFolder = this.getEventFolder(systemSession, event.getFromDateTime());
                this.syncRemoveEvent(eventFolder, event.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                systemSession.close();
            }
            this.removeReminder(eventNode);
            eventNode.remove();
            calendarNode.save();
            calendarNode.getSession().save();
            calendarNode.refresh(true);
            return event;
        }
        return null;
    }

    private void removeReminder(Node eventNode) throws Exception {
        if (eventNode.hasProperty(Utils.EXO_FROM_DATE_TIME)) {
            SessionProvider systemSession = this.createSystemProvider();
            try {
                Node reminders = this.getReminderFolder(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
                try {
                    reminders.getNode(eventNode.getName()).remove();
                    reminders.save();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Node events = reminders.getParent().getNode(Utils.CALENDAR_REMINDER);
                if (events != null && events.hasNode(eventNode.getName()) && events.hasNode(eventNode.getName())) {
                    events.getNode(eventNode.getName()).remove();
                    if (!reminders.isNew()) {
                        reminders.save();
                    } else {
                        reminders.getSession().save();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CalendarEvent getGroupEvent(String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        CalendarEvent calEvent = this.getEvent(calendarNode.getNode(eventId));
        calEvent.setCalType(String.valueOf(2));
        return calEvent;
    }

    public List<CalendarEvent> getGroupEventByCalendar(List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(it.nextNode()));
            }
        }
        return events;
    }

    public List<CalendarEvent> getPublicEvents(EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getPublicCalendarHome();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        eventQuery.setCalendarPath(calendarHome.getPath());
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.getEvent(it.nextNode());
            calEvent.setCalType(String.valueOf(2));
            events.add(calEvent);
            if (eventQuery.getLimitedItems() != it.getPosition()) continue;
            break;
        }
        return events;
    }

    public void savePublicEvent(String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
        this.saveEvent(calendarNode, event, reminderFolder, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarEvent removePublicEvent(String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            Node eventNode = calendarNode.getNode(eventId);
            CalendarEvent event = this.getEvent(eventNode);
            this.removeReminder(eventNode);
            eventNode.remove();
            calendarNode.save();
            calendarNode.getSession().save();
            calendarNode.refresh(true);
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            try {
                Node eventFolder = this.getEventFolder(systemSession, event.getFromDateTime());
                this.syncRemoveEvent(eventFolder, eventId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                systemSession.close();
            }
            return event;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalendarEvent getEvent(Node eventNode) throws Exception {
        int i;
        Value[] values;
        CalendarEvent event = new CalendarEvent();
        if (eventNode.hasProperty(Utils.EXO_ID)) {
            event.setId(eventNode.getProperty(Utils.EXO_ID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_CALENDAR_ID)) {
            event.setCalendarId(eventNode.getProperty(Utils.EXO_CALENDAR_ID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_SUMMARY)) {
            event.setSummary(eventNode.getProperty(Utils.EXO_SUMMARY).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_CATEGORYID)) {
            event.setEventCategoryId(eventNode.getProperty(Utils.EXO_EVENT_CATEGORYID).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_CATEGORY_NAME)) {
            event.setEventCategoryName(eventNode.getProperty(Utils.EXO_EVENT_CATEGORY_NAME).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_LOCATION)) {
            event.setLocation(eventNode.getProperty(Utils.EXO_LOCATION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_TASK_DELEGATOR)) {
            event.setTaskDelegator(eventNode.getProperty(Utils.EXO_TASK_DELEGATOR).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_REPEAT)) {
            event.setRepeatType(eventNode.getProperty(Utils.EXO_REPEAT).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            event.setDescription(eventNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_FROM_DATE_TIME)) {
            event.setFromDateTime(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
        }
        if (eventNode.hasProperty(Utils.EXO_TO_DATE_TIME)) {
            event.setToDateTime(eventNode.getProperty(Utils.EXO_TO_DATE_TIME).getDate().getTime());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_TYPE)) {
            event.setEventType(eventNode.getProperty(Utils.EXO_EVENT_TYPE).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_PRIORITY)) {
            event.setPriority(eventNode.getProperty(Utils.EXO_PRIORITY).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_IS_PRIVATE)) {
            event.setPrivate(eventNode.getProperty(Utils.EXO_IS_PRIVATE).getBoolean());
        }
        if (eventNode.hasProperty(Utils.EXO_EVENT_STATE)) {
            event.setEventState(eventNode.getProperty(Utils.EXO_EVENT_STATE).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_SEND_OPTION)) {
            event.setSendOption(eventNode.getProperty(Utils.EXO_SEND_OPTION).getString());
        }
        if (eventNode.hasProperty(Utils.EXO_MESSAGE)) {
            event.setMessage(eventNode.getProperty(Utils.EXO_MESSAGE).getString());
        }
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            event.setReminders(this.getReminders(eventNode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        event.setAttachment(this.getAttachments(eventNode));
        if (eventNode.hasProperty(Utils.EXO_INVITATION)) {
            values = eventNode.getProperty(Utils.EXO_INVITATION).getValues();
            if (values.length == 1) {
                event.setInvitation(new String[]{values[0].getString()});
            } else {
                String[] invites = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    invites[i] = values[i].getString();
                }
                event.setInvitation(invites);
            }
        }
        if (eventNode.hasProperty(Utils.EXO_PARTICIPANT)) {
            values = eventNode.getProperty(Utils.EXO_PARTICIPANT).getValues();
            if (values.length == 1) {
                event.setParticipant(new String[]{values[0].getString()});
            } else {
                String[] participant = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participant[i] = values[i].getString();
                }
                event.setParticipant(participant);
            }
        }
        if (eventNode.hasProperty(Utils.EXO_PARTICIPANT_STATUS)) {
            values = eventNode.getProperty(Utils.EXO_PARTICIPANT_STATUS).getValues();
            if (values.length == 1) {
                event.setParticipantStatus(new String[]{values[0].getString()});
            } else {
                String[] participantStatus = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    participantStatus[i] = values[i].getString();
                }
                event.setParticipantStatus(participantStatus);
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEvent(Node calendarNode, CalendarEvent event, Node reminderFolder, boolean isNew) throws Exception {
        List<Attachment> attachments;
        Node eventNode;
        if (isNew) {
            eventNode = calendarNode.addNode(event.getId(), Utils.EXO_CALENDAR_EVENT);
            eventNode.setProperty(Utils.EXO_ID, event.getId());
        } else {
            try {
                eventNode = calendarNode.getNode(event.getId());
            }
            catch (Exception e) {
                eventNode = calendarNode.addNode(event.getId(), Utils.EXO_CALENDAR_EVENT);
                eventNode.setProperty(Utils.EXO_ID, event.getId());
            }
            SessionProvider systemSession = SessionProvider.createSystemProvider();
            try {
                this.removeReminder(eventNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                systemSession.close();
            }
        }
        eventNode.setProperty(Utils.EXO_SUMMARY, event.getSummary());
        eventNode.setProperty(Utils.EXO_CALENDAR_ID, event.getCalendarId());
        eventNode.setProperty(Utils.EXO_EVENT_CATEGORYID, event.getEventCategoryId());
        eventNode.setProperty(Utils.EXO_EVENT_CATEGORY_NAME, event.getEventCategoryName());
        eventNode.setProperty(Utils.EXO_DESCRIPTION, event.getDescription());
        eventNode.setProperty(Utils.EXO_LOCATION, event.getLocation());
        eventNode.setProperty(Utils.EXO_TASK_DELEGATOR, event.getTaskDelegator());
        GregorianCalendar dateTime = Utils.getInstanceTempCalendar();
        dateTime.setTime(event.getFromDateTime());
        eventNode.setProperty(Utils.EXO_FROM_DATE_TIME, (java.util.Calendar)dateTime);
        dateTime.setTime(event.getToDateTime());
        eventNode.setProperty(Utils.EXO_TO_DATE_TIME, (java.util.Calendar)dateTime);
        eventNode.setProperty(Utils.EXO_EVENT_TYPE, event.getEventType());
        eventNode.setProperty(Utils.EXO_REPEAT, event.getRepeatType());
        eventNode.setProperty(Utils.EXO_PRIORITY, event.getPriority());
        eventNode.setProperty(Utils.EXO_IS_PRIVATE, event.isPrivate());
        eventNode.setProperty(Utils.EXO_EVENT_STATE, event.getEventState());
        if (event.getInvitation() == null) {
            event.setInvitation(new String[0]);
        }
        eventNode.setProperty(Utils.EXO_INVITATION, event.getInvitation());
        if (event.getParticipant() == null) {
            event.setParticipant(new String[0]);
        }
        eventNode.setProperty(Utils.EXO_PARTICIPANT, event.getParticipant());
        List<Reminder> reminders = event.getReminders();
        if (reminders != null && !reminders.isEmpty()) {
            for (Reminder rm : reminders) {
                rm.setFromDateTime(event.getFromDateTime());
                this.addReminder(eventNode, reminderFolder, rm);
            }
        }
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            while (eventNode.getNodes().hasNext()) {
                eventNode.getNodes().nextNode().remove();
            }
            eventNode.save();
        }
        if ((attachments = event.getAttachment()) != null) {
            for (Attachment att : attachments) {
                this.addAttachment(eventNode, att, isNew);
            }
        }
        eventNode.setProperty(Utils.EXO_MESSAGE, event.getMessage());
        eventNode.setProperty(Utils.EXO_SEND_OPTION, event.getSendOption());
        if (event.getParticipantStatus() == null) {
            event.setParticipantStatus(new String[0]);
        }
        eventNode.setProperty(Utils.EXO_PARTICIPANT_STATUS, event.getParticipantStatus());
        calendarNode.getSession().save();
        this.addEvent(event);
    }

    private void addReminder(Node eventNode, Node reminderFolder, Reminder reminder) throws Exception {
        Node reminderNode;
        Node catNode;
        try {
            catNode = reminderFolder.getNode(eventNode.getName());
        }
        catch (Exception e) {
            catNode = reminderFolder.addNode(eventNode.getName(), Utils.NT_UNSTRUCTURED);
        }
        try {
            reminderNode = catNode.getNode(reminder.getId());
        }
        catch (Exception e) {
            reminderNode = catNode.addNode(reminder.getId(), Utils.EXO_REMINDER);
        }
        reminderNode.setProperty(Utils.EXO_EVENT_ID, eventNode.getName());
        reminderNode.setProperty(Utils.EXO_ALARM_BEFORE, reminder.getAlarmBefore());
        reminderNode.setProperty(Utils.EXO_TIME_INTERVAL, reminder.getRepeatInterval());
        reminderNode.setProperty(Utils.EXO_REMINDER_TYPE, reminder.getReminderType());
        reminderNode.setProperty(Utils.EXO_EMAIL, reminder.getEmailAddress());
        reminderNode.setProperty(Utils.EXO_IS_REPEAT, reminder.isRepeat());
        reminderNode.setProperty(Utils.EXO_IS_OVER, false);
        if (reminder.getReminderType().equals(Reminder.TYPE_POPUP)) {
            reminderNode.setProperty(Utils.EXO_OWNER, reminder.getReminderOwner());
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (reminder.getFromDateTime() != null) {
            cal.setTime(reminder.getFromDateTime());
            reminderNode.setProperty(Utils.EXO_FROM_DATE_TIME, (java.util.Calendar)cal);
            long time = reminder.getFromDateTime().getTime() - reminder.getAlarmBefore() * 60L * 1000L;
            cal = new GregorianCalendar();
            cal.setTimeInMillis(time);
            reminderNode.setProperty(Utils.EXO_REMINDER_DATE, (java.util.Calendar)cal);
        }
        StringBuffer summary = new StringBuffer("Type      : ");
        summary.append(eventNode.getProperty(Utils.EXO_EVENT_TYPE).getString()).append("<br>");
        summary.append("Summary: ");
        summary.append(eventNode.getProperty(Utils.EXO_SUMMARY).getString()).append("<br>");
        summary.append("Description: ");
        if (eventNode.hasProperty(Utils.EXO_DESCRIPTION)) {
            summary.append(eventNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        summary.append("<br>");
        summary.append("Location   : ");
        if (eventNode.hasProperty(Utils.EXO_LOCATION)) {
            summary.append(eventNode.getProperty(Utils.EXO_LOCATION).getString());
        }
        summary.append("<br>");
        cal.setTime(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
        summary.append("From       : ").append(cal.get(11)).append(":");
        summary.append(cal.get(12)).append(" - ");
        summary.append(cal.get(5)).append("/");
        summary.append(cal.get(2) + 1).append("/");
        summary.append(cal.get(1)).append("<br>");
        cal.setTime(eventNode.getProperty(Utils.EXO_TO_DATE_TIME).getDate().getTime());
        summary.append("To         : ").append(cal.get(11)).append(":");
        summary.append(cal.get(12)).append(" - ");
        summary.append(cal.get(5)).append("/");
        summary.append(cal.get(2) + 1).append("/");
        summary.append(cal.get(1)).append("<br>");
        reminderNode.setProperty(Utils.EXO_DESCRIPTION, summary.toString());
        reminderNode.setProperty(Utils.EXO_SUMMARY, eventNode.getProperty(Utils.EXO_SUMMARY).getString());
        if (!reminderFolder.isNew()) {
            reminderFolder.save();
        } else {
            reminderFolder.getSession().save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(CalendarEvent event) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node eventFolder = this.getEventFolder(provider, event.getFromDateTime());
        this.syncRemoveEvent(eventFolder, event.getId());
        CalendarEvent ev = new CalendarEvent();
        Node publicEvent = eventFolder.addNode(ev.getId(), Utils.EXO_CALENDAR_PUBLIC_EVENT);
        publicEvent.setProperty(Utils.EXO_ID, ev.getId());
        publicEvent.setProperty(Utils.EXO_ROOT_EVENT_ID, event.getId());
        publicEvent.setProperty(Utils.EXO_EVENT_TYPE, event.getEventType());
        publicEvent.setProperty(Utils.EXO_CALENDAR_ID, event.getCalendarId());
        GregorianCalendar dateTime = Utils.getInstanceTempCalendar();
        dateTime.setTime(event.getFromDateTime());
        int fromDate = dateTime.get(6);
        publicEvent.setProperty(Utils.EXO_FROM_DATE_TIME, (java.util.Calendar)dateTime);
        publicEvent.setProperty(Utils.EXO_EVENT_STATE, event.getEventState());
        dateTime.setTime(event.getToDateTime());
        int toDate = dateTime.get(6);
        if (toDate > fromDate) {
            GregorianCalendar tmpTime = Utils.getInstanceTempCalendar();
            tmpTime.setTime(event.getFromDateTime());
            tmpTime.set(11, 0);
            tmpTime.set(12, 0);
            tmpTime.set(13, 0);
            tmpTime.set(14, 0);
            tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() + 86400000L - 1000L);
            publicEvent.setProperty(Utils.EXO_TO_DATE_TIME, (java.util.Calendar)tmpTime);
        } else {
            publicEvent.setProperty(Utils.EXO_TO_DATE_TIME, (java.util.Calendar)dateTime);
        }
        publicEvent.setProperty(Utils.EXO_PARTICIPANT, event.getParticipant());
        try {
            if (!eventFolder.isNew()) {
                eventFolder.save();
            } else {
                eventFolder.getSession().save();
            }
        }
        catch (Exception e) {
            eventFolder.getSession().refresh(true);
            eventFolder.getSession().save();
            e.printStackTrace();
        }
        finally {
            provider.close();
        }
        try {
            provider = SessionProvider.createSystemProvider();
            if (toDate > fromDate) {
                GregorianCalendar cal = Utils.getInstanceTempCalendar();
                cal.setTime(event.getFromDateTime());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                for (int i = fromDate + 1; i <= toDate; ++i) {
                    ((java.util.Calendar)cal).roll(6, true);
                    Node dateFolder = this.getEventFolder(provider, cal.getTime());
                    ev = new CalendarEvent();
                    eventFolder.getSession().getWorkspace().copy(publicEvent.getPath(), dateFolder.getPath() + Utils.SLASH + ev.getId());
                    dateFolder.getSession().save();
                    if (i > toDate) continue;
                    Node newEvent = dateFolder.getNode(ev.getId());
                    newEvent.setProperty(Utils.EXO_ID, ev.getId());
                    newEvent.setProperty(Utils.EXO_FROM_DATE_TIME, (java.util.Calendar)cal);
                    GregorianCalendar tmpCal = Utils.getInstanceTempCalendar();
                    if (i == toDate) {
                        tmpCal.setTime(event.getToDateTime());
                    } else {
                        tmpCal.setTimeInMillis(cal.getTimeInMillis() + 86400000L - 1000L);
                    }
                    newEvent.setProperty(Utils.EXO_TO_DATE_TIME, (java.util.Calendar)tmpCal);
                    newEvent.save();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            provider.close();
        }
    }

    private void syncRemoveEvent(Node eventFolder, String rootEventId) throws Exception {
        QueryManager qm = eventFolder.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + eventFolder.getParent().getParent().getParent().getPath() + "//element(*,exo:calendarPublicEvent)[@exo:rootEventId='").append(rootEventId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            it.nextNode().remove();
        }
        eventFolder.getSession().save();
        eventFolder.refresh(true);
    }

    private Node getReminderFolder(Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(Utils.CALENDAR_REMINDER);
        }
        catch (Exception e) {
            dateFolder.addNode(Utils.CALENDAR_REMINDER, Utils.NT_UNSTRUCTURED);
            if (dateFolder.isNew()) {
                dateFolder.getSession().save();
            } else {
                dateFolder.save();
            }
            return dateFolder.getNode(Utils.CALENDAR_REMINDER);
        }
    }

    private Node getEventFolder(SessionProvider provider, Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(CALENDAR_EVENT);
        }
        catch (Exception e) {
            dateFolder.addNode(CALENDAR_EVENT, Utils.NT_UNSTRUCTURED);
            this.getPublicRoot(provider).getSession().save();
            return dateFolder.getNode(CALENDAR_EVENT);
        }
    }

    private Node getEventFolder(Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(CALENDAR_EVENT);
        }
        catch (Exception e) {
            dateFolder.addNode(CALENDAR_EVENT, Utils.NT_UNSTRUCTURED);
            this.getPublicRoot().getSession().save();
            return dateFolder.getNode(CALENDAR_EVENT);
        }
    }

    private Node getDateFolder(Node publicApp, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        GregorianCalendar fromCalendar = new GregorianCalendar();
        fromCalendar.setTime(date);
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        try {
            yearNode = publicApp.getNode(year);
        }
        catch (Exception e) {
            yearNode = publicApp.addNode(year, Utils.NT_UNSTRUCTURED);
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (Exception e) {
            monthNode = yearNode.addNode(month, Utils.NT_UNSTRUCTURED);
        }
        try {
            return monthNode.getNode(day);
        }
        catch (Exception e) {
            return monthNode.addNode(day, Utils.NT_UNSTRUCTURED);
        }
    }

    private List<Reminder> getReminders(Node eventNode) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        Date fromDate = eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime();
        Node reminderFolder = this.getReminderFolder(fromDate);
        if (reminderFolder.hasNode(eventNode.getName())) {
            NodeIterator iter = reminderFolder.getNode(eventNode.getName()).getNodes();
            while (iter.hasNext()) {
                Node reminderNode = iter.nextNode();
                if (!reminderNode.isNodeType(Utils.EXO_REMINDER)) continue;
                Reminder reminder = new Reminder();
                reminder.setId(reminderNode.getName());
                if (reminderNode.hasProperty(Utils.EXO_OWNER)) {
                    reminder.setReminderOwner(reminderNode.getProperty(Utils.EXO_OWNER).getString());
                }
                if (reminderNode.hasProperty(Utils.EXO_EVENT_ID)) {
                    reminder.setEventId(reminderNode.getProperty(Utils.EXO_EVENT_ID).getString());
                }
                if (reminderNode.hasProperty(Utils.EXO_REMINDER_TYPE)) {
                    reminder.setReminderType(reminderNode.getProperty(Utils.EXO_REMINDER_TYPE).getString());
                }
                if (reminderNode.hasProperty(Utils.EXO_ALARM_BEFORE)) {
                    reminder.setAlarmBefore(reminderNode.getProperty(Utils.EXO_ALARM_BEFORE).getLong());
                }
                if (reminderNode.hasProperty(Utils.EXO_EMAIL)) {
                    reminder.setEmailAddress(reminderNode.getProperty(Utils.EXO_EMAIL).getString());
                }
                if (reminderNode.hasProperty(Utils.EXO_IS_REPEAT)) {
                    reminder.setRepeate(reminderNode.getProperty(Utils.EXO_IS_REPEAT).getBoolean());
                }
                if (reminderNode.hasProperty(Utils.EXO_TIME_INTERVAL)) {
                    reminder.setRepeatInterval(reminderNode.getProperty(Utils.EXO_TIME_INTERVAL).getLong());
                }
                if (reminderNode.hasProperty(Utils.EXO_DESCRIPTION)) {
                    reminder.setDescription(reminderNode.getProperty(Utils.EXO_DESCRIPTION).getString());
                }
                reminder.setFromDateTime(fromDate);
                reminders.add(reminder);
            }
        }
        return reminders;
    }

    private void addAttachment(Node eventNode, Attachment attachment, boolean isNew) throws Exception {
        Node attachNode;
        Node attachHome;
        ExtendedNode extNode = (ExtendedNode)eventNode;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(SystemIdentity.ANY, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
        try {
            attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
        }
        catch (Exception e) {
            attachHome = eventNode.addNode(Utils.ATTACHMENT_NODE, Utils.NT_UNSTRUCTURED);
        }
        String name = attachment.getId().substring(attachment.getId().lastIndexOf(Utils.SLASH) + 1);
        try {
            attachNode = attachHome.getNode(name);
        }
        catch (Exception e) {
            attachNode = attachHome.addNode(name, Utils.EXO_EVEN_TATTACHMENT);
        }
        attachNode.setProperty(Utils.EXO_FILE_NAME, attachment.getName());
        Node nodeContent = null;
        try {
            nodeContent = attachNode.getNode(Utils.JCR_CONTENT);
        }
        catch (Exception e) {
            nodeContent = attachNode.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
        }
        nodeContent.setProperty(Utils.JCR_LASTMODIFIED, java.util.Calendar.getInstance().getTimeInMillis());
        nodeContent.setProperty(Utils.JCR_MIMETYPE, attachment.getMimeType());
        nodeContent.setProperty(Utils.JCR_DATA, attachment.getInputStream());
    }

    private List<Attachment> getAttachments(Node eventNode) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (eventNode.hasNode(Utils.ATTACHMENT_NODE)) {
            Node attachHome = eventNode.getNode(Utils.ATTACHMENT_NODE);
            NodeIterator iter = attachHome.getNodes();
            while (iter.hasNext()) {
                Node contentNode;
                Node attchmentNode = iter.nextNode();
                if (!attchmentNode.isNodeType(Utils.EXO_EVEN_TATTACHMENT)) continue;
                Attachment attachment = new Attachment();
                attachment.setId(attchmentNode.getPath());
                if (attchmentNode.hasProperty(Utils.EXO_FILE_NAME)) {
                    attachment.setName(attchmentNode.getProperty(Utils.EXO_FILE_NAME).getString());
                }
                if ((contentNode = attchmentNode.getNode(Utils.JCR_CONTENT)) != null) {
                    if (contentNode.hasProperty(Utils.JCR_LASTMODIFIED)) {
                        attachment.setLastModified(contentNode.getProperty(Utils.JCR_LASTMODIFIED).getDate());
                    }
                    if (contentNode.hasProperty(Utils.JCR_MIMETYPE)) {
                        attachment.setMimeType(contentNode.getProperty(Utils.JCR_MIMETYPE).getString());
                    }
                    if (contentNode.hasProperty(Utils.JCR_DATA)) {
                        InputStream inputStream = contentNode.getProperty(Utils.JCR_DATA).getStream();
                        attachment.setSize(inputStream.available());
                        attachment.setInputStream(inputStream);
                    }
                }
                attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    public void saveCalendarSetting(String username, CalendarSetting setting) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(username);
        this.addCalendarSetting(calendarHome, setting);
        calendarHome.save();
    }

    private void addCalendarSetting(Node calendarHome, CalendarSetting setting) throws Exception {
        Node settingNode;
        try {
            settingNode = calendarHome.getNode(CALENDAR_SETTING);
        }
        catch (Exception e) {
            settingNode = calendarHome.addNode(CALENDAR_SETTING, Utils.EXO_CALENDAR_SETTING);
        }
        settingNode.setProperty(Utils.EXO_VIEW_TYPE, setting.getViewType());
        settingNode.setProperty(Utils.EXO_TIME_INTERVAL, setting.getTimeInterval());
        settingNode.setProperty(Utils.EXO_WEEK_START_ON, setting.getWeekStartOn());
        settingNode.setProperty(Utils.EXO_DATE_FORMAT, setting.getDateFormat());
        settingNode.setProperty(Utils.EXO_TIME_FORMAT, setting.getTimeFormat());
        settingNode.setProperty(Utils.EXO_LOCATION, setting.getLocation());
        settingNode.setProperty(Utils.EXO_TIMEZONE, setting.getTimeZone());
        settingNode.setProperty(Utils.EXO_IS_SHOW_WORKING_TIME, setting.isShowWorkingTime());
        if (setting.isShowWorkingTime()) {
            settingNode.setProperty(Utils.EXO_WORKING_BEGIN, setting.getWorkingTimeBegin());
            settingNode.setProperty(Utils.EXO_WORKING_END, setting.getWorkingTimeEnd());
        }
        settingNode.setProperty(Utils.EXO_BASE_URL, setting.getBaseURL());
        settingNode.setProperty(Utils.EXO_PRIVATE_CALENDARS, setting.getFilterPrivateCalendars());
        settingNode.setProperty(Utils.EXO_PUBLIC_CALENDARS, setting.getFilterPublicCalendars());
        settingNode.setProperty(Utils.EXO_SHARED_CALENDARS, setting.getFilterSharedCalendars());
        settingNode.setProperty(Utils.EXO_SHARED_CALENDAR_COLORS, setting.getSharedCalendarsColors());
        settingNode.setProperty(Utils.EXO_SEND_OPTION, setting.getSendOption());
    }

    public CalendarSetting getCalendarSetting(String username) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(username);
        if (calendarHome.hasNode(CALENDAR_SETTING)) {
            int i;
            String[] calendars;
            Value[] values;
            CalendarSetting calendarSetting = new CalendarSetting();
            Node settingNode = calendarHome.getNode(CALENDAR_SETTING);
            calendarSetting.setViewType(settingNode.getProperty(Utils.EXO_VIEW_TYPE).getString());
            calendarSetting.setTimeInterval(settingNode.getProperty(Utils.EXO_TIME_INTERVAL).getLong());
            calendarSetting.setWeekStartOn(settingNode.getProperty(Utils.EXO_WEEK_START_ON).getString());
            calendarSetting.setDateFormat(settingNode.getProperty(Utils.EXO_DATE_FORMAT).getString());
            calendarSetting.setTimeFormat(settingNode.getProperty(Utils.EXO_TIME_FORMAT).getString());
            if (settingNode.hasProperty(Utils.EXO_SEND_OPTION)) {
                calendarSetting.setSendOption(settingNode.getProperty(Utils.EXO_SEND_OPTION).getString());
            }
            if (settingNode.hasProperty(Utils.EXO_BASE_URL)) {
                calendarSetting.setBaseURL(settingNode.getProperty(Utils.EXO_BASE_URL).getString());
            }
            if (settingNode.hasProperty(Utils.EXO_LOCATION)) {
                calendarSetting.setLocation(settingNode.getProperty(Utils.EXO_LOCATION).getString());
            }
            if (settingNode.hasProperty(Utils.EXO_TIMEZONE)) {
                calendarSetting.setTimeZone(settingNode.getProperty(Utils.EXO_TIMEZONE).getString());
            }
            if (settingNode.hasProperty(Utils.EXO_IS_SHOW_WORKING_TIME)) {
                calendarSetting.setShowWorkingTime(settingNode.getProperty(Utils.EXO_IS_SHOW_WORKING_TIME).getBoolean());
            }
            if (calendarSetting.isShowWorkingTime()) {
                if (settingNode.hasProperty(Utils.EXO_WORKING_BEGIN)) {
                    calendarSetting.setWorkingTimeBegin(settingNode.getProperty(Utils.EXO_WORKING_BEGIN).getString());
                }
                if (settingNode.hasProperty(Utils.EXO_WORKING_END)) {
                    calendarSetting.setWorkingTimeEnd(settingNode.getProperty(Utils.EXO_WORKING_END).getString());
                }
            }
            if (settingNode.hasProperty(Utils.EXO_PRIVATE_CALENDARS)) {
                values = settingNode.getProperty(Utils.EXO_PRIVATE_CALENDARS).getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterPrivateCalendars(calendars);
            }
            if (settingNode.hasProperty(Utils.EXO_PUBLIC_CALENDARS)) {
                values = settingNode.getProperty(Utils.EXO_PUBLIC_CALENDARS).getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterPublicCalendars(calendars);
            }
            if (settingNode.hasProperty(Utils.EXO_SHARED_CALENDARS)) {
                values = settingNode.getProperty(Utils.EXO_SHARED_CALENDARS).getValues();
                calendars = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendars[i] = values[i].getString();
                }
                calendarSetting.setFilterSharedCalendars(calendars);
            }
            if (settingNode.hasProperty(Utils.EXO_SHARED_CALENDAR_COLORS)) {
                values = settingNode.getProperty(Utils.EXO_SHARED_CALENDAR_COLORS).getValues();
                String[] calendarsColors = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendarsColors[i] = values[i].getString();
                }
                calendarSetting.setSharedCalendarsColors(calendarsColors);
            }
            return calendarSetting;
        }
        return null;
    }

    private void storeXML(String feedXML, Node rssHome, String rssNodeName, RssData rssData) throws Exception {
        Node rss = rssHome.hasNode(rssNodeName) ? rssHome.getNode(rssNodeName) : rssHome.addNode(rssNodeName, Utils.EXO_RSS_DATA);
        rss.setProperty(Utils.EXO_BASE_URL, rssData.getUrl());
        rss.setProperty(Utils.EXO_TITLE, rssData.getTitle());
        rss.setProperty(Utils.EXO_CONTENT, (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
    }

    public int generateCalDav(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode(Utils.CALDAV_NODE);
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode(Utils.CALDAV_NODE, Utils.NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (String calendarMap : calendars.keySet()) {
                String calendarId = calendarMap.split("splitter")[0];
                String type = calendarMap.split("splitter")[1];
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), type);
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                Node ical = null;
                Node nodeContent = null;
                try {
                    ical = iCalHome.getNode(calendarMap + Utils.ICS_EXT);
                    nodeContent = ical.getNode(Utils.JCR_CONTENT);
                }
                catch (Exception e) {
                    ical = iCalHome.addNode(calendarMap + Utils.ICS_EXT, Utils.NT_FILE);
                    nodeContent = ical.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
                }
                nodeContent.setProperty(Utils.JCR_LASTMODIFIED, java.util.Calendar.getInstance().getTimeInMillis());
                nodeContent.setProperty(Utils.JCR_MIMETYPE, Utils.MIMETYPE_ICALENDAR);
                nodeContent.setProperty(Utils.JCR_DATA, (InputStream)is);
                if (!iCalHome.isNew()) {
                    iCalHome.save();
                } else {
                    iCalHome.getSession().save();
                }
                String link = rssData.getLink() + ical.getPath();
                Calendar exoCal = calendars.get(calendarMap);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(link);
                SyndContentImpl description = new SyndContentImpl();
                description.setType(Utils.MIMETYPE_TEXTPLAIN);
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entry.setAuthor(username);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make caldav!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    private void removeFeed(String username, String calendarId) throws Exception {
        Node rssCal;
        Node rssHome = this.getRssHome(username);
        NodeIterator iter = rssHome.getNodes();
        ArrayList<String> removedFeedNodes = new ArrayList<String>();
        while (iter.hasNext()) {
            Node feedNode = iter.nextNode();
            if (!feedNode.isNodeType(Utils.EXO_RSS_DATA)) continue;
            FeedData feedData = new FeedData();
            feedData.setTitle(feedNode.getProperty("exo:title").getString());
            StringBuffer url = new StringBuffer(feedNode.getProperty(Utils.EXO_BASE_URL).getString());
            url.append("/").append(PortalContainer.getInstance().getPortalContainerInfo().getContainerName());
            url.append("/").append(feedNode.getSession().getWorkspace().getName());
            url.append("/").append(username);
            url.append("/").append(feedNode.getName());
            feedData.setUrl(url.toString());
            URL feedUrl = new URL(feedData.getUrl());
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(feedUrl));
            List entries = feed.getEntries();
            ArrayList listBefore = new ArrayList();
            listBefore.addAll(entries);
            for (int i = 0; i < listBefore.size(); ++i) {
                SyndEntry entry = (SyndEntry)listBefore.get(i);
                String id = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                if (!id.contains(calendarId)) continue;
                listBefore.remove(i);
                --i;
            }
            if (listBefore.size() == 0) {
                removedFeedNodes.add(feedNode.getName());
                continue;
            }
            feed.setEntries(listBefore);
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString(feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            feedNode.setProperty(Utils.EXO_CONTENT, (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
            feedNode.save();
        }
        if (removedFeedNodes.size() > 0) {
            for (String s : removedFeedNodes) {
                if (rssHome.getNode(s) == null) continue;
                rssHome.getNode(s).remove();
            }
            rssHome.getSession().save();
        }
        if (rssHome.hasNode(Utils.CALDAV_NODE)) {
            iter = rssHome.getNode(Utils.CALDAV_NODE).getNodes();
            while (iter.hasNext()) {
                rssCal = iter.nextNode();
                if (!rssCal.getPath().contains(calendarId)) continue;
                rssCal.remove();
            }
        }
        if (rssHome.hasNode(Utils.RSS_NODE)) {
            iter = rssHome.getNode(Utils.RSS_NODE).getNodes();
            while (iter.hasNext()) {
                rssCal = iter.nextNode();
                if (!rssCal.getPath().contains(calendarId)) continue;
                rssCal.remove();
            }
        }
        rssHome.getSession().save();
    }

    public List<FeedData> getFeeds(String username) throws Exception {
        ArrayList<FeedData> feeds = new ArrayList<FeedData>();
        Node rssHome = this.getRssHome(username);
        NodeIterator iter = rssHome.getNodes();
        while (iter.hasNext()) {
            Node feedNode = iter.nextNode();
            if (!feedNode.isNodeType(Utils.EXO_RSS_DATA)) continue;
            FeedData feed = new FeedData();
            feed.setTitle(feedNode.getProperty("exo:title").getString());
            StringBuffer url = new StringBuffer(feedNode.getProperty(Utils.EXO_BASE_URL).getString());
            url.append("/").append(PortalContainer.getInstance().getPortalContainerInfo().getContainerName());
            url.append("/").append(feedNode.getSession().getWorkspace().getName());
            url.append("/").append(username);
            url.append("/").append(feedNode.getName());
            feed.setUrl(url.toString());
            feeds.add(feed);
        }
        return feeds;
    }

    public int generateRss(String username, List<String> calendarIds, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode(Utils.RSS_NODE);
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode(Utils.RSS_NODE, Utils.NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
            String portalName = containerInfo.getContainerName();
            ArrayList ids = new ArrayList();
            for (String calendarId : calendarIds) {
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), "0");
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                try {
                    iCalHome.getNode(calendarId + Utils.ICS_EXT).setProperty(Utils.EXO_DATA, (InputStream)is);
                }
                catch (Exception e) {
                    Node ical = iCalHome.addNode(calendarId + Utils.ICS_EXT, Utils.EXO_ICAL_DATA);
                    ical.setProperty(Utils.EXO_DATA, (InputStream)is);
                }
                StringBuffer path = new StringBuffer(Utils.SLASH);
                path.append(iCalHome.getName()).append(Utils.SLASH).append(iCalHome.getNode(calendarId + Utils.ICS_EXT).getName());
                String url = this.getEntryUrl(portalName, rssHomeNode.getSession().getWorkspace().getName(), username, path.toString(), rssData.getUrl());
                Calendar exoCal = this.getUserCalendar(username, calendarId);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(url);
                entry.setAuthor(username);
                SyndContentImpl description = new SyndContentImpl();
                description.setType(Utils.MIMETYPE_TEXTPLAIN);
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make rss!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    public int generateRss(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode(Utils.RSS_NODE);
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode(Utils.RSS_NODE, Utils.NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
            String portalName = containerInfo.getContainerName();
            for (String calendarMap : calendars.keySet()) {
                String calendarId = calendarMap.split("splitter")[0];
                String type = calendarMap.split("splitter")[1];
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), type);
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                try {
                    iCalHome.getNode(calendarMap + Utils.ICS_EXT).setProperty(Utils.EXO_DATA, (InputStream)is);
                }
                catch (Exception e) {
                    Node ical = iCalHome.addNode(calendarMap + Utils.ICS_EXT, Utils.EXO_ICAL_DATA);
                    ical.setProperty(Utils.EXO_DATA, (InputStream)is);
                }
                StringBuffer path = new StringBuffer(Utils.SLASH);
                path.append(iCalHome.getName()).append(Utils.SLASH).append(iCalHome.getNode(calendarMap + Utils.ICS_EXT).getName());
                String url = this.getEntryUrl(portalName, rssHomeNode.getSession().getWorkspace().getName(), username, path.toString(), rssData.getUrl());
                Calendar exoCal = calendars.get(calendarMap);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(url);
                entry.setAuthor(username);
                SyndContentImpl description = new SyndContentImpl();
                description.setType(Utils.MIMETYPE_TEXTPLAIN);
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make rss!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    public void updateRss(String username, String calendarId, CalendarImportExport imp) throws Exception {
        calendarId = calendarId.substring(0, calendarId.lastIndexOf("."));
        String id = calendarId.split("splitter")[0];
        String type = calendarId.split("splitter")[1];
        Node rssHome = this.getRssHome(username);
        if (rssHome.hasNode(Utils.RSS_NODE)) {
            NodeIterator iter = rssHome.getNode(Utils.RSS_NODE).getNodes();
            while (iter.hasNext()) {
                Node rssCal = iter.nextNode();
                if (!rssCal.getPath().contains(calendarId)) continue;
                OutputStream out = imp.exportCalendar(username, Arrays.asList(id), type);
                if (out != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                    rssCal.setProperty(Utils.EXO_DATA, (InputStream)is);
                    rssCal.save();
                    break;
                }
                rssCal.remove();
                rssHome.getSession().save();
                break;
            }
        }
    }

    public void updateRss(String username, String calendarId, CalendarImportExport imp, int number) throws Exception {
        calendarId = calendarId.substring(0, calendarId.lastIndexOf("."));
        String id = calendarId.split("splitter")[0];
        String type = calendarId.split("splitter")[1];
        Node rssHome = this.getRssHome(username);
        if (rssHome.hasNode(Utils.RSS_NODE)) {
            NodeIterator iter = rssHome.getNode(Utils.RSS_NODE).getNodes();
            while (iter.hasNext()) {
                Node rssCal = iter.nextNode();
                if (!rssCal.getPath().contains(calendarId)) continue;
                OutputStream out = imp.exportCalendar(username, Arrays.asList(id), type, number);
                if (out != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                    rssCal.setProperty(Utils.EXO_DATA, (InputStream)is);
                    rssCal.save();
                    break;
                }
                rssCal.remove();
                rssHome.getSession().save();
                break;
            }
        }
    }

    public void updateCalDav(String username, String calendarId, CalendarImportExport imp) throws Exception {
        calendarId = calendarId.substring(0, calendarId.lastIndexOf("."));
        String id = calendarId.split("splitter")[0];
        String type = calendarId.split("splitter")[1];
        Node rssHome = this.getRssHome(username);
        if (rssHome.hasNode(Utils.CALDAV_NODE)) {
            NodeIterator iter = rssHome.getNode(Utils.CALDAV_NODE).getNodes();
            while (iter.hasNext()) {
                Node rssCal = iter.nextNode();
                Node nodeContent = rssCal.getNode(Utils.JCR_CONTENT);
                OutputStream out = imp.exportCalendar(username, Arrays.asList(id), type);
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                nodeContent.setProperty(Utils.JCR_DATA, (InputStream)is);
            }
            rssHome.getSession().save();
        }
    }

    public void updateCalDav(String username, String calendarId, CalendarImportExport imp, int number) throws Exception {
        calendarId = calendarId.substring(0, calendarId.lastIndexOf("."));
        String id = calendarId.split("splitter")[0];
        String type = calendarId.split("splitter")[1];
        Node rssHome = this.getRssHome(username);
        if (rssHome.hasNode(Utils.CALDAV_NODE)) {
            NodeIterator iter = rssHome.getNode(Utils.CALDAV_NODE).getNodes();
            while (iter.hasNext()) {
                Node rssCal = iter.nextNode();
                Node nodeContent = rssCal.getNode(Utils.JCR_CONTENT);
                OutputStream out = imp.exportCalendar(username, Arrays.asList(id), type, number);
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                nodeContent.setProperty(Utils.JCR_DATA, (InputStream)is);
            }
            rssHome.getSession().save();
        }
    }

    public int generateCalDav(String username, List<String> calendarIds, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode(Utils.CALDAV_NODE);
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode(Utils.CALDAV_NODE, Utils.NT_UNSTRUCTURED);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (String calendarId : calendarIds) {
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), "0");
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                Node ical = null;
                Node nodeContent = null;
                try {
                    ical = iCalHome.getNode(calendarId + Utils.ICS_EXT);
                    nodeContent = ical.getNode(Utils.JCR_CONTENT);
                }
                catch (Exception e) {
                    ical = iCalHome.addNode(calendarId + Utils.ICS_EXT, Utils.NT_FILE);
                    nodeContent = ical.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
                }
                nodeContent.setProperty(Utils.JCR_LASTMODIFIED, java.util.Calendar.getInstance().getTimeInMillis());
                nodeContent.setProperty(Utils.JCR_MIMETYPE, Utils.MIMETYPE_ICALENDAR);
                nodeContent.setProperty(Utils.JCR_DATA, (InputStream)is);
                if (!iCalHome.isNew()) {
                    iCalHome.save();
                } else {
                    iCalHome.getSession().save();
                }
                String link = rssData.getLink() + ical.getPath();
                Calendar exoCal = this.getUserCalendar(username, calendarId);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(link);
                SyndContentImpl description = new SyndContentImpl();
                description.setType(Utils.MIMETYPE_TEXTPLAIN);
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entry.setAuthor(username);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                System.out.println("No data to make caldav!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData.getName(), rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    private String getEntryUrl(String portalName, String wsName, String username, String path, String baseUrl) throws Exception {
        StringBuilder url = new StringBuilder(baseUrl);
        url.append(Utils.SLASH).append(portalName).append(Utils.SLASH).append(wsName);
        if (username != null) {
            url.append(Utils.SLASH).append(username);
        }
        url.append(path);
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPageList searchEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            if (eventQuery.getCalendarId() == null) {
                events.addAll(this.getUserEvents(username, eventQuery));
                if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                    eventQuery.setCalendarId(publicCalendarIds);
                    events.addAll(this.getPublicEvents(eventQuery));
                    eventQuery.setCalendarId(null);
                }
                events.addAll(this.getSharedEvents(username, eventQuery));
            } else {
                String calFullId = eventQuery.getCalendarId()[0];
                if (calFullId.split(Utils.COLON).length > 0) {
                    String[] calId = new String[]{calFullId.split(Utils.COLON)[1]};
                    int type = Integer.parseInt(calFullId.split(Utils.COLON)[0]);
                    eventQuery.setCalendarId(calId);
                    switch (type) {
                        case 0: {
                            events.addAll(this.getUserEvents(username, eventQuery));
                            EventPageList eventPageList = new EventPageList(events, 10L);
                            return eventPageList;
                        }
                        case 1: {
                            events.addAll(this.getSharedEvents(username, eventQuery));
                            EventPageList eventPageList = new EventPageList(events, 10L);
                            return eventPageList;
                        }
                        case 2: {
                            events.addAll(this.getPublicEvents(eventQuery));
                            EventPageList eventPageList = new EventPageList(events, 10L);
                            return eventPageList;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        return new EventPageList(events, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> searchHightLightEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        Map<Integer, String> mapData = new HashMap<Integer, String>();
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            NodeIterator it;
            Query query;
            QueryManager qm;
            CalendarSetting calSetting = this.getCalendarSetting(username);
            if (username != null && username.length() > 0) {
                Node calendarHome = this.getUserCalendarHome(username);
                eventQuery.setCalendarPath(calendarHome.getPath());
                qm = calendarHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
                it = query.execute().getNodes();
                mapData = this.updateMap(mapData, it, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterPrivateCalendars());
            }
            if (this.getSharedCalendarHome(systemSession).hasNode(username)) {
                PropertyIterator iter = this.getSharedCalendarHome(systemSession).getNode(username).getReferences();
                while (iter.hasNext()) {
                    try {
                        Node calendar = iter.nextProperty().getParent();
                        eventQuery.setCalendarPath(calendar.getPath());
                        qm = calendar.getSession().getWorkspace().getQueryManager();
                        query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
                        NodeIterator it2 = query.execute().getNodes();
                        mapData = this.updateMap(mapData, it2, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterSharedCalendars());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Node publicCalHome = this.getPublicCalendarHome(systemSession);
            eventQuery.setCalendarPath(publicCalHome.getPath());
            qm = publicCalHome.getSession().getWorkspace().getQueryManager();
            eventQuery.setCalendarId(publicCalendarIds);
            query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
            it = query.execute().getNodes();
            mapData = this.updateMap(mapData, it, eventQuery.getFromDate(), eventQuery.getToDate(), calSetting.getFilterPublicCalendars());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        return mapData;
    }

    private Map<Integer, String> updateMap(Map<Integer, String> data, NodeIterator it, java.util.Calendar fromDate, java.util.Calendar toDate, String[] filterCalIds) throws Exception {
        int fromDayOfYear = fromDate.get(6);
        int daysOfyer = fromDate.getMaximum(6);
        int toDayOfYear = toDate.get(6);
        if (toDate.get(6) > fromDate.get(6)) {
            toDayOfYear += daysOfyer;
        }
        boolean isVictory = false;
        while (it.hasNext() && !isVictory) {
            Node eventNode = it.nextNode();
            if (filterCalIds != null && Arrays.asList(filterCalIds).contains(eventNode.getProperty(Utils.EXO_CALENDAR_ID).getString())) continue;
            java.util.Calendar eventFormDate = eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate();
            java.util.Calendar eventToDate = eventNode.getProperty(Utils.EXO_TO_DATE_TIME).getDate();
            int eventFromDayOfYear = eventFormDate.get(6);
            int eventToDayOfYear = eventToDate.get(6);
            Integer begin = -1;
            Integer end = -1;
            if (fromDayOfYear >= eventFromDayOfYear) {
                begin = fromDayOfYear;
                if (toDayOfYear <= eventToDayOfYear) {
                    end = toDayOfYear;
                    isVictory = true;
                } else {
                    end = eventToDayOfYear;
                }
            } else {
                begin = eventFromDayOfYear;
                end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
            }
            if (begin <= 0 || end <= 0) continue;
            Integer i = begin;
            while (i <= end) {
                data.put(i, VALUE);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return data;
    }

    public void shareCalendar(String username, String calendarId, List<String> receiverUsers) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        Value[] values = new Value[]{};
        if (calendarNode.isNodeType(Utils.EXO_SHARED_MIXIN)) {
            values = calendarNode.getProperty(Utils.EXO_SHARED_ID).getValues();
        } else {
            calendarNode.addMixin(Utils.EXO_SHARED_MIXIN);
        }
        Session systemSession = sharedCalendarHome.getSession();
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (String user : receiverUsers) {
            Node userNode;
            block12: {
                CalendarSetting calSetting = this.getCalendarSetting(user);
                if (calSetting == null) {
                    calSetting = new CalendarSetting();
                }
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : calSetting.getSharedCalendarsColors()) {
                    map.put(key.split(":")[0], key.split(":")[1]);
                }
                if (map.get(calendarNode.getProperty(Utils.EXO_ID).getString()) == null) {
                    map.put(calendarNode.getProperty(Utils.EXO_ID).getString(), calendarNode.getProperty("exo:calendarColor").getString());
                }
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(user, calSetting);
                try {
                    userNode = sharedCalendarHome.getNode(user);
                }
                catch (Exception e) {
                    userNode = sharedCalendarHome.addNode(user, Utils.NT_UNSTRUCTURED);
                    if (!userNode.canAddMixin(Utils.MIX_REFERENCEABLE)) break block12;
                    userNode.addMixin(Utils.MIX_REFERENCEABLE);
                }
            }
            boolean isExist = false;
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = systemSession.getNodeByUUID(uuid);
                if (refNode.getPath().equals(userNode.getPath())) {
                    isExist = true;
                    break;
                }
                valueList.add(value);
            }
            if (isExist) continue;
            Value value2add = calendarNode.getSession().getValueFactory().createValue(userNode);
            valueList.add(value2add);
        }
        if (valueList.size() > 0) {
            calendarNode.setProperty(Utils.EXO_SHARED_ID, valueList.toArray(new Value[valueList.size()]));
            calendarNode.save();
            sharedCalendarHome.getSession().save();
            calendarNode.getSession().save();
            systemSession.logout();
        }
    }

    public GroupCalendarData getSharedCalendars(String username, boolean isShowAll) throws Exception {
        if (this.getSharedCalendarHome().hasNode(username)) {
            Node sharedNode = this.getSharedCalendarHome().getNode(username);
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            PropertyIterator iter = sharedNode.getReferences();
            String[] defaultFilterCalendars = null;
            if (this.getCalendarSetting(username) != null) {
                defaultFilterCalendars = this.getCalendarSetting(username).getFilterSharedCalendars();
            }
            while (iter.hasNext()) {
                try {
                    Calendar cal = this.getCalendar(defaultFilterCalendars, null, iter.nextProperty().getParent(), isShowAll);
                    if (cal == null) continue;
                    calendars.add(cal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (calendars.size() > 0) {
                return new GroupCalendarData("Shared", "Shared", calendars);
            }
        }
        return null;
    }

    public void saveSharedCalendar(String username, Calendar calendar) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            ArrayList<Value> newValues = new ArrayList<Value>();
            while (iter.hasNext()) {
                Value[] values;
                Node calendarNode = iter.nextProperty().getParent();
                if (!calendarNode.getProperty(Utils.EXO_ID).getString().equals(calendar.getId())) continue;
                for (Value value : values = calendarNode.getProperty(Utils.EXO_SHARED_ID).getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                calendarNode.setProperty(Utils.EXO_NAME, calendar.getName());
                calendarNode.setProperty(Utils.EXO_DESCRIPTION, calendar.getDescription());
                calendarNode.setProperty(Utils.EXO_CATEGORY_ID, calendar.getCategoryId());
                calendarNode.setProperty(Utils.EXO_VIEW_PERMISSIONS, calendar.getViewPermission());
                calendarNode.setProperty(Utils.EXO_EDIT_PERMISSIONS, calendar.getEditPermission());
                calendarNode.setProperty(Utils.EXO_GROUPS, calendar.getGroups());
                calendarNode.setProperty(Utils.EXO_LOCALE, calendar.getLocale());
                calendarNode.setProperty(Utils.EXO_TIMEZONE, calendar.getTimeZone());
                CalendarSetting usCalSetting = this.getCalendarSetting(username);
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : usCalSetting.getSharedCalendarsColors()) {
                    map.put(key.split(Utils.COLON)[0], key.split(Utils.COLON)[1]);
                }
                map.put(calendar.getId(), calendar.getCalendarColor());
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + Utils.COLON + (String)map.get(key));
                }
                calColors.add(calendar.getId() + Utils.COLON + calendar.getCalendarColor());
                usCalSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(username, usCalSetting);
                calendarNode.save();
                break;
            }
        }
    }

    public List<CalendarEvent> getSharedEvents(String username, EventQuery eventQuery) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.getSharedCalendarHome().hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome().getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    eventQuery.setCalendarPath(calendar.getPath());
                    QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
                    Query query = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        CalendarEvent calEvent = this.getEvent(it.nextNode());
                        calEvent.setCalType("1");
                        events.add(calEvent);
                        if (eventQuery.getLimitedItems() != it.getPosition()) continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return events;
    }

    public List<CalendarEvent> getSharedEventByCalendars(String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.getSharedCalendarHome().hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome().getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendarIds.contains(calendar.getProperty(Utils.EXO_ID).getString())) continue;
                    NodeIterator it = calendar.getNodes();
                    while (it.hasNext()) {
                        events.add(this.getEvent(it.nextNode()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return events;
    }

    public void removeSharedCalendar(String username, String calendarId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            CalendarSetting calSetting = this.getCalendarSetting(username);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : calSetting.getSharedCalendarsColors()) {
                map.put(key.split(":")[0], key.split(":")[1]);
            }
            ArrayList<Value> newValues = new ArrayList<Value>();
            while (iter.hasNext()) {
                Value[] values;
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty(Utils.EXO_ID).getString().equals(calendarId)) continue;
                map.remove(calendarId);
                for (Value value : values = calendar.getProperty(Utils.EXO_SHARED_ID).getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(username, calSetting);
                calendar.setProperty(Utils.EXO_SHARED_ID, newValues.toArray(new Value[newValues.size()]));
                ArrayList<String> viewPerms = new ArrayList<String>();
                if (calendar.hasProperty(Utils.EXO_VIEW_PERMISSIONS)) {
                    Value[] viewValues;
                    for (Value v : viewValues = calendar.getProperty(Utils.EXO_VIEW_PERMISSIONS).getValues()) {
                        if (v.getString() == null || v.getString().equals(username)) continue;
                        viewPerms.add(v.getString());
                    }
                }
                ArrayList<String> editPerms = new ArrayList<String>();
                if (calendar.hasProperty(Utils.EXO_EDIT_PERMISSIONS)) {
                    Value[] editValues;
                    for (Value v : editValues = calendar.getProperty(Utils.EXO_EDIT_PERMISSIONS).getValues()) {
                        if (v.getString() == null || v.getString().equals(username)) continue;
                        editPerms.add(v.getString());
                    }
                }
                calendar.setProperty(Utils.EXO_VIEW_PERMISSIONS, viewPerms.toArray(new String[viewPerms.size()]));
                calendar.setProperty(Utils.EXO_EDIT_PERMISSIONS, editPerms.toArray(new String[editPerms.size()]));
                calendar.getSession().save();
                calendar.refresh(true);
                break;
            }
            try {
                this.removeFeed(username, calendarId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveEventToSharedCalendar(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty(Utils.EXO_ID).getString().equals(calendarId)) continue;
                Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                this.saveEvent(calendar, event, reminderFolder, isNew);
                calendar.save();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarEvent> getEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        ArrayList<String> filterList = new ArrayList<String>();
        CalendarSetting calSetting = this.getCalendarSetting(username);
        filterList.addAll(Arrays.asList(calSetting.getFilterPrivateCalendars()));
        filterList.addAll(Arrays.asList(calSetting.getFilterPublicCalendars()));
        filterList.addAll(Arrays.asList(calSetting.getFilterSharedCalendars()));
        eventQuery.setFilterCalendarIds(filterList.toArray(new String[0]));
        events.addAll(this.getUserEvents(username, eventQuery));
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            events.addAll(this.getSharedEvents(username, eventQuery));
            if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                eventQuery.setCalendarId(publicCalendarIds);
                events.addAll(this.getPublicEvents(eventQuery));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
        return events;
    }

    public Map<String, String> checkFreeBusy(EventQuery eventQuery) throws Exception {
        String[] pars;
        Node eventFolder = this.getEventFolder(eventQuery.getFromDate().getTime());
        HashMap<String, String> participantMap = new HashMap<String, String>();
        eventQuery.setCalendarPath(eventFolder.getPath());
        eventQuery.setOrderBy(new String[]{Utils.EXO_FROM_DATE_TIME});
        QueryManager qm = eventFolder.getSession().getWorkspace().getQueryManager();
        for (String par : pars = eventQuery.getParticipants()) {
            eventQuery.setParticipants(new String[]{par});
            Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            StringBuilder timeValues = new StringBuilder();
            while (it.hasNext()) {
                String to;
                Node event = it.nextNode();
                if (!event.hasProperty(Utils.EXO_EVENT_STATE) || CalendarEvent.ST_AVAILABLE.equals(event.getProperty(Utils.EXO_EVENT_STATE).getValue().getString())) continue;
                java.util.Calendar fromCal = event.getProperty(Utils.EXO_FROM_DATE_TIME).getDate();
                java.util.Calendar toCal = event.getProperty(Utils.EXO_TO_DATE_TIME).getDate();
                String from = fromCal.getTimeInMillis() < eventQuery.getFromDate().getTimeInMillis() ? String.valueOf(eventQuery.getFromDate().getTimeInMillis()) : String.valueOf(fromCal.getTimeInMillis());
                if (toCal.getTimeInMillis() > eventQuery.getToDate().getTimeInMillis()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(eventQuery.getToDate().getTimeInMillis() - 1000L);
                    to = String.valueOf(cal.getTimeInMillis());
                } else {
                    to = String.valueOf(toCal.getTimeInMillis());
                }
                if (timeValues != null && timeValues.length() > 0) {
                    timeValues.append(",");
                }
                timeValues.append(from).append(",").append(to);
                participantMap.put(par, timeValues.toString());
            }
        }
        return participantMap;
    }

    public void removeSharedEvent(String username, String calendarId, String eventId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty(Utils.EXO_ID).getString().equals(calendarId)) continue;
                if (calendar.hasNode(eventId)) {
                    Node event = calendar.getNode(eventId);
                    Node eventFolder = this.getEventFolder(event.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime());
                    this.syncRemoveEvent(eventFolder, eventId);
                    this.removeReminder(event);
                    event.remove();
                }
                calendar.save();
                calendar.refresh(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveEvent(String formCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            switch (Integer.parseInt(fromType)) {
                case 0: {
                    if (!this.getUserCalendarHome(username).hasNode(formCalendar)) return;
                    switch (Integer.parseInt(toType)) {
                        case 0: {
                            if (!this.getUserCalendarHome(username).hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                if (!formCalendar.equals(toCalendar)) {
                                    this.removeUserEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                                    continue;
                                }
                                this.saveUserEvent(username, toCalendar, calEvent, false);
                            }
                            return;
                        }
                        case 1: {
                            if (!this.getSharedCalendarHome().hasNode(username)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removeUserEvent(username, formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.saveEventToSharedCalendar(username, toCalendar, calEvent, this.getSharedCalendarHome(systemSession).getNode(username).hasNode(calEvent.getId()));
                            }
                            return;
                        }
                        case 2: {
                            if (!this.getPublicCalendarHome().hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removeUserEvent(username, formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                            }
                            return;
                        }
                    }
                    return;
                }
                case 1: {
                    if (!this.getSharedCalendarHome(systemSession).hasNode(username)) return;
                    switch (Integer.parseInt(toType)) {
                        case 0: {
                            if (!this.getUserCalendarHome(username).hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                            }
                            return;
                        }
                        case 1: {
                            if (!this.getSharedCalendarHome().hasNode(username)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                if (!formCalendar.equals(toCalendar)) {
                                    this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.saveEventToSharedCalendar(username, toCalendar, calEvent, this.getSharedCalendarHome().getNode(username).hasNode(calEvent.getId()));
                                    continue;
                                }
                                this.saveEventToSharedCalendar(username, toCalendar, calEvent, false);
                            }
                            return;
                        }
                        case 2: {
                            if (!this.getPublicCalendarHome(systemSession).hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                            }
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    if (!this.getPublicCalendarHome().hasNode(formCalendar)) return;
                    switch (Integer.parseInt(toType)) {
                        case 0: {
                            if (!this.getUserCalendarHome(username).hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removePublicEvent(formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                            }
                            return;
                        }
                        case 1: {
                            if (!this.getSharedCalendarHome().hasNode(username)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                this.removePublicEvent(formCalendar, calEvent.getId());
                                calEvent.setCalendarId(toCalendar);
                                this.saveEventToSharedCalendar(username, toCalendar, calEvent, true);
                            }
                            return;
                        }
                        case 2: {
                            if (!this.getPublicCalendarHome(systemSession).hasNode(toCalendar)) return;
                            Iterator<CalendarEvent> i$ = calEvents.iterator();
                            while (i$.hasNext()) {
                                CalendarEvent calEvent = i$.next();
                                if (!formCalendar.equals(toCalendar)) {
                                    this.removePublicEvent(formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome(systemSession).getNode(toCalendar).hasNode(calEvent.getId()));
                                    continue;
                                }
                                this.savePublicEvent(toCalendar, calEvent, false);
                            }
                            return;
                        }
                    }
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            systemSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) throws Exception {
        SessionProvider session = SessionProvider.createSystemProvider();
        try {
            HashMap<String, String> pars = new HashMap<String, String>();
            CalendarEvent event = null;
            if (0 == calType) {
                event = this.getUserEvent(fromUserId, calendarId, eventId);
            } else if (1 == calType) {
                ArrayList<String> calendarIds = new ArrayList<String>();
                calendarIds.add(calendarId);
                for (CalendarEvent calEvent : this.getSharedEventByCalendars(fromUserId, calendarIds)) {
                    if (!calEvent.getId().equals(eventId)) continue;
                    event = calEvent;
                    break;
                }
            } else if (2 == calType) {
                event = this.getGroupEvent(calendarId, eventId);
            }
            if (event != null) {
                if (event.getParticipant() != null) {
                    for (String id : event.getParticipant()) {
                        pars.put(id, id);
                    }
                }
                for (String s : toUserId.split(",")) {
                    if (0 == answer) {
                        pars.remove(s);
                    }
                    if (1 != answer && 2 != answer) continue;
                    pars.put(s, s);
                }
                event.setParticipant(pars.values().toArray(new String[pars.values().size()]));
                if (0 == calType) {
                    this.saveUserEvent(fromUserId, calendarId, event, false);
                } else if (1 == calType) {
                    this.saveEventToSharedCalendar(fromUserId, calendarId, event, false);
                } else if (2 == calType) {
                    this.savePublicEvent(calendarId, event, false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\n\n confirmInvitation " + e.getClass().toString());
        }
        finally {
            session.close();
        }
    }

    public void confirmInvitation(String fromUserId, String confirmingEmail, String confirmingUser, int calType, String calendarId, String eventId, int answer) throws Exception {
        SessionProvider session = SessionProvider.createSystemProvider();
        try {
            HashMap<String, String> pars = new HashMap<String, String>();
            CalendarEvent event = null;
            if (0 == calType) {
                event = this.getUserEvent(fromUserId, calendarId, eventId);
            } else if (1 == calType) {
                ArrayList<String> calendarIds = new ArrayList<String>();
                calendarIds.add(calendarId);
                for (CalendarEvent calEvent : this.getSharedEventByCalendars(fromUserId, calendarIds)) {
                    if (!calEvent.getId().equals(eventId)) continue;
                    event = calEvent;
                    break;
                }
            } else if (2 == calType) {
                event = this.getGroupEvent(calendarId, eventId);
            }
            if (event != null) {
                if (event.getParticipantStatus() != null) {
                    for (String parStatus : event.getParticipantStatus()) {
                        String[] entry = parStatus.split(":");
                        if (entry.length > 1) {
                            pars.put(entry[0], entry[1]);
                            continue;
                        }
                        pars.put(entry[0], Utils.STATUS_EMPTY);
                    }
                }
                String status = Utils.STATUS_EMPTY;
                switch (answer) {
                    case 0: {
                        status = Utils.STATUS_NO;
                        break;
                    }
                    case 1: {
                        status = Utils.STATUS_YES;
                        break;
                    }
                    case 2: {
                        status = Utils.STATUS_PENDING;
                        break;
                    }
                }
                if (pars.containsKey(confirmingUser)) {
                    pars.remove(confirmingUser);
                    pars.put(confirmingUser, status);
                }
                if (pars.containsKey(confirmingEmail)) {
                    pars.remove(confirmingEmail);
                    pars.put(confirmingEmail, status);
                }
                HashMap<String, String> participant = new HashMap<String, String>();
                for (Map.Entry par : pars.entrySet()) {
                    participant.put((String)par.getKey() + ":" + (String)par.getValue(), "");
                }
                event.setParticipantStatus(participant.keySet().toArray(new String[participant.keySet().size()]));
                if (0 == calType) {
                    this.saveUserEvent(fromUserId, calendarId, event, false);
                } else if (1 == calType) {
                    this.saveEventToSharedCalendar(fromUserId, calendarId, event, false);
                } else if (2 == calType) {
                    this.savePublicEvent(calendarId, event, false);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\n\n confirmInvitation " + e.getClass().toString());
            throw new Exception(e.getClass().toString(), e.fillInStackTrace());
        }
        finally {
            session.close();
        }
    }

    public int getTypeOfCalendar(String userName, String calendarId) {
        try {
            Node calendarNode = this.getUserCalendarHome(userName).getNode(calendarId);
            return 0;
        }
        catch (Exception e) {
            try {
                Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
                return 2;
            }
            catch (Exception e2) {
                try {
                    Node sharedCalendarHome = this.getSharedCalendarHome();
                    if (sharedCalendarHome.hasNode(userName)) {
                        Node userNode = sharedCalendarHome.getNode(userName);
                        PropertyIterator iter = userNode.getReferences();
                        while (iter.hasNext()) {
                            Node calendar = iter.nextProperty().getParent();
                            if (!calendar.getProperty(Utils.EXO_ID).getString().equals(calendarId)) continue;
                            return 1;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -1;
            }
        }
    }

    private SessionProvider createSessionProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        SessionProvider provider = service.getSessionProvider(null);
        if (provider == null) {
            log.info((Object)"No user session provider was available, trying to use a system session provider");
            provider = service.getSystemSessionProvider(null);
        }
        return provider;
    }

    private SessionProvider createUserProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSessionProvider(null);
    }

    private SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    private void closeSessionProvider(SessionProvider sessionProvider) {
        if (sessionProvider != null) {
            sessionProvider.close();
        }
    }
}

