/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SynchronizeRemoteCalendarJob
implements Job {
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_JOB = "SynchonizeRemoteCalendarJob";
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_GROUP = "SynchonizeRemoteCalendarGroup";
    private static final String CALENDARS = "calendars".intern();
    public static Boolean isExecuting = false;
    private static Log log_ = ExoLogger.getLogger((String)"cs.calendar.job");
    public static final String USERNAME = "username";
    private String username;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        isExecuting = true;
        PortalContainer container = Utils.getPortalContainer(context);
        if (container == null) {
            return;
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        SessionProvider provider = SessionProvider.createSystemProvider();
        CalendarService calService = (CalendarService)container.getComponentInstanceOfType(CalendarService.class);
        int total = 0;
        int success = 0;
        int failed = 0;
        long start = System.currentTimeMillis();
        try {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Remote calendar synchronization service");
            }
            JobDetail jobDetail = context.getJobDetail();
            JobDataMap dataMap = jobDetail.getJobDataMap();
            this.username = dataMap.getString(USERNAME);
            if (this.username == null) {
                return;
            }
            Node userCalendarHome = this.getUserCalendarHome(provider);
            StringBuffer path = new StringBuffer("/jcr:root");
            path.append(userCalendarHome.getPath());
            path.append("//element(*,exo:remoteCalendar)");
            QueryManager queryManager = this.getSession(provider).getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(path.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            while (iter.hasNext()) {
                ++total;
                Node remoteCalendar = iter.nextNode();
                String remoteCalendarId = remoteCalendar.getProperty(Utils.EXO_ID).getString();
                String remoteType = remoteCalendar.getProperty(Utils.EXO_REMOTE_TYPE).getString();
                String syncPeriod = remoteCalendar.getProperty(Utils.EXO_REMOTE_SYNC_PERIOD).getString();
                try {
                    if (syncPeriod.equals("auto")) {
                        calService.refreshRemoteCalendar(this.username, remoteCalendarId);
                        ++success;
                        continue;
                    }
                    long lastUpdate = remoteCalendar.getProperty(Utils.EXO_REMOTE_LAST_UPDATED).getDate().getTimeInMillis();
                    long now = Utils.getGreenwichMeanTime().getTimeInMillis();
                    long interval = 0L;
                    if ("5mins".equals(syncPeriod)) {
                        interval = 300000L;
                    }
                    if ("10mins".equals(syncPeriod)) {
                        interval = 600000L;
                    }
                    if ("15mins".equals(syncPeriod)) {
                        interval = 900000L;
                    }
                    if ("1hour".equals(syncPeriod)) {
                        interval = 3600000L;
                    }
                    if ("1day".equals(syncPeriod)) {
                        interval = 86400000L;
                    }
                    if ("1week".equals(syncPeriod)) {
                        interval = 604800000L;
                    }
                    if ("1year".equals(syncPeriod)) {
                        interval = 1708667904L;
                    }
                    if (lastUpdate + interval >= now) continue;
                    calService.refreshRemoteCalendar(this.username, remoteCalendarId);
                    ++success;
                }
                catch (Exception e) {
                    log_.debug((Object)("Skip this calendar, error when reload remote calendar " + remoteCalendarId + ". Error message: " + e.getMessage()));
                    ++failed;
                }
            }
        }
        catch (RepositoryException e) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Data base not ready!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Exception when synchronize remote calendar. " + e.toString()));
            }
        }
        finally {
            provider.close();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            isExecuting = false;
        }
        long finish = System.currentTimeMillis();
        long spent = finish - start;
        if (total > 0) {
            log_.info((Object)("Reload remote calendar completed. Total: " + total + ", Success: " + success + ", Failed: " + failed + ", Skip: " + (total - success - failed) + ". Time spent: " + spent + " ms."));
        }
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static JobInfo getJobInfo(String username) {
        String jobName = "SynchonizeRemoteCalendarJob_" + username;
        JobInfo info = new JobInfo(jobName, SYNCHRONIZE_REMOTE_CALENDAR_GROUP, SynchronizeRemoteCalendarJob.class);
        return info;
    }

    private Node getUserCalendarHome(SessionProvider provider) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userApp = nodeHierarchyCreator.getUserApplicationNode(provider, this.username);
            Node userCalendarApp = userApp.getNode(Utils.CALENDAR_APP);
            return userCalendarApp.getNode(CALENDARS);
        }
        catch (Exception e) {
            return null;
        }
    }
}

