/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class ShareCalendarJob
implements Job,
InterruptableJob {
    private static Log log = ExoLogger.getLogger((String)"cs.service.job");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info((Object)"Starting sharing calendar for groups");
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        OrganizationService oService = (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
        CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        HashMap<String, String> perms = new HashMap<String, String>();
        HashMap<String, String> sharedUsers = new HashMap<String, String>();
        List sharedGroups = (List)jobDataMap.get((Object)"sharedGroups");
        String user = jobDataMap.getString("userName");
        String calendarId = jobDataMap.getString("calendarId");
        String stopMessage = jobDataMap.getString("stopMessage");
        JCRDataStorage jcrDataStorage = (JCRDataStorage)jobDataMap.get((Object)"JCRDataStorage");
        try {
            Calendar cal = calendarService.getUserCalendar(user, calendarId);
            if (cal.getViewPermission() != null) {
                for (String v : cal.getViewPermission()) {
                    perms.put(v, String.valueOf(cal.getEditPermission() != null && Arrays.asList(cal.getEditPermission()).contains(v)));
                }
            }
            for (String name : sharedGroups) {
                for (User userTmp : oService.getUserHandler().findUsersByGroup(name.trim()).getAll()) {
                    String userId = userTmp.getUserName();
                    if (perms.get(userId) != null) continue;
                    sharedUsers.put(userId, userId);
                }
            }
            sharedUsers.remove(user);
            jcrDataStorage.shareCalendar(user, calendarId, Arrays.asList(sharedUsers.keySet().toArray(new String[sharedUsers.keySet().size()])));
            continuation.sendMessage(user, "/eXo/Application/Calendar/notifyShareCalendar", (Object)stopMessage);
            log.info((Object)"Finish sharing calendar for groups");
        }
        catch (Exception e) {
            log.debug((Object)("Exception in method:" + e));
            String errorMessage = jobDataMap.getString("errorMessage");
            continuation.sendMessage(user, "/eXo/Application/Calendar/notifyShareCalendar", (Object)errorMessage);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }
}

