/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UIAddressForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIAddressForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "keyWord".intern();
    public static final String FIELD_GROUP = "group".intern();
    private String recipientsType = "";
    protected String selectedAddressId_ = "";
    private UIPageIterator uiPageIterator_;

    public void setRecipientsType(String type) {
        this.recipientsType = type;
    }

    public String getRecipientType() {
        return this.recipientsType;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        UIFormSelectBox fieldGroup = new UIFormSelectBox(FIELD_GROUP, FIELD_GROUP, this.getGroups());
        fieldGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)fieldGroup);
        this.uiPageIterator_ = new UIPageIterator();
        this.uiPageIterator_.setId("UICalendarAddressPage");
    }

    private List<SelectItemOption<String>> getGroups() throws Exception {
        Object[] objGroups;
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ContactService contactService = (ContactService)this.getApplicationComponent(ContactService.class);
        options.add(new SelectItemOption("all", (Object)""));
        SessionProvider sessionPro = SessionProviderFactory.createSessionProvider();
        for (ContactGroup cg : contactService.getGroups(sessionPro, CalendarUtils.getCurrentUser())) {
            options.add(new SelectItemOption(cg.getName(), (Object)cg.getId()));
        }
        List addressList = contactService.getSharedAddressBooks(SessionProviderFactory.createSystemProvider(), CalendarUtils.getCurrentUser());
        for (SharedAddressBook sa : addressList) {
            options.add(new SelectItemOption(sa.getName(), (Object)sa.getId()));
        }
        for (Object object : objGroups = CalendarUtils.getOrganizationService().getGroupHandler().findGroupsOfUser(CalendarUtils.getCurrentUser()).toArray()) {
            if (object == null) continue;
            GroupImpl g = (GroupImpl)object;
            options.add((SelectItemOption<String>)new SelectItemOption(g.getGroupName(), (Object)g.getId()));
        }
        return options;
    }

    public String[] getActions() {
        return new String[]{"Add", "Replace", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Contact> getContacts() throws Exception {
        return new ArrayList<Contact>(this.uiPageIterator_.getCurrentPageData());
    }

    public void setContactList(String groupId) throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ContactFilter filter = new ContactFilter();
        if (!CalendarUtils.isEmpty((String)groupId)) {
            filter.setCategories(new String[]{groupId});
        }
        DataPageList resultPageList = contactSrv.searchContact(SessionProviderFactory.createSystemProvider(), CalendarUtils.getCurrentUser(), filter);
        this.setContactList(resultPageList.getAll());
    }

    public void setContactList(List<Contact> contactList) throws Exception {
        this.getUIFormSelectBox(FIELD_GROUP).setOptions(this.getGroups());
        ObjectPageList objPageList = new ObjectPageList(contactList, 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        for (Contact contact : contactList) {
            UIFormCheckBoxInput uiCheckbox = this.getUIFormCheckBoxInput(contact.getId());
            if (uiCheckbox != null) continue;
            uiCheckbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
            this.addUIFormInput((UIFormInput)uiCheckbox);
        }
    }

    public List<Contact> getCheckedContact() throws Exception {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Contact contact : this.getContacts()) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public long getAvailablePage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageIterator_.setCurrentPage(page);
    }
}

