/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelectComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.calendar.webui.popup.UISharedForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UISharedForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String FIELD_NAME = "calendarName".intern();
    public static final String FIELD_USER = "username".intern();
    public static final String FIELD_EDIT = "canEdit".intern();
    public static final String[] SPECIALCHARACTER = new String[]{CalendarUtils.SEMICOLON, CalendarUtils.SLASH, CalendarUtils.BACKSLASH, "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*"};
    private Map<String, String> permission_ = new HashMap();
    private String calendarId_;
    protected boolean isAddNew_ = true;

    public UISharedForm() throws Exception {
        UIFormInputWithActions inputset = new UIFormInputWithActions("UIInputUserSelect");
        inputset.addChild((UIComponent)new UIFormInputInfo(FIELD_NAME, FIELD_NAME, null));
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_USER, FIELD_USER, null));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setCssIconClass("SelectUserIcon");
        selectUserAction.setActionType(0);
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER);
        actions.add(selectUserAction);
        inputset.setActionField(FIELD_USER, actions);
        inputset.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_EDIT, FIELD_EDIT, null));
        this.addChild((UIComponent)inputset);
    }

    public void init(String username, Calendar cal, boolean isAddNew) {
        this.isAddNew_ = isAddNew;
        this.calendarId_ = cal.getId();
        this.setCalendarName(cal.getName());
        boolean canEdit = false;
        if (cal.getEditPermission() != null) {
            canEdit = Arrays.asList(cal.getEditPermission()).contains(username);
        }
        this.setCanEdit(canEdit);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setSelectedCalendarId(String id) {
        this.calendarId_ = id;
    }

    public void setCalendarName(String value) {
        this.getUIFormInputInfo(FIELD_NAME).setValue((Object)value);
    }

    protected void setCanEdit(boolean canEdit) {
        this.getUIFormCheckBoxInput(FIELD_EDIT).setChecked(canEdit);
    }

    protected boolean canEdit() {
        return this.getUIFormCheckBoxInput(FIELD_EDIT).isChecked();
    }

    protected void setSharedUser(String value) {
        UIFormInputWithActions inputset = (UIFormInputWithActions)this.getChildById("UIInputUserSelect");
        inputset.getUIStringInput(FIELD_USER).setValue((Object)value);
    }

    protected String getSharedUser() {
        UIFormInputWithActions inputset = (UIFormInputWithActions)this.getChildById("UIInputUserSelect");
        return (String)inputset.getUIStringInput(FIELD_USER).getValue();
    }

    public String[] getActions() {
        return new String[]{"Save", "Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        this.permission_.put(value.substring(value.lastIndexOf(":/") + 2), value.substring(value.lastIndexOf(":/") + 2));
        StringBuilder sb = new StringBuilder();
        for (String s : this.permission_.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ String access$000(UISharedForm x0) {
        return x0.calendarId_;
    }

    static /* synthetic */ Map access$100(UISharedForm x0) {
        return x0.permission_;
    }
}

