/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UIFormComboBox;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.popup.UIEventAttenderTab;
import org.exoplatform.calendar.webui.popup.UIEventDetailTab;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIEventReminderTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.MailServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MoveNextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MovePreviousActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEmailAddressActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowUserSelectEventForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIEventForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    public static final String TAB_EVENTDETAIL = "eventDetail".intern();
    public static final String TAB_EVENTREMINDER = "eventReminder".intern();
    public static final String TAB_EVENTSHARE = "eventShare".intern();
    public static final String TAB_EVENTATTENDER = "eventAttender".intern();
    public static final String FIELD_SHARE = "shareEvent".intern();
    public static final String FIELD_STATUS = "status".intern();
    public static final String FIELD_MEETING = "meeting".intern();
    public static final String FIELD_PARTICIPANT = "participant".intern();
    public static final String FIELD_ISSENDMAIL = "isSendMail".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_OUTSIDE = "outside".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    private boolean isAddNew_ = true;
    private CalendarEvent calendarEvent_ = null;
    protected String calType_ = "0";
    private String errorMsg_ = null;
    private String errorValues = null;
    private Map<String, User> participants_ = new LinkedHashMap();
    private String oldCalendarId_ = null;
    private String newCalendarId_ = null;

    public UIEventForm() throws Exception {
        super("UIEventForm");
        UIEventDetailTab eventDetailTab = new UIEventDetailTab(TAB_EVENTDETAIL);
        this.addChild((UIComponent)eventDetailTab);
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_EVENTREMINDER);
        this.addChild((UIComponent)eventReminderTab);
        UIFormInputWithActions eventShareTab = new UIFormInputWithActions(TAB_EVENTSHARE);
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        eventShareTab.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SHARE, FIELD_SHARE, this.getShareValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_STATUS, FIELD_STATUS, this.getStatusValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ISSENDMAIL, FIELD_ISSENDMAIL, (Object)false));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_PARTICIPANT, FIELD_PARTICIPANT, null));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MEETING, FIELD_MEETING, null));
        actions = new ArrayList();
        UIFormInputWithActions.ActionData addUser = new UIFormInputWithActions.ActionData();
        addUser.setActionListener("AddParticipant");
        addUser.setActionName("AddUser");
        addUser.setActionParameter(TAB_EVENTSHARE);
        addUser.setActionType(0);
        addUser.setCssIconClass("SelectUserIcon");
        actions.add(addUser);
        eventShareTab.setActionField(FIELD_PARTICIPANT, actions);
        this.addChild((UIComponent)eventShareTab);
        UIEventAttenderTab eventAttenderTab = new UIEventAttenderTab(TAB_EVENTATTENDER);
        this.addChild((UIComponent)eventAttenderTab);
        this.setSelectedTab(eventDetailTab.getId());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            System.out.println("Can not find " + this.getId() + ".label." + id);
            return id;
        }
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar, String formTime) throws Exception {
        this.reset();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM)).setDateFormatStyle(calSetting.getDateFormat());
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO)).setDateFormatStyle(calSetting.getDateFormat());
        UIEventAttenderTab attenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        List fromOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        List toOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_FROM_TIME).setOptions(fromOptions);
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_TO_TIME).setOptions(toOptions);
        if (eventCalendar != null) {
            this.isAddNew_ = false;
            this.calendarEvent_ = eventCalendar;
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(eventCalendar.getFromDateTime());
            this.setEventToDate(eventCalendar.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(eventCalendar.getCalendarId());
            String eventCategoryId = eventCalendar.getEventCategoryId();
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox selectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                boolean hasEventCategory = false;
                for (SelectItemOption o : selectBox.getOptions()) {
                    if (!((String)o.getValue()).equals(eventCategoryId)) continue;
                    hasEventCategory = true;
                    break;
                }
                if (!hasEventCategory) {
                    selectBox.getOptions().add(new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCategoryId));
                }
                this.setSelectedCategory(eventCategoryId);
            }
            this.setEventPlace(eventCalendar.getLocation());
            this.setEventRepeat(eventCalendar.getRepeatType());
            this.setSelectedEventPriority(eventCalendar.getPriority());
            this.setEventReminders(eventCalendar.getReminders());
            this.setAttachments(eventCalendar.getAttachment());
            if (eventCalendar.isPrivate()) {
                this.setSelectedShareType(ITEM_PRIVATE);
            } else {
                this.setSelectedShareType(ITEM_PUBLIC);
            }
            this.setSelectedEventState(eventCalendar.getEventState());
            this.setMeetingInvitation(eventCalendar.getInvitation());
            StringBuffer pars = new StringBuffer();
            if (eventCalendar.getParticipant() != null) {
                for (String par : eventCalendar.getParticipant()) {
                    if (!CalendarUtils.isEmpty((String)pars.toString())) {
                        pars.append(",");
                    }
                    pars.append(par);
                }
            }
            this.setParticipant(pars.toString());
            if (eventCategoryId != null) {
                UIFormSelectBox uiSelectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                if (!this.isAddNew_ && !String.valueOf(0).equalsIgnoreCase(this.calType_)) {
                    SelectItemOption item = new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCalendar.getEventCategoryId());
                    uiSelectBox.getOptions().add(item);
                    uiSelectBox.setValue(eventCalendar.getEventCategoryId());
                    uiSelectBox.setDisabled(true);
                    eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setDisabled(true);
                    eventDetailTab.setActionField(UIEventDetailTab.FIELD_CATEGORY, null);
                }
            }
            attenderTab.calendar_.setTime(eventCalendar.getFromDateTime());
        } else {
            UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
            Calendar cal = CalendarUtils.getInstanceTempCalendar();
            try {
                cal.setTimeInMillis(Long.parseLong(formTime));
            }
            catch (Exception e) {
                cal.setTime(miniCalendar.getCurrentCalendar().getTime());
            }
            Long beginMinute = (long)cal.get(12) / calSetting.getTimeInterval() * calSetting.getTimeInterval();
            cal.set(12, beginMinute.intValue());
            this.setEventFromDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(cal.getTime());
            cal.add(12, (int)calSetting.getTimeInterval() * 2);
            this.setEventToDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            StringBuffer pars = new StringBuffer(CalendarUtils.getCurrentUser());
            this.setParticipant(pars.toString());
            attenderTab.updateParticipants(pars.toString());
        }
    }

    private void setEventCheckTime(Date time) {
        UIEventAttenderTab uiAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        uiAttenderTab.calendar_.setTime(time);
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        if (options != null) {
            uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setOptions(options);
        } else {
            uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setOptions(this.getCalendars());
        }
        this.calType_ = calType;
    }

    private List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    public static List<SelectItemOption<String>> getCategory() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List eventCategories = calendarService.getEventCategories(CalendarUtils.getCurrentUser());
        for (EventCategory category : eventCategories) {
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setOptions(UIEventForm.getCategory());
    }

    private List<SelectItemOption<String>> getShareValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_PRIVATE, (Object)ITEM_PRIVATE));
        options.add(new SelectItemOption(ITEM_PUBLIC, (Object)ITEM_PUBLIC));
        return options;
    }

    private List<SelectItemOption<String>> getStatusValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_BUSY, (Object)ITEM_BUSY));
        options.add(new SelectItemOption(ITEM_AVAILABLE, (Object)ITEM_AVAILABLE));
        options.add(new SelectItemOption(ITEM_OUTSIDE, (Object)ITEM_OUTSIDE));
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
    }

    protected boolean isEventDetailValid(CalendarSetting calendarSetting) throws Exception {
        String dateFormat = calendarSetting.getDateFormat();
        String timeFormat = calendarSetting.getTimeFormat();
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = this.getId() + ".msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = this.getId() + ".msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventToDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-todate-required";
            return false;
        }
        try {
            from = this.getEventFromDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                return false;
            }
            if (!CalendarUtils.isAllEmailValid((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                this.errorValues = CalendarUtils.invalidEmailAddresses((String)this.getEmailAddress());
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isParticipantValid() throws Exception {
        if (this.isSendMail() && CalendarUtils.isEmpty((String)this.getParticipantValues())) {
            this.errorMsg_ = "UIEventForm.msg.error-particimant-email-required";
            return false;
        }
        if (this.isSendMail()) {
            this.errorValues = null;
            StringBuilder buider = new StringBuilder("");
            for (String par : this.getParticipantValues().split(CalendarUtils.COMMA)) {
                if (CalendarUtils.getOrganizationService().getUserHandler().findUserByName(par) != null) continue;
                if (buider.length() > 0) {
                    buider.append(", ");
                }
                buider.append(par);
            }
            if (buider.length() > 0) {
                this.errorMsg_ = "UIEventForm.msg.invalid-username";
                this.errorValues = buider.toString();
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        String value;
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        this.newCalendarId_ = value = (String)eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void setSelectedCalendarId(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        value = this.calType_ + CalendarUtils.COLON + value;
        eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setValue(value);
        this.oldCalendarId_ = value;
    }

    protected String getEventCategory() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).getValue();
    }

    public void setSelectedCategory(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceTempCalendar());
            return CalendarUtils.getBeginDay((Date)df.parse((String)fromField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        return df.parse((String)fromField.getValue() + " " + (String)timeField.getValue());
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        fromField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventFromDate(date, timeFormat);
    }

    protected Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceTempCalendar());
            return CalendarUtils.getEndDay((Date)df.parse((String)toField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        return df.parse((String)toField.getValue() + " " + (String)timeField.getValue());
    }

    protected void setEventToDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        toField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventToDate(date, timeFormat);
    }

    protected String getEventToDateValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected boolean getEventAllDate() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).getValue();
    }

    protected void setEventRepeat(String type) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).setValue(type);
    }

    protected String getEventPlace() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).getValue();
    }

    protected void setEventPlace(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    public void setEmailReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected String isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return String.valueOf("repeat".equals(eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_IS_REPEAT).getValue()));
    }

    public void setEmailRepeat(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        value = Boolean.parseBoolean(value) ? "repeat" : "no-repeat";
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_IS_REPEAT).setValue(value);
    }

    protected String getEmailRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected void setEmailRepeatInterVal(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected String isPopupRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return String.valueOf("repeat".equals(eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_IS_REPEAT).getValue()));
    }

    protected void setPopupRepeat(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        value = Boolean.parseBoolean(value) ? "repeat" : "no-repeat";
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_IS_REPEAT).setValue(value);
    }

    protected String getPopupRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
    }

    public void setEmailRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue(value);
    }

    protected String getEmailAddress() throws Exception {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormTextAreaInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    public void setEmailAddress(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormTextAreaInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected boolean getPopupReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).isChecked();
    }

    protected void setPopupReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).setChecked(isChecked);
    }

    protected String getPopupReminderTime() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).getValue();
    }

    protected void setPopupRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue(value);
    }

    protected long getPopupReminderSnooze() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        try {
            String time = (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
            return Long.parseLong(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected List<Attachment> getAttachments(String eventId, boolean isAddNew) {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        return uiEventDetailTab.getAttachments();
    }

    protected long getTotalAttachment() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        long attSize = 0L;
        for (Attachment att : uiEventDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    protected void setAttachments(List<Attachment> attachment) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        uiEventDetailTab.setAttachments(attachment);
        uiEventDetailTab.refreshUploadFileList();
    }

    protected void setPopupRepeatInterval(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected void setEventReminders(List<Reminder> reminders) {
        for (Reminder rm : reminders) {
            if (Reminder.TYPE_EMAIL.equals(rm.getReminderType())) {
                this.setEmailReminder(true);
                this.setEmailAddress(rm.getEmailAddress());
                this.setEmailRepeat(String.valueOf(rm.isRepeat()));
                this.setEmailRemindBefore(String.valueOf(rm.getAlarmBefore()));
                this.setEmailRepeatInterVal(rm.getRepeatInterval());
                continue;
            }
            if (!Reminder.TYPE_POPUP.equals(rm.getReminderType())) continue;
            this.setPopupReminder(true);
            this.setPopupRepeat(String.valueOf(rm.isRepeat()));
            this.setPopupRemindBefore(String.valueOf(rm.getAlarmBefore()));
            this.setPopupRepeatInterval(rm.getRepeatInterval());
        }
    }

    protected List<Reminder> getEventReminders(Date fromDateTime, List<Reminder> currentReminders) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_EMAIL)) continue;
                    email = rm;
                    break;
                }
            }
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            StringBuffer sbAddress = new StringBuffer();
            for (String s : this.getEmailAddress().split(CalendarUtils.COMMA)) {
                if (!CalendarUtils.isEmailValid((String)(s = s.trim()))) continue;
                if (sbAddress.length() > 0) {
                    sbAddress.append(CalendarUtils.COMMA);
                }
                sbAddress.append(s);
            }
            email.setEmailAddress(sbAddress.toString());
            email.setRepeate(Boolean.parseBoolean(this.isEmailRepeat()));
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            reminders.add(email);
        }
        if (this.getPopupReminder()) {
            Reminder popup = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_POPUP)) continue;
                    popup = rm;
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            boolean isExist = false;
            if (this.getParticipants() != null) {
                String s2;
                int i$ = 0;
                String[] arr$ = this.getParticipants();
                int len$ = arr$.length;
                if (i$ < len$ && (s2 = arr$[i$]).equals(CalendarUtils.getCurrentUser())) {
                    isExist = true;
                }
                for (String s2 : this.getParticipants()) {
                    if (sb.length() > 0) {
                        sb.append(CalendarUtils.COMMA);
                    }
                    sb.append(s2);
                }
            }
            if (!isExist) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(CalendarUtils.getCurrentUser());
            }
            popup.setReminderOwner(sb.toString());
            popup.setReminderType(Reminder.TYPE_POPUP);
            popup.setAlarmBefore(Long.parseLong(this.getPopupReminderTime()));
            popup.setRepeate(Boolean.parseBoolean(this.isPopupRepeat()));
            popup.setRepeatInterval(Long.parseLong(this.getPopupRepeatInterVal()));
            popup.setFromDateTime(fromDateTime);
            reminders.add(popup);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).setValue(value);
    }

    protected String getEventState() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormSelectBox(FIELD_STATUS).getValue();
    }

    public void setSelectedEventState(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormSelectBox(FIELD_STATUS).setValue(value);
    }

    protected String getShareType() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormSelectBox(FIELD_SHARE).getValue();
    }

    protected void setSelectedShareType(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormSelectBox(FIELD_SHARE).setValue(value);
    }

    protected String[] getMeetingInvitation() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        String invitation = (String)eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).getValue();
        if (CalendarUtils.isEmpty((String)invitation)) {
            return null;
        }
        return invitation.split(CalendarUtils.COMMA);
    }

    protected String getInvitationEmail() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        String invitation = (String)eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).getValue();
        return invitation;
    }

    protected void setMeetingInvitation(String[] values) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            for (String s : values) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(s);
            }
        }
        eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).setValue((Object)sb.toString());
    }

    protected String[] getParticipants() throws Exception {
        String participants = this.getParticipantValues();
        if (CalendarUtils.isEmpty((String)participants)) {
            return null;
        }
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        HashMap<String, String> parMap = new HashMap<String, String>();
        for (String user : participants.split(CalendarUtils.COMMA)) {
            if (orgService.getUserHandler().findUserByName(user.trim()) != null) {
                parMap.put(user.trim(), user.trim());
                continue;
            }
            if (!CalendarUtils.isValidEmailAddresses((String)user.trim())) continue;
        }
        return parMap.values().toArray(new String[parMap.values().size()]);
    }

    protected String getParticipantValues() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormTextAreaInput(FIELD_PARTICIPANT).getValue();
    }

    public void setParticipant(String values) throws Exception {
        this.participants_.clear();
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        StringBuffer sb = new StringBuffer();
        for (String s : values.split(CalendarUtils.COMMA)) {
            User user = orgService.getUserHandler().findUserByName(s);
            if (user == null) continue;
            this.participants_.put(s.trim(), user);
            if (!CalendarUtils.isEmpty((String)sb.toString())) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s.trim());
        }
        ((UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE)).getUIFormTextAreaInput(FIELD_PARTICIPANT).setValue((Object)sb.toString());
        ((UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER)).updateParticipants(values);
    }

    protected SessionProvider getSession() {
        return SessionProviderFactory.createSessionProvider();
    }

    protected SessionProvider getSystemSession() {
        return SessionProviderFactory.createSystemProvider();
    }

    protected boolean isSendMail() {
        UIFormInputWithActions uiShareTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        return uiShareTab.getUIFormCheckBoxInput(FIELD_ISSENDMAIL).isChecked();
    }

    protected void sendMail(MailService svr, OrganizationService orSvr, CalendarSetting setting, Account acc, String fromId, String toId, CalendarEvent event) throws Exception {
        CalendarService calService;
        List atts = this.getAttachments(null, false);
        SimpleDateFormat df = new SimpleDateFormat(setting.getDateFormat() + " " + setting.getTimeFormat());
        User invitor = orSvr.getUserHandler().findUserByName(CalendarUtils.getCurrentUser());
        StringBuffer sbSubject = new StringBuffer("[" + this.getLabel("invitation") + "] ");
        sbSubject.append(event.getSummary());
        sbSubject.append(" ");
        sbSubject.append(df.format(event.getFromDateTime()));
        StringBuffer sbBody = new StringBuffer();
        sbBody.append("<div style=\"margin: 20px auto; padding: 8px; background: rgb(224, 236, 255) none repeat scroll 0%; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial; width: 400px;\">");
        sbBody.append("<table style=\"margin: 0px; padding: 0px; border-collapse: collapse; border-spacing: 0px; width: 100%; line-height: 16px;\">");
        sbBody.append("<tbody>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap; \">" + this.getLabel("fromWho") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> " + invitor.getUserName() + "(" + invitor.getEmail() + ")" + " </td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_EVENT) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getSummary() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_DESCRIPTION) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getDescription() != null && event.getDescription().trim().length() > 0 ? event.getDescription() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel("when") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> <div>" + this.getLabel(UIEventDetailTab.FIELD_FROM) + ": " + df.format(event.getFromDateTime()) + "</div>");
        sbBody.append("<div>" + this.getLabel(UIEventDetailTab.FIELD_TO) + ": " + df.format(event.getToDateTime()) + "</div></td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_PLACE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getLocation() != null && event.getLocation().trim().length() > 0 ? event.getLocation() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(FIELD_PARTICIPANT) + "</td>");
        if (CalendarUtils.isEmpty((String)this.getInvitationEmail())) {
            sbBody.append("<td style=\"padding: 4px;\">" + toId + "</td>");
        } else {
            String newInvi = this.getInvitationEmail().replace(",", ", ");
            sbBody.append("<td style=\"padding: 4px;\">" + toId + ", " + newInvi + "</td>");
        }
        sbBody.append("</tr>");
        if (!atts.isEmpty()) {
            sbBody.append("<tr>");
            sbBody.append("<td style=\"padding: 4px; width: 60px; text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_ATTACHMENTS) + ":</td>");
            StringBuffer sbf = new StringBuffer();
            for (Attachment att : atts) {
                if (sbf.length() > 0) {
                    sbf.append(",");
                }
                sbf.append(att.getName());
            }
            sbBody.append("<td style=\"padding: 4px;\"> (" + atts.size() + ") " + sbf.toString() + " </td>");
            sbBody.append("</tr>");
        }
        sbBody.append("</tbody>");
        sbBody.append("</table>");
        sbBody.append("</div>");
        StringBuffer sbAddress = new StringBuffer();
        for (String s : toId.split(CalendarUtils.COMMA)) {
            s = s.trim();
            User reciver = orSvr.getUserHandler().findUserByName(s.trim());
            if (reciver.getEmail() != null && !CalendarUtils.isEmpty((String)sbAddress.toString())) {
                sbAddress.append(CalendarUtils.COMMA);
            }
            sbAddress.append(reciver.getEmail());
        }
        if (event.getInvitation() != null) {
            for (String s : event.getInvitation()) {
                s = s.trim();
                if (sbAddress.length() > 0) {
                    sbAddress.append(",");
                }
                sbAddress.append(s);
            }
        }
        StringBuffer values = new StringBuffer(fromId);
        User user = orSvr.getUserHandler().findUserByName(fromId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(toId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalType());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalendarId());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getId());
        if (acc != null) {
            org.exoplatform.mail.service.Message message = new org.exoplatform.mail.service.Message();
            message.setSubject(sbSubject.toString());
            message.setMessageBody(sbBody.toString());
            message.setMessageTo(sbAddress.toString());
            message.setContentType(Utils.MIMETYPE_TEXTHTML);
            message.setFrom(user.getEmail());
            message.setHeader(CalendarUtils.EXO_INVITATION, values.toString());
            message.setSendDate(new Date());
            ArrayList<BufferAttachment> attachments = new ArrayList<BufferAttachment>();
            try {
                calService = CalendarUtils.getCalendarService();
                OutputStream out = calService.getCalendarImportExports(CalendarServiceImpl.ICALENDAR).exportEventCalendar(this.getSystemSession(), fromId, event.getCalendarId(), event.getCalType(), event.getId());
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                BufferAttachment bf = new BufferAttachment();
                bf.setInputStream((InputStream)is);
                bf.setName("icalendar.ics");
                bf.setMimeType("text/calendar");
                attachments.add(bf);
                for (Attachment att : atts) {
                    bf = new BufferAttachment();
                    bf.setInputStream(att.getInputStream());
                    bf.setName(att.getName());
                    bf.setMimeType(att.getMimeType());
                    attachments.add(bf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            message.setAttachements(attachments);
            svr.sendMessage(this.getSession(), user.getUserName(), acc.getId(), message);
        } else {
            Message message = new Message();
            message.setSubject(sbSubject.toString());
            message.setBody(sbBody.toString());
            message.setTo(sbAddress.toString());
            message.setMimeType(Utils.MIMETYPE_TEXTHTML);
            message.setFrom(user.getEmail());
            org.exoplatform.services.mail.Attachment attachmentCal = new org.exoplatform.services.mail.Attachment();
            try {
                calService = CalendarUtils.getCalendarService();
                OutputStream out = calService.getCalendarImportExports(CalendarServiceImpl.ICALENDAR).exportEventCalendar(this.getSystemSession(), fromId, event.getCalendarId(), event.getCalType(), event.getId());
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                attachmentCal.setInputStream((InputStream)is);
                attachmentCal.setMimeType("text/calendar");
                message.addAttachment(attachmentCal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!atts.isEmpty()) {
                for (Attachment att : atts) {
                    org.exoplatform.services.mail.Attachment attachment = new org.exoplatform.services.mail.Attachment();
                    attachment.setInputStream(att.getInputStream());
                    attachment.setMimeType(att.getMimeType());
                    message.addAttachment(attachment);
                }
            }
            org.exoplatform.services.mail.MailService mService = (org.exoplatform.services.mail.MailService)this.getApplicationComponent(MailServiceImpl.class);
            mService.sendMessage(message);
        }
    }

    public String cleanValue(String values) throws Exception {
        String[] tmpArr = values.split(",");
        List<String> list = Arrays.asList(tmpArr);
        HashSet<String> set = new HashSet<String>(list);
        String[] result = new String[set.size()];
        set.toArray(result);
        String data2 = "";
        for (String s : result) {
            data2 = data2 + "," + s;
        }
        data2 = data2.substring(1);
        return data2;
    }

    public Attachment getAttachment(String attId) {
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        for (Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    static /* synthetic */ String access$000(UIEventForm x0) {
        return x0.errorMsg_;
    }

    static /* synthetic */ boolean access$100(UIEventForm x0) throws Exception {
        return x0.isReminderValid();
    }

    static /* synthetic */ String access$200(UIEventForm x0) {
        return x0.errorValues;
    }

    static /* synthetic */ boolean access$300(UIEventForm x0) throws Exception {
        return x0.isParticipantValid();
    }

    static /* synthetic */ boolean access$400(UIEventForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ CalendarEvent access$500(UIEventForm x0) {
        return x0.calendarEvent_;
    }

    static /* synthetic */ String access$600(UIEventForm x0) {
        return x0.oldCalendarId_;
    }

    static /* synthetic */ String access$700(UIEventForm x0) {
        return x0.newCalendarId_;
    }
}

