/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIYearView;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIYearView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class})})
public class UIYearView
extends UICalendarView {
    private Map<Integer, String> yearData_ = new HashMap();
    private String categoryId_ = null;

    protected void yearNext(int years) {
        this.calendar_.add(1, years);
    }

    protected void yearBack(int years) {
        this.calendar_.add(1, years);
    }

    protected Map<Integer, String> getValueMap() {
        return this.yearData_;
    }

    public void refresh() throws Exception {
        this.yearData_.clear();
        GregorianCalendar cal = new GregorianCalendar(this.getCurrentYear(), 0, 1, 0, 0, 0);
        Calendar beginYear = CalendarUtils.getBeginDay((Calendar)cal);
        ((Calendar)cal).add(1, 1);
        ((Calendar)cal).add(14, -1);
        GregorianCalendar endYear = cal;
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        if (!(CalendarUtils.isEmpty((String)this.categoryId_) || this.categoryId_.toLowerCase().equals("null") || this.categoryId_.toLowerCase().equals("all") || this.categoryId_.equals("calId"))) {
            eventQuery.setCategoryId(new String[]{this.categoryId_});
        }
        eventQuery.setFromDate(beginYear);
        eventQuery.setToDate((Calendar)endYear);
        this.yearData_ = calendarService.searchHightLightEvent(username, eventQuery, this.getPublicCalendars());
        UIFormSelectBox uiCategory = this.getUIFormSelectBox(EVENT_CATEGORIES);
        uiCategory.setValue(this.categoryId_);
        uiCategory.setOnChange("Onchange");
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return null;
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
        this.setSelectedCategory(categoryId);
    }

    protected String[] getDaysNameTitle() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        LinkedHashMap<Integer, String> days = new LinkedHashMap<Integer, String>();
        if (!locale.getDisplayLanguage().contains("Vietnam")) {
            for (int i = 1; i < dfs.getWeekdays().length; ++i) {
                days.put(i, dfs.getWeekdays()[i]);
            }
        } else {
            days.put(1, dfs.getWeekdays()[1]);
            for (int i = 2; i < dfs.getWeekdays().length; ++i) {
                days.put(i, dfs.getWeekdays()[i].split(" ")[1].toUpperCase());
            }
        }
        return days.values().toArray(new String[0]);
    }
}

