/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UICalendarView
extends UIForm
implements CalendarView {
    protected static final String EVENT_CATEGORIES = "eventCategories".intern();
    public static final int TYPE_DAY = 0;
    public static final int TYPE_WEEK = 1;
    public static final int TYPE_MONTH = 2;
    public static final int TYPE_YEAR = 3;
    public static final String ACT_NEXT = "MoveNext".intern();
    public static final String ACT_PREVIOUS = "MovePrevious".intern();
    public static final String ACT_ADDNEW_EVENT = "QuickAddNewEvent".intern();
    public static final String ACT_ADDNEW_TASK = "QuickAddNewTask".intern();
    public static final String[] CONTEXT_MENU = new String[]{ACT_ADDNEW_EVENT, ACT_ADDNEW_TASK};
    public static final String ACT_VIEW = "View".intern();
    public static final String ACT_EDIT = "Edit".intern();
    public static final String ACT_DELETE = "Delete".intern();
    public static final String[] QUICKEDIT_MENU = new String[]{ACT_VIEW, ACT_EDIT, ACT_DELETE};
    public static final String CALNAME = "calName".intern();
    public static final String CALENDARID = "calendarId".intern();
    public static final String CALTYPE = "calType".intern();
    public static final String EVENTID = "eventId".intern();
    public static final String DAY = "day".intern();
    public static final String MONTH = "month".intern();
    public static final String YEAR = "year".intern();
    public static final String TYPE_EVENT = CalendarEvent.TYPE_EVENT;
    public static final String TYPE_TASK = CalendarEvent.TYPE_TASK;
    public static final String TYPE_BOTH = "Both".intern();
    private String viewType_ = TYPE_BOTH;
    private String[] views = new String[]{TYPE_BOTH, TYPE_EVENT, TYPE_TASK};
    protected java.util.Calendar calendar_ = null;
    protected List<String> displayTimes_ = null;
    protected Map<String, String> timeSteps_ = null;
    public boolean isShowEvent_ = true;
    private String editedEventId_ = null;
    private int timeInterval_ = 30;
    protected CalendarSetting calendarSetting_;
    private String dateTimeFormat_;
    protected List<String> privateCalendarIds = new ArrayList();
    protected List<String> publicCalendarIds = new ArrayList();
    protected java.util.Calendar instanceTempCalendar_ = null;
    public static final Map<Integer, String> monthsName_ = new HashMap();
    private Map<Integer, String> daysMap_ = new LinkedHashMap();
    private Map<Integer, String> monthsMap_ = new LinkedHashMap();
    private Map<String, String> priorityMap_ = new HashMap();
    protected DateFormatSymbols dfs_;
    private boolean allDelete_ = true;

    abstract LinkedHashMap<String, CalendarEvent> getDataMap();

    public UICalendarView() throws Exception {
        int i;
        this.initCategories();
        this.applySeting();
        this.calendar_ = this.getInstanceTempCalendar();
        this.calendar_.setLenient(false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy k:m:s z");
        simpleDateFormat.setCalendar(this.calendar_);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (i = 0; i < this.dfs_.getMonths().length; ++i) {
            this.monthsMap_.put(i, this.dfs_.getMonths()[i]);
        }
        for (i = 1; i < this.dfs_.getWeekdays().length; ++i) {
            this.daysMap_.put(i, this.dfs_.getWeekdays()[i]);
        }
        for (i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
            this.priorityMap_.put(String.valueOf(i), CalendarEvent.PRIORITY[i]);
        }
    }

    protected java.util.Calendar getInstanceTempCalendar() {
        if (this.instanceTempCalendar_ != null) {
            return this.instanceTempCalendar_;
        }
        java.util.Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public void applySeting() throws Exception {
        this.displayTimes_ = null;
        this.timeSteps_ = null;
        this.instanceTempCalendar_ = null;
        try {
            this.calendarSetting_ = ((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getCalendarSetting();
        }
        catch (Exception e) {
            CalendarService calService = CalendarUtils.getCalendarService();
            String username = CalendarUtils.getCurrentUser();
            this.calendarSetting_ = calService.getCalendarSetting(username);
        }
        this.dateTimeFormat_ = this.getDateFormat() + " " + this.getTimeFormat();
    }

    public void setViewType(String viewType) {
        this.viewType_ = viewType;
    }

    public String getViewType() {
        return this.viewType_;
    }

    protected String[] getViews() {
        return this.views;
    }

    public void setLastUpdatedEventId(String eventId) {
        this.editedEventId_ = eventId;
    }

    public String getLastUpdatedEventId() {
        return this.editedEventId_;
    }

    public String[] getPublicCalendars() throws Exception {
        try {
            return ((UICalendars)((UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class)).findFirstComponentOfType(UICalendars.class)).getPublicCalendarIds();
        }
        catch (Exception e) {
            String[] groups = CalendarUtils.getUserGroups((String)CalendarUtils.getCurrentUser());
            CalendarService calendarService = CalendarUtils.getCalendarService();
            HashMap<String, String> map = new HashMap<String, String>();
            for (GroupCalendarData group : calendarService.getGroupCalendars(groups, false, CalendarUtils.getCurrentUser())) {
                for (Calendar calendar : group.getCalendars()) {
                    map.put(calendar.getId(), calendar.getId());
                }
            }
            return map.values().toArray(new String[0]);
        }
    }

    public List<String> getPrivateCalendars() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        ArrayList<String> list = new ArrayList<String>();
        for (Calendar c : calendarService.getUserCalendars(CalendarUtils.getCurrentUser(), true)) {
            if (c.getId().equals(Utils.getDefaultCalendarId((String)CalendarUtils.getCurrentUser())) && c.getName().equals("defaultCalendarName")) {
                String newName = CalendarUtils.getResourceBundle((String)"UICalendars.label.defaultCalendarId");
                c.setName(newName);
            }
            list.add(c.getId());
        }
        return list;
    }

    public List<String> getSharedCalendars() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        GroupCalendarData gcd = calendarService.getSharedCalendars(CalendarUtils.getCurrentUser(), true);
        if (gcd != null) {
            for (Calendar cal : gcd.getCalendars()) {
                list.add(cal.getId());
            }
        }
        return list;
    }

    public String[] getFilterCalendarIds() throws Exception {
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterPrivateCalendars()));
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterPublicCalendars()));
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterSharedCalendars()));
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(this.getPrivateCalendars());
        ids.addAll(this.getSharedCalendars());
        ids.addAll(Arrays.asList(this.getPublicCalendars()));
        ArrayList<String> results = new ArrayList<String>();
        for (String id : ids) {
            if (filterList.contains(id)) continue;
            results.add(id);
        }
        return filterList.toArray(new String[0]);
    }

    protected List<GroupCalendarData> getPublicCalendars(String username) throws Exception {
        String[] groups = CalendarUtils.getUserGroups((String)username);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List groupCalendars = calendarService.getGroupCalendars(groups, false, username);
        return groupCalendars;
    }

    public LinkedHashMap<String, String> getColors() {
        try {
            return ((UICalendars)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UICalendars.class)).getColorMap();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new LinkedHashMap<String, String>();
        }
    }

    public void refresh() throws Exception {
    }

    public void initCategories() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List eventCategories = calendarService.getEventCategories(username);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (EventCategory category : eventCategories) {
            if (category.getId().contains("defaultEventCategoryId") && category.getName().contains("defaultEventCategoryName")) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()));
                options.add(new SelectItemOption(newName, (Object)category.getId()));
                category.setName(newName);
                continue;
            }
            options.add(new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        UIFormSelectBox categoryInput = new UIFormSelectBox(EVENT_CATEGORIES, EVENT_CATEGORIES, options);
        this.addUIFormInput((UIFormInput)categoryInput);
    }

    protected String getSelectedCategory() {
        return (String)this.getUIFormSelectBox(EVENT_CATEGORIES).getValue();
    }

    public void setSelectedCategory(String id) {
        this.getUIFormSelectBox(EVENT_CATEGORIES).setValue(id);
    }

    protected String[] getMonthsName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (int i = 0; i < this.dfs_.getMonths().length; ++i) {
            this.monthsMap_.put(i, this.dfs_.getMonths()[i]);
        }
        return this.monthsMap_.values().toArray(new String[0]);
    }

    protected String[] getDaysName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (int i = 1; i < this.dfs_.getWeekdays().length; ++i) {
            this.daysMap_.put(i, this.dfs_.getWeekdays()[i]);
        }
        return this.daysMap_.values().toArray(new String[0]);
    }

    protected java.util.Calendar getDateByValue(int year, int month, int day, int type, int value) {
        GregorianCalendar cl = new GregorianCalendar(year, month, day);
        switch (type) {
            case 0: {
                ((java.util.Calendar)cl).add(5, value);
                break;
            }
            case 1: {
                ((java.util.Calendar)cl).add(3, value);
                break;
            }
            case 2: {
                ((java.util.Calendar)cl).add(2, value);
                break;
            }
            case 3: {
                ((java.util.Calendar)cl).add(1, value);
                break;
            }
        }
        return cl;
    }

    protected int getDaysInMonth() {
        return this.calendar_.getActualMaximum(5);
    }

    protected int getDaysInMonth(int month, int year) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        return ((java.util.Calendar)cal).getActualMaximum(5);
    }

    protected int getDayOfWeek(int year, int month, int day) {
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        return gc.get(7);
    }

    protected String getMonthName(int month) {
        this.getMonthsName();
        return ((String)this.monthsMap_.get(month)).toString();
    }

    protected String getDayName(int day) {
        this.getDaysName();
        return ((String)this.daysMap_.get(day)).toString();
    }

    protected String keyGen(int day, int month, int year) {
        return String.valueOf(day) + CalendarUtils.UNDERSCORE + String.valueOf(month) + CalendarUtils.UNDERSCORE + String.valueOf(year);
    }

    public void update() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List eventCategories = calendarService.getEventCategories(username);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (EventCategory category : eventCategories) {
            if (category.getId().contains("defaultEventCategoryId") && category.getName().contains("defaultEventCategoryName")) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()));
                options.add(new SelectItemOption(newName, (Object)category.getId()));
                continue;
            }
            options.add(new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        this.getUIFormSelectBox(EVENT_CATEGORIES).setOptions(options);
        this.getUIFormSelectBox(EVENT_CATEGORIES).setValue(null);
    }

    public List<CalendarEvent> getList() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List<Object> events = new ArrayList<CalendarEvent>();
        if (this.privateCalendarIds.size() > 0) {
            events = calendarService.getUserEventByCalendar(CalendarUtils.getCurrentUser(), this.privateCalendarIds);
        }
        if (this.publicCalendarIds.size() > 0) {
            if (events.size() > 0) {
                List publicEvents = calendarService.getGroupEventByCalendar(this.publicCalendarIds);
                for (CalendarEvent event : publicEvents) {
                    events.add(event);
                }
            } else {
                events = calendarService.getGroupEventByCalendar(this.publicCalendarIds);
            }
        }
        return events;
    }

    protected void gotoDate(int day, int month, int year) {
        this.setCurrentDay(day);
        this.setCurrentMonth(month);
        this.setCurrentYear(year);
    }

    protected boolean isCurrentDay(int day, int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceTempCalendar();
        boolean isCurrentDay = currentCal.get(5) == day;
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentDay && isCurrentMonth && isCurrentYear;
    }

    protected boolean isCurrentWeek(int week, int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceTempCalendar();
        boolean isCurrentWeek = currentCal.get(3) == week;
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentWeek && isCurrentMonth && isCurrentYear;
    }

    protected boolean isCurrentMonth(int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceTempCalendar();
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentMonth && isCurrentYear;
    }

    protected boolean isSameDate(java.util.Calendar date1, java.util.Calendar date2) {
        return CalendarUtils.isSameDate((java.util.Calendar)date1, (java.util.Calendar)date2);
    }

    protected boolean isSameDate(Date value1, Date value2) {
        return CalendarUtils.isSameDate((Date)value1, (Date)value2);
    }

    public void setCurrentCalendar(java.util.Calendar value) {
        this.calendar_ = value;
    }

    public java.util.Calendar getCurrentCalendar() {
        return this.calendar_;
    }

    protected Date getCurrentDate() {
        return this.calendar_.getTime();
    }

    protected void setCurrentDate(Date value) {
        this.calendar_.setTime(value);
    }

    protected int getCurrentDay() {
        return this.calendar_.get(5);
    }

    protected void setCurrentDay(int day) {
        this.calendar_.set(5, day);
    }

    protected int getCurrentWeek() {
        return this.calendar_.get(3);
    }

    protected void setCurrentWeek(int week) {
        this.calendar_.set(3, week);
    }

    protected int getCurrentMonth() {
        return this.calendar_.get(2);
    }

    protected void setCurrentMonth(int month) {
        this.calendar_.set(2, month);
    }

    protected int getCurrentYear() {
        return this.calendar_.get(1);
    }

    protected void setCurrentYear(int year) {
        this.calendar_.set(1, year);
    }

    protected void moveCalendarTo(int field, int amount) throws Exception {
        this.calendar_.add(field, amount);
    }

    protected void removeEvents(List<CalendarEvent> events) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        OrganizationService orService = CalendarUtils.getOrganizationService();
        for (CalendarEvent ce : events) {
            Calendar cal = null;
            if (CalendarUtils.PUBLIC_TYPE.equals(ce.getCalType())) {
                cal = calService.getGroupCalendar(ce.getCalendarId());
                if (cal.getEditPermission() != null && CalendarUtils.canEdit((OrganizationService)orService, (String[])cal.getEditPermission(), (String)username)) {
                    calService.removePublicEvent(ce.getCalendarId(), ce.getId());
                    continue;
                }
                this.allDelete_ = false;
                continue;
            }
            if (CalendarUtils.PRIVATE_TYPE.equals(ce.getCalType())) {
                calService.removeUserEvent(username, ce.getCalendarId(), ce.getId());
                continue;
            }
            if (!CalendarUtils.SHARED_TYPE.equals(ce.getCalType())) continue;
            cal = calService.getSharedCalendars(username, true).getCalendarById(ce.getCalendarId());
            if (cal.getEditPermission() != null && CalendarUtils.canEdit(null, (String[])cal.getEditPermission(), (String)username)) {
                calService.removeSharedEvent(username, ce.getCalendarId(), ce.getId());
                continue;
            }
            this.allDelete_ = false;
        }
    }

    protected void moveEvents(List<CalendarEvent> events, String toCalendarId, String toType) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        for (CalendarEvent ce : events) {
            ArrayList<CalendarEvent> list = new ArrayList<CalendarEvent>();
            list.add(ce);
            calService.moveEvent(ce.getCalendarId(), ce.getCalendarId(), ce.getCalType(), ce.getCalType(), list, username);
        }
    }

    protected java.util.Calendar getBeginDay(java.util.Calendar cal) {
        return CalendarUtils.getBeginDay((java.util.Calendar)cal);
    }

    protected java.util.Calendar getEndDay(java.util.Calendar cal) {
        return CalendarUtils.getEndDay((java.util.Calendar)cal);
    }

    protected String[] getContextMenu() {
        return CONTEXT_MENU;
    }

    protected String[] getQuickEditMenu() {
        return QUICKEDIT_MENU;
    }

    protected List<String> getDisplayTimes(String timeFormat, int timeInterval) {
        if (this.displayTimes_ == null) {
            this.displayTimes_ = new ArrayList();
            java.util.Calendar cal = CalendarUtils.getInstanceTempCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            SimpleDateFormat df = new SimpleDateFormat(timeFormat);
            df.setCalendar(cal);
            for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
                this.displayTimes_.add(df.format(cal.getTime()));
                cal.add(12, timeInterval);
            }
        }
        return this.displayTimes_;
    }

    protected List<String> getDisplayTimes(String timeFormat, int timeInterval, Locale locale) {
        ArrayList<String> displayTimes = new ArrayList<String>();
        java.util.Calendar cal = CalendarUtils.getInstanceTempCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        SimpleDateFormat valuedf = new SimpleDateFormat(CalendarUtils.TIMEFORMAT, locale);
        SimpleDateFormat df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(cal);
        for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
            displayTimes.add(valuedf.format(cal.getTime()) + "_" + df.format(cal.getTime()));
            cal.add(12, timeInterval);
        }
        return displayTimes;
    }

    protected Map<String, String> getTimeSteps(String timeFormat, int timeInterval) {
        if (this.timeSteps_ == null) {
            this.timeSteps_ = new LinkedHashMap();
            java.util.Calendar cal = CalendarUtils.getInstanceTempCalendar();
            cal.setTime(this.getCurrentDate());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            SimpleDateFormat df = new SimpleDateFormat(timeFormat);
            df.setCalendar(cal);
            for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
                this.timeSteps_.put(String.valueOf(cal.getTimeInMillis()), df.format(cal.getTime()));
                cal.add(12, timeInterval);
            }
        }
        return this.timeSteps_;
    }

    protected String getDateFormat() {
        return this.calendarSetting_.getDateFormat();
    }

    protected String getDateTimeFormat() {
        return this.dateTimeFormat_;
    }

    protected int getTimeInterval() {
        return this.timeInterval_;
    }

    protected int getDefaultTimeInterval() {
        return 15;
    }

    protected String getTimeFormat() {
        return this.calendarSetting_.getTimeFormat();
    }

    public void setCalendarSetting(CalendarSetting calendarSetting_) {
        this.calendarSetting_ = calendarSetting_;
    }

    public CalendarSetting getCalendarSetting() {
        return this.calendarSetting_;
    }

    public boolean isShowWorkingTime() {
        return this.calendarSetting_.isShowWorkingTime();
    }

    public String getStartTime() {
        if (this.calendarSetting_.isShowWorkingTime()) {
            return this.calendarSetting_.getWorkingTimeBegin();
        }
        return "";
    }

    public String getEndTime() {
        if (this.calendarSetting_.isShowWorkingTime()) {
            return this.calendarSetting_.getWorkingTimeEnd();
        }
        return "";
    }

    public String getPriority(String key) {
        return (String)this.priorityMap_.get(key);
    }

    public String getLabel(String arg) {
        if (CalendarUtils.isEmpty((String)arg)) {
            return "";
        }
        try {
            return super.getLabel(arg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return arg;
        }
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        if (!(this instanceof UIListView)) {
            this.refresh();
        }
        super.processRender(arg0);
    }

    public List<CalendarEvent> getSelectedEvents(String eventIds) throws Exception {
        String[] list = eventIds.split(",");
        ArrayList<CalendarEvent> dataList = new ArrayList<CalendarEvent>();
        for (int i = 0; i < list.length; ++i) {
            CalendarEvent evt = (CalendarEvent)this.getDataMap().get(list[i]);
            dataList.add(evt);
        }
        return dataList;
    }

    static /* synthetic */ boolean access$002(UICalendarView x0, boolean x1) {
        x0.allDelete_ = x1;
        return x0.allDelete_;
    }

    static /* synthetic */ boolean access$000(UICalendarView x0) {
        return x0.allDelete_;
    }
}

