/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.UIActionBar;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/calendar/webui/UICalendarPortlet.gtmpl")
public class UICalendarPortlet
extends UIPortletApplication {
    private CalendarSetting calendarSetting_ = CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser());

    public UICalendarPortlet() throws Exception {
        UIActionBar uiActionBar = (UIActionBar)this.addChild(UIActionBar.class, null, null);
        uiActionBar.setCurrentView(UICalendarViewContainer.TYPES[Integer.parseInt(this.getCalendarSetting().getViewType())]);
        this.addChild(UICalendarWorkingContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UICalendarPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UICalendarPopupWindow");
    }

    public CalendarSetting getCalendarSetting() throws Exception {
        if (this.calendarSetting_ != null) {
            return this.calendarSetting_;
        }
        this.calendarSetting_ = CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser());
        return this.calendarSetting_;
    }

    public void setCalendarSetting(CalendarSetting setting) throws Exception {
        this.calendarSetting_ = setting;
    }

    public String getSettingTimeZone() throws Exception {
        return String.valueOf(TimeZone.getTimeZone(this.getCalendarSetting().getTimeZone()).getRawOffset() / 1000 / 60);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    protected void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = CalendarUtils.getContinuationService();
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            System.out.println("\n\n can not get UserToken");
            return "";
        }
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }
}

