/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.ext.UIFormComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UIEventAttenderTab.gtmpl")
public class UIEventAttenderTab
extends UIFormInputWithActions {
    public static final String FIELD_FROM_TIME = "timeFrom".intern();
    public static final String FIELD_TO_TIME = "timeTo".intern();
    public static final String FIELD_CHECK_TIME = "checkTime".intern();
    public static final String FIELD_DATEALL = "dateAll".intern();
    public static final String FIELD_CURRENTATTENDER = "currentAttender".intern();
    protected Map<String, String> parMap_ = new HashMap();
    public Calendar calendar_;

    public UIEventAttenderTab(String arg0) {
        super(arg0);
        this.setComponentConfig(this.getClass(), null);
        this.calendar_ = CalendarUtils.getInstanceTempCalendar();
        ArrayList options = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_FROM_TIME, FIELD_FROM_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_TO_TIME, FIELD_TO_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_DATEALL, FIELD_DATEALL, (Object)false));
        UIFormCheckBoxInput checkFreeInput = new UIFormCheckBoxInput(FIELD_CHECK_TIME, FIELD_CHECK_TIME, (Object)false);
        checkFreeInput.setOnChange("OnChange");
        this.addUIFormInput((UIFormInput)checkFreeInput);
    }

    protected UIFormComboBox getUIFormComboBox(String id) {
        return (UIFormComboBox)this.findComponentById(id);
    }

    protected void updateParticipants(String values) throws Exception {
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        this.parMap_.clear();
        HashMap tmpMap = new HashMap();
        ArrayList<String> newPars = new ArrayList<String>();
        if (!CalendarUtils.isEmpty((String)values)) {
            for (String par : values.split(CalendarUtils.BREAK_LINE)) {
                if (orgService.getUserHandler().findUserByName(par) == null) continue;
                String vl = (String)tmpMap.get(par);
                this.parMap_.put(par.trim(), vl);
                if (vl != null) continue;
                newPars.add(par.trim());
            }
        }
        if (newPars.size() > 0) {
            EventQuery eventQuery = new EventQuery();
            eventQuery.setFromDate(CalendarUtils.getBeginDay((Calendar)this.calendar_));
            eventQuery.setToDate(CalendarUtils.getEndDay((Calendar)this.calendar_));
            eventQuery.setParticipants(newPars.toArray(new String[0]));
            eventQuery.setNodeType("exo:calendarPublicEvent");
            Map parsMap = CalendarUtils.getCalendarService().checkFreeBusy(eventQuery);
            this.parMap_.putAll(parsMap);
        }
    }

    public boolean isCheckFreeTime() {
        return this.getUIFormCheckBoxInput(FIELD_CHECK_TIME).isChecked();
    }

    protected Map<String, String> getMap() {
        for (String id : this.parMap_.keySet()) {
            if (this.getUIFormCheckBoxInput(id) != null) continue;
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(id, id, (Object)false));
        }
        return this.parMap_;
    }

    protected String[] getParticipants() {
        return this.parMap_.keySet().toArray(new String[0]);
    }

    protected String getDateValue() throws Exception {
        CalendarSetting calSetting = ((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getCalendarSetting();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(calSetting.getDateFormat(), locale);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        return df.format(this.calendar_.getTime());
    }

    protected void moveNextDay() throws Exception {
        this.calendar_.add(5, 1);
        StringBuilder values = new StringBuilder();
        for (String par : this.parMap_.keySet()) {
            if (values != null && values.length() > 0) {
                values.append(CalendarUtils.BREAK_LINE);
            }
            values.append(par);
        }
        this.parMap_.clear();
        this.updateParticipants(values.toString());
    }

    protected void movePreviousDay() throws Exception {
        this.calendar_.add(5, -1);
        StringBuilder values = new StringBuilder();
        for (String par : this.parMap_.keySet()) {
            if (values != null && values.length() > 0) {
                values.append(CalendarUtils.BREAK_LINE);
            }
            values.append(par);
        }
        this.parMap_.clear();
        this.updateParticipants(values.toString());
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    protected String getFormName() {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        return uiForm.getId();
    }

    protected String getFromFieldValue() {
        return (String)this.getUIFormComboBox(FIELD_FROM_TIME).getValue();
    }

    protected void setEventFromDate(Date date, String timeFormat) {
        UIFormComboBox timeField = (UIFormComboBox)this.getChildById(FIELD_FROM_TIME);
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        timeField.setValue((Object)df.format(date));
        this.calendar_.setTime(date);
    }

    protected boolean getEventAllDate() {
        return false;
    }

    protected void setEventToDate(Date date, String timeFormat) {
        UIFormComboBox timeField = (UIFormComboBox)this.getChildById(FIELD_TO_TIME);
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        timeField.setValue((Object)df.format(date));
    }

    protected boolean isAllDateFieldChecked() {
        return this.getUIFormCheckBoxInput(FIELD_DATEALL).isChecked();
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        super.processRender(arg0);
    }

    public String getUserTimeZone(String username) throws Exception {
        String timeZone = CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser()).getTimeZone();
        return CalendarUtils.getTimeZone((String)timeZone);
    }

    public String getServerTimeZone() {
        return CalendarUtils.getTimeZone((String)TimeZone.getDefault().getID());
    }
}

