/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.popup.UIImportForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIImportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ImportActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UIImportForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String CATEGORY = "category";
    public static final String PERMISSION = "permission";
    public static final String SELECT_COLOR = "selectColor";
    public static final String TIMEZONE = "timeZone";
    public static final String LOCALE = "locale";
    public static final String PERMISSION_SUB = "_permission".intern();
    public Map<String, Map<String, String>> perms_ = new HashMap();
    public static final String TYPE = "type".intern();
    public static final String FIELD_UPLOAD = "upload".intern();
    public static final String FIELD_TO_CALENDAR = "impotTo".intern();
    public static final String ONCHANGE = "OnChange".intern();
    public static final int UPDATE_EXIST = 1;
    public static final int ADD_NEW = 0;
    protected int flag_ = -1;

    public UIImportForm() throws Exception {
        this.setMultiPart(true);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        for (String type : calendarService.getExportImportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
        this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD));
        UIFormSelectBoxWithGroups privateCal = new UIFormSelectBoxWithGroups(FIELD_TO_CALENDAR, FIELD_TO_CALENDAR, CalendarUtils.getCalendarOption());
        this.addUIFormInput((UIFormInput)privateCal);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        UIFormSelectBoxWithGroups calCategory = new UIFormSelectBoxWithGroups(CATEGORY, CATEGORY, CalendarUtils.getCalendarCategoryOption());
        calCategory.setOnChange("OnChange");
        this.addUIFormInput((UIFormInput)calCategory);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PERMISSION, PERMISSION, null));
        CalendarSetting setting = CalendarUtils.getCurrentUserCalendarSetting();
        UIFormStringInput locale = new UIFormStringInput(LOCALE, LOCALE, CalendarUtils.getLocationDisplayString((String)setting.getLocation()));
        locale.setLabel(setting.getLocation());
        locale.setEditable(false);
        this.addUIFormInput((UIFormInput)locale);
        UIFormStringInput timeZones = new UIFormStringInput(TIMEZONE, TIMEZONE, CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
        timeZones.setEditable(false);
        timeZones.setLabel(setting.getTimeZone());
        this.addUIFormInput((UIFormInput)timeZones);
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(SELECT_COLOR, SELECT_COLOR));
    }

    public void init(String calId, String calType) {
        if (!CalendarUtils.isEmpty((String)calId)) {
            UIFormSelectBoxWithGroups selectBox = this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR);
            if (selectBox.getOptions() != null && !selectBox.getOptions().isEmpty()) {
                this.switchMode(1);
                selectBox.setValue(calType + CalendarUtils.COLON + calId);
            } else {
                this.switchMode(0);
            }
        } else {
            this.switchMode(0);
        }
    }

    private List<SelectItemOption<String>> getTimeZones() {
        return CalendarUtils.getTimeZoneSelectBoxOptions((String[])TimeZone.getAvailableIDs());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private List<SelectItemOption<String>> getLocales() {
        return CalendarUtils.getLocaleSelectBoxOptions((Locale[])java.util.Calendar.getAvailableLocales());
    }

    private List getSelectedGroups(String groupId) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        Group g = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getGroupHandler().findGroupById(groupId);
        groups.add(g);
        return groups;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<SelectItemOption<String>> getPrivateCalendars() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        try {
            for (Calendar c : CalendarUtils.getCalendarService().getUserCalendars(CalendarUtils.getCurrentUser(), true)) {
                if (c.getId().equals(Utils.getDefaultCalendarId((String)CalendarUtils.getCurrentUser())) && c.getName().equals(NewUserListener.defaultCalendarName)) {
                    String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                    c.setName(newName);
                }
                options.add((SelectItemOption<String>)new SelectItemOption(c.getName(), (Object)c.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public boolean isNew() {
        return this.flag_ == 0;
    }

    protected String getSelectedTypeGroup() {
        UIFormSelectBoxWithGroups calCategory = this.getUIFormSelectBoxGroup(CATEGORY);
        String value = (String)calCategory.getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            return value.split(CalendarUtils.COLON)[0];
        }
        return value;
    }

    protected String getSelectedIdGroup() {
        UIFormSelectBoxWithGroups calCategory = this.getUIFormSelectBoxGroup(CATEGORY);
        String value = (String)calCategory.getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    protected String getDescription() {
        return (String)this.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    protected String getTimeZone() {
        return this.getUIStringInput(TIMEZONE).getLabel();
    }

    protected String getLocale() {
        return this.getUIStringInput(LOCALE).getLabel();
    }

    public void switchMode(int flag) {
        this.flag_ = flag;
        if (flag == 1) {
            this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR).setRendered(true);
            this.getUIStringInput(DISPLAY_NAME).setRendered(false);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(false);
            this.getUIFormSelectBoxGroup(CATEGORY).setRendered(false);
            this.getUIStringInput(PERMISSION).setRendered(false);
            this.getUIStringInput(TIMEZONE).setRendered(false);
            this.getUIStringInput(LOCALE).setRendered(false);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(false);
        } else if (flag == 0) {
            this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR).setRendered(false);
            this.getUIStringInput(DISPLAY_NAME).setRendered(true);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(true);
            this.getUIFormSelectBoxGroup(CATEGORY).setRendered(true);
            String groupType = this.getSelectedTypeGroup();
            if (!CalendarUtils.isEmpty((String)groupType) && groupType.equals(CalendarUtils.PUBLIC_TYPE)) {
                this.getUIStringInput(PERMISSION).setRendered(true);
            } else {
                this.getUIStringInput(PERMISSION).setRendered(false);
            }
            this.getUIStringInput(TIMEZONE).setRendered(true);
            this.getUIStringInput(LOCALE).setRendered(true);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(true);
        } else {
            System.out.println("Wrong flag(" + flag + ") only UPDATE_EXIST(1) or ADD_NEW(0) accept ");
        }
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }

    protected String getCalendarId() {
        UIFormSelectBoxWithGroups calendars = this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR);
        String value = (String)calendars.getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        StringBuilder sb = new StringBuilder();
        Map<String, String> temp = new HashMap<String, String>();
        String key = value.substring(0, value.lastIndexOf(CalendarUtils.COLON_SLASH) - 1);
        String tempS = value.substring(value.lastIndexOf(CalendarUtils.COLON_SLASH) + 2);
        if (this.perms_.get(selectField) == null) {
            temp.put(key, tempS);
        } else {
            temp = (Map)this.perms_.get(selectField);
            if (temp.get(key) != null && !tempS.equals(temp.get(key))) {
                tempS = (String)temp.get(key) + CalendarUtils.COMMA + tempS;
            }
            temp.put(key, tempS);
        }
        this.perms_.put(selectField, temp);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String s : temp.values()) {
            for (String t : s.split(CalendarUtils.COMMA)) {
                tempMap.put(t, t);
            }
        }
        for (String s : tempMap.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ List access$000(UIImportForm x0, String x1) throws Exception {
        return x0.getSelectedGroups(x1);
    }
}

