/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMiniCalendar.gtmpl", events={@EventConfig(listeners={MoveNextActionListener.class}), @EventConfig(listeners={MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class})})
public class UIMiniCalendar
extends UICalendarView {
    private Map<Integer, String> dataMap = new HashMap();
    private String categoryId_ = null;

    public UIMiniCalendar() throws Exception {
        this.updateMiniCal();
    }

    public void updateMiniCal() throws Exception {
        this.dataMap.clear();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonth());
        eventQuery.setToDate(this.getEndDateOfMonth());
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        this.dataMap = calendarService.searchHightLightEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars());
        this.dataMap.putAll(calendarService.searchHighlightRecurrenceEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars(), timezone));
    }

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    private Map<Integer, String> getData() {
        return this.dataMap;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return null;
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        while (temCal.get(5) < 20 && temCal.get(5) != 1) {
            temCal.add(5, -7);
        }
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, 1);
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, this.getDaysInMonth());
        return CalendarUtils.getEndDay((Calendar)temCal);
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public void refresh() throws Exception {
        this.dataMap.clear();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonth());
        Calendar cal = this.getEndDateOfMonth();
        cal.add(14, -1);
        eventQuery.setToDate(cal);
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        this.dataMap = calendarService.searchHightLightEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars());
        this.dataMap.putAll(calendarService.searchHighlightRecurrenceEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars(), timezone));
    }
}

