/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIDayView;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIDayView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={SaveEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class})})
public class UIDayView
extends UICalendarView {
    private List<CalendarEvent> eventData_ = new ArrayList();
    private List<CalendarEvent> allDayEvent_ = new ArrayList();

    public void refresh() throws Exception {
        this.eventData_.clear();
        this.allDayEvent_.clear();
        Calendar begin = this.getBeginDay(this.getCurrentCalendar());
        Calendar end = this.getEndDay(this.getCurrentCalendar());
        end.add(14, -1);
        List events = new ArrayList();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(begin);
        eventQuery.setToDate(end);
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        events = calendarService.getEvents(username, eventQuery, this.getPublicCalendars());
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        List originalRecurEvents = calendarService.getOriginalRecurrenceEvents(username, eventQuery.getFromDate(), eventQuery.getToDate(), this.getPublicCalendars());
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            for (CalendarEvent recurEvent : originalRecurEvents) {
                Map tempMap = calendarService.getOccurrenceEvents(recurEvent, eventQuery.getFromDate(), eventQuery.getToDate(), timezone);
                if (tempMap == null) continue;
                this.recurrenceEventsMap.put(recurEvent.getId(), tempMap);
                events.addAll(tempMap.values());
            }
        }
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            CalendarEvent ce = (CalendarEvent)iter.next();
            long eventAmount = ce.getToDateTime().getTime() - ce.getFromDateTime().getTime();
            if (!this.isSameDate(ce.getFromDateTime(), this.getCurrentDate()) || !this.isSameDate(ce.getToDateTime(), this.getCurrentDate()) || eventAmount >= 84960000L) continue;
            this.eventData_.add(ce);
            iter.remove();
        }
        for (CalendarEvent ce : events) {
            this.allDayEvent_.add(ce);
        }
    }

    protected List<CalendarEvent> getEventData() {
        return this.eventData_;
    }

    protected List<CalendarEvent> getAllDayEvents() {
        return this.allDayEvent_;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        LinkedHashMap<String, CalendarEvent> dataMap = new LinkedHashMap<String, CalendarEvent>();
        for (CalendarEvent ce : this.eventData_) {
            dataMap.put(ce.getId(), ce);
        }
        for (CalendarEvent ce : this.allDayEvent_) {
            dataMap.put(ce.getId(), ce);
        }
        return dataMap;
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }
}

