/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIWeekView;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIWeekView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={SaveEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class})})
public class UIWeekView
extends UICalendarView {
    private static final Log log = ExoLogger.getExoLogger(UIWeekView.class);
    protected Map<String, List<CalendarEvent>> eventData_ = new HashMap();
    protected List<CalendarEvent> allDayEvent = new ArrayList();
    protected LinkedHashMap<String, CalendarEvent> dataMap_ = new LinkedHashMap();
    protected List<CalendarEvent> daysData_ = new ArrayList();
    protected boolean isShowCustomView_ = false;
    protected Date beginDate_;
    protected Date endDate_;

    public void refresh() throws Exception {
        this.eventData_.clear();
        this.allDayEvent.clear();
        int i = 0;
        Calendar c = this.getBeginDateOfWeek();
        int maxDay = 7;
        if (this.isShowCustomView_) {
            maxDay = 5;
        }
        while (i++ < maxDay) {
            ArrayList list = new ArrayList();
            String key = this.keyGen(c.get(5), c.get(2), c.get(1));
            this.eventData_.put(key, list);
            c.add(5, 1);
        }
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfWeek());
        Calendar endDateOfWeek = this.getEndDateOfWeek();
        Date toDate = endDateOfWeek.getTime();
        toDate.setTime(toDate.getTime() - 1L);
        endDateOfWeek.setTime(toDate);
        eventQuery.setToDate(endDateOfWeek);
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        List allEvents = calendarService.getEvents(username, eventQuery, this.getPublicCalendars());
        List originalRecurEvents = calendarService.getOriginalRecurrenceEvents(username, eventQuery.getFromDate(), eventQuery.getToDate(), this.getPublicCalendars());
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            for (CalendarEvent recurEvent : originalRecurEvents) {
                Map tempMap = calendarService.getOccurrenceEvents(recurEvent, eventQuery.getFromDate(), eventQuery.getToDate(), timezone);
                if (tempMap == null) continue;
                this.recurrenceEventsMap.put(recurEvent.getId(), tempMap);
                allEvents.addAll(tempMap.values());
            }
        }
        Iterator iter = allEvents.iterator();
        while (iter.hasNext()) {
            CalendarEvent event = (CalendarEvent)iter.next();
            Date beginEvent = event.getFromDateTime();
            Date endEvent = event.getToDateTime();
            long eventAmount = endEvent.getTime() - beginEvent.getTime();
            i = 0;
            c = this.getBeginDateOfWeek();
            while (i++ < maxDay) {
                String key = this.keyGen(c.get(5), c.get(2), c.get(1));
                if (this.isSameDate(c.getTime(), beginEvent) && this.isSameDate(c.getTime(), endEvent) && eventAmount < 84960000L) {
                    ((List)this.eventData_.get(key)).add(event);
                    iter.remove();
                }
                c.add(5, 1);
            }
        }
        for (CalendarEvent ce : allEvents) {
            this.allDayEvent.add(ce);
        }
    }

    public Calendar getBeginDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        }
        if (temCal.getFirstDayOfWeek() > temCal.get(7)) {
            temCal.add(3, -1);
        }
        int amout = temCal.getFirstDayOfWeek() - temCal.get(7);
        if (this.isShowCustomView_) {
            ++amout;
        }
        temCal.add(5, amout);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        }
        temCal.setTime(this.getBeginDateOfWeek().getTime());
        int amout = 6;
        if (this.isShowCustomView_) {
            amout -= 2;
        }
        temCal.add(5, amout);
        return this.getEndDay(temCal);
    }

    protected Map<String, List<CalendarEvent>> getEventData() {
        return this.eventData_;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        LinkedHashMap<String, CalendarEvent> dataMap = new LinkedHashMap<String, CalendarEvent>();
        for (CalendarEvent ce : this.allDayEvent) {
            dataMap.put(ce.getId(), ce);
        }
        for (String key : this.eventData_.keySet()) {
            for (CalendarEvent ce : (List)this.eventData_.get(key)) {
                dataMap.put(ce.getId(), ce);
            }
        }
        return dataMap;
    }

    public boolean isShowCustomView() {
        return this.isShowCustomView_;
    }

    public String getDefaultStartTimeOfEvent() {
        if (this.isCurrentWeek(this.calendar_.get(3), this.calendar_.get(2), this.calendar_.get(1))) {
            return String.valueOf(System.currentTimeMillis());
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.calendar_.getTime());
        int firstDayOfWeek = this.calendar_.getFirstDayOfWeek();
        c.setFirstDayOfWeek(firstDayOfWeek);
        do {
            c.add(5, 1);
        } while (c.get(7) != firstDayOfWeek);
        c.add(5, -1);
        return String.valueOf(c.getTimeInMillis());
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

