/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.UILazyPageIterator;
import org.exoplatform.calendar.webui.popup.UIAddressForm;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.calendar.webui.popup.UITaskForm;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.ContactData;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.QueryState;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIAddressForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIAddressForm.class);
    public static final String FIELD_KEYWORD = "keyWord".intern();
    public static final String FIELD_GROUP = "group".intern();
    private String recipientsType = "";
    protected String selectedAddressId_ = "";
    private UIPageIterator uiPageIterator;
    protected String[] actions_ = new String[]{"Add", "Replace", "Cancel"};
    public List<String> checkedList_ = new ArrayList();
    private static final int NUMBER_OF_ITEMS_SHOWN_ON_ONE_PAGE = 10;
    private UILazyPageIterator uiLazyPageIterator;
    private boolean loadNewPage = true;
    private QueryState queryState;
    private boolean isLastPage = false;
    private boolean isSearchEnabled = false;
    private Set<ContactData> contacts;

    public void clearContacts() {
        this.contacts.clear();
    }

    public boolean isSearchEnabled() {
        return this.isSearchEnabled;
    }

    public void setSearchEnabled(boolean isSearchEnabled) {
        this.isSearchEnabled = isSearchEnabled;
    }

    public void setRecipientsType(String type) {
        this.recipientsType = type;
    }

    public String getRecipientType() {
        return this.recipientsType;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void getToLastPage() {
        this.isLastPage = true;
    }

    public int getPageShown() {
        return this.uiLazyPageIterator.getPageShown();
    }

    public void setPageShown(int page) {
        this.uiLazyPageIterator.setPageShown(page);
    }

    public void notLastPage() {
        this.isLastPage = false;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        UIFormSelectBox fieldGroup = new UIFormSelectBox(FIELD_GROUP, FIELD_GROUP, this.getGroups());
        fieldGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)fieldGroup);
        this.contacts = new LinkedHashSet();
        this.uiLazyPageIterator = new UILazyPageIterator();
        this.uiLazyPageIterator.setId("UICalendarAddressPage");
        this.uiPageIterator = new UIPageIterator();
        this.uiPageIterator.setId("UICalendarAddressPage1");
        this.queryState = new QueryState();
        this.queryState.on("publicContacts").withRelativeOffset(0);
    }

    private List<SelectItemOption<String>> getGroups() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ContactService contactService = (ContactService)this.getApplicationComponent(ContactService.class);
        options.add(new SelectItemOption("all", (Object)Utils.EMPTY_STR));
        for (AddressBook cg : contactService.getGroups(CalendarUtils.getCurrentUser())) {
            options.add(new SelectItemOption(cg.getName(), (Object)cg.getId()));
        }
        List addressList = contactService.getSharedAddressBooks(CalendarUtils.getCurrentUser());
        for (SharedAddressBook sa : addressList) {
            String name = Utils.EMPTY_STR;
            if (!CalendarUtils.isEmpty((String)sa.getSharedUserId())) {
                name = sa.getSharedUserId() + "-";
            }
            options.add((SelectItemOption<String>)new SelectItemOption(name + sa.getName(), (Object)sa.getId()));
        }
        List publicAddressBookIds = contactService.getAllsPublicAddressBookIds(null);
        if (!publicAddressBookIds.isEmpty()) {
            for (String publicCg : publicAddressBookIds) {
                options.add((SelectItemOption<String>)new SelectItemOption(CalendarUtils.getOrganizationService().getGroupHandler().findGroupById(publicCg).getGroupName(), (Object)publicCg));
            }
        }
        return options;
    }

    public String[] getActions() {
        return this.actions_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.actions_ = new String[]{"Add", "Replace", "Cancel"};
    }

    public List<ContactData> getContacts() throws Exception {
        for (String id : this.checkedList_) {
            UIFormCheckBoxInput uiInput = this.getUIFormCheckBoxInput(id);
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        if (!this.isSearchEnabled()) {
            return new ArrayList<ContactData>(this.uiLazyPageIterator.getCurrentPageData());
        }
        return new ArrayList<ContactData>(this.uiPageIterator.getCurrentPageData());
    }

    public void setContactList(String groupId) throws Exception {
        ContactFilter filter = new ContactFilter();
        if (!CalendarUtils.isEmpty((String)groupId)) {
            filter.setCategories(new String[]{groupId});
        }
        this.setContactList(filter);
    }

    public void setContactList(ContactFilter filter) throws Exception {
        if (filter.getCategories() == null) {
            this.getUIFormSelectBox(FIELD_GROUP).setOptions(this.getGroups());
        }
        if (this.isSearchEnabled()) {
            ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
            List data2 = contactSrv.findEmailFromContacts(CalendarUtils.getCurrentUser(), filter);
            this.setContactList(data2);
            return;
        }
        if (!this.loadNewPage) {
            this.notLastPage();
            ArrayList contactList = new ArrayList(this.contacts);
            int firstIndex = (this.getPageShown() - 1) * 10;
            int lastIndex = firstIndex + 10;
            if (firstIndex + 10 > this.contacts.size()) {
                this.getToLastPage();
                lastIndex = this.contacts.size();
            }
            this.setContactList(contactList.subList(firstIndex, lastIndex));
            return;
        }
        List data3 = null;
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        int previousSize = this.contacts.size();
        int diff = 0;
        while (this.contacts.size() - previousSize < 10) {
            diff = this.contacts.size() - previousSize;
            data3 = contactSrv.findNextEmailsForType(CalendarUtils.getCurrentUser(), filter, 10 - diff, this.queryState);
            if (data3.size() == 0) break;
            this.contacts.addAll(data3);
        }
        if ((diff = this.contacts.size() - previousSize) < 10) {
            this.getToLastPage();
            if (diff == 0 && this.contacts.size() != 0) {
                this.uiLazyPageIterator.setPageShown(this.getPageShown() - 1);
                return;
            }
        } else {
            this.notLastPage();
        }
        ArrayList contactList = new ArrayList(this.contacts);
        int firstIndex = (this.getPageShown() - 1) * 10;
        int lastIndex = firstIndex + 10;
        if (firstIndex + 10 > this.contacts.size()) {
            lastIndex = this.contacts.size();
        }
        this.setContactList(contactList.subList(firstIndex, lastIndex));
    }

    public List<ContactData> getContactList() {
        try {
            if (this.isSearchEnabled()) {
                return this.uiPageIterator.getCurrentPageData();
            }
            return this.uiLazyPageIterator.getCurrentPageData();
        }
        catch (Exception e) {
            return new ArrayList<ContactData>();
        }
    }

    public void setContactList(List<ContactData> contactList) throws Exception {
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(ContactData.class, contactList), 10);
        if (!this.isSearchEnabled()) {
            this.uiLazyPageIterator.setPageList((PageList)pageList);
        } else {
            this.uiPageIterator.setPageList((PageList)pageList);
        }
        for (ContactData contact : contactList) {
            UIFormCheckBoxInput uiCheckbox = this.getUIFormCheckBoxInput(contact.getId());
            if (uiCheckbox != null) continue;
            uiCheckbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
            this.addUIFormInput((UIFormInput)uiCheckbox);
        }
    }

    public List<ContactData> getCheckedContact() throws Exception {
        ArrayList<ContactData> contactList = new ArrayList<ContactData>();
        if (!this.isSearchEnabled()) {
            for (ContactData contact : new ArrayList(this.uiLazyPageIterator.getCurrentPageData())) {
                UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
                if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
                contactList.add(contact);
            }
        } else {
            for (ContactData contact : new ArrayList(this.uiPageIterator.getCurrentPageData())) {
                UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
                if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
                contactList.add(contact);
            }
        }
        return contactList;
    }

    public long getAvailablePage() {
        return this.uiPageIterator.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        UIPopupAction uiPopupAction = (UIPopupAction)((UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class)).getChild(UIPopupAction.class);
        UIEventForm uiEventForm = (UIEventForm)uiPopupAction.findFirstComponentOfType(UIEventForm.class);
        UITaskForm uiTaskForm = (UITaskForm)uiPopupAction.findFirstComponentOfType(UITaskForm.class);
        String oldAddress = "";
        if (uiEventForm != null) {
            oldAddress = uiEventForm.getEmailAddress();
        } else if (uiTaskForm != null) {
            oldAddress = uiTaskForm.getEmailAddress();
        }
        if (!this.isSearchEnabled()) {
            if (this.getPageShown() > page) {
                this.loadNewPage = false;
            }
            this.uiLazyPageIterator.setPageShown(page);
            UITaskForm.showAddressForm((UIAddressForm)this, (String)oldAddress);
        } else {
            this.uiPageIterator.setCurrentPage(page);
            UITaskForm.showAddressForm((UIAddressForm)this, (String)oldAddress);
        }
    }

    static /* synthetic */ boolean access$002(UIAddressForm x0, boolean x1) {
        x0.loadNewPage = x1;
        return x0.loadNewPage;
    }

    static /* synthetic */ QueryState access$100(UIAddressForm x0) {
        return x0.queryState;
    }
}

