/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.popup.UICalendarDetailTab;
import org.exoplatform.calendar.webui.popup.UICalendarForm;
import org.exoplatform.calendar.webui.popup.UIGroupCalendarTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelectComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webservice.cs.calendar.CalendarWebservice;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPublicURLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ActiveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeactiveActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalendarForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    private static final Log log = ExoLogger.getExoLogger(UICalendarForm.class);
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String CATEGORY = "category";
    public static final String SHARED_GROUPS = "sharedGroups";
    public static final String EDIT_PERMISSION = "editPermission";
    public static final String SELECT_COLOR = "selectColor";
    public static final String SELECT_GROUPS = "selectGroups";
    public static final String INPUT_CALENDAR = "calendarDetail".intern();
    public static final String INPUT_SHARE = "public".intern();
    public static final String TIMEZONE = "timeZone";
    public static final String LOCALE = "locale";
    public static final String PERMISSION_SUB = "_permission".intern();
    public static final String PUBLIC_URL = "public-url".intern();
    public static final String PRIVATE_URL = "private-url".intern();
    public static final String PUBLIC_URL_MSG = "public-url-msg-active".intern();
    public static final String PUBLIC_URL_MSG_D = "public-url-msg-deactive".intern();
    public static final String ACT_SELECT_PERM = "SelectPermission".intern();
    public static final String ACT_ADD_CATEGORY = "AddCategory".intern();
    public static final String ACT_OPEN = "Open".intern();
    public static final String ACT_SUBSCRIBE = "Subscribe".intern();
    public static final String ACT_ACTIVE = "Active".intern();
    public static final String ACT_DEACTIVE = "Deactive".intern();
    public Map<String, String> permission_ = new HashMap();
    public Map<String, Map<String, String>> perms_ = new HashMap();
    public Calendar calendar_ = null;
    public String calType_ = CalendarUtils.PRIVATE_TYPE;
    private boolean isAddNew_ = true;
    public String groupCalId_ = null;

    public UICalendarForm() throws Exception {
        super("UICalendarForm");
        UICalendarDetailTab calendarDetail = new UICalendarDetailTab(INPUT_CALENDAR);
        calendarDetail.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        calendarDetail.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        calendarDetail.addUIFormInput((UIFormInput)new UIFormSelectBox(CATEGORY, CATEGORY, this.getCategory()));
        CalendarSetting setting = CalendarUtils.getCurrentUserCalendarSetting();
        UIFormStringInput country = new UIFormStringInput(LOCALE, LOCALE, CalendarUtils.getLocationDisplayString((String)setting.getLocation()));
        country.setLabel(setting.getLocation());
        country.setEditable(false);
        calendarDetail.addUIFormInput((UIFormInput)country);
        UIFormStringInput timeZone = new UIFormStringInput(TIMEZONE, TIMEZONE, CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
        timeZone.setLabel(setting.getTimeZone());
        timeZone.setEditable(false);
        calendarDetail.addUIFormInput((UIFormInput)timeZone);
        calendarDetail.addUIFormInput((UIFormInput)new UIFormColorPicker(SELECT_COLOR, SELECT_COLOR));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addCategory = new UIFormInputWithActions.ActionData();
        addCategory.setActionListener(ACT_ADD_CATEGORY);
        addCategory.setActionType(0);
        addCategory.setActionName(ACT_ADD_CATEGORY);
        actions.add(addCategory);
        calendarDetail.setActionField(CATEGORY, actions);
        this.setSelectedTab(calendarDetail.getId());
        this.addChild((UIComponent)calendarDetail);
        UIGroupCalendarTab sharing = new UIGroupCalendarTab(INPUT_SHARE);
        sharing.addUIFormInput((UIFormInput)new UIFormInputInfo(SELECT_GROUPS, SELECT_GROUPS, null));
        sharing.addUIFormInput((UIFormInput)new UIFormStringInput(EDIT_PERMISSION, null, null));
        for (Object groupObj : this.getPublicGroups()) {
            String group = ((Group)groupObj).getId();
            if (sharing.getUIFormCheckBoxInput(group) != null) {
                sharing.getUIFormCheckBoxInput(group).setChecked(false);
            } else {
                sharing.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, group, (Object)false));
            }
            if (sharing.getUIFormInputInfo(group + PERMISSION_SUB) != null) continue;
            sharing.addUIFormInput((UIFormInput)new UIFormStringInput(group + PERMISSION_SUB, group + PERMISSION_SUB, null));
            actions = new ArrayList();
            UIFormInputWithActions.ActionData editPermission = new UIFormInputWithActions.ActionData();
            editPermission.setActionListener(ACT_SELECT_PERM);
            editPermission.setActionName("SelectUser");
            editPermission.setActionParameter(UISelectComponent.TYPE_USER + ":" + group + PERMISSION_SUB);
            editPermission.setActionType(0);
            editPermission.setCssIconClass("SelectUserIcon");
            actions.add(editPermission);
            UIFormInputWithActions.ActionData membershipPerm = new UIFormInputWithActions.ActionData();
            membershipPerm.setActionListener(ACT_SELECT_PERM);
            membershipPerm.setActionName("SelectMemberShip");
            membershipPerm.setActionParameter(UISelectComponent.TYPE_MEMBERSHIP + ":" + group + PERMISSION_SUB);
            membershipPerm.setActionType(0);
            membershipPerm.setCssIconClass("SelectMemberIcon");
            actions.add(membershipPerm);
            sharing.setActionField(group + PERMISSION_SUB, actions);
        }
        this.addChild((UIComponent)sharing);
    }

    public String getCalType() {
        return this.calType_;
    }

    public String[] getActions() {
        return new String[]{"Save", "Reset", "Cancel"};
    }

    private List<SelectItemOption<String>> getCategory() throws Exception {
        String username = CalendarUtils.getCurrentUser();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List categories = calendarService.getCategories(username);
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (CalendarCategory category : categories) {
            if (category.getId().equals(NewUserListener.defaultCalendarCategoryId) && category.getName().equals(NewUserListener.defaultCalendarCategoryName)) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarCategoryId), (String)NewUserListener.defaultCalendarCategoryId);
                category.setName(newName);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    public void reloadCategory() throws Exception {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIFormSelectBox(CATEGORY).setOptions(this.getCategory());
    }

    protected void lockCheckBoxFields(boolean isLock) throws Exception {
        UIFormInputWithActions shareTab = (UIFormInputWithActions)this.getChildById(INPUT_SHARE);
        for (String group : CalendarUtils.getAllGroups()) {
            UIFormCheckBoxInput uiInput = shareTab.getUIFormCheckBoxInput(group);
            UIFormStringInput uiPermInput = shareTab.getUIStringInput(group + PERMISSION_SUB);
            if (uiInput != null) {
                uiInput.setEnable(!isLock);
            }
            if (uiPermInput != null) {
                uiPermInput.setEditable(!isLock);
            }
            if (!isLock) continue;
            shareTab.setActionField(group + PERMISSION_SUB, null);
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void resetField() throws Exception {
        this.permission_.clear();
        this.perms_.clear();
        UIGroupCalendarTab sharing = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        for (Object obj : this.getPublicGroups()) {
            UIFormStringInput uiInputIfo;
            String groupId = ((Group)obj).getId();
            UIFormCheckBoxInput checkbox = sharing.getUIFormCheckBoxInput(((Group)obj).getId());
            if (checkbox != null) {
                checkbox.setChecked(false);
            }
            if ((uiInputIfo = sharing.getUIStringInput(groupId + PERMISSION_SUB)) == null) continue;
            uiInputIfo.setValue(null);
        }
        if (this.isAddNew_) {
            this.calendar_ = null;
            this.calType_ = CalendarUtils.PRIVATE_TYPE;
            this.setDisplayName(null);
            this.setDescription(null);
            this.setSelectedGroup(null);
            this.setLocale(null);
            this.setTimeZone(null);
            this.setSelectedColor(null);
            this.lockCheckBoxFields(false);
        } else {
            this.init(this.calendar_, null);
        }
    }

    public boolean isAddNew() {
        return this.isAddNew_;
    }

    public void init(Calendar calendar, CalendarSetting setting) throws Exception {
        Object privateUrl;
        this.isAddNew_ = false;
        this.calendar_ = calendar;
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        if (calendar.getId().equals(Utils.getDefaultCalendarId((String)CalendarUtils.getCurrentUser())) && calendar.getName().equals(NewUserListener.defaultCalendarName)) {
            String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
            calendar.setName(newName);
        }
        if (setting != null) {
            UIFormStringInput info = calendarDetail.getUIStringInput(TIMEZONE);
            info.setValue((Object)CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
            info.setLabel(setting.getTimeZone());
            info = calendarDetail.getUIStringInput(LOCALE);
            info.setValue((Object)CalendarUtils.getLocationDisplayString((String)setting.getLocation()));
            info.setLabel(setting.getLocation());
        }
        this.setDisplayName(calendar.getName());
        this.setDescription(calendar.getDescription());
        UIFormInputWithActions sharing = (UIFormInputWithActions)this.getChildById(INPUT_SHARE);
        sharing.setRendered(true);
        if (CalendarUtils.PUBLIC_TYPE.equals(this.calType_)) {
            calendarDetail.removeChildById(CATEGORY);
            calendarDetail.setActionField(CATEGORY, null);
            for (String groupId : calendar.getGroups()) {
                UIFormCheckBoxInput checkbox = sharing.getUIFormCheckBoxInput(groupId);
                UIFormStringInput uiInput = sharing.getUIStringInput(groupId + PERMISSION_SUB);
                if (checkbox == null) continue;
                checkbox.setChecked(true);
                StringBuffer sb = new StringBuffer();
                ArrayList<String> checkList = new ArrayList<String>();
                if (calendar.getEditPermission() != null) {
                    for (String s : calendar.getEditPermission()) {
                        if (s.lastIndexOf(CalendarUtils.SLASH_COLON) <= -1) continue;
                        String id = s.split(CalendarUtils.SLASH_COLON)[0].trim();
                        String perm = s.split(CalendarUtils.SLASH_COLON)[1].trim();
                        if (!groupId.equals(id) || checkList.contains(s.split(CalendarUtils.SLASH_COLON)[1])) continue;
                        checkList.add(perm);
                        if (sb.length() > 0) {
                            sb.append(CalendarUtils.COMMA);
                        }
                        sb.append(perm);
                    }
                }
                uiInput.setValue((Object)sb.toString());
            }
        }
        if (CalendarUtils.PRIVATE_TYPE.equals(this.calType_)) {
            this.setSelectedGroup(calendar.getCategoryId());
            this.lockCheckBoxFields(true);
            sharing.setRendered(false);
        }
        this.setSelectedColor(calendar.getCalendarColor());
        if (calendar.getPrivateUrl() == null || calendar.getPrivateUrl().isEmpty()) {
            privateUrl = CalendarUtils.getServerBaseUrl() + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + CalendarWebservice.BASE_URL_PRIVATE + CalendarUtils.getCurrentUser() + "/" + calendar.getId() + "/" + this.calType_;
            this.calendar_.setPrivateUrl((String)privateUrl);
        }
        privateUrl = new UIFormInputInfo(PRIVATE_URL, PRIVATE_URL, null);
        UIFormInputWithActions.ActionData privateAction = new UIFormInputWithActions.ActionData();
        privateAction.setActionListener(ACT_OPEN);
        privateAction.setActionParameter(this.calendar_.getPrivateUrl());
        privateAction.setActionName(ACT_OPEN);
        privateAction.setActionType(0);
        privateAction.setCssIconClass("ICalIcon");
        calendarDetail.addUIFormInput((UIFormInput)privateUrl);
        calendarDetail.setActionField(PRIVATE_URL, Arrays.asList(privateAction));
    }

    protected String getDisplayName() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)calendarDetail.getUIStringInput(DISPLAY_NAME).getValue();
    }

    protected void setDisplayName(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIStringInput(DISPLAY_NAME).setValue((Object)value);
    }

    protected String getDescription() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)calendarDetail.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected void setDescription(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)value);
    }

    protected String getSelectedGroup() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        if (calendarDetail.getUIFormSelectBox(CATEGORY) != null) {
            return (String)calendarDetail.getUIFormSelectBox(CATEGORY).getValue();
        }
        return null;
    }

    public void setSelectedGroup(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIFormSelectBox(CATEGORY).setValue(value);
    }

    protected String getSelectedColor() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)((UIFormColorPicker)calendarDetail.getChild(UIFormColorPicker.class)).getValue();
    }

    protected void setSelectedColor(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        ((UIFormColorPicker)calendarDetail.getChild(UIFormColorPicker.class)).setValue(value);
    }

    protected String getLocale() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return calendarDetail.getUIStringInput(LOCALE).getLabel();
    }

    public void setLocale(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIStringInput(LOCALE).setValue((Object)CalendarUtils.getLocationDisplayString((String)value));
        calendarDetail.getUIStringInput(LOCALE).setLabel(value);
    }

    protected String getTimeZone() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return calendarDetail.getUIStringInput(TIMEZONE).getLabel();
    }

    public void setTimeZone(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        UIFormStringInput timeZone = calendarDetail.getUIStringInput(TIMEZONE);
        timeZone.setValue((Object)CalendarUtils.generateTimeZoneLabel((String)value));
        timeZone.setLabel(value);
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIGroupCalendarTab shareTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        UIFormStringInput fieldInput = shareTab.getUIStringInput(selectField);
        StringBuilder sb = new StringBuilder();
        Map<String, String> temp = new HashMap<String, String>();
        String key = value.substring(0, selectField.lastIndexOf(PERMISSION_SUB));
        String tempS = value.substring(value.lastIndexOf(CalendarUtils.COLON_SLASH) + 2);
        if (this.perms_.get(selectField) == null) {
            temp.put(key, tempS);
        } else {
            temp = (Map)this.perms_.get(selectField);
            if (temp.get(key) != null && !tempS.equals(temp.get(key))) {
                tempS = (String)temp.get(key) + CalendarUtils.COMMA + tempS;
            }
            temp.put(key, tempS);
        }
        this.perms_.put(selectField, temp);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String s : temp.values()) {
            for (String t : s.split(CalendarUtils.COMMA)) {
                tempMap.put(t, t);
            }
        }
        for (String s : tempMap.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
        this.setSelectedTab(shareTab.getId());
    }

    protected boolean isPublic() throws Exception {
        UIGroupCalendarTab sharing = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        for (Object groupObj : this.getPublicGroups()) {
            String group = ((Group)groupObj).getId();
            UIFormCheckBoxInput checkBox = sharing.getUIFormCheckBoxInput(group);
            if (checkBox == null || !checkBox.isChecked()) continue;
            return true;
        }
        return false;
    }

    private Object[] getPublicGroups() throws Exception {
        OrganizationService organization = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        String currentUser = CalendarUtils.getCurrentUser();
        return organization.getGroupHandler().findGroupsOfUser(currentUser).toArray();
    }

    private List getSelectedGroups(String groupId) throws Exception {
        UIGroupCalendarTab sharing = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        ArrayList<Group> groups = new ArrayList<Group>();
        Group g = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getGroupHandler().findGroupById(groupId);
        UIFormCheckBoxInput input = sharing.getUIFormCheckBoxInput(groupId);
        if (input != null && input.isChecked()) {
            groups.add(g);
        }
        return groups;
    }

    protected List<SelectItemOption<String>> getTimeZones() {
        return CalendarUtils.getTimeZoneSelectBoxOptions((String[])TimeZone.getAvailableIDs());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    protected List<SelectItemOption<String>> getLocales() {
        return CalendarUtils.getLocaleSelectBoxOptions((Locale[])java.util.Calendar.getAvailableLocales());
    }

    public static List<String> getPermissions(List<String> listPermission, String typedPerms, OrganizationService orgService, String groupIdSelected, String groupKey, Event<?> event) throws Exception {
        if (!CalendarUtils.isEmpty((String)typedPerms)) {
            for (String s : typedPerms.split(CalendarUtils.COMMA)) {
                if (CalendarUtils.isEmpty((String)(s = s.trim()))) continue;
                List users = orgService.getUserHandler().findUsersByGroup(groupIdSelected).getAll();
                boolean isExisted = false;
                for (User u : users) {
                    if (!u.getUserName().equals(s)) continue;
                    isExisted = true;
                    break;
                }
                if (isExisted) {
                    listPermission.add(groupKey + s);
                    continue;
                }
                if (s.equals(CalendarUtils.ANY)) {
                    listPermission.add(groupKey + s);
                    continue;
                }
                if (s.indexOf(CalendarUtils.ANY_OF) > -1) {
                    String typeName = s.substring(s.lastIndexOf(CalendarUtils.DOT) + 1, s.length());
                    if (orgService.getMembershipTypeHandler().findMembershipType(typeName) != null) {
                        listPermission.add(groupKey + s);
                        continue;
                    }
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendarForm.msg.name-not-on-group", new Object[]{s, groupKey}, 1));
                    return null;
                }
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendarForm.msg.name-not-on-group", new Object[]{s, groupKey}, 1));
                return null;
            }
        }
        return listPermission;
    }

    static /* synthetic */ List access$000(UICalendarForm x0, String x1) throws Exception {
        return x0.getSelectedGroups(x1);
    }

    static /* synthetic */ boolean access$100(UICalendarForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ Object[] access$200(UICalendarForm x0) throws Exception {
        return x0.getPublicGroups();
    }

    static /* synthetic */ Log access$300() {
        return log;
    }
}

