/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.popup.UIEditFeed;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webservice.cs.calendar.CalendarWebservice;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIEditFeed.gtmpl", events={@EventConfig(listeners={DeleteCalendarActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetURLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={GenerateURLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCalendarActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIEditFeed
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIEditFeed.class);
    private static final String URL = "url".intern();
    private static final String NAME = "name".intern();
    private static final String CALENDARS = "calendars".intern();
    private static final String ADDMORE = "addMore".intern();
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_ = new HashMap();
    private LinkedHashMap<String, String> feedCalendars = new LinkedHashMap();
    private FeedData feedData = null;
    private boolean isNew_ = false;
    private static String DEFAULT_FEED_NAME = "defaultFeedName".intern();

    private String getURL(String feedName) throws Exception {
        String restName = PortalContainer.getCurrentRestContextName();
        return Utils.SLASH + restName + "/private" + CalendarWebservice.BASE_RSS_URL + Utils.SLASH + CalendarUtils.getCurrentUser() + Utils.SLASH + feedName + Utils.SLASH + IdGenerator.generate() + Utils.RSS_EXT;
    }

    public UIEditFeed() throws Exception {
        String feedName = this.getDefaultFeedName();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, feedName).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(URL, URL, this.getURL(feedName)).addValidator(MandatoryValidator.class, new Object[0]));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData resetURL = new UIFormInputWithActions.ActionData();
        resetURL.setActionListener("ResetURL");
        resetURL.setCssIconClass("ResetURLIcon");
        resetURL.setActionType(0);
        resetURL.setActionName("ResetURL");
        actions.add(resetURL);
        UIFormInputWithActions.ActionData generateURL = new UIFormInputWithActions.ActionData();
        generateURL.setActionListener("GenerateURL");
        generateURL.setCssIconClass("GenerateURLIcon");
        generateURL.setActionType(0);
        generateURL.setActionName("GenerateURL");
        actions.add(generateURL);
        this.setActionField(URL, actions);
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(CALENDARS, CALENDARS, null));
        UIFormComboBox comboBox = new UIFormComboBox(ADDMORE, ADDMORE, this.getCalendarsOptions());
        this.addUIFormInput((UIFormInput)comboBox);
        ArrayList<UIFormInputWithActions.ActionData> actions2 = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addCalendar = new UIFormInputWithActions.ActionData();
        addCalendar.setActionListener("AddCalendar");
        addCalendar.setActionType(0);
        addCalendar.setActionName("AddCalendar");
        actions2.add(addCalendar);
        this.setActionField(ADDMORE, actions2);
        comboBox.setValue(null);
        comboBox.addJsActions(UIFormComboBox.ON_BLUR, "javascript:void(0);");
    }

    private String getDefaultFeedName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("UIEditFeed.label.defaultFeedName");
        }
        catch (MissingResourceException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource is missing", (Throwable)e);
            }
            return DEFAULT_FEED_NAME;
        }
    }

    public void setNew(boolean isNew) {
        this.isNew_ = isNew;
    }

    private List<SelectItemOption<String>> getCalendarsOptions() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        for (Calendar cal : calendarService.getUserCalendars(username, true)) {
            if (this.feedCalendars.containsKey(cal.getId())) continue;
            if (cal.getId().equals(Utils.getDefaultCalendarId((String)username)) && cal.getName().equals(NewUserListener.defaultCalendarName)) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                cal.setName(newName);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(cal.getName(), (Object)(0 + Utils.COLON + cal.getId())));
        }
        List groupCals = calendarService.getGroupCalendars(CalendarUtils.getUserGroups((String)username), true, username);
        for (GroupCalendarData groupData : groupCals) {
            String groupName = groupData.getName();
            if (groupData == null) continue;
            for (Calendar cal : groupData.getCalendars()) {
                if (this.feedCalendars.containsKey(cal.getId())) continue;
                options.add((SelectItemOption<String>)new SelectItemOption(CalendarUtils.getGroupCalendarName((String)groupName.substring(groupName.lastIndexOf("/") + 1), (String)cal.getName()), (Object)(2 + Utils.COLON + cal.getId())));
            }
        }
        GroupCalendarData sharedData = calendarService.getSharedCalendars(CalendarUtils.getCurrentUser(), true);
        if (sharedData != null) {
            for (Calendar cal : sharedData.getCalendars()) {
                if (this.feedCalendars.containsKey(cal.getId())) continue;
                if (cal.getId().equals(Utils.getDefaultCalendarId((String)cal.getCalendarOwner())) && cal.getName().equals(NewUserListener.defaultCalendarName)) {
                    String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                    cal.setName(newName);
                }
                options.add((SelectItemOption<String>)new SelectItemOption(Utils.getDisplaySharedCalendar((String)cal.getCalendarOwner(), (String)cal.getName()), (Object)(1 + Utils.COLON + cal.getId())));
            }
        }
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Close"};
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) throws Exception {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setFeed(FeedData feed) throws Exception {
        this.feedData = feed;
        this.getUIStringInput(NAME).setValue((Object)feed.getTitle());
        this.getUIStringInput(URL).setValue((Object)feed.getUrl());
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
        ArrayList entries = new ArrayList(syndFeed.getEntries());
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        for (int i = 0; i < entries.size(); ++i) {
            SyndEntry entry = (SyndEntry)entries.get(i);
            String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
            Calendar calendar = null;
            try {
                String newName;
                calendar = calendarService.getUserCalendar(username, calendarId);
                if (calendar != null) {
                    if (calendar.getId().equals(Utils.getDefaultCalendarId((String)username)) && calendar.getName().equals(NewUserListener.defaultCalendarName)) {
                        newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                        calendar.setName(newName);
                    }
                    this.feedCalendars.put(0 + Utils.COLON + calendar.getId(), calendar.getName());
                    continue;
                }
                try {
                    calendar = calendarService.getSharedCalendars(username, false).getCalendarById(calendarId);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (calendar != null) {
                    if (calendar.getId().equals(Utils.getDefaultCalendarId((String)calendar.getCalendarOwner())) && calendar.getName().equals(NewUserListener.defaultCalendarName)) {
                        newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                        calendar.setName(newName);
                    }
                    this.feedCalendars.put(1 + Utils.COLON + calendar.getId(), Utils.getDisplaySharedCalendar((String)calendar.getCalendarOwner(), (String)calendar.getName()));
                    continue;
                }
                calendar = calendarService.getGroupCalendar(calendarId);
                List options = this.getCalendarsOptions();
                String groupName = null;
                for (SelectItemOption option : options) {
                    if (!((String)option.getValue()).contains(calendarId)) continue;
                    groupName = option.getLabel();
                    break;
                }
                if (calendar == null) continue;
                this.feedCalendars.put(2 + Utils.COLON + calendar.getId(), groupName);
                continue;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Fail to set feed", (Throwable)e);
            }
        }
    }

    public LinkedHashMap<String, String> getFeedCalendars() {
        return this.feedCalendars;
    }

    static /* synthetic */ String access$000() {
        return ADDMORE;
    }

    static /* synthetic */ LinkedHashMap access$100(UIEditFeed x0) {
        return x0.feedCalendars;
    }

    static /* synthetic */ String access$200() {
        return NAME;
    }

    static /* synthetic */ boolean access$300(UIEditFeed x0) {
        return x0.isNew_;
    }

    static /* synthetic */ FeedData access$400(UIEditFeed x0) {
        return x0.feedData;
    }

    static /* synthetic */ String access$500() {
        return URL;
    }

    static /* synthetic */ String access$600(UIEditFeed x0, String x1) throws Exception {
        return x0.getURL(x1);
    }

    static /* synthetic */ String access$700(UIEditFeed x0) {
        return x0.getDefaultFeedName();
    }
}

