/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.servlet.ServletContainerRequest;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;

@Deprecated
public class MessengerServlet
extends HttpServlet
implements Connector {
    private static final long serialVersionUID = -5976447080959500615L;
    private static final Log LOGGER = LogFactory.getLog((String)"MessangerServlet");
    private int connectionTimeout;
    private int timeChekEvent;
    private ServletConfig config;
    private ServletContext context;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
        try {
            String timeOut = this.getInitParameter("connection-timeout");
            String timeChekEventStr = this.getInitParameter("time-check-event");
            if (timeOut != null) {
                this.connectionTimeout = Integer.parseInt(timeOut);
            } else {
                LOGGER.info((Object)"Connection timeout is not set, default 60000 ms");
                this.connectionTimeout = 60000;
            }
            if (timeChekEventStr != null) {
                this.timeChekEvent = Integer.parseInt(timeChekEventStr);
            } else {
                LOGGER.info((Object)"Timeout for cheking event is not set, default 3000 ms");
                this.timeChekEvent = 3000;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Can not get init parameters");
        }
    }

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        HttpSession httpSession;
        HttpSessionStateKey stateKey;
        httpRequest.setCharacterEncoding("UTF-8");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null && (state = conversationRegistry.getState((StateKey)(stateKey = new HttpSessionStateKey(httpSession = httpRequest.getSession())))) != null && !userId.equals(state.getIdentity().getUserId())) {
            conversationRegistry.unregister((StateKey)stateKey);
        }
        LOGGER.debug((Object)("Current Container: " + container));
        RequestHandler requestHandler = (RequestHandler)container.getComponentInstanceOfType(RequestHandler.class);
        EnvironmentContext env = new EnvironmentContext();
        env.put(HttpServletRequest.class, (Object)httpRequest);
        env.put(HttpServletResponse.class, (Object)httpResponse);
        env.put(ServletConfig.class, (Object)this.config);
        env.put(ServletContext.class, (Object)this.context);
        try {
            EnvironmentContext.setCurrent((EnvironmentContext)env);
            ServletContainerRequest request = new ServletContainerRequest(httpRequest);
            ContainerResponse response = new ContainerResponse((ContainerResponseWriter)new ServletContainerResponseWriter(httpResponse));
            requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            EnvironmentContext.setCurrent(null);
        }
    }

    class ServletContainerResponseWriter
    implements ContainerResponseWriter {
        private HttpServletResponse servletResponse;

        ServletContainerResponseWriter(HttpServletResponse response) {
            this.servletResponse = response;
        }

        public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
            Object entity = response.getEntity();
            if (entity != null) {
                ServletOutputStream out = this.servletResponse.getOutputStream();
                entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
                out.flush();
            }
        }

        public void writeHeaders(GenericContainerResponse response) throws IOException {
            if (this.servletResponse.isCommitted()) {
                return;
            }
            this.servletResponse.setStatus(response.getStatus());
            if (response.getHttpHeaders() != null) {
                for (Map.Entry e : response.getHttpHeaders().entrySet()) {
                    String name = (String)e.getKey();
                    for (Object o : (List)e.getValue()) {
                        String value = null;
                        if (o == null || (value = HeaderHelper.getHeaderAsString(o)) == null) continue;
                        this.servletResponse.addHeader(name, value);
                    }
                }
            }
        }
    }
}

