/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.uistate.rest;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.uistate.UIStateSession;
import org.exoplatform.services.uistate.bean.UIStateDataBean;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;

@Path(value="/uistateservice")
public class UIStateService
implements ResourceContainer {
    private static final CacheControl cc;
    private static String unreadMessageCount;

    @POST
    @Path(value="/save/{username}/{unreadMessageCnt}")
    @Produces(value={"application/json"})
    public Response saveState(@PathParam(value="username") String userName, @PathParam(value="unreadMessageCnt") String unreadMessageCnt, UIStateDataBean stateData) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            if (messenger != null) {
                UIStateSession uiSession = messenger.getUISateSession(userName);
                stateData = stateData != null ? stateData : new UIStateDataBean();
                uiSession.setUIStateData(stateData);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        unreadMessageCount = unreadMessageCnt;
        UIStateDataBean stateDataBean = new UIStateDataBean("null");
        stateDataBean.setUnreadMessageCnt(unreadMessageCount);
        return Response.ok((Object)stateDataBean, (String)"application/json").cacheControl(cc).build();
    }

    @GET
    @Path(value="/get/{username}/")
    @Produces(value={"application/json"})
    public Response getState(@PathParam(value="username") String userName) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            if (messenger != null) {
                UIStateSession uiSession = messenger.getUISateSession(userName);
                UIStateDataBean uiStateData = uiSession.getUIStateData();
                uiStateData = uiStateData != null ? uiStateData : new UIStateDataBean();
                return Response.ok((Object)uiStateData, (String)"application/json").cacheControl(cc).build();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UIStateDataBean stateDataBean = new UIStateDataBean();
        return Response.ok((Object)stateDataBean, (String)"application/json").cacheControl(cc).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

