/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.webui;

import javax.portlet.PortletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/chat/webui/UIChatPortlet.gtmpl")
public class UIChatPortlet
extends UIPortletApplication {
    private String windowId;

    public UIChatPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = context.getRequest();
        this.windowId = prequest.getWindowID();
    }

    public String getId() {
        return this.windowId;
    }

    public String getRemoteUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public String getUserToken() {
        try {
            return this.getContinuationService().getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            System.out.println("\n\n can not get UserToken");
            return "";
        }
    }

    protected ContinuationService getContinuationService() {
        PortalContainer container = PortalContainer.getInstance();
        ContinuationService continuation = (ContinuationService)container.getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    protected String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }

    protected String getCometdContextName() {
        String cometdContextName = "cometd";
        try {
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
            return bayeux == null ? "cometd" : bayeux.getCometdContextName();
        }
        catch (Exception exception) {
            return cometdContextName;
        }
    }
}

