/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chatbar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class Utils {
    public static final String URL_PATTERN = "((mailto\\:|(news|(ht|f)tp(s?))\\://){1}\\S+)";

    public static String getServerBaseUrl() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String url = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort()) + "/";
        return url;
    }

    public static String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public static boolean isUri(String input) {
        try {
            if (input == null) {
                return false;
            }
            Matcher matcher = Pattern.compile(URL_PATTERN).matcher(input);
            return matcher.find();
        }
        catch (Exception e) {
            return false;
        }
    }
}

