/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.JCRPageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactPageList
extends JCRPageList {
    private String username_;
    private NodeIterator iter_ = null;
    private boolean isQuery_ = false;
    private String value_;
    private String contactType_ = "0";

    public ContactPageList(String username, NodeIterator iter, long pageSize, String value, boolean isQuery, String type) throws Exception {
        super(pageSize);
        this.username_ = username;
        this.iter_ = iter;
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.contactType_ = type;
        this.setAvailablePage(iter.getSize());
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        if (this.iter_ == null) {
            Session session = this.getJCRSession(username);
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            session.logout();
        }
        this.setAvailablePage(this.iter_.getSize());
        long pageSize = this.getPageSize();
        long position = 0L;
        if (page == 1L) {
            position = 0L;
        } else {
            position = (page - 1L) * pageSize;
            this.iter_.skip(position);
        }
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:contact")) {
                Contact contact = this.getContact(currentNode, this.contactType_);
                if (contact.getId().equalsIgnoreCase(this.username_)) {
                    this.currentListPage_.add(0, contact);
                } else {
                    this.currentListPage_.add(contact);
                }
            }
            ++i;
        }
        this.iter_ = null;
    }

    private Contact getContact(Node contactNode, String type) throws Exception {
        Node image;
        Contact contact = new Contact();
        if (contactNode.hasProperty("exo:id")) {
            contact.setId(contactNode.getProperty("exo:id").getString());
        }
        if (contactNode.hasProperty("exo:fullName")) {
            contact.setFullName(contactNode.getProperty("exo:fullName").getString());
        }
        if (contactNode.hasProperty("exo:firstName")) {
            contact.setFirstName(contactNode.getProperty("exo:firstName").getString());
        }
        if (contactNode.hasProperty("exo:lastName")) {
            contact.setLastName(contactNode.getProperty("exo:lastName").getString());
        }
        if (contactNode.hasProperty("exo:nickName")) {
            contact.setNickName(contactNode.getProperty("exo:nickName").getString());
        }
        if (contactNode.hasProperty("exo:gender")) {
            contact.setGender(contactNode.getProperty("exo:gender").getString());
        }
        if (contactNode.hasProperty("exo:birthday")) {
            contact.setBirthday(contactNode.getProperty("exo:birthday").getDate().getTime());
        }
        if (contactNode.hasProperty("exo:jobTitle")) {
            contact.setJobTitle(contactNode.getProperty("exo:jobTitle").getString());
        }
        if (contactNode.hasProperty("exo:emailAddress")) {
            contact.setEmailAddress(contactNode.getProperty("exo:emailAddress").getString());
        }
        if (contactNode.hasProperty("exo:exoId")) {
            contact.setExoId(contactNode.getProperty("exo:exoId").getString());
        }
        if (contactNode.hasProperty("exo:googleId")) {
            contact.setGoogleId(contactNode.getProperty("exo:googleId").getString());
        }
        if (contactNode.hasProperty("exo:msnId")) {
            contact.setMsnId(contactNode.getProperty("exo:msnId").getString());
        }
        if (contactNode.hasProperty("exo:aolId")) {
            contact.setAolId(contactNode.getProperty("exo:aolId").getString());
        }
        if (contactNode.hasProperty("exo:yahooId")) {
            contact.setYahooId(contactNode.getProperty("exo:yahooId").getString());
        }
        if (contactNode.hasProperty("exo:icrId")) {
            contact.setIcrId(contactNode.getProperty("exo:icrId").getString());
        }
        if (contactNode.hasProperty("exo:skypeId")) {
            contact.setSkypeId(contactNode.getProperty("exo:skypeId").getString());
        }
        if (contactNode.hasProperty("exo:icqId")) {
            contact.setIcqId(contactNode.getProperty("exo:icqId").getString());
        }
        if (contactNode.hasProperty("exo:homeAddress")) {
            contact.setHomeAddress(contactNode.getProperty("exo:homeAddress").getString());
        }
        if (contactNode.hasProperty("exo:homeCity")) {
            contact.setHomeCity(contactNode.getProperty("exo:homeCity").getString());
        }
        if (contactNode.hasProperty("exo:homeState_province")) {
            contact.setHomeState_province(contactNode.getProperty("exo:homeState_province").getString());
        }
        if (contactNode.hasProperty("exo:homePostalCode")) {
            contact.setHomePostalCode(contactNode.getProperty("exo:homePostalCode").getString());
        }
        if (contactNode.hasProperty("exo:homeCountry")) {
            contact.setHomeCountry(contactNode.getProperty("exo:homeCountry").getString());
        }
        if (contactNode.hasProperty("exo:homePhone1")) {
            contact.setHomePhone1(contactNode.getProperty("exo:homePhone1").getString());
        }
        if (contactNode.hasProperty("exo:homePhone2")) {
            contact.setHomePhone2(contactNode.getProperty("exo:homePhone2").getString());
        }
        if (contactNode.hasProperty("exo:homeFax")) {
            contact.setHomeFax(contactNode.getProperty("exo:homeFax").getString());
        }
        if (contactNode.hasProperty("exo:personalSite")) {
            contact.setPersonalSite(contactNode.getProperty("exo:personalSite").getString());
        }
        if (contactNode.hasProperty("exo:workAddress")) {
            contact.setWorkAddress(contactNode.getProperty("exo:workAddress").getString());
        }
        if (contactNode.hasProperty("exo:workCity")) {
            contact.setWorkCity(contactNode.getProperty("exo:workCity").getString());
        }
        if (contactNode.hasProperty("exo:workState_province")) {
            contact.setWorkStateProvince(contactNode.getProperty("exo:workState_province").getString());
        }
        if (contactNode.hasProperty("exo:workPostalCode")) {
            contact.setWorkPostalCode(contactNode.getProperty("exo:workPostalCode").getString());
        }
        if (contactNode.hasProperty("exo:workCountry")) {
            contact.setWorkCountry(contactNode.getProperty("exo:workCountry").getString());
        }
        if (contactNode.hasProperty("exo:workPhone1")) {
            contact.setWorkPhone1(contactNode.getProperty("exo:workPhone1").getString());
        }
        if (contactNode.hasProperty("exo:workPhone2")) {
            contact.setWorkPhone2(contactNode.getProperty("exo:workPhone2").getString());
        }
        if (contactNode.hasProperty("exo:workFax")) {
            contact.setWorkFax(contactNode.getProperty("exo:workFax").getString());
        }
        if (contactNode.hasProperty("exo:mobilePhone")) {
            contact.setMobilePhone(contactNode.getProperty("exo:mobilePhone").getString());
        }
        if (contactNode.hasProperty("exo:webPage")) {
            contact.setWebPage(contactNode.getProperty("exo:webPage").getString());
        }
        if (contactNode.hasProperty("exo:note")) {
            contact.setNote(contactNode.getProperty("exo:note").getString());
        }
        if (contactNode.hasProperty("exo:categories")) {
            contact.setAddressBook(this.ValuesToStrings(contactNode.getProperty("exo:categories").getValues()));
        }
        if (contactNode.hasProperty("exo:tags")) {
            contact.setTags(this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionUsers")) {
            contact.setViewPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionUsers")) {
            contact.setEditPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionGroups")) {
            contact.setViewPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionGroups")) {
            contact.setEditPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:lastUpdated")) {
            contact.setLastUpdated(contactNode.getProperty("exo:lastUpdated").getDate().getTime());
        }
        contact.setPath(contactNode.getPath());
        if (contactNode.hasNode("image") && (image = contactNode.getNode("image")).isNodeType("nt:file")) {
            ContactAttachment file = new ContactAttachment();
            file.setId(image.getPath());
            file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            file.setFileName(image.getName());
            file.setWorkspace(image.getSession().getWorkspace().getName());
            contact.setAttachment(file);
        }
        contact.setContactType(type);
        if (contactNode.hasProperty("exo:isOwner")) {
            contact.setOwner(contactNode.getProperty("exo:isOwner").getBoolean());
        }
        if (contactNode.hasProperty("exo:ownerId")) {
            contact.setOwnerId(contactNode.getProperty("exo:ownerId").getString());
        }
        return contact;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    @Override
    public List<Contact> getAll() throws Exception {
        if (this.iter_ == null) {
            Session session = this.getJCRSession(this.username_);
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            session.logout();
        }
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        while (this.iter_.hasNext()) {
            Node contactNode = this.iter_.nextNode();
            contacts.add(this.getContact(contactNode, this.contactType_));
        }
        return contacts;
    }

    @Override
    public void setList(List<Contact> contacts) {
    }

    private Session getJCRSession(String username) throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
        return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
    }
}

