/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.impl.GroupImpl;

public class NewUserListener
extends UserEventListener {
    private ContactService cservice_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    public static String DEFAULTGROUP = "default".intern();
    public static String DEFAULTGROUPNAME = "My contacts".intern();
    public static String DEFAULTGROUPDES = "Default address book".intern();

    public NewUserListener(ContactService cservice, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.cservice_ = cservice;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        Contact contact = null;
        contact = isNew ? new Contact() : this.cservice_.getPublicContact(user.getUserName());
        if (contact != null) {
            contact.setFullName(user.getFirstName() + " " + user.getLastName());
            contact.setFirstName(user.getFirstName());
            contact.setLastName(user.getLastName());
            contact.setEmailAddress(user.getEmail());
            GregorianCalendar cal = new GregorianCalendar();
            contact.setLastUpdated(cal.getTime());
        }
        if (isNew) {
            Object[] objGroupIds;
            ContactGroup group = new ContactGroup();
            group.setId(DEFAULTGROUP + user.getUserName());
            group.setName(DEFAULTGROUPNAME);
            group.setDescription(DEFAULTGROUPDES);
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            this.cservice_.saveGroup(sysProvider, user.getUserName(), group, true);
            contact.setId(user.getUserName());
            LinkedHashMap<String, String> groupIds = new LinkedHashMap<String, String>();
            groupIds.put(group.getId(), group.getId());
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            for (Object object : objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(user.getUserName()).toArray()) {
                String id = ((GroupImpl)object).getId();
                groupIds.put(id, id);
            }
            contact.setAddressBook(groupIds.keySet().toArray(new String[0]));
            contact.setOwner(true);
            contact.setOwnerId(user.getUserName());
            this.cservice_.saveContact(sysProvider, user.getUserName(), contact, true);
            JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_);
            Node publicContactHome = storage_.getPublicContactHome(SessionProvider.createSystemProvider());
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(JCRDataStorage.USERS_PATH);
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            ArrayList<String> recievedUser = new ArrayList<String>();
            recievedUser.add(user.getUserName());
            for (Object object : objGroupIds) {
                String groupId = ((GroupImpl)object).getId();
                StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(groupId + "']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node address = nodes.nextNode();
                    storage_.shareAddressBook(SessionProvider.createSystemProvider(), address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), recievedUser);
                }
                queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(groupId + "']");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node contactNode = nodes.nextNode();
                    String split = "/";
                    String temp = contactNode.getPath().split(usersPath)[1];
                    String userId = temp.split(split)[1];
                    storage_.shareContact(SessionProvider.createSystemProvider(), userId, new String[]{contactNode.getProperty("exo:id").getString()}, recievedUser);
                }
            }
            Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(SessionProvider.createSystemProvider(), user.getUserName());
            userApp.getSession().save();
            sysProvider.close();
        } else if (contact != null) {
            this.cservice_.saveContact(SessionProvider.createSystemProvider(), user.getUserName(), contact, false);
        }
    }

    private void reparePermissions(Node node, String owner) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(owner, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
        extNode.removePermission("any");
    }

    public void preDelete(User user) throws Exception {
    }
}

