/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.GroupContactData;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private static final String CONTACTS = "contacts".intern();
    private static final String ADDRESS_BOOK = "contactGroup".intern();
    private static final String TAGS = "tags".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String CONTACT_APP = "ContactApplication".intern();
    private static final String SHARED_HOME = "Shared".intern();
    private static final String SHARED_CONTACT = "SharedContact".intern();
    private static final String SHARED_ADDRESSBOOK = "SharedAddressBook".intern();
    private static final String SHARED_MIXIN = "exo:contactShared".intern();
    private static final String SHARED_PROP = "exo:sharedId".intern();
    public static final String USERS_PATH = "usersPath".intern();
    public static final String PRIVATE = "0".intern();
    public static final String SHARED = "1".intern();
    public static final String PUBLIC = "2".intern();
    public static final String SPLIT = "::".intern();
    public static final String HYPHEN = "shared_".intern();
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    private Node getUserContactServiceHome(SessionProvider sProvider, String username) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username);
        try {
            return userApp.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node userHome = userApp.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            userApp.getSession().save();
            return userHome;
        }
    }

    private Node getPublicContactServiceHome(SessionProvider sProvider) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return userApp.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node publicHome = userApp.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            userApp.save();
            return publicHome;
        }
    }

    private Node getUserContactHome(SessionProvider sProvider, String username) throws Exception {
        Node contactServiceHome = this.getUserContactServiceHome(sProvider, username);
        try {
            return contactServiceHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node userHome = contactServiceHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return userHome;
        }
    }

    protected Node getUserContactGroupHome(SessionProvider sProvider, String username) throws Exception {
        Node contactServiceHome = this.getUserContactServiceHome(sProvider, username);
        try {
            return contactServiceHome.getNode(ADDRESS_BOOK);
        }
        catch (PathNotFoundException ex) {
            Node addHome = contactServiceHome.addNode(ADDRESS_BOOK, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return addHome;
        }
    }

    protected Node getPublicContactHome(SessionProvider sProvider) throws Exception {
        Node contactServiceHome = this.getPublicContactServiceHome(sProvider);
        try {
            return contactServiceHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node publicHome = contactServiceHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return publicHome;
        }
    }

    private Node getTagHome(SessionProvider sProvider, String username) throws Exception {
        Node contactServiceHome = this.getUserContactServiceHome(sProvider, username);
        try {
            return contactServiceHome.getNode(TAGS);
        }
        catch (PathNotFoundException ex) {
            Node tagHome = contactServiceHome.addNode(TAGS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return tagHome;
        }
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getPersonalContact(String userId) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getUserContactHome(provider, userId);
            try {
                Contact contact = this.getContact(contactHome.getNode(userId), PUBLIC);
                return contact;
            }
            catch (PathNotFoundException e) {
                Contact contact = null;
                provider.close();
                return contact;
            }
        }
        finally {
            provider.close();
        }
    }

    private Contact getContact(Node contactNode, String contactType) throws Exception {
        Node image;
        Contact contact = new Contact();
        contact.setContactType(contactType);
        if (contactNode.hasProperty("exo:id")) {
            contact.setId(contactNode.getProperty("exo:id").getString());
        }
        if (contactNode.hasProperty("exo:fullName")) {
            contact.setFullName(contactNode.getProperty("exo:fullName").getString());
        }
        if (contactNode.hasProperty("exo:firstName")) {
            contact.setFirstName(contactNode.getProperty("exo:firstName").getString());
        }
        if (contactNode.hasProperty("exo:lastName")) {
            contact.setLastName(contactNode.getProperty("exo:lastName").getString());
        }
        if (contactNode.hasProperty("exo:nickName")) {
            contact.setNickName(contactNode.getProperty("exo:nickName").getString());
        }
        if (contactNode.hasProperty("exo:gender")) {
            contact.setGender(contactNode.getProperty("exo:gender").getString());
        }
        if (contactNode.hasProperty("exo:birthday")) {
            contact.setBirthday(contactNode.getProperty("exo:birthday").getDate().getTime());
        }
        if (contactNode.hasProperty("exo:jobTitle")) {
            contact.setJobTitle(contactNode.getProperty("exo:jobTitle").getString());
        }
        if (contactNode.hasProperty("exo:emailAddress")) {
            contact.setEmailAddress(contactNode.getProperty("exo:emailAddress").getString());
        }
        if (contactNode.hasProperty("exo:exoId")) {
            contact.setExoId(contactNode.getProperty("exo:exoId").getString());
        }
        if (contactNode.hasProperty("exo:googleId")) {
            contact.setGoogleId(contactNode.getProperty("exo:googleId").getString());
        }
        if (contactNode.hasProperty("exo:msnId")) {
            contact.setMsnId(contactNode.getProperty("exo:msnId").getString());
        }
        if (contactNode.hasProperty("exo:aolId")) {
            contact.setAolId(contactNode.getProperty("exo:aolId").getString());
        }
        if (contactNode.hasProperty("exo:yahooId")) {
            contact.setYahooId(contactNode.getProperty("exo:yahooId").getString());
        }
        if (contactNode.hasProperty("exo:icrId")) {
            contact.setIcrId(contactNode.getProperty("exo:icrId").getString());
        }
        if (contactNode.hasProperty("exo:skypeId")) {
            contact.setSkypeId(contactNode.getProperty("exo:skypeId").getString());
        }
        if (contactNode.hasProperty("exo:icqId")) {
            contact.setIcqId(contactNode.getProperty("exo:icqId").getString());
        }
        if (contactNode.hasProperty("exo:homeAddress")) {
            contact.setHomeAddress(contactNode.getProperty("exo:homeAddress").getString());
        }
        if (contactNode.hasProperty("exo:homeCity")) {
            contact.setHomeCity(contactNode.getProperty("exo:homeCity").getString());
        }
        if (contactNode.hasProperty("exo:homeState_province")) {
            contact.setHomeState_province(contactNode.getProperty("exo:homeState_province").getString());
        }
        if (contactNode.hasProperty("exo:homePostalCode")) {
            contact.setHomePostalCode(contactNode.getProperty("exo:homePostalCode").getString());
        }
        if (contactNode.hasProperty("exo:homeCountry")) {
            contact.setHomeCountry(contactNode.getProperty("exo:homeCountry").getString());
        }
        if (contactNode.hasProperty("exo:homePhone1")) {
            contact.setHomePhone1(contactNode.getProperty("exo:homePhone1").getString());
        }
        if (contactNode.hasProperty("exo:homePhone2")) {
            contact.setHomePhone2(contactNode.getProperty("exo:homePhone2").getString());
        }
        if (contactNode.hasProperty("exo:homeFax")) {
            contact.setHomeFax(contactNode.getProperty("exo:homeFax").getString());
        }
        if (contactNode.hasProperty("exo:personalSite")) {
            contact.setPersonalSite(contactNode.getProperty("exo:personalSite").getString());
        }
        if (contactNode.hasProperty("exo:workAddress")) {
            contact.setWorkAddress(contactNode.getProperty("exo:workAddress").getString());
        }
        if (contactNode.hasProperty("exo:workCity")) {
            contact.setWorkCity(contactNode.getProperty("exo:workCity").getString());
        }
        if (contactNode.hasProperty("exo:workState_province")) {
            contact.setWorkStateProvince(contactNode.getProperty("exo:workState_province").getString());
        }
        if (contactNode.hasProperty("exo:workPostalCode")) {
            contact.setWorkPostalCode(contactNode.getProperty("exo:workPostalCode").getString());
        }
        if (contactNode.hasProperty("exo:workCountry")) {
            contact.setWorkCountry(contactNode.getProperty("exo:workCountry").getString());
        }
        if (contactNode.hasProperty("exo:workPhone1")) {
            contact.setWorkPhone1(contactNode.getProperty("exo:workPhone1").getString());
        }
        if (contactNode.hasProperty("exo:workPhone2")) {
            contact.setWorkPhone2(contactNode.getProperty("exo:workPhone2").getString());
        }
        if (contactNode.hasProperty("exo:workFax")) {
            contact.setWorkFax(contactNode.getProperty("exo:workFax").getString());
        }
        if (contactNode.hasProperty("exo:mobilePhone")) {
            contact.setMobilePhone(contactNode.getProperty("exo:mobilePhone").getString());
        }
        if (contactNode.hasProperty("exo:webPage")) {
            contact.setWebPage(contactNode.getProperty("exo:webPage").getString());
        }
        if (contactNode.hasProperty("exo:note")) {
            contact.setNote(contactNode.getProperty("exo:note").getString());
        }
        if (contactNode.hasProperty("exo:categories")) {
            contact.setAddressBook(this.ValuesToStrings(contactNode.getProperty("exo:categories").getValues()));
        }
        if (contactNode.hasProperty("exo:tags")) {
            contact.setTags(this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionUsers")) {
            contact.setEditPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionUsers")) {
            contact.setViewPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionGroups")) {
            contact.setEditPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionGroups")) {
            contact.setViewPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:lastUpdated")) {
            contact.setLastUpdated(contactNode.getProperty("exo:lastUpdated").getDate().getTime());
        }
        contact.setPath(contactNode.getPath());
        if (contactNode.hasNode("image") && (image = contactNode.getNode("image")).isNodeType("nt:file")) {
            ContactAttachment file = new ContactAttachment();
            file.setId(image.getPath());
            file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            file.setFileName(image.getName());
            file.setWorkspace(image.getSession().getWorkspace().getName());
            contact.setAttachment(file);
        }
        if (contactNode.hasProperty("exo:isOwner")) {
            contact.setOwner(contactNode.getProperty("exo:isOwner").getBoolean());
        }
        if (contactNode.hasProperty("exo:ownerId")) {
            contact.setOwnerId(contactNode.getProperty("exo:ownerId").getString());
        }
        return contact;
    }

    public List<Contact> getAllContact(SessionProvider sProvider, String username) throws Exception {
        Node contactHomeNode = this.getUserContactHome(sProvider, username);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        NodeIterator iter = contactHomeNode.getNodes();
        while (iter.hasNext()) {
            Node contactNode = iter.nextNode();
            Contact contact = this.getContact(contactNode, PRIVATE);
            contacts.add(contact);
        }
        return contacts;
    }

    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, ContactFilter filter, String type) throws Exception {
        QueryManager qm = null;
        if (type.equals(PRIVATE)) {
            Node contactHomeNode = this.getUserContactHome(sProvider, username);
            filter.setAccountPath(contactHomeNode.getPath());
            qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
        } else if (type.equals(PUBLIC)) {
            Node publicContactHomeNode = this.getPublicContactHome(sProvider);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            filter.setAccountPath(usersPath);
            qm = publicContactHomeNode.getSession().getWorkspace().getQueryManager();
        } else if (type.equals(SHARED)) {
            Node sharedAddressBookMock = this.getSharedAddressBook(username);
            PropertyIterator iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                if (!addressBook.getName().equals(filter.getCategories()[0])) continue;
                Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                filter.setAccountPath(contacts.getPath());
                qm = contacts.getSession().getWorkspace().getQueryManager();
                break;
            }
        }
        if (qm != null) {
            Query query = qm.createQuery(filter.getStatement(), "xpath");
            QueryResult result = query.execute();
            return new ContactPageList(username, result.getNodes(), 10L, filter.getStatement(), true, type);
        }
        return null;
    }

    public Contact getContact(SessionProvider sProvider, String username, String contactId) throws Exception {
        Node contactHomeNode = this.getUserContactHome(sProvider, username);
        try {
            return this.getContact(contactHomeNode.getNode(contactId), PRIVATE);
        }
        catch (PathNotFoundException ex) {
            return null;
        }
    }

    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        Node contactHome = this.getUserContactHome(sProvider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']").append("order by @exo:fullName,@exo:id ascending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        ContactPageList pageList = new ContactPageList(username, result.getNodes(), 10L, queryString.toString(), true, PRIVATE);
        return pageList;
    }

    public List<String> getAllEmailAddressByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        Node contactHome = this.getUserContactHome(sProvider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
        NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
        ArrayList<String> address = new ArrayList<String>();
        while (it.hasNext()) {
            Node contact = it.nextNode();
            if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
            address.add(contact.getProperty("exo:emailAddress").getString());
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllEmailByPublicGroup(String username, String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node publicContactHome = this.getPublicContactHome(provider);
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            ArrayList<String> address = new ArrayList<String>();
            while (it.hasNext()) {
                Node contact = it.nextNode();
                if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
                address.add(contact.getProperty("exo:emailAddress").getString());
            }
            ArrayList<String> arrayList = address;
            return arrayList;
        }
        finally {
            provider.close();
        }
    }

    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            QueryManager qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + addressBook.getParent().getParent().getNode(CONTACTS).getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBookId).append("')]");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            ArrayList<String> address = new ArrayList<String>();
            while (it.hasNext()) {
                Node contact = it.nextNode();
                if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
                address.add(contact.getProperty("exo:emailAddress").getString());
            }
            return address;
        }
        return null;
    }

    private ContactGroup getGroup(Node contactGroupNode) throws Exception {
        ContactGroup contactGroup = new ContactGroup();
        if (contactGroupNode.hasProperty("exo:id")) {
            contactGroup.setId(contactGroupNode.getProperty("exo:id").getString());
        }
        if (contactGroupNode.hasProperty("exo:name")) {
            contactGroup.setName(contactGroupNode.getProperty("exo:name").getString());
        }
        if (contactGroupNode.hasProperty("exo:description")) {
            contactGroup.setDescription(contactGroupNode.getProperty("exo:description").getString());
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionUsers")) {
            contactGroup.setViewPermissionUsers(this.ValuesToStrings(contactGroupNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionUsers")) {
            contactGroup.setEditPermissionUsers(this.ValuesToStrings(contactGroupNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionGroups")) {
            contactGroup.setViewPermissionGroups(this.ValuesToStrings(contactGroupNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionGroups")) {
            contactGroup.setEditPermissionGroups(this.ValuesToStrings(contactGroupNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        return contactGroup;
    }

    public ContactGroup getGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        Node contactGroupHomeNode = this.getUserContactGroupHome(sProvider, username);
        if (contactGroupHomeNode.hasNode(groupId)) {
            return this.getGroup(contactGroupHomeNode.getNode(groupId));
        }
        return null;
    }

    public ContactGroup getSharedGroup(String username, String groupId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(groupId)) continue;
            return this.getGroup(addressBook);
        }
        return null;
    }

    public List<ContactGroup> getGroups(SessionProvider sProvider, String username) throws Exception {
        Node contactGroupHomeNode = this.getUserContactGroupHome(sProvider, username);
        ArrayList<ContactGroup> contactGroups = new ArrayList<ContactGroup>();
        NodeIterator iter = contactGroupHomeNode.getNodes();
        while (iter.hasNext()) {
            Node contactGroupNode = iter.nextNode();
            contactGroups.add(this.getGroup(contactGroupNode));
        }
        return contactGroups;
    }

    public List<Contact> removeContacts(SessionProvider sysProvider, String username, List<String> contactIds) throws Exception {
        Node contactHomeNode = this.getUserContactHome(sysProvider, username);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (String contactId : contactIds) {
            if (!contactHomeNode.hasNode(contactId)) continue;
            Contact contact = this.getContact(sysProvider, username, contactId);
            contactHomeNode.getNode(contactId).remove();
            contactHomeNode.getSession().save();
            contacts.add(contact);
        }
        return contacts;
    }

    public void moveContacts(SessionProvider sysProvider, String username, List<Contact> contacts, String addressType) throws Exception {
        Node privateContactHome = this.getUserContactHome(sysProvider, username);
        for (Contact contact : contacts) {
            if (addressType.equals(PRIVATE)) {
                this.saveContact(sysProvider, username, contact, false);
                continue;
            }
            if (!addressType.equals(SHARED)) continue;
            this.saveContactToSharedAddressBook(username, contact.getAddressBook()[0], contact, true);
            if (!privateContactHome.hasNode(contact.getId())) continue;
            privateContactHome.getNode(contact.getId()).remove();
        }
        if (privateContactHome.getSession().hasPendingChanges()) {
            privateContactHome.getSession().save();
        }
    }

    private List<String> getUserContactNodesByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        Node contactHome = this.getUserContactHome(sProvider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        ArrayList<String> contactIds = new ArrayList<String>();
        while (it.hasNext()) {
            contactIds.add(it.nextNode().getProperty("exo:id").getString());
        }
        return contactIds;
    }

    public ContactGroup removeGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        Node contactGroupHomeNode = this.getUserContactGroupHome(sProvider, username);
        if (contactGroupHomeNode.hasNode(groupId)) {
            ContactGroup contactGroup = this.getGroup(sProvider, username, groupId);
            contactGroupHomeNode.getNode(groupId).remove();
            contactGroupHomeNode.save();
            contactGroupHomeNode.getSession().save();
            List<String> contactIds = this.getUserContactNodesByGroup(sProvider, username, groupId);
            this.removeContacts(sProvider, username, contactIds);
            return contactGroup;
        }
        return null;
    }

    public void saveContact(SessionProvider sProvider, String username, Contact contact, boolean isNew) throws Exception {
        Node contactHomeNode = this.getUserContactHome(sProvider, username);
        this.saveContact(contactHomeNode, contact, isNew);
        contactHomeNode.getSession().save();
    }

    public void saveGroup(SessionProvider sProvider, String username, ContactGroup group, boolean isNew) throws Exception {
        Node groupNode = null;
        if (isNew) {
            groupNode = this.getUserContactGroupHome(sProvider, username).addNode(group.getId(), "exo:contactGroup");
            groupNode.setProperty("exo:id", group.getId());
        } else {
            try {
                groupNode = this.getUserContactGroupHome(sProvider, username).getNode(group.getId());
            }
            catch (PathNotFoundException e) {
                Node sharedAddressBookMock = this.getSharedAddressBook(username);
                PropertyIterator iter = sharedAddressBookMock.getReferences();
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    if (!addressBook.getName().equals(group.getId())) continue;
                    groupNode = addressBook;
                    break;
                }
            }
        }
        if (groupNode == null && !isNew) {
            throw new PathNotFoundException();
        }
        groupNode.setProperty("exo:name", group.getName());
        groupNode.setProperty("exo:description", group.getDescription());
        groupNode.setProperty("exo:editPermissionUsers", group.getEditPermissionUsers());
        groupNode.setProperty("exo:viewPermissionUsers", group.getViewPermissionUsers());
        groupNode.setProperty("exo:editPermissionGroups", group.getEditPermissionGroups());
        groupNode.setProperty("exo:viewPermissionGroups", group.getViewPermissionGroups());
        if (isNew) {
            groupNode.getSession().save();
        } else {
            groupNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getSharedAddressBook(String userId) throws Exception {
        Node sharedHome;
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node contactHome = this.getUserContactServiceHome(provider, userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            Node ex = sharedHome.getNode(SHARED_ADDRESSBOOK);
            return ex;
        }
        catch (PathNotFoundException ex) {
            Node sharedAddress = sharedHome.addNode(SHARED_ADDRESSBOOK, NT_UNSTRUCTURED);
            if (sharedAddress.canAddMixin("mix:referenceable")) {
                sharedAddress.addMixin("mix:referenceable");
            }
            sharedHome.save();
            Node node = sharedAddress;
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getSharedContact(String userId) throws Exception {
        Node sharedHome;
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node contactHome = this.getUserContactServiceHome(provider, userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            Node ex = sharedHome.getNode(SHARED_CONTACT);
            return ex;
        }
        catch (PathNotFoundException ex) {
            Node sharedContact = sharedHome.addNode(SHARED_CONTACT, NT_UNSTRUCTURED);
            if (sharedContact.canAddMixin("mix:referenceable")) {
                sharedContact.addMixin("mix:referenceable");
            }
            sharedHome.save();
            Node node = sharedContact;
            return node;
        }
    }

    public void removeUserShareContact(SessionProvider sProvider, String username, String contactId, String removedUser) throws Exception {
        Node contactNode;
        String split = "/";
        if (username.split(split).length > 1) {
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            String temp = username.split(usersPath)[1];
            String userId = temp.split(split)[1];
            contactNode = this.getUserContactHome(sProvider, userId).getNode(contactId);
        } else {
            contactNode = this.getUserContactHome(sProvider, username).getNode(contactId);
        }
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.ValuesToStrings(contactNode.getProperty(SHARED_PROP).getValues())));
        ArrayList<String> newValues = new ArrayList<String>(values);
        Node sharedContact = this.getSharedContact(removedUser);
        for (String value : values) {
            Node refNode = sharedContact.getSession().getNodeByUUID(value);
            if (!refNode.getPath().equals(sharedContact.getPath())) continue;
            newValues.remove(value);
        }
        try {
            String[] viewPer = this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionUsers").getValues());
            if (viewPer != null) {
                ArrayList<String> newViewPer = new ArrayList<String>();
                newViewPer.addAll(Arrays.asList(viewPer));
                newViewPer.remove(removedUser + HYPHEN);
                contactNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
                String[] editPer = this.ValuesToStrings(contactNode.getProperty("exo:editPermissionUsers").getValues());
                if (editPer != null) {
                    ArrayList<String> newEditPer = new ArrayList<String>();
                    newEditPer.addAll(Arrays.asList(editPer));
                    newEditPer.remove(removedUser + HYPHEN);
                    contactNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
                }
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        contactNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
        contactNode.save();
        contactNode.getSession().save();
    }

    public void removeUserShareAddressBook(SessionProvider sProvider, String username, String addressBookId, String removedUser) throws Exception {
        Node addressBookNode = this.getUserContactGroupHome(sProvider, username).getNode(addressBookId);
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.ValuesToStrings(addressBookNode.getProperty(SHARED_PROP).getValues())));
        ArrayList<String> newValues = new ArrayList<String>(values);
        Node sharedAddress = this.getSharedAddressBook(removedUser);
        for (String value : values) {
            Node refNode = sharedAddress.getSession().getNodeByUUID(value);
            if (!refNode.getPath().equals(sharedAddress.getPath())) continue;
            newValues.remove(value);
        }
        String[] viewPer = null;
        try {
            viewPer = this.ValuesToStrings(addressBookNode.getProperty("exo:viewPermissionUsers").getValues());
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (viewPer != null) {
            ArrayList<String> newViewPer = new ArrayList<String>();
            newViewPer.addAll(Arrays.asList(viewPer));
            newViewPer.remove(removedUser + HYPHEN);
            addressBookNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
            String[] editPer = null;
            try {
                editPer = this.ValuesToStrings(addressBookNode.getProperty("exo:editPermissionUsers").getValues());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            if (editPer != null) {
                ArrayList<String> newEditPer = new ArrayList<String>();
                newEditPer.addAll(Arrays.asList(editPer));
                newEditPer.remove(removedUser + HYPHEN);
                addressBookNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
            }
        }
        addressBookNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
        addressBookNode.save();
        addressBookNode.getSession().save();
    }

    public void shareAddressBook(SessionProvider sProvider, String username, String addressBookId, List<String> receiveUsers) throws Exception {
        Node addressBookNode = this.getUserContactGroupHome(sProvider, username).getNode(addressBookId);
        Value[] values = new Value[]{};
        if (addressBookNode.isNodeType(SHARED_MIXIN)) {
            values = addressBookNode.getProperty(SHARED_PROP).getValues();
        } else {
            addressBookNode.addMixin(SHARED_MIXIN);
            addressBookNode.setProperty("exo:sharedUserId", username);
        }
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (String userId : receiveUsers) {
            Node sharedAddress = this.getSharedAddressBook(userId.replaceFirst(HYPHEN, ""));
            boolean isExist = false;
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = sharedAddress.getSession().getNodeByUUID(uuid);
                if (refNode.getPath().equals(sharedAddress.getPath())) {
                    isExist = true;
                    break;
                }
                valueList.add(value);
            }
            if (isExist) continue;
            Value value2add = addressBookNode.getSession().getValueFactory().createValue(sharedAddress);
            valueList.add(value2add);
        }
        if (valueList.size() > 0) {
            LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
            for (Value value : values) {
                newValue.put(value.getString(), value);
            }
            for (Value value : valueList) {
                newValue.put(value.getString(), value);
            }
            addressBookNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
        } else {
            try {
                addressBookNode.getProperty(SHARED_PROP);
            }
            catch (PathNotFoundException e) {
                addressBookNode.setProperty(SHARED_PROP, new Value[0]);
            }
        }
        addressBookNode.save();
        addressBookNode.getSession().save();
    }

    public void shareContact(SessionProvider sProvider, String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        for (String contactId : contactIds) {
            Node contactNode = this.getUserContactHome(sProvider, username).getNode(contactId);
            Value[] values = new Value[]{};
            if (contactNode.isNodeType(SHARED_MIXIN)) {
                values = contactNode.getProperty(SHARED_PROP).getValues();
            } else {
                contactNode.addMixin(SHARED_MIXIN);
                contactNode.setProperty("exo:sharedUserId", username);
            }
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (String user : receiveUsers) {
                Node sharedContact = this.getSharedContact(user.replaceFirst(HYPHEN, ""));
                boolean isExist = false;
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    String uuid = value.getString();
                    Node refNode = sharedContact.getSession().getNodeByUUID(uuid);
                    if (refNode.getPath().equals(sharedContact.getPath())) {
                        isExist = true;
                        break;
                    }
                    valueList.add(value);
                }
                if (isExist) continue;
                Value value2add = contactNode.getSession().getValueFactory().createValue(sharedContact);
                valueList.add(value2add);
            }
            if (valueList.size() <= 0) continue;
            LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
            for (Value value : values) {
                newValue.put(value.getString(), value);
            }
            for (Value value : valueList) {
                newValue.put(value.getString(), value);
            }
            contactNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
            contactNode.save();
            contactNode.getSession().save();
        }
    }

    public List<SharedAddressBook> getSharedAddressBooks(SessionProvider sProvider, String username) throws Exception {
        ArrayList<SharedAddressBook> addressBooks = new ArrayList<SharedAddressBook>();
        Node sharedAddress = this.getSharedAddressBook(username);
        PropertyIterator iter = sharedAddress.getReferences();
        while (iter.hasNext()) {
            try {
                Node addressNode = iter.nextProperty().getParent();
                SharedAddressBook sharedAddressBook = new SharedAddressBook(addressNode.getProperty("exo:name").getString(), addressNode.getName(), addressNode.getProperty("exo:sharedUserId").getString());
                if (addressNode.hasProperty("exo:editPermissionUsers")) {
                    sharedAddressBook.setEditPermissionUsers(this.ValuesToStrings(addressNode.getProperty("exo:editPermissionUsers").getValues()));
                }
                if (addressNode.hasProperty("exo:editPermissionGroups")) {
                    sharedAddressBook.setEditPermissionGroups(this.ValuesToStrings(addressNode.getProperty("exo:editPermissionGroups").getValues()));
                }
                addressBooks.add(sharedAddressBook);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return addressBooks;
    }

    public void removeSharedContact(SessionProvider sProvider, String username, String addressBookId, String contactId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        PropertyIterator iter2 = sharedAddressBookMock.getReferences();
        while (iter2.hasNext()) {
            Node addressBook = iter2.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                contactHomeNode.getNode(contactId).remove();
                contactHomeNode.getSession().save();
                break;
            }
            catch (PathNotFoundException e) {
            }
        }
    }

    public Contact getSharedContact(SessionProvider sProvider, String username, String contactId) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contactId)) continue;
                return this.getContact(contactNode, SHARED);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public DataPageList getSharedContacts(String username) throws Exception {
        ArrayList<Contact> sharedContacts = new ArrayList<Contact>();
        Node sharedContact = this.getSharedContact(username);
        PropertyIterator iter = sharedContact.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                sharedContacts.add(this.getContact(contactNode, SHARED));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DataPageList(sharedContacts, 10L, null, false);
    }

    public void saveSharedContact(String username, Contact contact) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        boolean isEdit = false;
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contact.getId())) continue;
                isEdit = true;
                this.saveContact(contactNode.getParent(), contact, false);
                contactNode.getParent().getSession().save();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isEdit) {
            throw new PathNotFoundException();
        }
    }

    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            contact.setOwner(false);
            this.saveContact(contactHomeNode, contact, isNew);
            contactHomeNode.getSession().save();
            return;
        }
    }

    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                return this.getContact(contactHomeNode.getNode(contactId), SHARED);
            }
            catch (PathNotFoundException e) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList getSharedContactsByAddressBook(SessionProvider sProvider, String username, SharedAddressBook addressBook) throws Exception {
        if (addressBook == null) {
            return null;
        }
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getUserContactHome(sysProvider, addressBook.getSharedUserId());
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBook.getId()).append("')]").append(" order by @exo:fullName,@exo:id ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            ContactPageList contactPageList = new ContactPageList(username, result.getNodes(), 10L, queryString.toString(), true, SHARED);
            return contactPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getPublicContact(String contactId) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node contactHomeNode = this.getUserContactHome(provider, contactId);
            Contact contact = this.getContact(contactHomeNode.getNode(contactId), PUBLIC);
            return contact;
        }
        catch (PathNotFoundException e) {
            Contact contact = null;
            return contact;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList getPublicContactsByAddressBook(SessionProvider sProvider, String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getPublicContactHome(sysProvider);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("' and @exo:isOwner='true'] ").append("order by @exo:fullName,@exo:id ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            ContactPageList contactPageList = new ContactPageList(null, result.getNodes(), 10L, queryString.toString(), true, PUBLIC);
            return contactPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    public List<GroupContactData> getPublicContacts(SessionProvider sysProvider, String[] groupIds) throws Exception {
        ArrayList<GroupContactData> contactByGroup = new ArrayList<GroupContactData>();
        for (String groupId : groupIds) {
            List<Contact> contacts = this.getPublicContactsByAddressBook(sysProvider, groupId).getAll();
            if (contacts.size() <= 0) continue;
            contactByGroup.add(new GroupContactData(groupId, contacts));
        }
        return contactByGroup;
    }

    public List<String> getPublicAddressBookContacts(SessionProvider sysProvider, String[] groupIds) throws Exception {
        ArrayList<String> groups = new ArrayList<String>();
        for (String groupId : groupIds) {
            if (!this.hasContacts(sysProvider, groupId)) continue;
            groups.add(groupId);
        }
        return groups;
    }

    private boolean hasContacts(SessionProvider sysProvider, String groupId) throws Exception {
        StringBuffer queryString;
        Node contactHome = this.getPublicContactHome(sysProvider);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']")).toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes().getSize() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupToPersonalContact(String userId, String groupId) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getUserContactHome(provider, userId);
            Node contactNode = contactHome.getNode(userId);
            Value[] values = contactNode.getProperty("exo:categories").getValues();
            ArrayList<String> ls = new ArrayList<String>();
            for (Value vl : values) {
                if (vl.getString().equals(groupId)) {
                    return;
                }
                ls.add(vl.getString());
            }
            ls.add(groupId);
            contactNode.setProperty("exo:categories", ls.toArray(new String[0]));
            contactNode.save();
        }
        finally {
            provider.close();
        }
    }

    private void reparePermissions(Node node, String owner) throws Exception {
    }

    private void saveContact(Node contactHomeNode, Contact contact, boolean isNew) throws Exception {
        ContactAttachment attachment;
        Node contactNode;
        if (isNew) {
            contactNode = contactHomeNode.addNode(contact.getId(), "exo:contact");
            contactNode.setProperty("exo:id", contact.getId());
            if (contact.isOwner()) {
                contactNode.setProperty("exo:isOwner", true);
                contactNode.setProperty("exo:ownerId", contact.getOwnerId());
                this.reparePermissions(contactHomeNode, contact.getOwnerId());
                this.reparePermissions(contactNode, contact.getOwnerId());
            }
        } else {
            contactNode = contactHomeNode.getNode(contact.getId());
        }
        contactNode.setProperty("exo:fullName", contact.getFullName());
        contactNode.setProperty("exo:firstName", contact.getFirstName());
        contactNode.setProperty("exo:lastName", contact.getLastName());
        contactNode.setProperty("exo:nickName", contact.getNickName());
        contactNode.setProperty("exo:gender", contact.getGender());
        GregorianCalendar dateTime = new GregorianCalendar();
        Date birthday = contact.getBirthday();
        if (birthday != null) {
            dateTime.setTime(birthday);
            contactNode.setProperty("exo:birthday", (Calendar)dateTime);
        }
        contactNode.setProperty("exo:jobTitle", contact.getJobTitle());
        contactNode.setProperty("exo:emailAddress", contact.getEmailAddress());
        contactNode.setProperty("exo:exoId", contact.getExoId());
        contactNode.setProperty("exo:googleId", contact.getGoogleId());
        contactNode.setProperty("exo:msnId", contact.getMsnId());
        contactNode.setProperty("exo:aolId", contact.getAolId());
        contactNode.setProperty("exo:yahooId", contact.getYahooId());
        contactNode.setProperty("exo:icrId", contact.getIcrId());
        contactNode.setProperty("exo:skypeId", contact.getSkypeId());
        contactNode.setProperty("exo:icqId", contact.getIcqId());
        contactNode.setProperty("exo:homeAddress", contact.getHomeAddress());
        contactNode.setProperty("exo:homeCity", contact.getHomeCity());
        contactNode.setProperty("exo:homeState_province", contact.getHomeState_province());
        contactNode.setProperty("exo:homePostalCode", contact.getHomePostalCode());
        contactNode.setProperty("exo:homeCountry", contact.getHomeCountry());
        contactNode.setProperty("exo:homePhone1", contact.getHomePhone1());
        contactNode.setProperty("exo:homePhone2", contact.getHomePhone2());
        contactNode.setProperty("exo:homeFax", contact.getHomeFax());
        contactNode.setProperty("exo:personalSite", contact.getPersonalSite());
        contactNode.setProperty("exo:workAddress", contact.getWorkAddress());
        contactNode.setProperty("exo:workCity", contact.getWorkCity());
        contactNode.setProperty("exo:workState_province", contact.getWorkStateProvince());
        contactNode.setProperty("exo:workPostalCode", contact.getWorkPostalCode());
        contactNode.setProperty("exo:workCountry", contact.getWorkCountry());
        contactNode.setProperty("exo:workPhone1", contact.getWorkPhone1());
        contactNode.setProperty("exo:workPhone2", contact.getWorkPhone2());
        contactNode.setProperty("exo:workFax", contact.getWorkFax());
        contactNode.setProperty("exo:mobilePhone", contact.getMobilePhone());
        contactNode.setProperty("exo:webPage", contact.getWebPage());
        contactNode.setProperty("exo:note", contact.getNote());
        contactNode.setProperty("exo:categories", contact.getAddressBook());
        contactNode.setProperty("exo:tags", contact.getTags());
        contactNode.setProperty("exo:editPermissionUsers", contact.getEditPermissionUsers());
        contactNode.setProperty("exo:viewPermissionUsers", contact.getViewPermissionUsers());
        contactNode.setProperty("exo:editPermissionGroups", contact.getEditPermissionGroups());
        contactNode.setProperty("exo:viewPermissionGroups", contact.getViewPermissionGroups());
        if (contact.getLastUpdated() != null) {
            dateTime.setTime(contact.getLastUpdated());
            contactNode.setProperty("exo:lastUpdated", (Calendar)dateTime);
        }
        if ((attachment = contact.getAttachment()) != null) {
            ExtendedNode extNode = (ExtendedNode)contactNode;
            if (extNode.canAddMixin("exo:privilegeable")) {
                extNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
            extNode.setPermission(SystemIdentity.ANY, arrayPers);
            List permsList = extNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
            }
            if (attachment.getFileName() != null) {
                Node nodeFile = null;
                try {
                    nodeFile = contactNode.getNode("image");
                }
                catch (PathNotFoundException ex) {
                    nodeFile = contactNode.addNode("image", "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                nodeContent.setProperty("jcr:data", attachment.getInputStream());
                nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            }
        } else if (contactNode.hasNode("image")) {
            contactNode.getNode("image").remove();
        }
    }

    private Tag getTag(Node tagNode) throws Exception {
        Tag tag = new Tag();
        if (tagNode.hasProperty("exo:id")) {
            tag.setId(tagNode.getProperty("exo:id").getString());
        }
        if (tagNode.hasProperty("exo:name")) {
            tag.setName(tagNode.getProperty("exo:name").getString());
        }
        if (tagNode.hasProperty("exo:description")) {
            tag.setDescription(tagNode.getProperty("exo:description").getString());
        }
        if (tagNode.hasProperty("exo:color")) {
            tag.setColor(tagNode.getProperty("exo:color").getString());
        }
        return tag;
    }

    public void updateTag(SessionProvider sProvider, String username, Tag tag) throws Exception {
        Node tagHome = this.getTagHome(sProvider, username);
        Node tagNode = tagHome.getNode(tag.getId());
        tagNode.setProperty("exo:name", tag.getName());
        tagNode.setProperty("exo:description", tag.getDescription());
        tagNode.setProperty("exo:color", tag.getColor());
        tagHome.save();
    }

    public Tag getTag(SessionProvider sProvider, String username, String tagId) throws Exception {
        Node tagHomeNode = this.getTagHome(sProvider, username);
        if (tagHomeNode.hasNode(tagId)) {
            return this.getTag(tagHomeNode.getNode(tagId));
        }
        return null;
    }

    public List<Tag> getTags(SessionProvider sProvider, String username) throws Exception {
        Node tagHomeNode = this.getTagHome(sProvider, username);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        NodeIterator iter = tagHomeNode.getNodes();
        while (iter.hasNext()) {
            Node tagNode = iter.nextNode();
            tags.add(this.getTag(tagNode));
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPageList getContactPageListByTag(SessionProvider provider, String username, String tagId) throws Exception {
        Node contactHome = this.getUserContactHome(provider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
        while (it.hasNext()) {
            Contact contact = this.getContact(it.nextNode(), PRIVATE);
            contacts.put(contact.getId(), contact);
        }
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            PropertyIterator iter;
            Node publicContactHome = this.getPublicContactHome(sysProvider);
            qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            it = result.getNodes();
            while (it.hasNext()) {
                Contact contact = this.getContact(it.nextNode(), PUBLIC);
                if (contact.getId().equals(username)) {
                    contact.setContactType(PRIVATE);
                }
                contacts.put(contact.getId(), contact);
            }
            try {
                Node sharedContact = this.getSharedContact(username);
                iter = sharedContact.getReferences();
                while (iter.hasNext()) {
                    try {
                        Node contactNode = iter.nextProperty().getParent();
                        if (!contactNode.hasProperty("exo:tags") || !Arrays.asList(this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues())).contains(tagId)) continue;
                        Contact contact = this.getContact(contactNode, SHARED);
                        contacts.put(contact.getId(), contact);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            Node sharedAddressBookMock = this.getSharedAddressBook(username);
            iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                it = result.getNodes();
                while (it.hasNext()) {
                    Contact contact = this.getContact(it.nextNode(), SHARED);
                    if (!Arrays.asList(contact.getAddressBook()).contains(addressBook.getProperty("exo:id").getString())) continue;
                    contacts.put(contact.getId(), contact);
                }
            }
            DataPageList dataPageList = new DataPageList(Arrays.asList(contacts.values().toArray(new Contact[0])), 10L, null, false);
            return dataPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(SessionProvider provider, String username, List<String> contactIds, String tagId) throws Exception {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put(tagId, tagId);
        SessionProvider sysProvider = null;
        try {
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PRIVATE)) {
                    contactNode = this.getUserContactHome(provider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    sysProvider = SessionProvider.createSystemProvider();
                    contactNode = this.getUserContactHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBook(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty("exo:categories").getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    throw new PathNotFoundException();
                }
                HashMap<String, String> thisTagMap = new HashMap<String, String>();
                thisTagMap = tagMap;
                Value[] values = null;
                if (contactNode.hasProperty("exo:tags")) {
                    for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                        thisTagMap.put(value.getString(), value.getString());
                    }
                }
                contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(SessionProvider provider, String username, List<String> contactIds, List<Tag> tags) throws Exception {
        Node tagHomeNode = this.getTagHome(provider, username);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        String newTag = null;
        SessionProvider sysProvider = null;
        try {
            for (Tag tag : tags) {
                if (!tagHomeNode.hasNode(tag.getId())) {
                    newTag = tag.getId();
                    Node tagNode = tagHomeNode.addNode(tag.getId(), "exo:contactTag");
                    tagNode.setProperty("exo:id", tag.getId());
                    tagNode.setProperty("exo:name", tag.getName());
                    tagNode.setProperty("exo:description", tag.getDescription());
                    tagNode.setProperty("exo:color", tag.getColor());
                    tagHomeNode.getSession().save();
                }
                tagMap.put(tag.getId(), tag.getId());
            }
            if (contactIds == null || contactIds.size() == 0) {
                return;
            }
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PRIVATE)) {
                    contactNode = this.getUserContactHome(provider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    sysProvider = SessionProvider.createSystemProvider();
                    contactNode = this.getUserContactHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBook(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty("exo:categories").getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    if (contactIds.get(0).equals(contact) && newTag != null) {
                        tagHomeNode.getNode(newTag).remove();
                        tagHomeNode.getSession().save();
                    }
                    throw new PathNotFoundException();
                }
                HashMap<String, String> thisTagMap = new HashMap<String, String>();
                thisTagMap.putAll(tagMap);
                Value[] values = null;
                if (contactNode.hasProperty("exo:tags")) {
                    for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                        thisTagMap.put(value.getString(), value.getString());
                    }
                }
                contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    private void removeTagInContacts(NodeIterator it, String tagId) throws Exception {
        while (it.hasNext()) {
            Node contactNode = it.nextNode();
            if (!contactNode.hasProperty("exo:tags")) continue;
            String[] tagIds = this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues());
            ArrayList<String> newTagIds = new ArrayList<String>();
            for (String id : tagIds) {
                if (id.equals(tagId)) continue;
                newTagIds.add(id);
            }
            contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
            contactNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag removeTag(SessionProvider provider, String username, String tagId) throws Exception {
        PropertyIterator iter;
        Node tagHomeNode = this.getTagHome(provider, username);
        Node tagNode = tagHomeNode.getNode(tagId);
        Tag tag = this.getTag(tagNode);
        tagNode.remove();
        tagHomeNode.save();
        Node contactHome = this.getUserContactHome(provider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        this.removeTagInContacts(query.execute().getNodes(), tagId);
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        Node publicContactHome = this.getPublicContactHome(sysProvider);
        qm = publicContactHome.getSession().getWorkspace().getQueryManager();
        queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
        query = qm.createQuery(queryString.toString(), "xpath");
        this.removeTagInContacts(query.execute().getNodes(), tagId);
        try {
            Node sharedContact = this.getSharedContact(username);
            iter = sharedContact.getReferences();
            while (iter.hasNext()) {
                try {
                    Node contactNode = iter.nextProperty().getParent();
                    if (!contactNode.hasProperty("exo:tags")) continue;
                    String[] tagIds = this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues());
                    ArrayList<String> newTagIds = new ArrayList<String>();
                    for (String id : tagIds) {
                        if (id.equals(tagId)) continue;
                        newTagIds.add(id);
                    }
                    contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
                    contactNode.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        Node sharedAddressBookMock = this.getSharedAddressBook(username);
        iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
            query = qm.createQuery(queryString.toString(), "xpath");
            this.removeTagInContacts(query.execute().getNodes(), tagId);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactTag(SessionProvider provider, String username, List<String> contactIds, List<String> tags) throws Exception {
        SessionProvider sysProvider = null;
        try {
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PRIVATE)) {
                    contactNode = this.getUserContactHome(provider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    sysProvider = SessionProvider.createSystemProvider();
                    contactNode = this.getUserContactHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBook(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty("exo:categories").getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    throw new PathNotFoundException();
                }
                if (!contactNode.hasProperty("exo:tags")) continue;
                Value[] values = contactNode.getProperty("exo:tags").getValues();
                ArrayList<String> tagList = new ArrayList<String>();
                for (Value value : values) {
                    tagList.add(value.getString());
                }
                for (String tag : tags) {
                    if (!tagList.contains(tag)) continue;
                    tagList.remove(tag);
                }
                contactNode.setProperty("exo:tags", tagList.toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPageList searchContact(SessionProvider provider, String username, ContactFilter filter) throws Exception {
        LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
        filter.setUsername(username);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Contact contact;
            QueryManager qm = null;
            Query query = null;
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            if (filter.getType() == null || filter.getType().equals(PUBLIC)) {
                Node publicContactHome = this.getPublicContactHome(sysProvider);
                usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                filter.setAccountPath(usersPath);
                filter.setOwner("true");
                qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator itpublic = query.execute().getNodes();
                while (itpublic.hasNext()) {
                    contact = this.getContact(itpublic.nextNode(), PUBLIC);
                    contacts.put(contact.getId(), contact);
                }
            }
            filter.setOwner(null);
            if ((filter.getType() == null || filter.getType().equals(PRIVATE)) && username != null && username.length() > 0) {
                Node contactHome = this.getUserContactHome(provider, username);
                filter.setAccountPath(contactHome.getPath());
                qm = contactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator it = query.execute().getNodes();
                while (it.hasNext()) {
                    contact = this.getContact(it.nextNode(), PRIVATE);
                    contacts.put(contact.getId(), contact);
                }
            }
            if (filter.getType() == null || filter.getType().equals(SHARED)) {
                PropertyIterator iter;
                try {
                    Node sharedContact = this.getSharedContact(username);
                    iter = sharedContact.getReferences();
                    List<Contact> sharedContacts = this.getSharedContacts(username).getAll();
                    ArrayList<String> sharedContactIds = new ArrayList<String>();
                    for (Contact contact2 : sharedContacts) {
                        sharedContactIds.add(contact2.getId());
                    }
                    while (iter.hasNext()) {
                        try {
                            Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                            filter.setAccountPath(sharedContactHomeNode.getPath());
                            String split = "/";
                            String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                            String userId = temp.split(split)[1];
                            filter.setUsername(userId);
                            qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                            query = qm.createQuery(filter.getStatement(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            while (it.hasNext()) {
                                Node contactNode = it.nextNode();
                                if (!sharedContactIds.contains(contactNode.getProperty("exo:id").getString())) continue;
                                Contact contact3 = this.getContact(contactNode, SHARED);
                                if (!contacts.containsKey(contact3.getId())) {
                                    contacts.put(contact3.getId(), contact3);
                                } else {
                                    ((Contact)contacts.get(contact3.getId())).setContactType(SHARED);
                                }
                                sharedContactIds.remove(contact3.getId());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                Node sharedAddressBookMock = this.getSharedAddressBook(username);
                iter = sharedAddressBookMock.getReferences();
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contactHomeNode.getPath());
                    filter.setCategories(new String[]{addressBook.getName()});
                    filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                    qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Contact contact2;
                        contact2 = this.getContact(it.nextNode(), SHARED);
                        contacts.put(contact2.getId(), contact2);
                    }
                }
            }
            ArrayList<Contact> contactList = new ArrayList<Contact>();
            contactList.addAll(contacts.values());
            DataPageList dataPageList = new DataPageList(contactList, 10L, null, false);
            return dataPageList;
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> searchEmails(SessionProvider provider, String username, ContactFilter filter) throws Exception {
        LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
        filter.setUsername(username);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            boolean hasGroup;
            PropertyIterator iter;
            Node publicContactHome = this.getPublicContactHome(sysProvider);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            filter.setAccountPath(usersPath);
            filter.setOwner("true");
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator itpublic = query.execute().getNodes();
            while (itpublic.hasNext()) {
                Node contactNode = itpublic.nextNode();
                if (!contactNode.hasProperty("exo:emailAddress")) continue;
                emails.put(contactNode.getProperty("exo:id").getString(), contactNode.getProperty("exo:fullName").getString() + Utils.SPLIT + contactNode.getProperty("exo:emailAddress").getString());
            }
            filter.setOwner(null);
            if (username != null && username.length() > 0) {
                Node contactHome = this.getUserContactHome(provider, username);
                filter.setAccountPath(contactHome.getPath());
                qm = contactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator it = query.execute().getNodes();
                while (it.hasNext()) {
                    Node contactNode = it.nextNode();
                    if (!contactNode.hasProperty("exo:emailAddress")) continue;
                    emails.put(contactNode.getProperty("exo:id").getString(), contactNode.getProperty("exo:fullName").getString() + Utils.SPLIT + contactNode.getProperty("exo:emailAddress").getString());
                }
            }
            try {
                Node sharedContact = this.getSharedContact(username);
                iter = sharedContact.getReferences();
                while (iter.hasNext()) {
                    try {
                        Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                        filter.setAccountPath(sharedContactHomeNode.getPath());
                        String split = "/";
                        String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                        String userId = temp.split(split)[1];
                        filter.setUsername(userId);
                        qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                        query = qm.createQuery(filter.getStatement(), "xpath");
                        NodeIterator it = query.execute().getNodes();
                        while (it.hasNext()) {
                            Node contactNode = it.nextNode();
                            if (!contactNode.hasProperty("exo:emailAddress")) continue;
                            emails.put(contactNode.getProperty("exo:id").getString(), contactNode.getProperty("exo:fullName").getString() + Utils.SPLIT + contactNode.getProperty("exo:emailAddress").getString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            Node sharedAddressBookMock = this.getSharedAddressBook(username);
            iter = sharedAddressBookMock.getReferences();
            boolean bl = hasGroup = filter.getCategories() != null && filter.getCategories().length > 0;
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                filter.setAccountPath(contactHomeNode.getPath());
                if (!hasGroup) {
                    filter.setCategories(new String[]{addressBook.getName()});
                }
                filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator it = query.execute().getNodes();
                while (it.hasNext()) {
                    Node contactNode = it.nextNode();
                    if (!contactNode.hasProperty("exo:emailAddress")) continue;
                    emails.put(contactNode.getProperty("exo:id").getString(), contactNode.getProperty("exo:fullName").getString() + Utils.SPLIT + contactNode.getProperty("exo:emailAddress").getString());
                }
            }
            LinkedHashMap<String, String> linkedHashMap = emails;
            return linkedHashMap;
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNodes(SessionProvider sProvider, String username, Node srcHomeNode, NodeIterator iter, String destAddress, String destType) throws Exception {
        block13: {
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            try {
                if (destType.equals(PRIVATE)) {
                    Node contactHomeNode = this.getUserContactHome(sProvider, username);
                    while (iter.hasNext()) {
                        ExtendedNode extNode;
                        Node oldNode = iter.nextNode();
                        String newId = "Contact" + IdGenerator.generate();
                        try {
                            contactHomeNode.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                        }
                        catch (AccessDeniedException ex) {
                            Node userContactHome = this.getUserContactHome(sysProvider, oldNode.getProperty("exo:id").getString());
                            userContactHome.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                        }
                        try {
                            extNode = (ExtendedNode)contactHomeNode.getNode(newId);
                        }
                        catch (Exception e) {
                            extNode = (ExtendedNode)this.getUserContactHome(sysProvider, username).getNode(newId);
                        }
                        if (extNode.canAddMixin("exo:privilegeable")) {
                            extNode.addMixin("exo:privilegeable");
                        }
                        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                        extNode.setPermission(username, arrayPers);
                        extNode.save();
                        Node newNode = contactHomeNode.getNode(newId);
                        newNode.setProperty("exo:categories", new String[]{destAddress});
                        newNode.setProperty("exo:id", newId);
                        newNode.setProperty("exo:isOwner", false);
                        newNode.setProperty("exo:editPermissionUsers", new String[0]);
                        newNode.setProperty("exo:viewPermissionUsers", new String[0]);
                        newNode.setProperty("exo:editPermissionGroups", new String[0]);
                        newNode.setProperty("exo:viewPermissionGroups", new String[0]);
                    }
                    contactHomeNode.getSession().save();
                    break block13;
                }
                if (!destType.equals(SHARED)) break block13;
                Node sharedAddressBookMock = this.getSharedAddressBook(username);
                PropertyIterator proIter = sharedAddressBookMock.getReferences();
                while (proIter.hasNext()) {
                    Node addressBook = proIter.nextProperty().getParent();
                    if (!addressBook.getName().equals(destAddress)) continue;
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    while (iter.hasNext()) {
                        String newId = "Contact" + IdGenerator.generate();
                        Node oldNode = iter.nextNode();
                        contactHomeNode.getSession().getWorkspace().copy(srcHomeNode.getPath() + "/" + oldNode.getProperty("exo:id").getString(), contactHomeNode.getPath() + "/" + newId);
                        Node newNode = contactHomeNode.getNode(newId);
                        newNode.setProperty("exo:categories", new String[]{destAddress});
                        newNode.setProperty("exo:id", newId);
                        newNode.setProperty("exo:isOwner", false);
                        newNode.setProperty("exo:editPermissionUsers", new String[0]);
                        newNode.setProperty("exo:viewPermissionUsers", new String[0]);
                        newNode.setProperty("exo:editPermissionGroups", new String[0]);
                        newNode.setProperty("exo:viewPermissionGroups", new String[0]);
                    }
                    contactHomeNode.getSession().save();
                    break;
                }
            }
            finally {
                if (sysProvider != null) {
                    sysProvider.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteAddressBook(SessionProvider sProvider, String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        if (srcType.equals(PRIVATE)) {
            Node contactHome = this.getUserContactHome(sProvider, username);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            this.copyNodes(sProvider, username, contactHome, iter, destAddress, destType);
        } else if (srcType.equals(SHARED)) {
            Node sharedAddressBookMock = this.getSharedAddressBook(username);
            PropertyIterator proIter = sharedAddressBookMock.getReferences();
            while (proIter.hasNext()) {
                Node addressBook = proIter.nextProperty().getParent();
                if (!addressBook.getName().equals(srcAddress)) continue;
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                QueryManager qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                this.copyNodes(sProvider, username, contactHomeNode, iter, destAddress, destType);
                break;
            }
        } else {
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            try {
                Node publicContactHome = this.getPublicContactHome(sysProvider);
                QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                this.copyNodes(sProvider, username, publicContactHome, iter, destAddress, destType);
            }
            finally {
                sysProvider.close();
            }
        }
    }

    public void pasteContacts(SessionProvider sProvider, String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (String contactId : contactsMap.keySet()) {
            String type = contactsMap.get(contactId);
            Contact contact = null;
            if (type.equals(PRIVATE)) {
                contact = this.getContact(sProvider, username, contactId);
            } else if (type.equals(PUBLIC)) {
                contact = this.getPublicContact(contactId);
            } else {
                contact = this.getSharedContact(sProvider, username, contactId);
                if (contact == null) {
                    contact = this.getSharedContactAddressBook(username, contactId);
                }
            }
            if (contact == null) continue;
            contacts.add(contact);
        }
        block1: for (Contact contact : contacts) {
            if (destType.equals(PRIVATE)) {
                Node contactHomeNode = this.getUserContactHome(sProvider, username);
                this.saveCopyContact(contactHomeNode, contact, destAddress, destType);
                continue;
            }
            if (!destType.equals(SHARED)) continue;
            Node sharedAddressBookMock = this.getSharedAddressBook(username);
            PropertyIterator iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                if (!addressBook.getName().equals(destAddress)) continue;
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                this.saveCopyContact(contactHomeNode, contact, destAddress, destType);
                continue block1;
            }
        }
    }

    private void saveCopyContact(Node contactHomeNode, Contact contact, String destAddress, String destType) throws Exception {
        ContactAttachment attachment;
        String newId = "Contact" + IdGenerator.generate();
        Node contactNode = contactHomeNode.addNode(newId, "exo:contact");
        contactNode.setProperty("exo:id", newId);
        contactNode.setProperty("exo:fullName", contact.getFullName());
        contactNode.setProperty("exo:firstName", contact.getFirstName());
        contactNode.setProperty("exo:lastName", contact.getLastName());
        contactNode.setProperty("exo:nickName", contact.getNickName());
        contactNode.setProperty("exo:gender", contact.getGender());
        GregorianCalendar dateTime = new GregorianCalendar();
        Date birthday = contact.getBirthday();
        if (birthday != null) {
            dateTime.setTime(birthday);
            contactNode.setProperty("exo:birthday", (Calendar)dateTime);
        }
        contactNode.setProperty("exo:jobTitle", contact.getJobTitle());
        contactNode.setProperty("exo:emailAddress", contact.getEmailAddress());
        contactNode.setProperty("exo:exoId", contact.getExoId());
        contactNode.setProperty("exo:googleId", contact.getGoogleId());
        contactNode.setProperty("exo:msnId", contact.getMsnId());
        contactNode.setProperty("exo:aolId", contact.getAolId());
        contactNode.setProperty("exo:yahooId", contact.getYahooId());
        contactNode.setProperty("exo:icrId", contact.getIcrId());
        contactNode.setProperty("exo:skypeId", contact.getSkypeId());
        contactNode.setProperty("exo:icqId", contact.getIcqId());
        contactNode.setProperty("exo:homeAddress", contact.getHomeAddress());
        contactNode.setProperty("exo:homeCity", contact.getHomeCity());
        contactNode.setProperty("exo:homeState_province", contact.getHomeState_province());
        contactNode.setProperty("exo:homePostalCode", contact.getHomePostalCode());
        contactNode.setProperty("exo:homeCountry", contact.getHomeCountry());
        contactNode.setProperty("exo:homePhone1", contact.getHomePhone1());
        contactNode.setProperty("exo:homePhone2", contact.getHomePhone2());
        contactNode.setProperty("exo:homeFax", contact.getHomeFax());
        contactNode.setProperty("exo:personalSite", contact.getPersonalSite());
        contactNode.setProperty("exo:workAddress", contact.getWorkAddress());
        contactNode.setProperty("exo:workCity", contact.getWorkCity());
        contactNode.setProperty("exo:workState_province", contact.getWorkStateProvince());
        contactNode.setProperty("exo:workPostalCode", contact.getWorkPostalCode());
        contactNode.setProperty("exo:workCountry", contact.getWorkCountry());
        contactNode.setProperty("exo:workPhone1", contact.getWorkPhone1());
        contactNode.setProperty("exo:workPhone2", contact.getWorkPhone2());
        contactNode.setProperty("exo:workFax", contact.getWorkFax());
        contactNode.setProperty("exo:mobilePhone", contact.getMobilePhone());
        contactNode.setProperty("exo:webPage", contact.getWebPage());
        contactNode.setProperty("exo:note", contact.getNote());
        contactNode.setProperty("exo:tags", contact.getTags());
        contactNode.setProperty("exo:categories", new String[]{destAddress});
        if (contact.getLastUpdated() != null) {
            dateTime.setTime(contact.getLastUpdated());
            contactNode.setProperty("exo:lastUpdated", (Calendar)dateTime);
        }
        if ((attachment = contact.getAttachment()) != null) {
            if (attachment.getFileName() != null) {
                ExtendedNode extNode = (ExtendedNode)contactNode;
                if (extNode.canAddMixin("exo:privilegeable")) {
                    extNode.addMixin("exo:privilegeable");
                }
                String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                extNode.setPermission(SystemIdentity.ANY, arrayPers);
                List permsList = extNode.getACL().getPermissionEntries();
                for (AccessControlEntry accessControlEntry : permsList) {
                    extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                }
                Node nodeFile = null;
                try {
                    nodeFile = contactNode.getNode("image");
                }
                catch (PathNotFoundException ex) {
                    nodeFile = contactNode.addNode("image", "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                nodeContent.setProperty("jcr:data", attachment.getInputStream());
                nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            }
        } else if (contactNode.hasNode("image")) {
            contactNode.getNode("image").remove();
        }
        contactHomeNode.getSession().save();
    }
}

