/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactImportExport;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.GroupContactData;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.contact.service.impl.VCardImportExport;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactServiceImpl
implements ContactService {
    private static final String VCARD = "x-vcard".intern();
    private JCRDataStorage storage_;
    private Map<String, ContactImportExport> contactImportExport_ = new HashMap<String, ContactImportExport>();

    public ContactServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
        this.contactImportExport_.put(VCARD, new VCardImportExport(this.storage_));
    }

    @Override
    public List<Contact> getAllContact(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getAllContact(sProvider, username);
    }

    @Override
    public Contact getPersonalContact(String userId) throws Exception {
        return this.storage_.getPersonalContact(userId);
    }

    @Override
    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.storage_.getContactPageListByGroup(sProvider, username, groupId);
    }

    @Override
    public ContactPageList getContactPageListByGroup(SessionProvider sProvider, String username, ContactFilter filter, String type) throws Exception {
        return this.storage_.getContactPageListByGroup(sProvider, username, filter, type);
    }

    @Override
    public Map<String, String> searchEmails(SessionProvider sysProvider, String username, ContactFilter filter) throws Exception {
        return this.storage_.searchEmails(sysProvider, username, filter);
    }

    @Override
    public List<String> getAllEmailAddressByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.storage_.getAllEmailAddressByGroup(sProvider, username, groupId);
    }

    @Override
    public Contact getContact(SessionProvider sProvider, String username, String contactId) throws Exception {
        return this.storage_.getContact(sProvider, username, contactId);
    }

    @Override
    public void saveContact(SessionProvider sProvider, String username, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContact(sProvider, username, contact, isNew);
    }

    @Override
    public List<Contact> removeContacts(SessionProvider sProvider, String username, List<String> contactIds) throws Exception {
        return this.storage_.removeContacts(sProvider, username, contactIds);
    }

    @Override
    public void moveContacts(SessionProvider sysProvider, String username, List<Contact> contacts, String addressType) throws Exception {
        this.storage_.moveContacts(sysProvider, username, contacts, addressType);
    }

    @Override
    public void addGroupToPersonalContact(String userId, String groupId) throws Exception {
        this.storage_.addGroupToPersonalContact(userId, groupId);
    }

    @Override
    public List<ContactGroup> getGroups(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getGroups(sProvider, username);
    }

    @Override
    public ContactGroup getGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.storage_.getGroup(sProvider, username, groupId);
    }

    @Override
    public void saveGroup(SessionProvider sProvider, String username, ContactGroup group, boolean isNew) throws Exception {
        this.storage_.saveGroup(sProvider, username, group, isNew);
    }

    @Override
    public ContactGroup removeGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        return this.storage_.removeGroup(sProvider, username, groupId);
    }

    @Override
    public void removeUserShareContact(SessionProvider sProvider, String username, String contactId, String removedUser) throws Exception {
        this.storage_.removeUserShareContact(sProvider, username, contactId, removedUser);
    }

    @Override
    public void shareContact(SessionProvider sProvider, String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        this.storage_.shareContact(sProvider, username, contactIds, receiveUsers);
    }

    @Override
    public DataPageList getSharedContacts(String username) throws Exception {
        return this.storage_.getSharedContacts(username);
    }

    @Override
    public void shareAddressBook(SessionProvider sProvider, String username, String addressBookId, List<String> receiverUsers) throws Exception {
        this.storage_.shareAddressBook(sProvider, username, addressBookId, receiverUsers);
    }

    @Override
    public void removeUserShareAddressBook(SessionProvider sProvider, String username, String addressBookId, String removedUser) throws Exception {
        this.storage_.removeUserShareAddressBook(sProvider, username, addressBookId, removedUser);
    }

    @Override
    public List<SharedAddressBook> getSharedAddressBooks(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getSharedAddressBooks(sProvider, username);
    }

    @Override
    public ContactPageList getSharedContactsByAddressBook(SessionProvider sProvider, String username, SharedAddressBook addressBook) throws Exception {
        return this.storage_.getSharedContactsByAddressBook(sProvider, username, addressBook);
    }

    @Override
    public void removeSharedContact(SessionProvider sProvider, String username, String addressBookId, String contactId) throws Exception {
        this.storage_.removeSharedContact(sProvider, username, addressBookId, contactId);
    }

    @Override
    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        this.storage_.saveContactToSharedAddressBook(username, addressBookId, contact, isNew);
    }

    @Override
    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        return this.storage_.getSharedContactAddressBook(username, contactId);
    }

    @Override
    public void saveSharedContact(String username, Contact contact) throws Exception {
        this.storage_.saveSharedContact(username, contact);
    }

    @Override
    public Contact getSharedContact(SessionProvider sProvider, String username, String contactId) throws Exception {
        return this.storage_.getSharedContact(sProvider, username, contactId);
    }

    @Override
    public Contact getPublicContact(String contactId) throws Exception {
        return this.storage_.getPublicContact(contactId);
    }

    @Override
    public List<GroupContactData> getPublicContacts(SessionProvider sProvider, String[] groupIds) throws Exception {
        return this.storage_.getPublicContacts(sProvider, groupIds);
    }

    @Override
    public List<String> getPublicAddressBookContacts(SessionProvider sProvider, String[] groupIds) throws Exception {
        return this.storage_.getPublicAddressBookContacts(sProvider, groupIds);
    }

    @Override
    public Tag getTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.storage_.getTag(sProvider, username, tagName);
    }

    @Override
    public List<Tag> getTags(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getTags(sProvider, username);
    }

    @Override
    public DataPageList getContactPageListByTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.storage_.getContactPageListByTag(sProvider, username, tagName);
    }

    @Override
    public void addTag(SessionProvider sProvider, String username, List<String> contactIds, List<Tag> tags) throws Exception {
        this.storage_.addTag(sProvider, username, contactIds, tags);
    }

    @Override
    public void addTag(SessionProvider sProvider, String username, List<String> contactIds, String tagId) throws Exception {
        this.storage_.addTag(sProvider, username, contactIds, tagId);
    }

    @Override
    public Tag removeTag(SessionProvider sProvider, String username, String tagName) throws Exception {
        return this.storage_.removeTag(sProvider, username, tagName);
    }

    @Override
    public void updateTag(SessionProvider sProvider, String username, Tag tag) throws Exception {
        this.storage_.updateTag(sProvider, username, tag);
    }

    @Override
    public void removeContactTag(SessionProvider sProvider, String username, List<String> contactIds, List<String> tags) throws Exception {
        this.storage_.removeContactTag(sProvider, username, contactIds, tags);
    }

    @Override
    public ContactPageList getPublicContactsByAddressBook(SessionProvider sProvider, String groupId) throws Exception {
        return this.storage_.getPublicContactsByAddressBook(sProvider, groupId);
    }

    @Override
    public void pasteAddressBook(SessionProvider sProvider, String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        this.storage_.pasteAddressBook(sProvider, username, srcAddress, srcType, destAddress, destType);
    }

    @Override
    public List<Contact> pasteContacts(SessionProvider sProvider, String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        return this.storage_.pasteContacts(sProvider, username, destAddress, destType, contactsMap);
    }

    @Override
    public ContactImportExport getContactImportExports(String type) {
        return this.contactImportExport_.get(type);
    }

    @Override
    public String[] getImportExportType() throws Exception {
        return this.contactImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public DataPageList searchContact(SessionProvider sProvider, String username, ContactFilter filter) throws Exception {
        return this.storage_.searchContact(sProvider, username, filter);
    }

    @Override
    public ContactGroup getSharedGroup(String username, String groupId) throws Exception {
        return this.storage_.getSharedGroup(username, groupId);
    }

    @Override
    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        return this.storage_.getAllEmailBySharedGroup(username, addressBookId);
    }

    @Override
    public List<String> getAllEmailByPublicGroup(String username, String groupId) throws Exception {
        return this.storage_.getAllEmailByPublicGroup(username, groupId);
    }
}

