/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class NewMembershipListener
extends MembershipEventListener {
    private ContactService cservice_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public NewMembershipListener(ContactService cservice, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.cservice_ = cservice;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        this.cservice_.addGroupToPersonalContact(m.getUserName(), m.getGroupId());
        JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_);
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            Node publicContactHome = storage_.getPublicContactHome(systemSession);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(JCRDataStorage.USERS_PATH);
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            ArrayList<String> recievedUser = new ArrayList<String>();
            recievedUser.add(m.getUserName());
            Contact contact = this.cservice_.getPublicContact(m.getUserName());
            LinkedHashMap<String, String> groups = new LinkedHashMap<String, String>();
            for (String group : contact.getAddressBook()) {
                groups.put(group, group);
            }
            groups.put(m.getGroupId(), m.getGroupId());
            contact.setAddressBook(groups.keySet().toArray(new String[0]));
            this.cservice_.saveContact(systemSession, m.getUserName(), contact, false);
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node address = nodes.nextNode();
                storage_.shareAddressBook(systemSession, address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), recievedUser);
            }
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node contactNode = nodes.nextNode();
                String split = "/";
                String temp = contactNode.getPath().split(usersPath)[1];
                String userId = temp.split(split)[1];
                storage_.shareContact(systemSession, userId, new String[]{contactNode.getProperty("exo:id").getString()}, recievedUser);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            systemSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(Membership m) throws Exception {
        Contact contact = this.cservice_.getPublicContact(m.getUserName());
        LinkedHashMap<String, String> groupIds = new LinkedHashMap<String, String>();
        for (String group : contact.getAddressBook()) {
            groupIds.put(group, group);
        }
        groupIds.remove(m.getGroupId());
        contact.setAddressBook(groupIds.keySet().toArray(new String[0]));
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            this.cservice_.saveContact(systemSession, m.getUserName(), contact, false);
            JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_);
            Node publicContactHome = storage_.getPublicContactHome(systemSession);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(JCRDataStorage.USERS_PATH);
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node address = nodes.nextNode();
                storage_.removeUserShareAddressBook(systemSession, address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), m.getUserName());
                for (Value groupShared : address.getProperty("exo:viewPermissionGroups").getValues()) {
                    if (!groupIds.keySet().contains(groupShared.getString())) continue;
                    ArrayList<String> reciever = new ArrayList<String>();
                    reciever.add(m.getUserName());
                    storage_.shareAddressBook(systemSession, address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), reciever);
                }
            }
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node contactNode = nodes.nextNode();
                String split = "/";
                String temp = contactNode.getPath().split(usersPath)[1];
                String userId = temp.split(split)[1];
                storage_.removeUserShareContact(systemSession, userId, contactNode.getProperty("exo:id").getString(), m.getUserName());
                for (Value groupShared : contactNode.getProperty("exo:viewPermissionGroups").getValues()) {
                    if (!groupIds.keySet().contains(groupShared.getString())) continue;
                    ArrayList<String> reciever = new ArrayList<String>();
                    reciever.add(m.getUserName());
                    storage_.shareContact(systemSession, userId, new String[]{contactNode.getProperty("exo:id").getString()}, reciever);
                }
            }
        }
        catch (ReferentialIntegrityException e) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            systemSession.close();
        }
    }
}

