/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.GroupContactData;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.AddressBookNotFoundException;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private static final String PROP_ADDRESSBOOK_REFS = "exo:categories";
    private static final String CONTACTS = "contacts".intern();
    private static final String PERSONAL_ADDRESS_BOOKS = "contactGroup".intern();
    private static final String TAGS = "tags".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String CONTACT_APP = "ContactApplication".intern();
    private static final String SHARED_HOME = "Shared".intern();
    private static final String SHARED_CONTACT = "SharedContact".intern();
    private static final String SHARED_ADDRESSBOOK = "SharedAddressBook".intern();
    private static final String SHARED_MIXIN = "exo:contactShared".intern();
    private static final String SHARED_PROP = "exo:sharedId".intern();
    public static final String USERS_PATH = "usersPath".intern();
    public static final String PERSONAL = "0".intern();
    public static final String SHARED = "1".intern();
    public static final String PUBLIC = "2".intern();
    public static final String SPLIT = "::".intern();
    public static final String HYPHEN = "shared_".intern();
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public Node getContactUserDataHome(SessionProvider sProvider, String username) throws Exception {
        SessionProvider sessionProvider = this.createSystemProvider();
        Node userDataHome = this.nodeHierarchyCreator_.getUserApplicationNode(sessionProvider, username);
        try {
            return userDataHome.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node contactUserDataHome = userDataHome.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            userDataHome.getSession().save();
            return contactUserDataHome;
        }
    }

    public Node getContactApplicationDataHome(SessionProvider sProvider) throws Exception {
        Node applicationDataHome = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return applicationDataHome.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node contactApplicationDataHome = applicationDataHome.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            applicationDataHome.save();
            return contactApplicationDataHome;
        }
    }

    public Node getPersonalContactsHome(SessionProvider sProvider, String username) throws Exception {
        Node userDataHome = this.getContactUserDataHome(sProvider, username);
        try {
            return userDataHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node personalContactsHome = userDataHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            userDataHome.save();
            return personalContactsHome;
        }
    }

    public Node getPersonalAddressBooksHome(SessionProvider sProvider, String username) throws Exception {
        Node userDataHome = this.getContactUserDataHome(sProvider, username);
        try {
            return userDataHome.getNode(PERSONAL_ADDRESS_BOOKS);
        }
        catch (PathNotFoundException ex) {
            Node padHome = userDataHome.addNode(PERSONAL_ADDRESS_BOOKS, NT_UNSTRUCTURED);
            userDataHome.save();
            return padHome;
        }
    }

    public Node getPublicContactsHome(SessionProvider sProvider) throws Exception {
        Node contactServiceHome = this.getContactApplicationDataHome(sProvider);
        try {
            return contactServiceHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node publicHome = contactServiceHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return publicHome;
        }
    }

    public Node getTagsHome(SessionProvider sProvider, String username) throws Exception {
        Node contactServiceHome = this.getContactUserDataHome(sProvider, username);
        try {
            return contactServiceHome.getNode(TAGS);
        }
        catch (PathNotFoundException ex) {
            Node tagHome = contactServiceHome.addNode(TAGS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return tagHome;
        }
    }

    public Node getSharedAddressBooksHome(SessionProvider provider, String userId) throws Exception {
        Node sharedHome;
        Node userData = this.getContactUserDataHome(provider, userId);
        if (!userData.hasNode(SHARED_HOME)) {
            sharedHome = userData.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            userData.save();
        } else {
            sharedHome = userData.getNode(SHARED_HOME);
        }
        Node sharedAddressBooksHome = null;
        if (!sharedHome.hasNode(SHARED_ADDRESSBOOK)) {
            sharedAddressBooksHome = sharedHome.addNode(SHARED_ADDRESSBOOK, NT_UNSTRUCTURED);
            if (sharedAddressBooksHome.canAddMixin("mix:referenceable")) {
                sharedAddressBooksHome.addMixin("mix:referenceable");
            }
            sharedHome.save();
        } else {
            sharedAddressBooksHome = sharedHome.getNode(SHARED_ADDRESSBOOK);
        }
        return sharedAddressBooksHome;
    }

    public Node getSharedContactsHome(SessionProvider provider, String userId) throws Exception {
        Node sharedHome;
        Node userData = this.getContactUserDataHome(provider, userId);
        if (!userData.hasNode(SHARED_HOME)) {
            sharedHome = userData.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            userData.save();
        } else {
            sharedHome = userData.getNode(SHARED_HOME);
        }
        Node sharedContactsHome = null;
        if (!sharedHome.hasNode(SHARED_CONTACT)) {
            sharedContactsHome = sharedHome.addNode(SHARED_CONTACT, NT_UNSTRUCTURED);
            if (sharedContactsHome.canAddMixin("mix:referenceable")) {
                sharedContactsHome.addMixin("mix:referenceable");
            }
            sharedHome.save();
        } else {
            sharedContactsHome = sharedHome.getNode(SHARED_CONTACT);
        }
        return sharedContactsHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getSharedContact(String userId) throws Exception {
        Node sharedHome;
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node contactHome = this.getContactUserDataHome(provider, userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            Node ex = sharedHome.getNode(SHARED_CONTACT);
            return ex;
        }
        catch (PathNotFoundException ex) {
            Node sharedContact = sharedHome.addNode(SHARED_CONTACT, NT_UNSTRUCTURED);
            if (sharedContact.canAddMixin("mix:referenceable")) {
                sharedContact.addMixin("mix:referenceable");
            }
            sharedHome.save();
            Node node = sharedContact;
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getSharedAddressBooksHome(String userId) throws Exception {
        Node sharedHome;
        SessionProvider provider = null;
        provider = this.createSystemProvider();
        Node contactHome = this.getContactUserDataHome(provider, userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            Node ex = sharedHome.getNode(SHARED_ADDRESSBOOK);
            return ex;
        }
        catch (PathNotFoundException ex) {
            Node sharedAddressBooksHome = sharedHome.addNode(SHARED_ADDRESSBOOK, NT_UNSTRUCTURED);
            if (sharedAddressBooksHome.canAddMixin("mix:referenceable")) {
                sharedAddressBooksHome.addMixin("mix:referenceable");
            }
            sharedHome.save();
            Node node = sharedAddressBooksHome;
            return node;
        }
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact loadPublicContactByUser(String userId) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node contactHomeNode = this.getPersonalContactsHome(provider, userId);
            Contact contact = this.getContact(contactHomeNode.getNode(userId), PUBLIC);
            return contact;
        }
        catch (PathNotFoundException e) {
            log.error((Object)("Public contact " + userId + " not found"));
            Contact contact = null;
            return contact;
        }
        finally {
            provider.close();
        }
    }

    private Contact getContact(Node contactNode, String contactType) throws Exception {
        Node image;
        Contact contact = new Contact();
        contact.setContactType(contactType);
        if (contactNode.hasProperty("exo:id")) {
            contact.setId(contactNode.getProperty("exo:id").getString());
        }
        if (contactNode.hasProperty("exo:fullName")) {
            contact.setFullName(contactNode.getProperty("exo:fullName").getString());
        }
        if (contactNode.hasProperty("exo:firstName")) {
            contact.setFirstName(contactNode.getProperty("exo:firstName").getString());
        }
        if (contactNode.hasProperty("exo:lastName")) {
            contact.setLastName(contactNode.getProperty("exo:lastName").getString());
        }
        if (contactNode.hasProperty("exo:nickName")) {
            contact.setNickName(contactNode.getProperty("exo:nickName").getString());
        }
        if (contactNode.hasProperty("exo:gender")) {
            contact.setGender(contactNode.getProperty("exo:gender").getString());
        }
        if (contactNode.hasProperty("exo:birthday")) {
            contact.setBirthday(contactNode.getProperty("exo:birthday").getDate().getTime());
        }
        if (contactNode.hasProperty("exo:jobTitle")) {
            contact.setJobTitle(contactNode.getProperty("exo:jobTitle").getString());
        }
        if (contactNode.hasProperty("exo:emailAddress")) {
            contact.setEmailAddress(contactNode.getProperty("exo:emailAddress").getString());
        }
        if (contactNode.hasProperty("exo:exoId")) {
            contact.setExoId(contactNode.getProperty("exo:exoId").getString());
        }
        if (contactNode.hasProperty("exo:googleId")) {
            contact.setGoogleId(contactNode.getProperty("exo:googleId").getString());
        }
        if (contactNode.hasProperty("exo:msnId")) {
            contact.setMsnId(contactNode.getProperty("exo:msnId").getString());
        }
        if (contactNode.hasProperty("exo:aolId")) {
            contact.setAolId(contactNode.getProperty("exo:aolId").getString());
        }
        if (contactNode.hasProperty("exo:yahooId")) {
            contact.setYahooId(contactNode.getProperty("exo:yahooId").getString());
        }
        if (contactNode.hasProperty("exo:icrId")) {
            contact.setIcrId(contactNode.getProperty("exo:icrId").getString());
        }
        if (contactNode.hasProperty("exo:skypeId")) {
            contact.setSkypeId(contactNode.getProperty("exo:skypeId").getString());
        }
        if (contactNode.hasProperty("exo:icqId")) {
            contact.setIcqId(contactNode.getProperty("exo:icqId").getString());
        }
        if (contactNode.hasProperty("exo:homeAddress")) {
            contact.setHomeAddress(contactNode.getProperty("exo:homeAddress").getString());
        }
        if (contactNode.hasProperty("exo:homeCity")) {
            contact.setHomeCity(contactNode.getProperty("exo:homeCity").getString());
        }
        if (contactNode.hasProperty("exo:homeState_province")) {
            contact.setHomeState_province(contactNode.getProperty("exo:homeState_province").getString());
        }
        if (contactNode.hasProperty("exo:homePostalCode")) {
            contact.setHomePostalCode(contactNode.getProperty("exo:homePostalCode").getString());
        }
        if (contactNode.hasProperty("exo:homeCountry")) {
            contact.setHomeCountry(contactNode.getProperty("exo:homeCountry").getString());
        }
        if (contactNode.hasProperty("exo:homePhone1")) {
            contact.setHomePhone1(contactNode.getProperty("exo:homePhone1").getString());
        }
        if (contactNode.hasProperty("exo:homePhone2")) {
            contact.setHomePhone2(contactNode.getProperty("exo:homePhone2").getString());
        }
        if (contactNode.hasProperty("exo:homeFax")) {
            contact.setHomeFax(contactNode.getProperty("exo:homeFax").getString());
        }
        if (contactNode.hasProperty("exo:personalSite")) {
            contact.setPersonalSite(contactNode.getProperty("exo:personalSite").getString());
        }
        if (contactNode.hasProperty("exo:workAddress")) {
            contact.setWorkAddress(contactNode.getProperty("exo:workAddress").getString());
        }
        if (contactNode.hasProperty("exo:workCity")) {
            contact.setWorkCity(contactNode.getProperty("exo:workCity").getString());
        }
        if (contactNode.hasProperty("exo:workState_province")) {
            contact.setWorkStateProvince(contactNode.getProperty("exo:workState_province").getString());
        }
        if (contactNode.hasProperty("exo:workPostalCode")) {
            contact.setWorkPostalCode(contactNode.getProperty("exo:workPostalCode").getString());
        }
        if (contactNode.hasProperty("exo:workCountry")) {
            contact.setWorkCountry(contactNode.getProperty("exo:workCountry").getString());
        }
        if (contactNode.hasProperty("exo:workPhone1")) {
            contact.setWorkPhone1(contactNode.getProperty("exo:workPhone1").getString());
        }
        if (contactNode.hasProperty("exo:workPhone2")) {
            contact.setWorkPhone2(contactNode.getProperty("exo:workPhone2").getString());
        }
        if (contactNode.hasProperty("exo:workFax")) {
            contact.setWorkFax(contactNode.getProperty("exo:workFax").getString());
        }
        if (contactNode.hasProperty("exo:mobilePhone")) {
            contact.setMobilePhone(contactNode.getProperty("exo:mobilePhone").getString());
        }
        if (contactNode.hasProperty("exo:webPage")) {
            contact.setWebPage(contactNode.getProperty("exo:webPage").getString());
        }
        if (contactNode.hasProperty("exo:note")) {
            contact.setNote(contactNode.getProperty("exo:note").getString());
        }
        if (contactNode.hasProperty(PROP_ADDRESSBOOK_REFS)) {
            contact.setAddressBookIds(this.ValuesToStrings(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues()));
        }
        if (contactNode.hasProperty("exo:tags")) {
            contact.setTags(this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionUsers")) {
            contact.setEditPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionUsers")) {
            contact.setViewPermissionUsers(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactNode.hasProperty("exo:editPermissionGroups")) {
            contact.setEditPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:viewPermissionGroups")) {
            contact.setViewPermissionGroups(this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactNode.hasProperty("exo:lastUpdated")) {
            contact.setLastUpdated(contactNode.getProperty("exo:lastUpdated").getDate().getTime());
        }
        contact.setPath(contactNode.getPath());
        if (contactNode.hasNode("image") && (image = contactNode.getNode("image")).isNodeType("nt:file")) {
            ContactAttachment file = new ContactAttachment();
            file.setId(image.getPath());
            file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            file.setFileName(image.getName());
            file.setWorkspace(image.getSession().getWorkspace().getName());
            contact.setAttachment(file);
        }
        if (contactNode.hasProperty("exo:isOwner")) {
            contact.setOwner(contactNode.getProperty("exo:isOwner").getBoolean());
        }
        if (contactNode.hasProperty("exo:ownerId")) {
            contact.setOwnerId(contactNode.getProperty("exo:ownerId").getString());
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> findAllContactsByOwner(String username) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node contactHomeNode = this.getPersonalContactsHome(sProvider, username);
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            NodeIterator iter = contactHomeNode.getNodes();
            while (iter.hasNext()) {
                Node contactNode = iter.nextNode();
                Contact contact = this.getContact(contactNode, PERSONAL);
                contacts.add(contact);
            }
            ArrayList<Contact> arrayList = contacts;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList findContactsByFilter(String username, ContactFilter filter, String type) throws Exception {
        QueryManager qm = null;
        SessionProvider sysp = this.createSystemProvider();
        try {
            ContactPageList contactPageList;
            if (type.equals(PERSONAL)) {
                Node contactHomeNode = this.getPersonalContactsHome(sysp, username);
                filter.setAccountPath(contactHomeNode.getPath());
                qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
            } else if (type.equals(PUBLIC)) {
                Node publicContactHomeNode = this.getPublicContactsHome(sysp);
                String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                filter.setAccountPath(usersPath);
                qm = publicContactHomeNode.getSession().getWorkspace().getQueryManager();
            } else if (type.equals(SHARED)) {
                Node sharedAddressBookHolder = this.getSharedAddressBooksHome(sysp, username);
                PropertyIterator iter = sharedAddressBookHolder.getReferences();
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    if (!addressBook.getName().equals(filter.getCategories()[0])) continue;
                    Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contacts.getPath());
                    qm = contacts.getSession().getWorkspace().getQueryManager();
                    break;
                }
            }
            if (qm != null) {
                contactPageList = new ContactPageList(username, 10L, filter.getStatement(), type);
                return contactPageList;
            }
            contactPageList = null;
            return contactPageList;
        }
        finally {
            this.closeSessionProvider(sysp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact loadPersonalContact(String ownerUserId, String contactId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node contactHomeNode = this.getPersonalContactsHome(sProvider, ownerUserId);
            try {
                Contact contact = this.getContact(contactHomeNode.getNode(contactId), PERSONAL);
                return contact;
            }
            catch (PathNotFoundException ex) {
                Contact contact = null;
                this.closeSessionProvider(sProvider);
                return contact;
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList findPersonalContactsByAddressBook(String owner, String addressBookId) throws Exception {
        SessionProvider sProvider = null;
        try {
            ContactPageList pageList;
            sProvider = this.createSessionProvider();
            Node userContactsHome = this.getPersonalContactsHome(sProvider, owner);
            String queryString = new StringBuffer("/jcr:root" + userContactsHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(addressBookId).append("']").append("order by @exo:fullName,@exo:id ascending").toString();
            ContactPageList contactPageList = pageList = new ContactPageList(owner, 10L, queryString, PERSONAL);
            return contactPageList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    public List<String> findEmailsByAddressBook(String username, String addressBookId) throws AddressBookNotFoundException, Exception {
        AddressBookType type = this.getAddressBookType(username, addressBookId);
        if (type == AddressBookType.Personal) {
            return this.findEmailsInPersonalAddressBook(username, addressBookId);
        }
        if (type == AddressBookType.Shared) {
            return this.findEmailsInPersonalAddressBook(username, addressBookId);
        }
        if (type == AddressBookType.Public) {
            return this.findEmailsInPublicAddressBook(username, addressBookId);
        }
        throw new AddressBookNotFoundException(addressBookId);
    }

    private AddressBookType getAddressBookType(String username, String addressBookId) throws Exception {
        AddressBook shared = this.getSharedAddressBookById(username, addressBookId);
        if (shared != null) {
            return AddressBookType.Shared;
        }
        AddressBook personal = this.findPersonalAddressBookById(username, addressBookId);
        if (personal != null) {
            return AddressBookType.Personal;
        }
        AddressBook publicAb = this.findPublicAddressBookById(username, addressBookId);
        if (publicAb != null) {
            return AddressBookType.Public;
        }
        return null;
    }

    private AddressBook findPublicAddressBookById(String username, String addressBookId) {
        return null;
    }

    private AddressBook findPersonalAddressBookById(String username, String addressBookId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findEmailsInPersonalAddressBook(String username, String addressBookId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node contactHome = this.getPersonalContactsHome(sProvider, username);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(addressBookId).append("']");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            ArrayList<String> address = new ArrayList<String>();
            while (it.hasNext()) {
                Node contact = it.nextNode();
                if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
                address.add(contact.getProperty("exo:emailAddress").getString());
            }
            ArrayList<String> arrayList = address;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findEmailsInPublicAddressBook(String username, String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node publicContactHome = this.getPublicContactsHome(provider);
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            ArrayList<String> address = new ArrayList<String>();
            while (it.hasNext()) {
                Node contact = it.nextNode();
                if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
                address.add(contact.getProperty("exo:emailAddress").getString());
            }
            ArrayList<String> arrayList = address;
            return arrayList;
        }
        finally {
            provider.close();
        }
    }

    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            QueryManager qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + addressBook.getParent().getParent().getNode(CONTACTS).getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBookId).append("')]");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            ArrayList<String> address = new ArrayList<String>();
            while (it.hasNext()) {
                Node contact = it.nextNode();
                if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(contact.getProperty("exo:emailAddress").getString())) continue;
                address.add(contact.getProperty("exo:emailAddress").getString());
            }
            return address;
        }
        return null;
    }

    private AddressBook toAddressBook(Node contactGroupNode) throws Exception {
        AddressBook contactGroup = new AddressBook();
        if (contactGroupNode.hasProperty("exo:id")) {
            contactGroup.setId(contactGroupNode.getProperty("exo:id").getString());
        }
        if (contactGroupNode.hasProperty("exo:name")) {
            contactGroup.setName(contactGroupNode.getProperty("exo:name").getString());
        }
        if (contactGroupNode.hasProperty("exo:description")) {
            contactGroup.setDescription(contactGroupNode.getProperty("exo:description").getString());
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionUsers")) {
            contactGroup.setViewPermissionUsers(this.ValuesToStrings(contactGroupNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionUsers")) {
            contactGroup.setEditPermissionUsers(this.ValuesToStrings(contactGroupNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionGroups")) {
            contactGroup.setViewPermissionGroups(this.ValuesToStrings(contactGroupNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionGroups")) {
            contactGroup.setEditPermissionGroups(this.ValuesToStrings(contactGroupNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        return contactGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressBook loadPersonalAddressBook(String username, String groupId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            if (groupId == null) {
                AddressBook addressBook = null;
                return addressBook;
            }
            Node contactGroupHomeNode = this.getPersonalAddressBooksHome(sProvider, username);
            if (contactGroupHomeNode.hasNode(groupId)) {
                AddressBook addressBook = this.toAddressBook(contactGroupHomeNode.getNode(groupId));
                return addressBook;
            }
            AddressBook addressBook = null;
            return addressBook;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    public AddressBook getSharedAddressBookById(String username, String addressBookId) throws Exception {
        Node sharedAddressBookNode = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookNode.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            return this.toAddressBook(addressBook);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AddressBook> findPersonalAddressBooksByOwner(String username) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node addressBooksHome = this.getPersonalAddressBooksHome(sProvider, username);
            ArrayList<AddressBook> addressBooks = new ArrayList<AddressBook>();
            NodeIterator iter = addressBooksHome.getNodes();
            while (iter.hasNext()) {
                Node addressBook = iter.nextNode();
                addressBooks.add(this.toAddressBook(addressBook));
            }
            ArrayList<AddressBook> arrayList = addressBooks;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> removeContacts(String username, List<String> contactIds) throws Exception {
        SessionProvider sp = null;
        try {
            sp = this.createSessionProvider();
            Node contactHomeNode = this.getPersonalContactsHome(sp, username);
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            for (String contactId : contactIds) {
                if (!contactHomeNode.hasNode(contactId)) continue;
                Contact contact = this.loadPersonalContact(username, contactId);
                contactHomeNode.getNode(contactId).remove();
                contactHomeNode.getSession().save();
                contacts.add(contact);
            }
            ArrayList<Contact> arrayList = contacts;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveContacts(String username, List<Contact> contacts, String addressType) throws Exception {
        SessionProvider sysProvider = null;
        try {
            sysProvider = this.createSystemProvider();
            Node privateContactHome = this.getPersonalContactsHome(sysProvider, username);
            for (Contact contact : contacts) {
                if (addressType.equals(PERSONAL)) {
                    this.saveContact(username, contact, false);
                    continue;
                }
                if (!addressType.equals(SHARED)) continue;
                this.saveContactToSharedAddressBook(username, contact.getAddressBookIds()[0], contact, true);
                if (!privateContactHome.hasNode(contact.getId())) continue;
                privateContactHome.getNode(contact.getId()).remove();
            }
            if (privateContactHome.getSession().hasPendingChanges()) {
                privateContactHome.getSession().save();
            }
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    private List<String> getUserContactNodesByGroup(SessionProvider sProvider, String username, String groupId) throws Exception {
        Node contactHome = this.getPersonalContactsHome(sProvider, username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        ArrayList<String> contactIds = new ArrayList<String>();
        while (it.hasNext()) {
            contactIds.add(it.nextNode().getProperty("exo:id").getString());
        }
        return contactIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressBook removePersonalAddressBook(String username, String addressBookId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node addressBooksHomeNode = this.getPersonalAddressBooksHome(sProvider, username);
            if (addressBooksHomeNode.hasNode(addressBookId)) {
                AddressBook contactGroup = this.loadPersonalAddressBook(username, addressBookId);
                addressBooksHomeNode.getNode(addressBookId).remove();
                addressBooksHomeNode.save();
                addressBooksHomeNode.getSession().save();
                AddressBook addressBook = contactGroup;
                return addressBook;
            }
            AddressBook addressBook = null;
            return addressBook;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAddressBook(String username, String addressBookId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            List<String> contactIds = this.getUserContactNodesByGroup(sProvider, username, addressBookId);
            this.removeContacts(username, contactIds);
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContact(String username, Contact contact, boolean isNew) throws Exception {
        SessionProvider sProvider = null;
        try {
            boolean systemPrivilege = false;
            sProvider = systemPrivilege ? this.createSessionProvider() : this.createSystemProvider();
            Node contactHomeNode = this.getPersonalContactsHome(sProvider, username);
            this.contactToNode(contactHomeNode, contact, isNew);
            contactHomeNode.getSession().save();
            this.closeSessionProvider(sProvider);
        }
        catch (Throwable throwable) {
            this.closeSessionProvider(sProvider);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersonalOrSharedAddressBook(String username, AddressBook addressbook, boolean isNew) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node groupNode = null;
            String id = addressbook.getId();
            if (isNew) {
                groupNode = this.getPersonalAddressBooksHome(sProvider, username).addNode(id, "exo:contactGroup");
                groupNode.setProperty("exo:id", id);
            } else {
                try {
                    groupNode = this.getPersonalAddressBooksHome(sProvider, username).getNode(id);
                }
                catch (PathNotFoundException e) {
                    Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                    PropertyIterator iter = sharedAddressBookMock.getReferences();
                    while (iter.hasNext()) {
                        Node addressBook = iter.nextProperty().getParent();
                        if (!addressBook.getName().equals(id)) continue;
                        groupNode = addressBook;
                        break;
                    }
                }
            }
            if (groupNode == null && !isNew) {
                throw new PathNotFoundException("No personal or shared address book for user " + username + " was found with ID " + addressbook);
            }
            groupNode.setProperty("exo:name", addressbook.getName());
            groupNode.setProperty("exo:description", addressbook.getDescription());
            groupNode.setProperty("exo:editPermissionUsers", addressbook.getEditPermissionUsers());
            groupNode.setProperty("exo:viewPermissionUsers", addressbook.getViewPermissionUsers());
            groupNode.setProperty("exo:editPermissionGroups", addressbook.getEditPermissionGroups());
            groupNode.setProperty("exo:viewPermissionGroups", addressbook.getViewPermissionGroups());
            if (isNew) {
                groupNode.getSession().save();
            } else {
                groupNode.save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserShareContact(String username, String contactId, String removedUser) throws Exception {
        SessionProvider sProvider = null;
        try {
            Node contactNode;
            sProvider = this.createSystemProvider();
            String split = "/";
            if (username.split(split).length > 1) {
                String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                String temp = username.split(usersPath)[1];
                String userId = temp.split(split)[1];
                contactNode = this.getPersonalContactsHome(sProvider, userId).getNode(contactId);
            } else {
                contactNode = this.getPersonalContactsHome(sProvider, username).getNode(contactId);
            }
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.ValuesToStrings(contactNode.getProperty(SHARED_PROP).getValues())));
            ArrayList<String> newValues = new ArrayList<String>(values);
            Node sharedContact = this.getSharedContact(removedUser);
            for (String value : values) {
                Node refNode = sharedContact.getSession().getNodeByUUID(value);
                if (!refNode.getPath().equals(sharedContact.getPath())) continue;
                newValues.remove(value);
            }
            try {
                String[] viewPer = this.ValuesToStrings(contactNode.getProperty("exo:viewPermissionUsers").getValues());
                if (viewPer != null) {
                    ArrayList<String> newViewPer = new ArrayList<String>();
                    newViewPer.addAll(Arrays.asList(viewPer));
                    newViewPer.remove(removedUser + HYPHEN);
                    contactNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
                    String[] editPer = this.ValuesToStrings(contactNode.getProperty("exo:editPermissionUsers").getValues());
                    if (editPer != null) {
                        ArrayList<String> newEditPer = new ArrayList<String>();
                        newEditPer.addAll(Arrays.asList(editPer));
                        newEditPer.remove(removedUser + HYPHEN);
                        contactNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            contactNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
            contactNode.save();
            contactNode.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unshareAddressBook(String username, String addressBookId, String removedUser) throws Exception {
        SessionProvider sysProvider = null;
        try {
            sysProvider = this.createSystemProvider();
            Node addressBookNode = this.getPersonalAddressBooksHome(sysProvider, username).getNode(addressBookId);
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.ValuesToStrings(addressBookNode.getProperty(SHARED_PROP).getValues())));
            ArrayList<String> newValues = new ArrayList<String>(values);
            Node sharedAddress = this.getSharedAddressBooksHome(sysProvider, removedUser);
            for (String value : values) {
                Node refNode = sharedAddress.getSession().getNodeByUUID(value);
                if (!refNode.getPath().equals(sharedAddress.getPath())) continue;
                newValues.remove(value);
            }
            String[] viewPer = null;
            try {
                viewPer = this.ValuesToStrings(addressBookNode.getProperty("exo:viewPermissionUsers").getValues());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            if (viewPer != null) {
                ArrayList<String> newViewPer = new ArrayList<String>();
                newViewPer.addAll(Arrays.asList(viewPer));
                newViewPer.remove(removedUser + HYPHEN);
                addressBookNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
                String[] editPer = null;
                try {
                    editPer = this.ValuesToStrings(addressBookNode.getProperty("exo:editPermissionUsers").getValues());
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (editPer != null) {
                    ArrayList<String> newEditPer = new ArrayList<String>();
                    newEditPer.addAll(Arrays.asList(editPer));
                    newEditPer.remove(removedUser + HYPHEN);
                    addressBookNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
                }
            }
            addressBookNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
            addressBookNode.save();
            addressBookNode.getSession().save();
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shareAddressBook(String username, String addressBookId, List<String> receiveUsers) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node addressBookNode = this.getPersonalAddressBooksHome(sProvider, username).getNode(addressBookId);
            Value[] values = new Value[]{};
            if (addressBookNode.isNodeType(SHARED_MIXIN)) {
                values = addressBookNode.getProperty(SHARED_PROP).getValues();
            } else {
                addressBookNode.addMixin(SHARED_MIXIN);
                addressBookNode.setProperty("exo:sharedUserId", username);
            }
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (String userId : receiveUsers) {
                Node sharedAddress = this.getSharedAddressBooksHome(userId.replaceFirst(HYPHEN, ""));
                boolean isExist = false;
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    String uuid = value.getString();
                    Node refNode = sharedAddress.getSession().getNodeByUUID(uuid);
                    if (refNode.getPath().equals(sharedAddress.getPath())) {
                        isExist = true;
                        break;
                    }
                    valueList.add(value);
                }
                if (isExist) continue;
                Value value2add = addressBookNode.getSession().getValueFactory().createValue(sharedAddress);
                valueList.add(value2add);
            }
            if (valueList.size() > 0) {
                LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
                for (Value value : values) {
                    newValue.put(value.getString(), value);
                }
                for (Value value : valueList) {
                    newValue.put(value.getString(), value);
                }
                addressBookNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
            } else {
                try {
                    addressBookNode.getProperty(SHARED_PROP);
                }
                catch (PathNotFoundException e) {
                    addressBookNode.setProperty(SHARED_PROP, new Value[0]);
                }
            }
            addressBookNode.save();
            addressBookNode.getSession().save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shareContact(String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSystemProvider();
            for (String contactId : contactIds) {
                Node contactNode = this.getPersonalContactsHome(sProvider, username).getNode(contactId);
                Value[] values = new Value[]{};
                if (contactNode.isNodeType(SHARED_MIXIN)) {
                    values = contactNode.getProperty(SHARED_PROP).getValues();
                } else {
                    contactNode.addMixin(SHARED_MIXIN);
                    contactNode.setProperty("exo:sharedUserId", username);
                }
                ArrayList<Value> valueList = new ArrayList<Value>();
                for (String user : receiveUsers) {
                    Node sharedContact = this.getSharedContact(user.replaceFirst(HYPHEN, ""));
                    boolean isExist = false;
                    for (int i = 0; i < values.length; ++i) {
                        Value value = values[i];
                        String uuid = value.getString();
                        Node refNode = sharedContact.getSession().getNodeByUUID(uuid);
                        if (refNode.getPath().equals(sharedContact.getPath())) {
                            isExist = true;
                            break;
                        }
                        valueList.add(value);
                    }
                    if (isExist) continue;
                    Value value2add = contactNode.getSession().getValueFactory().createValue(sharedContact);
                    valueList.add(value2add);
                }
                if (valueList.size() <= 0) continue;
                LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
                for (Value value : values) {
                    newValue.put(value.getString(), value);
                }
                for (Value value : valueList) {
                    newValue.put(value.getString(), value);
                }
                contactNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
                contactNode.save();
                contactNode.getSession().save();
            }
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SharedAddressBook> findSharedAddressBooksByUser(String username) throws Exception {
        SessionProvider sysProvider = null;
        try {
            sysProvider = this.createSystemProvider();
            ArrayList<SharedAddressBook> addressBooks = new ArrayList<SharedAddressBook>();
            Node sharedAddress = this.getSharedAddressBooksHome(sysProvider, username);
            PropertyIterator iter = sharedAddress.getReferences();
            while (iter.hasNext()) {
                try {
                    Node addressNode = iter.nextProperty().getParent();
                    SharedAddressBook sharedAddressBook = new SharedAddressBook(addressNode.getProperty("exo:name").getString(), addressNode.getName(), addressNode.getProperty("exo:sharedUserId").getString());
                    if (addressNode.hasProperty("exo:editPermissionUsers")) {
                        sharedAddressBook.setEditPermissionUsers(this.ValuesToStrings(addressNode.getProperty("exo:editPermissionUsers").getValues()));
                    }
                    if (addressNode.hasProperty("exo:editPermissionGroups")) {
                        sharedAddressBook.setEditPermissionGroups(this.ValuesToStrings(addressNode.getProperty("exo:editPermissionGroups").getValues()));
                    }
                    addressBooks.add(sharedAddressBook);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ArrayList<SharedAddressBook> arrayList = addressBooks;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    public void removeSharedContact(String username, String addressBookId, String contactId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter2 = sharedAddressBookMock.getReferences();
        while (iter2.hasNext()) {
            Node addressBook = iter2.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                contactHomeNode.getNode(contactId).remove();
                contactHomeNode.getSession().save();
                break;
            }
            catch (PathNotFoundException e) {
            }
        }
    }

    public Contact getSharedContact(String username, String contactId) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contactId)) continue;
                return this.getContact(contactNode, SHARED);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public DataPageList getSharedContacts(String username) throws Exception {
        ArrayList<Contact> sharedContacts = new ArrayList<Contact>();
        Node sharedContact = this.getSharedContact(username);
        PropertyIterator iter = sharedContact.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                sharedContacts.add(this.getContact(contactNode, SHARED));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new DataPageList(sharedContacts, 10L, null, false);
    }

    public void saveSharedContact(String username, Contact contact) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        boolean isEdit = false;
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contact.getId())) continue;
                isEdit = true;
                this.contactToNode(contactNode.getParent(), contact, false);
                contactNode.getParent().getSession().save();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isEdit) {
            throw new PathNotFoundException();
        }
    }

    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            contact.setOwner(false);
            this.contactToNode(contactHomeNode, contact, isNew);
            contactHomeNode.getSession().save();
            return;
        }
    }

    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                Node contactNode = contactHomeNode.getNode(contactId);
                if (!Arrays.asList(this.ValuesToStrings(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) continue;
                return this.getContact(contactNode, SHARED);
            }
            catch (PathNotFoundException e) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList getSharedContactsByAddressBook(String username, SharedAddressBook addressBook) throws Exception {
        if (addressBook == null) {
            return null;
        }
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getPersonalContactsHome(sysProvider, addressBook.getSharedUserId());
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBook.getId()).append("')]").append(" order by @exo:fullName,@exo:id ascending");
            ContactPageList contactPageList = new ContactPageList(username, 10L, queryString.toString(), SHARED);
            return contactPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactPageList getPublicContactsByAddressBook(String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("' and @exo:isOwner='true'] ").append("order by @exo:fullName,@exo:id ascending");
            ContactPageList contactPageList = new ContactPageList(null, 10L, queryString.toString(), PUBLIC);
            return contactPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    public List<GroupContactData> getPublicContacts(SessionProvider sysProvider, String[] groupIds) throws Exception {
        ArrayList<GroupContactData> contactByGroup = new ArrayList<GroupContactData>();
        for (String groupId : groupIds) {
            List<Contact> contacts = this.getPublicContactsByAddressBook(groupId).getAll();
            if (contacts.size() <= 0) continue;
            contactByGroup.add(new GroupContactData(groupId, contacts));
        }
        return contactByGroup;
    }

    public List<String> getPublicAddressBookContacts(SessionProvider sysProvider, String[] groupIds) throws Exception {
        ArrayList<String> groups = new ArrayList<String>();
        for (String groupId : groupIds) {
            if (!this.hasContacts(sysProvider, groupId)) continue;
            groups.add(groupId);
        }
        return groups;
    }

    private boolean hasContacts(SessionProvider sysProvider, String groupId) throws Exception {
        StringBuffer queryString;
        Node contactHome = this.getPublicContactsHome(sysProvider);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']")).toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes().getSize() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserContactInAddressBook(String userId, String addressBookId) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node contactHome = this.getPersonalContactsHome(provider, userId);
            Node contactNode = contactHome.getNode(userId);
            Value[] values = contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues();
            ArrayList<String> ls = new ArrayList<String>();
            for (Value vl : values) {
                if (vl.getString().equals(addressBookId)) {
                    return;
                }
                ls.add(vl.getString());
            }
            ls.add(addressBookId);
            contactNode.setProperty(PROP_ADDRESSBOOK_REFS, ls.toArray(new String[0]));
            contactNode.save();
        }
        finally {
            provider.close();
        }
    }

    private void reparePermissions(Node node, String owner) throws Exception {
    }

    private void contactToNode(Node contactsHome, Contact contact, boolean isNew) throws Exception {
        ContactAttachment attachment;
        Node contactNode;
        if (isNew) {
            contactNode = contactsHome.addNode(contact.getId(), "exo:contact");
            contactNode.setProperty("exo:id", contact.getId());
            if (contact.isOwner()) {
                contactNode.setProperty("exo:isOwner", true);
                contactNode.setProperty("exo:ownerId", contact.getOwnerId());
                this.reparePermissions(contactsHome, contact.getOwnerId());
                this.reparePermissions(contactNode, contact.getOwnerId());
            }
        } else {
            contactNode = contactsHome.getNode(contact.getId());
        }
        contactNode.setProperty("exo:fullName", contact.getFullName());
        contactNode.setProperty("exo:firstName", contact.getFirstName());
        contactNode.setProperty("exo:lastName", contact.getLastName());
        contactNode.setProperty("exo:nickName", contact.getNickName());
        contactNode.setProperty("exo:gender", contact.getGender());
        GregorianCalendar dateTime = new GregorianCalendar();
        Date birthday = contact.getBirthday();
        if (birthday != null) {
            dateTime.setTime(birthday);
            contactNode.setProperty("exo:birthday", (Calendar)dateTime);
        } else {
            try {
                contactNode.getProperty("exo:birthday").remove();
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        contactNode.setProperty("exo:jobTitle", contact.getJobTitle());
        contactNode.setProperty("exo:emailAddress", contact.getEmailAddress());
        contactNode.setProperty("exo:exoId", contact.getExoId());
        contactNode.setProperty("exo:googleId", contact.getGoogleId());
        contactNode.setProperty("exo:msnId", contact.getMsnId());
        contactNode.setProperty("exo:aolId", contact.getAolId());
        contactNode.setProperty("exo:yahooId", contact.getYahooId());
        contactNode.setProperty("exo:icrId", contact.getIcrId());
        contactNode.setProperty("exo:skypeId", contact.getSkypeId());
        contactNode.setProperty("exo:icqId", contact.getIcqId());
        contactNode.setProperty("exo:homeAddress", contact.getHomeAddress());
        contactNode.setProperty("exo:homeCity", contact.getHomeCity());
        contactNode.setProperty("exo:homeState_province", contact.getHomeState_province());
        contactNode.setProperty("exo:homePostalCode", contact.getHomePostalCode());
        contactNode.setProperty("exo:homeCountry", contact.getHomeCountry());
        contactNode.setProperty("exo:homePhone1", contact.getHomePhone1());
        contactNode.setProperty("exo:homePhone2", contact.getHomePhone2());
        contactNode.setProperty("exo:homeFax", contact.getHomeFax());
        contactNode.setProperty("exo:personalSite", contact.getPersonalSite());
        contactNode.setProperty("exo:workAddress", contact.getWorkAddress());
        contactNode.setProperty("exo:workCity", contact.getWorkCity());
        contactNode.setProperty("exo:workState_province", contact.getWorkStateProvince());
        contactNode.setProperty("exo:workPostalCode", contact.getWorkPostalCode());
        contactNode.setProperty("exo:workCountry", contact.getWorkCountry());
        contactNode.setProperty("exo:workPhone1", contact.getWorkPhone1());
        contactNode.setProperty("exo:workPhone2", contact.getWorkPhone2());
        contactNode.setProperty("exo:workFax", contact.getWorkFax());
        contactNode.setProperty("exo:mobilePhone", contact.getMobilePhone());
        contactNode.setProperty("exo:webPage", contact.getWebPage());
        contactNode.setProperty("exo:note", contact.getNote());
        contactNode.setProperty(PROP_ADDRESSBOOK_REFS, contact.getAddressBookIds());
        contactNode.setProperty("exo:tags", contact.getTags());
        contactNode.setProperty("exo:editPermissionUsers", contact.getEditPermissionUsers());
        contactNode.setProperty("exo:viewPermissionUsers", contact.getViewPermissionUsers());
        contactNode.setProperty("exo:editPermissionGroups", contact.getEditPermissionGroups());
        contactNode.setProperty("exo:viewPermissionGroups", contact.getViewPermissionGroups());
        if (contact.getLastUpdated() != null) {
            dateTime.setTime(contact.getLastUpdated());
            contactNode.setProperty("exo:lastUpdated", (Calendar)dateTime);
        }
        if ((attachment = contact.getAttachment()) != null) {
            ExtendedNode extNode = (ExtendedNode)contactNode;
            if (extNode.canAddMixin("exo:privilegeable")) {
                extNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
            extNode.setPermission(SystemIdentity.ANY, arrayPers);
            List permsList = extNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
            }
            if (attachment.getFileName() != null) {
                Node nodeFile = null;
                try {
                    nodeFile = contactNode.getNode("image");
                }
                catch (PathNotFoundException ex) {
                    nodeFile = contactNode.addNode("image", "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                nodeContent.setProperty("jcr:data", attachment.getInputStream());
                nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            }
        } else if (contactNode.hasNode("image")) {
            contactNode.getNode("image").remove();
        }
    }

    private Tag getTag(Node tagNode) throws Exception {
        Tag tag = new Tag();
        if (tagNode.hasProperty("exo:id")) {
            tag.setId(tagNode.getProperty("exo:id").getString());
        }
        if (tagNode.hasProperty("exo:name")) {
            tag.setName(tagNode.getProperty("exo:name").getString());
        }
        if (tagNode.hasProperty("exo:description")) {
            tag.setDescription(tagNode.getProperty("exo:description").getString());
        }
        if (tagNode.hasProperty("exo:color")) {
            tag.setColor(tagNode.getProperty("exo:color").getString());
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTag(String username, Tag tag) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSessionProvider();
            Node tagHome = this.getTagsHome(sProvider, username);
            Node tagNode = tagHome.getNode(tag.getId());
            tagNode.setProperty("exo:name", tag.getName());
            tagNode.setProperty("exo:description", tag.getDescription());
            tagNode.setProperty("exo:color", tag.getColor());
            tagHome.save();
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag getTag(String username, String tagId) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSystemProvider();
            Node tagHomeNode = this.getTagsHome(sProvider, username);
            if (tagHomeNode.hasNode(tagId)) {
                Tag tag = this.getTag(tagHomeNode.getNode(tagId));
                return tag;
            }
            Tag tag = null;
            return tag;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getTags(String username) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSystemProvider();
            Node tagHomeNode = this.getTagsHome(sProvider, username);
            ArrayList<Tag> tags = new ArrayList<Tag>();
            NodeIterator iter = tagHomeNode.getNodes();
            while (iter.hasNext()) {
                Node tagNode = iter.nextNode();
                tags.add(this.getTag(tagNode));
            }
            ArrayList<Tag> arrayList = tags;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPageList getContactPageListByTag(String username, String tagId) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            PropertyIterator iter;
            Node contactHome = this.getPersonalContactsHome(sysProvider, username);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
            while (it.hasNext()) {
                Contact contact = this.getContact(it.nextNode(), PERSONAL);
                contacts.put(contact.getId(), contact);
            }
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            Node publicContactHome = this.getPublicContactsHome(sysProvider);
            qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            it = result.getNodes();
            while (it.hasNext()) {
                Contact contact = this.getContact(it.nextNode(), PUBLIC);
                if (contact.getId().equals(username)) {
                    contact.setContactType(PERSONAL);
                }
                contacts.put(contact.getId(), contact);
            }
            try {
                Node sharedContact = this.getSharedContact(username);
                iter = sharedContact.getReferences();
                while (iter.hasNext()) {
                    try {
                        Node contactNode = iter.nextProperty().getParent();
                        if (!contactNode.hasProperty("exo:tags") || !Arrays.asList(this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues())).contains(tagId)) continue;
                        Contact contact = this.getContact(contactNode, SHARED);
                        contacts.put(contact.getId(), contact);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                it = result.getNodes();
                while (it.hasNext()) {
                    Contact contact = this.getContact(it.nextNode(), SHARED);
                    if (!Arrays.asList(contact.getAddressBookIds()).contains(addressBook.getProperty("exo:id").getString())) continue;
                    contacts.put(contact.getId(), contact);
                }
            }
            DataPageList dataPageList = new DataPageList(Arrays.asList(contacts.values().toArray(new Contact[0])), 10L, null, false);
            return dataPageList;
        }
        finally {
            sysProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(String username, List<String> contactIds, String tagId) throws Exception {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put(tagId, tagId);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PERSONAL)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    throw new PathNotFoundException();
                }
                HashMap<String, String> thisTagMap = new HashMap<String, String>();
                thisTagMap = tagMap;
                Value[] values = null;
                if (contactNode.hasProperty("exo:tags")) {
                    for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                        thisTagMap.put(value.getString(), value.getString());
                    }
                }
                contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(String username, List<String> contactIds, List<Tag> tags) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        Node tagHomeNode = this.getTagsHome(sysProvider, username);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        String newTag = null;
        try {
            for (Tag tag : tags) {
                if (!tagHomeNode.hasNode(tag.getId())) {
                    newTag = tag.getId();
                    Node tagNode = tagHomeNode.addNode(tag.getId(), "exo:contactTag");
                    tagNode.setProperty("exo:id", tag.getId());
                    tagNode.setProperty("exo:name", tag.getName());
                    tagNode.setProperty("exo:description", tag.getDescription());
                    tagNode.setProperty("exo:color", tag.getColor());
                    tagHomeNode.getSession().save();
                }
                tagMap.put(tag.getId(), tag.getId());
            }
            if (contactIds == null || contactIds.size() == 0) {
                return;
            }
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PERSONAL)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    if (contactIds.get(0).equals(contact) && newTag != null) {
                        tagHomeNode.getNode(newTag).remove();
                        tagHomeNode.getSession().save();
                    }
                    throw new PathNotFoundException();
                }
                HashMap<String, String> thisTagMap = new HashMap<String, String>();
                thisTagMap.putAll(tagMap);
                Value[] values = null;
                if (contactNode.hasProperty("exo:tags")) {
                    for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                        thisTagMap.put(value.getString(), value.getString());
                    }
                }
                contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    private void removeTagInContacts(NodeIterator it, String tagId) throws Exception {
        while (it.hasNext()) {
            Node contactNode = it.nextNode();
            if (!contactNode.hasProperty("exo:tags")) continue;
            String[] tagIds = this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues());
            ArrayList<String> newTagIds = new ArrayList<String>();
            for (String id : tagIds) {
                if (id.equals(tagId)) continue;
                newTagIds.add(id);
            }
            contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
            contactNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag removeTag(String username, String tagId) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            PropertyIterator iter;
            Node tagHomeNode = this.getTagsHome(sysProvider, username);
            Node tagNode = tagHomeNode.getNode(tagId);
            Tag tag = this.getTag(tagNode);
            tagNode.remove();
            tagHomeNode.save();
            Node contactHome = this.getPersonalContactsHome(sysProvider, username);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            this.removeTagInContacts(query.execute().getNodes(), tagId);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            Node publicContactHome = this.getPublicContactsHome(sysProvider);
            qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
            query = qm.createQuery(queryString.toString(), "xpath");
            this.removeTagInContacts(query.execute().getNodes(), tagId);
            try {
                Node sharedContact = this.getSharedContact(username);
                iter = sharedContact.getReferences();
                while (iter.hasNext()) {
                    try {
                        Node contactNode = iter.nextProperty().getParent();
                        if (!contactNode.hasProperty("exo:tags")) continue;
                        String[] tagIds = this.ValuesToStrings(contactNode.getProperty("exo:tags").getValues());
                        ArrayList<String> newTagIds = new ArrayList<String>();
                        for (String id : tagIds) {
                            if (id.equals(tagId)) continue;
                            newTagIds.add(id);
                        }
                        contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
                        contactNode.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
                query = qm.createQuery(queryString.toString(), "xpath");
                this.removeTagInContacts(query.execute().getNodes(), tagId);
            }
            Tag tag2 = tag;
            return tag2;
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactTag(String username, List<String> contactIds, List<String> tags) throws Exception {
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            for (String contact : contactIds) {
                Node contactNode = null;
                String contactId = contact.split(SPLIT)[0];
                String contactType = contact.split(SPLIT)[1];
                if (contactType.equals(PERSONAL)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, username).getNode(contactId);
                } else if (contactType.equals(PUBLIC)) {
                    contactNode = this.getPersonalContactsHome(sysProvider, contactId).getNode(contactId);
                } else {
                    Node sharedContactMock = this.getSharedContact(username);
                    PropertyIterator iter = sharedContactMock.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node node = iter.nextProperty().getParent();
                            if (!node.getName().equals(contactId)) continue;
                            contactNode = node;
                            break;
                        }
                        catch (Exception exx) {
                            exx.printStackTrace();
                        }
                    }
                    if (contactNode == null) {
                        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                        PropertyIterator iter1 = sharedAddressBookMock.getReferences();
                        while (iter1.hasNext()) {
                            Node addressBook = iter1.nextProperty().getParent();
                            Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                            if (!contacts.hasNode(contactId)) continue;
                            contactNode = contacts.getNode(contactId);
                            if (Arrays.asList(this.ValuesToStrings(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                            contactNode = null;
                            break;
                        }
                    }
                }
                if (contactNode == null) {
                    throw new PathNotFoundException();
                }
                if (!contactNode.hasProperty("exo:tags")) continue;
                Value[] values = contactNode.getProperty("exo:tags").getValues();
                ArrayList<String> tagList = new ArrayList<String>();
                for (Value value : values) {
                    tagList.add(value.getString());
                }
                for (String tag : tags) {
                    if (!tagList.contains(tag)) continue;
                    tagList.remove(tag);
                }
                contactNode.setProperty("exo:tags", tagList.toArray(new String[0]));
                contactNode.save();
            }
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPageList searchContact(String username, ContactFilter filter) throws Exception {
        LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
        filter.setUsername(username);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            Contact contact;
            QueryManager qm = null;
            Query query = null;
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            if (filter.getType() == null || filter.getType().equals(PUBLIC)) {
                Node publicContactHome = this.getPublicContactsHome(sysProvider);
                usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                filter.setAccountPath(usersPath);
                filter.setOwner("true");
                qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator itpublic = query.execute().getNodes();
                while (itpublic.hasNext()) {
                    contact = this.getContact(itpublic.nextNode(), PUBLIC);
                    contacts.put(contact.getId(), contact);
                }
            }
            filter.setOwner(null);
            if ((filter.getType() == null || filter.getType().equals(PERSONAL)) && username != null && username.length() > 0) {
                Node contactHome = this.getPersonalContactsHome(sysProvider, username);
                filter.setAccountPath(contactHome.getPath());
                qm = contactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator it = query.execute().getNodes();
                while (it.hasNext()) {
                    contact = this.getContact(it.nextNode(), PERSONAL);
                    contacts.put(contact.getId(), contact);
                }
            }
            if (filter.getType() == null || filter.getType().equals(SHARED)) {
                PropertyIterator iter;
                try {
                    Node sharedContact = this.getSharedContact(username);
                    iter = sharedContact.getReferences();
                    List<Contact> sharedContacts = this.getSharedContacts(username).getAll();
                    ArrayList<String> sharedContactIds = new ArrayList<String>();
                    for (Contact contact2 : sharedContacts) {
                        sharedContactIds.add(contact2.getId());
                    }
                    while (iter.hasNext()) {
                        try {
                            Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                            filter.setAccountPath(sharedContactHomeNode.getPath());
                            String split = "/";
                            String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                            String userId = temp.split(split)[1];
                            filter.setUsername(userId);
                            qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                            query = qm.createQuery(filter.getStatement(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            while (it.hasNext()) {
                                Node contactNode = it.nextNode();
                                if (!sharedContactIds.contains(contactNode.getProperty("exo:id").getString())) continue;
                                Contact contact3 = this.getContact(contactNode, SHARED);
                                if (!contacts.containsKey(contact3.getId())) {
                                    contacts.put(contact3.getId(), contact3);
                                } else {
                                    ((Contact)contacts.get(contact3.getId())).setContactType(SHARED);
                                }
                                sharedContactIds.remove(contact3.getId());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (!filter.isSearchSharedContacts()) {
                    Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                    iter = sharedAddressBookMock.getReferences();
                    boolean searchByAddress = false;
                    if (filter.getCategories() != null && filter.getCategories().length > 0) {
                        searchByAddress = true;
                    }
                    while (iter.hasNext()) {
                        Node addressBook = iter.nextProperty().getParent();
                        Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                        filter.setAccountPath(contactHomeNode.getPath());
                        if (!searchByAddress) {
                            filter.setCategories(new String[]{addressBook.getName()});
                        }
                        filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                        qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                        query = qm.createQuery(filter.getStatement(), "xpath");
                        NodeIterator it = query.execute().getNodes();
                        while (it.hasNext()) {
                            Contact contact4 = this.getContact(it.nextNode(), SHARED);
                            contacts.put(contact4.getId(), contact4);
                        }
                    }
                }
            }
            ArrayList<Contact> contactList = new ArrayList<Contact>();
            contactList.addAll(contacts.values());
            DataPageList dataPageList = new DataPageList(contactList, 10L, null, false);
            return dataPageList;
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> findEmailsByFilter(String username, ContactFilter filter) throws Exception {
        LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
        filter.setUsername(username);
        filter.setHasEmails(true);
        SessionProvider sysProvider = SessionProvider.createSystemProvider();
        try {
            PropertyIterator iter;
            Query query;
            QueryManager qm;
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            if (!filter.isSearchSharedContacts()) {
                Node publicContactHome = this.getPublicContactsHome(sysProvider);
                filter.setAccountPath(usersPath);
                filter.setOwner("true");
                qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                query = qm.createQuery(filter.getStatement(), "xpath");
                NodeIterator itpublic = query.execute().getNodes();
                while (itpublic.hasNext()) {
                    Node contactNode = itpublic.nextNode();
                    this.feedEmailResult(emails, contactNode);
                }
                filter.setOwner(null);
                if (username != null && username.length() > 0) {
                    Node contactHome = this.getPersonalContactsHome(sysProvider, username);
                    filter.setAccountPath(contactHome.getPath());
                    qm = contactHome.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Node contactNode = it.nextNode();
                        this.feedEmailResult(emails, contactNode);
                    }
                }
            }
            try {
                Node sharedContact = this.getSharedContact(username);
                iter = sharedContact.getReferences();
                while (iter.hasNext()) {
                    try {
                        Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                        filter.setAccountPath(sharedContactHomeNode.getPath());
                        String split = "/";
                        String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                        String userId = temp.split(split)[1];
                        filter.setUsername(userId);
                        qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                        query = qm.createQuery(filter.getStatement(), "xpath");
                        NodeIterator it = query.execute().getNodes();
                        while (it.hasNext()) {
                            Node contactNode = it.nextNode();
                            this.feedEmailResult(emails, contactNode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            if (!filter.isSearchSharedContacts()) {
                boolean hasGroup;
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(sysProvider, username);
                iter = sharedAddressBookMock.getReferences();
                boolean bl = hasGroup = filter.getCategories() != null && filter.getCategories().length > 0;
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contactHomeNode.getPath());
                    if (!hasGroup) {
                        filter.setCategories(new String[]{addressBook.getName()});
                    }
                    filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                    qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Node contactNode = it.nextNode();
                        this.feedEmailResult(emails, contactNode);
                    }
                }
            }
            LinkedHashMap<String, String> linkedHashMap = emails;
            return linkedHashMap;
        }
        finally {
            if (sysProvider != null) {
                sysProvider.close();
            }
        }
    }

    private void feedEmailResult(Map<String, String> emails, Node contactNode) throws Exception {
        String id = contactNode.getProperty("exo:id").getString();
        String fullName = contactNode.getProperty("exo:fullName").getString();
        String emailAddresses = contactNode.getProperty("exo:emailAddress").getString();
        emails.put(id, fullName + Utils.SPLIT + emailAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNodes(SessionProvider sProvider, String username, Node srcHomeNode, NodeIterator iter, String destAddress, String destType) throws Exception {
        block13: {
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            try {
                if (destType.equals(PERSONAL)) {
                    Node contactHomeNode = this.getPersonalContactsHome(sProvider, username);
                    while (iter.hasNext()) {
                        ExtendedNode extNode;
                        Node oldNode = iter.nextNode();
                        String newId = "Contact" + IdGenerator.generate();
                        try {
                            contactHomeNode.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                        }
                        catch (AccessDeniedException ex) {
                            Node userContactHome = this.getPersonalContactsHome(sysProvider, oldNode.getProperty("exo:id").getString());
                            userContactHome.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                        }
                        try {
                            extNode = (ExtendedNode)contactHomeNode.getNode(newId);
                        }
                        catch (Exception e) {
                            extNode = (ExtendedNode)this.getPersonalContactsHome(sysProvider, username).getNode(newId);
                        }
                        if (extNode.canAddMixin("exo:privilegeable")) {
                            extNode.addMixin("exo:privilegeable");
                        }
                        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                        extNode.setPermission(username, arrayPers);
                        extNode.save();
                        Node newNode = contactHomeNode.getNode(newId);
                        newNode.setProperty(PROP_ADDRESSBOOK_REFS, new String[]{destAddress});
                        newNode.setProperty("exo:id", newId);
                        newNode.setProperty("exo:isOwner", false);
                        newNode.setProperty("exo:editPermissionUsers", new String[0]);
                        newNode.setProperty("exo:viewPermissionUsers", new String[0]);
                        newNode.setProperty("exo:editPermissionGroups", new String[0]);
                        newNode.setProperty("exo:viewPermissionGroups", new String[0]);
                    }
                    contactHomeNode.getSession().save();
                    break block13;
                }
                if (!destType.equals(SHARED)) break block13;
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                PropertyIterator proIter = sharedAddressBookMock.getReferences();
                while (proIter.hasNext()) {
                    Node addressBook = proIter.nextProperty().getParent();
                    if (!addressBook.getName().equals(destAddress)) continue;
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    while (iter.hasNext()) {
                        String newId = "Contact" + IdGenerator.generate();
                        Node oldNode = iter.nextNode();
                        contactHomeNode.getSession().getWorkspace().copy(srcHomeNode.getPath() + "/" + oldNode.getProperty("exo:id").getString(), contactHomeNode.getPath() + "/" + newId);
                        Node newNode = contactHomeNode.getNode(newId);
                        newNode.setProperty(PROP_ADDRESSBOOK_REFS, new String[]{destAddress});
                        newNode.setProperty("exo:id", newId);
                        newNode.setProperty("exo:isOwner", false);
                        newNode.setProperty("exo:editPermissionUsers", new String[0]);
                        newNode.setProperty("exo:viewPermissionUsers", new String[0]);
                        newNode.setProperty("exo:editPermissionGroups", new String[0]);
                        newNode.setProperty("exo:viewPermissionGroups", new String[0]);
                    }
                    contactHomeNode.getSession().save();
                    break;
                }
            }
            finally {
                if (sysProvider != null) {
                    sysProvider.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteAddressBook(String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        block6: {
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            try {
                if (srcType.equals(PERSONAL)) {
                    Node contactHome = this.getPersonalContactsHome(sysProvider, username);
                    QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
                    StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                    Query query = qm.createQuery(queryString.toString(), "xpath");
                    QueryResult result = query.execute();
                    NodeIterator iter = result.getNodes();
                    this.copyNodes(sysProvider, username, contactHome, iter, destAddress, destType);
                    break block6;
                }
                if (srcType.equals(SHARED)) {
                    Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                    PropertyIterator proIter = sharedAddressBookMock.getReferences();
                    while (proIter.hasNext()) {
                        Node addressBook = proIter.nextProperty().getParent();
                        if (!addressBook.getName().equals(srcAddress)) continue;
                        Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                        QueryManager qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                        Query query = qm.createQuery(queryString.toString(), "xpath");
                        QueryResult result = query.execute();
                        NodeIterator iter = result.getNodes();
                        this.copyNodes(sysProvider, username, contactHomeNode, iter, destAddress, destType);
                        break block6;
                    }
                    break block6;
                }
                String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                Node publicContactHome = this.getPublicContactsHome(sysProvider);
                QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                this.copyNodes(sysProvider, username, publicContactHome, iter, destAddress, destType);
            }
            finally {
                sysProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> pasteContacts(String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        SessionProvider sProvider = null;
        try {
            sProvider = this.createSystemProvider();
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            ArrayList<Contact> pastedContacts = new ArrayList<Contact>();
            for (String contactId : contactsMap.keySet()) {
                String type = contactsMap.get(contactId);
                Contact contact = null;
                if (type.equals(PERSONAL)) {
                    contact = this.loadPersonalContact(username, contactId);
                } else if (type.equals(PUBLIC)) {
                    contact = this.loadPublicContactByUser(contactId);
                } else {
                    contact = this.getSharedContact(username, contactId);
                    if (contact == null) {
                        contact = this.getSharedContactAddressBook(username, contactId);
                    }
                }
                if (contact == null) continue;
                contacts.add(contact);
            }
            block4: for (Contact contact : contacts) {
                if (destType.equals(PERSONAL)) {
                    Node contactHomeNode = this.getPersonalContactsHome(sProvider, username);
                    pastedContacts.add(this.getContact(this.saveCopyContact(contactHomeNode, contact, destAddress, destType), destType));
                    continue;
                }
                if (!destType.equals(SHARED)) continue;
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                PropertyIterator iter = sharedAddressBookMock.getReferences();
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    if (!addressBook.getName().equals(destAddress)) continue;
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    pastedContacts.add(this.getContact(this.saveCopyContact(contactHomeNode, contact, destAddress, destType), destType));
                    continue block4;
                }
            }
            ArrayList<Contact> arrayList = pastedContacts;
            return arrayList;
        }
        finally {
            this.closeSessionProvider(sProvider);
        }
    }

    private Node saveCopyContact(Node contactHomeNode, Contact contact, String destAddress, String destType) throws Exception {
        ContactAttachment attachment;
        String newId = "Contact" + IdGenerator.generate();
        Node contactNode = contactHomeNode.addNode(newId, "exo:contact");
        contactNode.setProperty("exo:id", newId);
        contactNode.setProperty("exo:fullName", contact.getFullName());
        contactNode.setProperty("exo:firstName", contact.getFirstName());
        contactNode.setProperty("exo:lastName", contact.getLastName());
        contactNode.setProperty("exo:nickName", contact.getNickName());
        contactNode.setProperty("exo:gender", contact.getGender());
        GregorianCalendar dateTime = new GregorianCalendar();
        Date birthday = contact.getBirthday();
        if (birthday != null) {
            dateTime.setTime(birthday);
            contactNode.setProperty("exo:birthday", (Calendar)dateTime);
        }
        contactNode.setProperty("exo:jobTitle", contact.getJobTitle());
        contactNode.setProperty("exo:emailAddress", contact.getEmailAddress());
        contactNode.setProperty("exo:exoId", contact.getExoId());
        contactNode.setProperty("exo:googleId", contact.getGoogleId());
        contactNode.setProperty("exo:msnId", contact.getMsnId());
        contactNode.setProperty("exo:aolId", contact.getAolId());
        contactNode.setProperty("exo:yahooId", contact.getYahooId());
        contactNode.setProperty("exo:icrId", contact.getIcrId());
        contactNode.setProperty("exo:skypeId", contact.getSkypeId());
        contactNode.setProperty("exo:icqId", contact.getIcqId());
        contactNode.setProperty("exo:homeAddress", contact.getHomeAddress());
        contactNode.setProperty("exo:homeCity", contact.getHomeCity());
        contactNode.setProperty("exo:homeState_province", contact.getHomeState_province());
        contactNode.setProperty("exo:homePostalCode", contact.getHomePostalCode());
        contactNode.setProperty("exo:homeCountry", contact.getHomeCountry());
        contactNode.setProperty("exo:homePhone1", contact.getHomePhone1());
        contactNode.setProperty("exo:homePhone2", contact.getHomePhone2());
        contactNode.setProperty("exo:homeFax", contact.getHomeFax());
        contactNode.setProperty("exo:personalSite", contact.getPersonalSite());
        contactNode.setProperty("exo:workAddress", contact.getWorkAddress());
        contactNode.setProperty("exo:workCity", contact.getWorkCity());
        contactNode.setProperty("exo:workState_province", contact.getWorkStateProvince());
        contactNode.setProperty("exo:workPostalCode", contact.getWorkPostalCode());
        contactNode.setProperty("exo:workCountry", contact.getWorkCountry());
        contactNode.setProperty("exo:workPhone1", contact.getWorkPhone1());
        contactNode.setProperty("exo:workPhone2", contact.getWorkPhone2());
        contactNode.setProperty("exo:workFax", contact.getWorkFax());
        contactNode.setProperty("exo:mobilePhone", contact.getMobilePhone());
        contactNode.setProperty("exo:webPage", contact.getWebPage());
        contactNode.setProperty("exo:note", contact.getNote());
        contactNode.setProperty("exo:tags", contact.getTags());
        contactNode.setProperty(PROP_ADDRESSBOOK_REFS, new String[]{destAddress});
        if (contact.getLastUpdated() != null) {
            dateTime.setTime(contact.getLastUpdated());
            contactNode.setProperty("exo:lastUpdated", (Calendar)dateTime);
        }
        if ((attachment = contact.getAttachment()) != null) {
            if (attachment.getFileName() != null) {
                ExtendedNode extNode = (ExtendedNode)contactNode;
                if (extNode.canAddMixin("exo:privilegeable")) {
                    extNode.addMixin("exo:privilegeable");
                }
                String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                extNode.setPermission(SystemIdentity.ANY, arrayPers);
                List permsList = extNode.getACL().getPermissionEntries();
                for (AccessControlEntry accessControlEntry : permsList) {
                    extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                }
                Node nodeFile = null;
                try {
                    nodeFile = contactNode.getNode("image");
                }
                catch (PathNotFoundException ex) {
                    nodeFile = contactNode.addNode("image", "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                nodeContent.setProperty("jcr:data", attachment.getInputStream());
                nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            }
        } else if (contactNode.hasNode("image")) {
            contactNode.getNode("image").remove();
        }
        contactHomeNode.getSession().save();
        return contactNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewUser(User user, boolean isNew) throws Exception {
        Contact contact = null;
        contact = isNew ? new Contact() : this.loadPublicContactByUser(user.getUserName());
        if (contact != null) {
            contact.setFullName(user.getFirstName() + " " + user.getLastName());
            contact.setFirstName(user.getFirstName());
            contact.setLastName(user.getLastName());
            contact.setEmailAddress(user.getEmail());
            GregorianCalendar cal = new GregorianCalendar();
            contact.setLastUpdated(cal.getTime());
        }
        SessionProvider sysProvider = this.createSystemProvider();
        try {
            if (isNew) {
                Object[] groupsOfUser;
                Node addressHome = this.getPersonalAddressBooksHome(sysProvider, user.getUserName());
                AddressBook addressbook = new AddressBook();
                addressbook.setId(NewUserListener.DEFAULTGROUP + user.getUserName());
                addressbook.setName(NewUserListener.DEFAULTGROUPNAME);
                addressbook.setDescription(NewUserListener.DEFAULTGROUPDES);
                Node groupNode = addressHome.addNode(addressbook.getId(), "exo:contactGroup");
                groupNode.setProperty("exo:id", addressbook.getId());
                groupNode.setProperty("exo:name", addressbook.getName());
                groupNode.setProperty("exo:description", addressbook.getDescription());
                groupNode.setProperty("exo:editPermissionUsers", addressbook.getEditPermissionUsers());
                groupNode.setProperty("exo:viewPermissionUsers", addressbook.getViewPermissionUsers());
                groupNode.setProperty("exo:editPermissionGroups", addressbook.getEditPermissionGroups());
                groupNode.setProperty("exo:viewPermissionGroups", addressbook.getViewPermissionGroups());
                Node addressesGroup = addressHome.addNode(NewUserListener.ADDRESSESGROUP + user.getUserName(), "exo:contactGroup");
                addressesGroup.setProperty("exo:id", NewUserListener.ADDRESSESGROUP + user.getUserName());
                addressesGroup.setProperty("exo:name", NewUserListener.ADDRESSESGROUPNAME);
                addressHome.getSession().save();
                contact.setId(user.getUserName());
                LinkedHashMap<String, String> groupIds = new LinkedHashMap<String, String>();
                groupIds.put(addressbook.getId(), addressbook.getId());
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                for (Object object : groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(user.getUserName()).toArray()) {
                    String id = ((GroupImpl)object).getId();
                    groupIds.put(id, id);
                }
                contact.setAddressBookIds(groupIds.keySet().toArray(new String[0]));
                contact.setOwner(true);
                contact.setOwnerId(user.getUserName());
                this.saveContact(user.getUserName(), contact, true);
                JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_);
                Node publicContactHome = storage_.getPublicContactsHome(sysProvider);
                String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
                QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
                ArrayList<String> recievedUser = new ArrayList<String>();
                recievedUser.add(user.getUserName());
                for (Object object : groupsOfUser) {
                    String groupId = ((GroupImpl)object).getId();
                    StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(groupId + "']");
                    Query query = qm.createQuery(queryString.toString(), "xpath");
                    QueryResult result = query.execute();
                    NodeIterator nodes = result.getNodes();
                    while (nodes.hasNext()) {
                        Node addressBook = nodes.nextNode();
                        storage_.shareAddressBook(addressBook.getProperty("exo:sharedUserId").getString(), addressBook.getProperty("exo:id").getString(), recievedUser);
                    }
                    queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(groupId + "']");
                    query = qm.createQuery(queryString.toString(), "xpath");
                    result = query.execute();
                    nodes = result.getNodes();
                    while (nodes.hasNext()) {
                        Node contactNode = nodes.nextNode();
                        String split = "/";
                        String temp = contactNode.getPath().split(usersPath)[1];
                        String userId = temp.split(split)[1];
                        storage_.shareContact(userId, new String[]{contactNode.getProperty("exo:id").getString()}, recievedUser);
                    }
                }
                Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sysProvider, user.getUserName());
                userApp.getSession().save();
            } else if (contact != null) {
                this.saveContact(user.getUserName(), contact, false);
            }
        }
        finally {
            this.closeSessionProvider(sysProvider);
        }
    }

    private SessionProvider createSessionProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        SessionProvider provider = service.getSessionProvider(null);
        if (provider == null) {
            log.info((Object)"No user session provider was available, using a system session provider");
            provider = service.getSystemSessionProvider(null);
        }
        return provider;
    }

    private SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    private void closeSessionProvider(SessionProvider sessionProvider) {
        if (sessionProvider != null) {
            sessionProvider.close();
        }
    }

    public void saveAddress(String username, String emailAddress) throws Exception {
        ContactFilter filter = new ContactFilter();
        for (String email : Utils.parseEmails(emailAddress)) {
            filter.setEmailAddress(email);
            if (this.searchContact(username, filter).getAll().size() != 0) continue;
            Contact contact = new Contact();
            String name = email.split("@")[0];
            contact.setLastName(name);
            contact.setFullName(name);
            contact.setEmailAddress(email);
            contact.setAddressBookIds(new String[]{NewUserListener.ADDRESSESGROUP + username});
            this.saveContact(username, contact, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AddressBookType {
        Personal,
        Shared,
        Public;

    }
}

