/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class ContactAttachment {
    private String id;
    private String fileName;
    private String mimeType;
    private String workspace;
    private byte[] imageBytes;

    public String getDataPath() throws Exception {
        Node attachmentData;
        try {
            attachmentData = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return attachmentData.getPath();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String ws) {
        this.workspace = ws;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String s) {
        this.fileName = s;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String s) {
        this.mimeType = s;
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    public InputStream getInputStream() throws Exception {
        Node attachment;
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        try {
            attachment = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        return attachment.getNode("jcr:content").getProperty("jcr:data").getStream();
    }

    private Session getSesison() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getDefaultRepository().getSystemSession(this.workspace);
    }
}

