/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.GroupContactData;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.AddressBookNotFoundException;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage
implements DataStorage {
    private static final String PROP_ADDRESSBOOK_REFS = "exo:categories";
    private static final String CONTACTS = "contacts".intern();
    private static final String PERSONAL_ADDRESS_BOOKS = "contactGroup".intern();
    private static final String GROUP_ADDRESS_BOOKS = "GroupAddress".intern();
    private static final String TAGS = "tags".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String CONTACT_APP = "ContactApplication".intern();
    private static final String SHARED_HOME = "Shared".intern();
    private static final String SHARED_CONTACT = "SharedContact".intern();
    private static final String SHARED_ADDRESSBOOK = "SharedAddressBook".intern();
    private static final String SHARED_MIXIN = "exo:contactShared".intern();
    private static final String SHARED_PROP = "exo:sharedId".intern();
    private static Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repoService_;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repoService_ = repoService;
    }

    @Override
    public Node getSharedContact(String userId) throws Exception {
        Node sharedHome;
        Node contactHome = this.getContactUserDataHome(userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            return sharedHome.getNode(SHARED_CONTACT);
        }
        catch (PathNotFoundException ex) {
            Node sharedContact = sharedHome.addNode(SHARED_CONTACT, NT_UNSTRUCTURED);
            if (sharedContact.canAddMixin("mix:referenceable")) {
                sharedContact.addMixin("mix:referenceable");
            }
            sharedHome.save();
            return sharedContact;
        }
    }

    @Override
    public Node getSharedAddressBooksHome(String userId) throws Exception {
        Node sharedHome;
        Node contactHome = this.getContactUserDataHome(userId);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        try {
            return sharedHome.getNode(SHARED_ADDRESSBOOK);
        }
        catch (PathNotFoundException ex) {
            Node sharedAddressBooksHome = sharedHome.addNode(SHARED_ADDRESSBOOK, NT_UNSTRUCTURED);
            if (sharedAddressBooksHome.canAddMixin("mix:referenceable")) {
                sharedAddressBooksHome.addMixin("mix:referenceable");
            }
            sharedHome.save();
            return sharedAddressBooksHome;
        }
    }

    @Override
    public Contact loadPublicContactByUser(String userId) throws Exception {
        try {
            Node contactHomeNode = this.getPersonalContactsHome(userId);
            return Utils.getContact(contactHomeNode.getNode(userId), PUBLIC);
        }
        catch (PathNotFoundException e) {
            log.error((Object)("Public contact " + userId + " not found"));
            return null;
        }
    }

    @Override
    public List<Contact> findAllContactsByOwner(String username) throws Exception {
        Node contactHomeNode = this.getPersonalContactsHome(username);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        NodeIterator iter = contactHomeNode.getNodes();
        while (iter.hasNext()) {
            Node contactNode = iter.nextNode();
            Contact contact = Utils.getContact(contactNode, PERSONAL);
            contacts.add(contact);
        }
        return contacts;
    }

    @Override
    public ContactPageList findContactsByFilter(String username, ContactFilter filter, String type) throws Exception {
        boolean canfind = false;
        if (type.equals(PERSONAL)) {
            Node contactHomeNode = this.getPersonalContactsHome(username);
            filter.setAccountPath(contactHomeNode.getPath());
            canfind = true;
        } else if (type.equals(PUBLIC)) {
            Node publicContactHomeNode = this.getPublicContactsHome();
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            filter.setAccountPath(usersPath);
            canfind = true;
        } else if (type.equals(SHARED)) {
            Node sharedAddressBookHolder = this.getSharedAddressBooksHome(username);
            PropertyIterator iter = sharedAddressBookHolder.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                if (!addressBook.getName().equals(filter.getCategories()[0])) continue;
                Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                filter.setAccountPath(contacts.getPath());
                canfind = true;
                break;
            }
        }
        if (canfind) {
            return new ContactPageList(username, 10L, filter.getStatement(), type);
        }
        return null;
    }

    @Override
    public Contact loadPersonalContact(String ownerUserId, String contactId) throws Exception {
        Node contactHomeNode = this.getPersonalContactsHome(ownerUserId);
        try {
            return Utils.getContact(contactHomeNode.getNode(contactId), PERSONAL);
        }
        catch (PathNotFoundException ex) {
            return null;
        }
    }

    @Override
    public ContactPageList findPersonalContactsByAddressBook(String owner, String addressBookId) throws Exception {
        Node userContactsHome = this.getPersonalContactsHome(owner);
        String queryString = new StringBuffer("/jcr:root" + userContactsHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(addressBookId).append("']").append("order by @exo:fullName,@exo:id ascending").toString();
        ContactPageList pageList = new ContactPageList(owner, 10L, queryString, PERSONAL);
        return pageList;
    }

    @Override
    public List<String> findEmailsByAddressBook(String username, String addressBookId) throws AddressBookNotFoundException, Exception {
        DataStorage.AddressBookType type = this.getAddressBookType(username, addressBookId);
        if (type == DataStorage.AddressBookType.Personal) {
            return this.findEmailsInPersonalAddressBook(username, addressBookId);
        }
        if (type == DataStorage.AddressBookType.Shared) {
            return this.findEmailsInPersonalAddressBook(username, addressBookId);
        }
        if (type == DataStorage.AddressBookType.Public) {
            return this.findEmailsInPublicAddressBook(username, addressBookId);
        }
        throw new AddressBookNotFoundException(addressBookId);
    }

    @Override
    public DataStorage.AddressBookType getAddressBookType(String username, String addressBookId) throws Exception {
        AddressBook shared = this.getSharedAddressBookById(username, addressBookId);
        if (shared != null) {
            return DataStorage.AddressBookType.Shared;
        }
        AddressBook personal = this.findPersonalAddressBookById(username, addressBookId);
        if (personal != null) {
            return DataStorage.AddressBookType.Personal;
        }
        return null;
    }

    @Override
    public AddressBook findPersonalAddressBookById(String username, String addressBookId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> findEmailsInPersonalAddressBook(String username, String addressBookId) throws Exception {
        Node contactHome = this.getPersonalContactsHome(username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(addressBookId).append("']");
        NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
        return this.getEmails(it);
    }

    private List<String> getEmails(NodeIterator it) throws Exception {
        ArrayList<String> address = new ArrayList<String>();
        while (it.hasNext()) {
            String emails;
            Node contact = it.nextNode();
            if (!contact.hasProperty("exo:emailAddress") || Utils.isEmpty(emails = Utils.valuesToString(contact.getProperty("exo:emailAddress").getValues()))) continue;
            address.add(emails.split(",")[0].split(";")[0]);
        }
        return address;
    }

    @Override
    public List<String> findEmailsInPublicAddressBook(String username, String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        QueryManager qm = this.getSession(this.createSystemProvider()).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
        NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
        return this.getEmails(it);
    }

    @Override
    public List<String> getAllEmailBySharedGroup(String username, String addressBookId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        QueryManager qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            StringBuffer queryString = new StringBuffer("/jcr:root" + addressBook.getParent().getParent().getNode(CONTACTS).getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBookId).append("')]");
            NodeIterator it = qm.createQuery(queryString.toString(), "xpath").execute().getNodes();
            return this.getEmails(it);
        }
        return null;
    }

    @Override
    public AddressBook toAddressBook(Node contactGroupNode) throws Exception {
        AddressBook contactGroup = new AddressBook();
        if (contactGroupNode.hasProperty("exo:id")) {
            contactGroup.setId(Utils.decodeGroupId(contactGroupNode.getProperty("exo:id").getString()));
        }
        if (contactGroupNode.hasProperty("exo:name")) {
            contactGroup.setName(contactGroupNode.getProperty("exo:name").getString());
        }
        if (contactGroupNode.hasProperty("exo:description")) {
            contactGroup.setDescription(contactGroupNode.getProperty("exo:description").getString());
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionUsers")) {
            contactGroup.setViewPermissionUsers(Utils.valuesToStringArray(contactGroupNode.getProperty("exo:viewPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionUsers")) {
            contactGroup.setEditPermissionUsers(Utils.valuesToStringArray(contactGroupNode.getProperty("exo:editPermissionUsers").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:viewPermissionGroups")) {
            contactGroup.setViewPermissionGroups(Utils.valuesToStringArray(contactGroupNode.getProperty("exo:viewPermissionGroups").getValues()));
        }
        if (contactGroupNode.hasProperty("exo:editPermissionGroups")) {
            contactGroup.setEditPermissionGroups(Utils.valuesToStringArray(contactGroupNode.getProperty("exo:editPermissionGroups").getValues()));
        }
        return contactGroup;
    }

    @Override
    public AddressBook loadPersonalAddressBook(String username, String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        Node contactGroupHomeNode = this.getPersonalAddressBooksHome(username);
        if (contactGroupHomeNode.hasNode(groupId)) {
            return this.toAddressBook(contactGroupHomeNode.getNode(groupId));
        }
        return null;
    }

    @Override
    public AddressBook loadPublicAddressBook(String username, String groupId) throws Exception {
        if (groupId == null) {
            return null;
        }
        Node contactGroupHomeNode = this.getPublicAddressHome();
        if (contactGroupHomeNode.hasNode(Utils.encodeGroupId(groupId))) {
            return this.toAddressBook(contactGroupHomeNode.getNode(Utils.encodeGroupId(groupId)));
        }
        return null;
    }

    @Override
    public AddressBook getSharedAddressBookById(String username, String addressBookId) throws Exception {
        Node sharedAddressBookNode = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookNode.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            return this.toAddressBook(addressBook);
        }
        return null;
    }

    @Override
    public List<AddressBook> findPersonalAddressBooksByOwner(String username) throws Exception {
        Node addressBooksHome = this.getPersonalAddressBooksHome(username);
        ArrayList<AddressBook> addressBooks = new ArrayList<AddressBook>();
        NodeIterator iter = addressBooksHome.getNodes();
        while (iter.hasNext()) {
            Node addressBook = iter.nextNode();
            addressBooks.add(this.toAddressBook(addressBook));
        }
        return addressBooks;
    }

    @Override
    public List<String> getPublicAddresses(String username) throws Exception {
        ArrayList<String> groupIds;
        if (username == null) {
            Identity identity = ConversationState.getCurrent().getIdentity();
            groupIds = new ArrayList<String>(identity.getGroups());
        } else {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(username).toArray();
            groupIds = new ArrayList();
            for (Object object : objGroupIds) {
                groupIds.add(((Group)object).getId());
            }
        }
        Node addressBooksHome = this.getPublicAddressHome();
        ArrayList<String> addressBooks = new ArrayList<String>();
        NodeIterator iter = addressBooksHome.getNodes();
        block1: while (iter.hasNext()) {
            String[] viewGroups;
            String[] viewUsers;
            Node addressBook = iter.nextNode();
            String id = Utils.decodeGroupId(addressBook.getProperty("exo:id").getString());
            if (addressBook.hasProperty("exo:viewPermissionUsers") && (viewUsers = Utils.valuesToStringArray(addressBook.getProperty("exo:viewPermissionUsers").getValues())).length > 0 && Arrays.asList(viewUsers).contains(username) && !addressBooks.contains(id)) {
                addressBooks.add(id);
            }
            if (!addressBook.hasProperty("exo:viewPermissionGroups")) continue;
            for (String viewGroup : viewGroups = Utils.valuesToStringArray(addressBook.getProperty("exo:viewPermissionGroups").getValues())) {
                if (viewGroup.contains(Utils.COLON)) {
                    viewGroup = viewGroup.split(Utils.COLON)[0];
                }
                if (!groupIds.contains(viewGroup)) continue;
                if (addressBooks.contains(id)) continue block1;
                addressBooks.add(id);
                continue block1;
            }
        }
        return addressBooks;
    }

    @Override
    public List<Contact> removeContacts(String username, List<String> contactIds) throws Exception {
        Node contactHomeNode = this.getPersonalContactsHome(username);
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (String contactId : contactIds) {
            if (!contactHomeNode.hasNode(contactId)) continue;
            Contact contact = this.loadPersonalContact(username, contactId);
            contactHomeNode.getNode(contactId).remove();
            contactHomeNode.getSession().save();
            contacts.add(contact);
        }
        return contacts;
    }

    @Override
    public void moveContacts(String username, List<Contact> contacts, String addressType) throws Exception {
        Node publicContactHome = this.getPersonalContactsHome(username);
        for (Contact contact : contacts) {
            if (addressType.equals(PERSONAL)) {
                this.saveContactUser(username, contact, false);
                continue;
            }
            if (!addressType.equals(SHARED)) continue;
            if (!this.haveEditPermissionOnAddressBook(username, contact.getAddressBookIds()[0]) || contact.getContactType().equals(SHARED) && !this.haveEditPermissionOnContact(username, contact)) {
                log.info((Object)"\n Do not have edit permission. \n");
                throw new Exception();
            }
            this.saveContactToSharedAddressBook(username, contact.getAddressBookIds()[0], contact, true);
            if (!publicContactHome.hasNode(contact.getId())) continue;
            publicContactHome.getNode(contact.getId()).remove();
        }
        if (publicContactHome.getSession().hasPendingChanges()) {
            publicContactHome.getSession().save();
        }
    }

    @Override
    public AddressBook removePersonalAddressBook(String username, String addressBookId) throws Exception {
        Node addressBooksHomeNode = this.getPersonalAddressBooksHome(username);
        if (addressBooksHomeNode.hasNode(addressBookId)) {
            AddressBook contactGroup = this.loadPersonalAddressBook(username, addressBookId);
            addressBooksHomeNode.getNode(addressBookId).remove();
            addressBooksHomeNode.save();
            addressBooksHomeNode.getSession().save();
            return contactGroup;
        }
        return null;
    }

    @Override
    public void clearAddressBook(String username, String addressBookId) throws Exception {
        List<String> contactIds = this.getUserContactNodesByGroup(username, addressBookId);
        this.removeContacts(username, contactIds);
    }

    @Override
    public void saveContact(String username, Contact contact, boolean isNew) throws Exception {
        Node contactHomeNode = this.getPersonalContactsHome(username);
        this.contactToNode(contactHomeNode, contact, isNew);
        contactHomeNode.getSession().save();
    }

    private void saveContactUser(String username, Contact contact, boolean isNew) throws Exception {
        Node contactHomeNode = this.getPersonalContactsHome(username);
        this.contactToNode(contactHomeNode, contact, isNew);
        contactHomeNode.getSession().save();
    }

    @Override
    public void savePersonalOrSharedAddressBook(String username, AddressBook addressbook, boolean isNew) throws Exception {
        Node groupNode = null;
        String id = addressbook.getId();
        if (isNew) {
            groupNode = this.getPersonalAddressBooksHome(username).addNode(id, "exo:contactGroup");
            groupNode.setProperty("exo:id", id);
        } else {
            try {
                groupNode = this.getPersonalAddressBooksHome(username).getNode(id);
            }
            catch (PathNotFoundException e) {
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                PropertyIterator iter = sharedAddressBookMock.getReferences();
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    if (!addressBook.getName().equals(id)) continue;
                    if (!this.haveEditPermissionOnAddressBook(username, addressbook.getId())) {
                        log.info((Object)"\n Do not have edit permission. \n");
                        throw new Exception();
                    }
                    groupNode = addressBook;
                    break;
                }
            }
        }
        if (groupNode == null && !isNew) {
            throw new PathNotFoundException("No personal or shared address book for user " + username + " was found with ID " + addressbook);
        }
        groupNode.setProperty("exo:name", addressbook.getName());
        groupNode.setProperty("exo:description", addressbook.getDescription());
        groupNode.setProperty("exo:editPermissionUsers", addressbook.getEditPermissionUsers());
        groupNode.setProperty("exo:viewPermissionUsers", addressbook.getViewPermissionUsers());
        groupNode.setProperty("exo:editPermissionGroups", addressbook.getEditPermissionGroups());
        groupNode.setProperty("exo:viewPermissionGroups", addressbook.getViewPermissionGroups());
        if (isNew) {
            groupNode.getSession().save();
        } else {
            groupNode.save();
        }
    }

    @Override
    public void savePublicAddressBook(AddressBook addressbook, boolean isNew) throws Exception {
        Node groupNode = null;
        String id = Utils.encodeGroupId(addressbook.getId());
        if (isNew) {
            groupNode = this.getPublicAddressHome().addNode(id, "exo:contactGroup");
            groupNode.setProperty("exo:id", id);
        } else {
            try {
                groupNode = this.getPublicAddressHome().getNode(id);
                if (groupNode == null) {
                    throw new PathNotFoundException("No address book was found with ID " + addressbook);
                }
            }
            catch (PathNotFoundException e) {
                log.error((Object)e.getMessage());
            }
        }
        groupNode.setProperty("exo:name", addressbook.getName());
        groupNode.setProperty("exo:description", addressbook.getDescription());
        groupNode.setProperty("exo:editPermissionUsers", addressbook.getEditPermissionUsers());
        groupNode.setProperty("exo:viewPermissionUsers", addressbook.getViewPermissionUsers());
        groupNode.setProperty("exo:editPermissionGroups", addressbook.getEditPermissionGroups());
        groupNode.setProperty("exo:viewPermissionGroups", addressbook.getViewPermissionGroups());
        if (isNew) {
            groupNode.getSession().save();
        } else {
            groupNode.save();
        }
    }

    @Override
    public void removeUserShareContact(String username, String contactId, String removedUser) throws Exception {
        String[] viewPer;
        Node contactNode;
        String split = "/";
        if (username.split(split).length > 1) {
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            String temp = username.split(usersPath)[1];
            String userId = temp.split(split)[1];
            contactNode = this.getPersonalContactsHome(userId).getNode(contactId);
        } else {
            contactNode = this.getPersonalContactsHome(username).getNode(contactId);
        }
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(Utils.valuesToStringArray(contactNode.getProperty(SHARED_PROP).getValues())));
        ArrayList<String> newValues = new ArrayList<String>(values);
        Node sharedContact = this.getSharedContact(removedUser);
        for (String value : values) {
            Node refNode = sharedContact.getSession().getNodeByUUID(value);
            if (!refNode.getPath().equals(sharedContact.getPath())) continue;
            newValues.remove(value);
        }
        if (contactNode.hasProperty("exo:viewPermissionUsers") && (viewPer = Utils.valuesToStringArray(contactNode.getProperty("exo:viewPermissionUsers").getValues())) != null) {
            String[] editPer;
            ArrayList<String> newViewPer = new ArrayList<String>();
            newViewPer.addAll(Arrays.asList(viewPer));
            newViewPer.remove(removedUser + HYPHEN);
            contactNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
            if (contactNode.hasProperty("exo:editPermissionUsers") && (editPer = Utils.valuesToStringArray(contactNode.getProperty("exo:editPermissionUsers").getValues())) != null) {
                ArrayList<String> newEditPer = new ArrayList<String>();
                newEditPer.addAll(Arrays.asList(editPer));
                newEditPer.remove(removedUser + HYPHEN);
                contactNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
            }
        }
        contactNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
        contactNode.save();
        contactNode.getSession().save();
    }

    @Override
    public void unshareAddressBook(String username, String addressBookId, String removedUser) throws Exception {
        Node addressBookNode = this.getPersonalAddressBooksHome(username).getNode(addressBookId);
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(Utils.valuesToStringArray(addressBookNode.getProperty(SHARED_PROP).getValues())));
        ArrayList<String> newValues = new ArrayList<String>(values);
        Node sharedAddress = this.getSharedAddressBooksHome(removedUser);
        for (String value : values) {
            Node refNode = sharedAddress.getSession().getNodeByUUID(value);
            if (!refNode.getPath().equals(sharedAddress.getPath())) continue;
            newValues.remove(value);
        }
        String[] viewPer = null;
        if (addressBookNode.hasProperty("exo:viewPermissionUsers")) {
            viewPer = Utils.valuesToStringArray(addressBookNode.getProperty("exo:viewPermissionUsers").getValues());
        }
        if (viewPer != null) {
            ArrayList<String> newViewPer = new ArrayList<String>();
            newViewPer.addAll(Arrays.asList(viewPer));
            newViewPer.remove(removedUser + HYPHEN);
            addressBookNode.setProperty("exo:viewPermissionUsers", newViewPer.toArray(new String[0]));
            String[] editPer = null;
            if (addressBookNode.hasProperty("exo:editPermissionUsers")) {
                editPer = Utils.valuesToStringArray(addressBookNode.getProperty("exo:editPermissionUsers").getValues());
            }
            if (editPer != null) {
                ArrayList<String> newEditPer = new ArrayList<String>();
                newEditPer.addAll(Arrays.asList(editPer));
                newEditPer.remove(removedUser + HYPHEN);
                addressBookNode.setProperty("exo:editPermissionUsers", newEditPer.toArray(new String[0]));
            }
        }
        addressBookNode.setProperty(SHARED_PROP, newValues.toArray(new String[0]));
        addressBookNode.save();
        addressBookNode.getSession().save();
    }

    @Override
    public void shareAddressBook(String username, String addressBookId, List<String> receiveUsers) throws Exception {
        Node addressBookNode = this.getPersonalAddressBooksHome(username).getNode(addressBookId);
        Value[] values = new Value[]{};
        if (addressBookNode.isNodeType(SHARED_MIXIN)) {
            values = addressBookNode.getProperty(SHARED_PROP).getValues();
        } else {
            addressBookNode.addMixin(SHARED_MIXIN);
            addressBookNode.setProperty("exo:sharedUserId", username);
        }
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (String userId : receiveUsers) {
            Node sharedAddress = this.getSharedAddressBooksHome(userId.replaceFirst(DataStorage.HYPHEN, ""));
            boolean isExist = false;
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = sharedAddress.getSession().getNodeByUUID(uuid);
                if (refNode.getPath().equals(sharedAddress.getPath())) {
                    isExist = true;
                    break;
                }
                valueList.add(value);
            }
            if (isExist) continue;
            Value value2add = addressBookNode.getSession().getValueFactory().createValue(sharedAddress);
            valueList.add(value2add);
        }
        if (valueList.size() > 0) {
            LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
            for (Value value : values) {
                newValue.put(value.getString(), value);
            }
            for (Value value : valueList) {
                newValue.put(value.getString(), value);
            }
            addressBookNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
        } else {
            try {
                addressBookNode.getProperty(SHARED_PROP);
            }
            catch (PathNotFoundException e) {
                addressBookNode.setProperty(SHARED_PROP, new Value[0]);
            }
        }
        addressBookNode.save();
        addressBookNode.getSession().save();
    }

    @Override
    public void shareContact(String username, String[] contactIds, List<String> receiveUsers) throws Exception {
        for (String contactId : contactIds) {
            Node contactNode = this.getPersonalContactsHome(username).getNode(contactId);
            Value[] values = new Value[]{};
            if (contactNode.isNodeType(SHARED_MIXIN)) {
                values = contactNode.getProperty(SHARED_PROP).getValues();
            } else {
                contactNode.addMixin(SHARED_MIXIN);
                contactNode.setProperty("exo:sharedUserId", username);
            }
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (String user : receiveUsers) {
                Node sharedContact = this.getSharedContact(user.replaceFirst(DataStorage.HYPHEN, ""));
                boolean isExist = false;
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    String uuid = value.getString();
                    Node refNode = sharedContact.getSession().getNodeByUUID(uuid);
                    if (refNode.getPath().equals(sharedContact.getPath())) {
                        isExist = true;
                        break;
                    }
                    valueList.add(value);
                }
                if (isExist) continue;
                Value value2add = contactNode.getSession().getValueFactory().createValue(sharedContact);
                valueList.add(value2add);
            }
            if (valueList.size() <= 0) continue;
            LinkedHashMap<String, Value> newValue = new LinkedHashMap<String, Value>();
            for (Value value : values) {
                newValue.put(value.getString(), value);
            }
            for (Value value : valueList) {
                newValue.put(value.getString(), value);
            }
            contactNode.setProperty(SHARED_PROP, newValue.values().toArray(new Value[newValue.size()]));
            contactNode.save();
            contactNode.getSession().save();
        }
    }

    @Override
    public List<SharedAddressBook> findSharedAddressBooksByUser(String username) throws Exception {
        ArrayList<SharedAddressBook> addressBooks = new ArrayList<SharedAddressBook>();
        Node sharedAddress = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddress.getReferences();
        while (iter.hasNext()) {
            try {
                Node addressNode = iter.nextProperty().getParent();
                SharedAddressBook sharedAddressBook = new SharedAddressBook(addressNode.getProperty("exo:name").getString(), addressNode.getName(), addressNode.getProperty("exo:sharedUserId").getString());
                if (addressNode.hasProperty("exo:editPermissionUsers")) {
                    sharedAddressBook.setEditPermissionUsers(Utils.valuesToStringArray(addressNode.getProperty("exo:editPermissionUsers").getValues()));
                }
                if (addressNode.hasProperty("exo:editPermissionGroups")) {
                    sharedAddressBook.setEditPermissionGroups(Utils.valuesToStringArray(addressNode.getProperty("exo:editPermissionGroups").getValues()));
                }
                addressBooks.add(sharedAddressBook);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method findSharedAddressBooksByUser", (Throwable)e);
            }
        }
        return addressBooks;
    }

    @Override
    public void removeSharedContact(String username, String addressBookId, String contactId) throws Exception {
        if (!this.haveEditPermissionOnAddressBook(username, addressBookId)) {
            log.info((Object)"\n Do not have edit permission. \n");
            throw new Exception();
        }
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter2 = sharedAddressBookMock.getReferences();
        while (iter2.hasNext()) {
            Node addressBook = iter2.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                contactHomeNode.getNode(contactId).remove();
                contactHomeNode.getSession().save();
                break;
            }
            catch (PathNotFoundException e) {
                log.warn((Object)String.format("Failed to get shared contact with id %s in address book %s belongs to user %s", contactId, addressBookId, username), (Throwable)e);
            }
        }
    }

    @Override
    public Contact getSharedContact(String username, String contactId) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contactId)) continue;
                Contact contact = Utils.getContact(contactNode, DataStorage.SHARED);
                if (contactNode.hasProperty("exo:sharedUserId")) {
                    contact.setAuthor(contactNode.getProperty("exo:sharedUserId").getString());
                }
                return contact;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method getSharedContact", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public DataPageList getSharedContacts(String username) throws Exception {
        ArrayList<Contact> sharedContacts = new ArrayList<Contact>();
        Node sharedContact = this.getSharedContact(username);
        PropertyIterator iter = sharedContact.getReferences();
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                Contact contact = Utils.getContact(contactNode, SHARED);
                if (contactNode.hasProperty("exo:sharedUserId")) {
                    contact.setAuthor(contactNode.getProperty("exo:sharedUserId").getString());
                }
                sharedContacts.add(contact);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method getSharedContacts", (Throwable)e);
            }
        }
        return new DataPageList(sharedContacts, 10L, null, false);
    }

    @Override
    public void saveSharedContact(String username, Contact contact) throws Exception {
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        boolean isEdit = false;
        while (iter.hasNext()) {
            try {
                Node contactNode = iter.nextProperty().getParent();
                if (!contactNode.getName().equals(contact.getId())) continue;
                if (!this.haveEditPermissionOnAddressBook(username, contact.getAddressBookIds()[0]) && !this.haveEditPermissionOnContact(username, contact)) {
                    log.info((Object)"\n Do not have edit permission. \n");
                    throw new Exception();
                }
                isEdit = true;
                this.contactToNode(contactNode.getParent(), contact, false);
                contactNode.getParent().getSession().save();
                return;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method saveSharedContact", (Throwable)e);
            }
        }
        if (!isEdit) {
            throw new PathNotFoundException();
        }
    }

    @Override
    public void saveContactToSharedAddressBook(String username, String addressBookId, Contact contact, boolean isNew) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            if (!addressBook.getName().equals(addressBookId)) continue;
            if (!this.haveEditPermissionOnAddressBook(username, addressBookId) && !this.haveEditPermissionOnContact(username, contact)) {
                log.info((Object)"\n Do not have edit permission. \n");
                throw new Exception();
            }
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            contact.setOwner(false);
            this.contactToNode(contactHomeNode, contact, isNew);
            contactHomeNode.getSession().save();
            return;
        }
    }

    @Override
    public Contact getSharedContactAddressBook(String username, String contactId) throws Exception {
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            try {
                Node contactNode = contactHomeNode.getNode(contactId);
                if (!Arrays.asList(Utils.valuesToStringArray(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) continue;
                return Utils.getContact(contactNode, DataStorage.SHARED);
            }
            catch (PathNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Failed to get shared contact address book with id %s belongs to user %s", contactId, username), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public ContactPageList getSharedContactsByAddressBook(String username, SharedAddressBook addressBook) throws Exception {
        if (addressBook == null) {
            return null;
        }
        Node contactHome = this.getPersonalContactsHome(addressBook.getSharedUserId());
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[(@exo:categories='").append(addressBook.getId()).append("')]").append(" order by @exo:fullName,@exo:id ascending");
        return new ContactPageList(username, 10L, queryString.toString(), SHARED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContactPageList getPublicContactsByAddressBook(String groupId) throws Exception {
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("' and @exo:isOwner='true'] ").append("order by @exo:fullName,@exo:id ascending");
        ContactPageList contactPageList = new ContactPageList(null, 10L, queryString.toString(), PUBLIC);
        return contactPageList;
    }

    @Override
    public void addUserContactInAddressBook(String userId, String addressBookId) throws Exception {
        Node contactHome = this.getPersonalContactsHome(userId);
        Node contactNode = contactHome.getNode(userId);
        Value[] values = contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues();
        ArrayList<String> ls = new ArrayList<String>();
        for (Value vl : values) {
            if (vl.getString().equals(addressBookId)) {
                return;
            }
            ls.add(vl.getString());
        }
        ls.add(addressBookId);
        contactNode.setProperty(PROP_ADDRESSBOOK_REFS, ls.toArray(new String[0]));
        contactNode.save();
    }

    @Override
    public void contactToNode(Node contactsHome, Contact contact, boolean isNew) throws Exception {
        Node contactNode;
        if (isNew) {
            contactNode = contactsHome.addNode(contact.getId(), "exo:contact");
            contactNode.setProperty("exo:id", contact.getId());
            if (contact.isOwner()) {
                contactNode.setProperty("exo:isOwner", true);
                contactNode.setProperty("exo:ownerId", contact.getOwnerId());
            }
        } else {
            contactNode = contactsHome.getNode(contact.getId());
        }
        this.setContactNodeProperties(contactNode, contact);
    }

    private Node setContactNodeProperties(Node contactNode, Contact contact) throws Exception {
        ContactAttachment attachment;
        contactNode.setProperty("exo:fullName", contact.getFullName());
        contactNode.setProperty("exo:firstName", contact.getFirstName());
        contactNode.setProperty("exo:lastName", contact.getLastName());
        contactNode.setProperty("exo:nickName", contact.getNickName());
        contactNode.setProperty("exo:gender", contact.getGender());
        GregorianCalendar dateTime = new GregorianCalendar();
        Date birthday = contact.getBirthday();
        if (birthday != null) {
            dateTime.setTime(birthday);
            contactNode.setProperty("exo:birthday", (Calendar)dateTime);
        } else if (contactNode.hasProperty("exo:birthday")) {
            contactNode.getProperty("exo:birthday").remove();
        }
        contactNode.setProperty("exo:jobTitle", contact.getJobTitle());
        if (contact.getEmailAddresses() == null || contact.getEmailAddress().length() == 0) {
            contactNode.setProperty("exo:emailAddress", new String[]{""});
        } else {
            contactNode.setProperty("exo:emailAddress", contact.getEmailAddresses().toArray(new String[0]));
        }
        contactNode.setProperty("exo:exoId", contact.getExoId());
        contactNode.setProperty("exo:googleId", contact.getGoogleId());
        contactNode.setProperty("exo:msnId", contact.getMsnId());
        contactNode.setProperty("exo:aolId", contact.getAolId());
        contactNode.setProperty("exo:yahooId", contact.getYahooId());
        contactNode.setProperty("exo:icrId", contact.getIcrId());
        contactNode.setProperty("exo:skypeId", contact.getSkypeId());
        contactNode.setProperty("exo:icqId", contact.getIcqId());
        contactNode.setProperty("exo:homeAddress", contact.getHomeAddress());
        contactNode.setProperty("exo:homeCity", contact.getHomeCity());
        contactNode.setProperty("exo:homeState_province", contact.getHomeState_province());
        contactNode.setProperty("exo:homePostalCode", contact.getHomePostalCode());
        contactNode.setProperty("exo:homeCountry", contact.getHomeCountry());
        contactNode.setProperty("exo:homePhone1", contact.getHomePhone1());
        contactNode.setProperty("exo:homePhone2", contact.getHomePhone2());
        contactNode.setProperty("exo:homeFax", contact.getHomeFax());
        contactNode.setProperty("exo:personalSite", contact.getPersonalSite());
        contactNode.setProperty("exo:workAddress", contact.getWorkAddress());
        contactNode.setProperty("exo:workCity", contact.getWorkCity());
        contactNode.setProperty("exo:workState_province", contact.getWorkStateProvince());
        contactNode.setProperty("exo:workPostalCode", contact.getWorkPostalCode());
        contactNode.setProperty("exo:workCountry", contact.getWorkCountry());
        contactNode.setProperty("exo:workPhone1", contact.getWorkPhone1());
        contactNode.setProperty("exo:workPhone2", contact.getWorkPhone2());
        contactNode.setProperty("exo:workFax", contact.getWorkFax());
        contactNode.setProperty("exo:mobilePhone", contact.getMobilePhone());
        contactNode.setProperty("exo:webPage", contact.getWebPage());
        contactNode.setProperty("exo:note", contact.getNote());
        contactNode.setProperty(PROP_ADDRESSBOOK_REFS, contact.getAddressBookIds());
        contactNode.setProperty("exo:tags", contact.getTags());
        contactNode.setProperty("exo:editPermissionUsers", contact.getEditPermissionUsers());
        contactNode.setProperty("exo:viewPermissionUsers", contact.getViewPermissionUsers());
        contactNode.setProperty("exo:editPermissionGroups", contact.getEditPermissionGroups());
        contactNode.setProperty("exo:viewPermissionGroups", contact.getViewPermissionGroups());
        if (contact.getLastUpdated() != null) {
            dateTime.setTime(contact.getLastUpdated());
            contactNode.setProperty("exo:lastUpdated", (Calendar)dateTime);
        }
        if ((attachment = contact.getAttachment()) != null) {
            ExtendedNode extNode = (ExtendedNode)contactNode;
            if (extNode.canAddMixin("exo:privilegeable")) {
                extNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
            extNode.setPermission(SystemIdentity.ANY, arrayPers);
            List permsList = extNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
            }
            if (attachment.getFileName() != null) {
                Node nodeFile = null;
                try {
                    nodeFile = contactNode.getNode("image");
                }
                catch (PathNotFoundException ex) {
                    nodeFile = contactNode.addNode("image", "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                nodeContent.setProperty("jcr:data", attachment.getInputStream());
                nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            }
        } else if (contactNode.hasNode("image")) {
            contactNode.getNode("image").remove();
        }
        return contactNode;
    }

    @Override
    public Tag getTag(Node tagNode) throws Exception {
        Tag tag = new Tag();
        if (tagNode.hasProperty("exo:id")) {
            tag.setId(tagNode.getProperty("exo:id").getString());
        }
        if (tagNode.hasProperty("exo:name")) {
            tag.setName(tagNode.getProperty("exo:name").getString());
        }
        if (tagNode.hasProperty("exo:description")) {
            tag.setDescription(tagNode.getProperty("exo:description").getString());
        }
        if (tagNode.hasProperty("exo:color")) {
            tag.setColor(tagNode.getProperty("exo:color").getString());
        }
        return tag;
    }

    @Override
    public void updateTag(String username, Tag tag) throws Exception {
        Node tagHome = this.getTagsHome(username);
        Node tagNode = tagHome.getNode(tag.getId());
        tagNode.setProperty("exo:name", tag.getName());
        tagNode.setProperty("exo:description", tag.getDescription());
        tagNode.setProperty("exo:color", tag.getColor());
        tagHome.save();
    }

    @Override
    public Tag getTag(String username, String tagId) throws Exception {
        Node tagHomeNode = this.getTagsHome(username);
        if (tagHomeNode.hasNode(tagId)) {
            return this.getTag(tagHomeNode.getNode(tagId));
        }
        return null;
    }

    @Override
    public List<Tag> getTags(String username) throws Exception {
        Node tagHomeNode = this.getTagsHome(username);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        NodeIterator iter = tagHomeNode.getNodes();
        while (iter.hasNext()) {
            Node tagNode = iter.nextNode();
            tags.add(this.getTag(tagNode));
        }
        return tags;
    }

    @Override
    public DataPageList getContactPageListByTag(String username, String tagId) throws Exception {
        LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
        QueryResult result = null;
        NodeIterator it = null;
        Query query = null;
        QueryManager qm = null;
        StringBuffer queryString = null;
        Node contactHome = this.getPersonalContactsHome(username);
        qm = contactHome.getSession().getWorkspace().getQueryManager();
        queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
        query = qm.createQuery(queryString.toString(), "xpath");
        result = query.execute();
        it = result.getNodes();
        while (it.hasNext()) {
            Contact contact = Utils.getContact(it.nextNode(), PERSONAL);
            contacts.put(contact.getId(), contact);
        }
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        Node publicContactHome = this.getPublicContactsHome();
        qm = publicContactHome.getSession().getWorkspace().getQueryManager();
        queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
        query = qm.createQuery(queryString.toString(), "xpath");
        result = query.execute();
        it = result.getNodes();
        while (it.hasNext()) {
            Contact contact = Utils.getContact(it.nextNode(), PUBLIC);
            if (contact.getId().equals(username)) {
                contact.setContactType(PERSONAL);
            }
            contacts.put(contact.getId(), contact);
        }
        Node sharedContact = this.getSharedContact(username);
        PropertyIterator sIter = sharedContact.getReferences();
        while (sIter.hasNext()) {
            try {
                Node contactNode = sIter.nextProperty().getParent();
                if (!contactNode.hasProperty("exo:tags") || !contactNode.hasProperty("exo:tags") || !Arrays.asList(Utils.valuesToStringArray(contactNode.getProperty("exo:tags").getValues())).contains(tagId)) continue;
                Contact contact = Utils.getContact(contactNode, SHARED);
                contacts.put(contact.getId(), contact);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method saveSharedContact", (Throwable)e);
            }
        }
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
            qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            it = result.getNodes();
            while (it.hasNext()) {
                Contact contact = Utils.getContact(it.nextNode(), SHARED);
                if (!Arrays.asList(contact.getAddressBookIds()).contains(addressBook.getProperty("exo:id").getString())) continue;
                contacts.put(contact.getId(), contact);
            }
        }
        return new DataPageList(Arrays.asList(contacts.values().toArray(new Contact[0])), 10L, null, false);
    }

    private Node getContactNode(String username, String contact) throws Exception {
        String contactId = contact.split(SPLIT)[0];
        String contactType = contact.split(SPLIT)[1];
        if (contactType.equals(PERSONAL)) {
            return this.getPersonalContactsHome(username).getNode(contactId);
        }
        if (contactType.equals(PUBLIC)) {
            return this.getPersonalContactsHome(contactId).getNode(contactId);
        }
        Node contactNode = null;
        Node sharedContactMock = this.getSharedContact(username);
        PropertyIterator iter = sharedContactMock.getReferences();
        while (iter.hasNext()) {
            try {
                Node node = iter.nextProperty().getParent();
                if (!node.getName().equals(contactId)) continue;
                contactNode = node;
                break;
            }
            catch (Exception exx) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method getContactNode", (Throwable)exx);
            }
        }
        if (contactNode == null) {
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            PropertyIterator iter1 = sharedAddressBookMock.getReferences();
            while (iter1.hasNext()) {
                Node addressBook = iter1.nextProperty().getParent();
                Node contacts = addressBook.getParent().getParent().getNode(CONTACTS);
                if (!contacts.hasNode(contactId)) continue;
                contactNode = contacts.getNode(contactId);
                if (Arrays.asList(Utils.valuesToStringArray(contactNode.getProperty(PROP_ADDRESSBOOK_REFS).getValues())).contains(addressBook.getProperty("exo:id").getString())) break;
                contactNode = null;
            }
        }
        return contactNode;
    }

    @Override
    public void addTag(String username, List<String> contactIds, String tagId) throws Exception {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        tagMap.put(tagId, tagId);
        for (String contact : contactIds) {
            Node contactNode = this.getContactNode(username, contact);
            if (contactNode == null) {
                throw new PathNotFoundException();
            }
            HashMap<String, String> thisTagMap = new HashMap<String, String>();
            thisTagMap = tagMap;
            Value[] values = null;
            if (contactNode.hasProperty("exo:tags")) {
                for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                    thisTagMap.put(value.getString(), value.getString());
                }
            }
            contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
            contactNode.save();
        }
    }

    @Override
    public void addTag(String username, List<String> contactIds, List<Tag> tags) throws Exception {
        Node tagHomeNode = this.getTagsHome(username);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        String newTag = null;
        for (Tag tag : tags) {
            if (!tagHomeNode.hasNode(tag.getId())) {
                newTag = tag.getId();
                Node tagNode = tagHomeNode.addNode(tag.getId(), "exo:contactTag");
                tagNode.setProperty("exo:id", tag.getId());
                tagNode.setProperty("exo:name", tag.getName());
                tagNode.setProperty("exo:description", tag.getDescription());
                tagNode.setProperty("exo:color", tag.getColor());
                tagHomeNode.getSession().save();
            }
            tagMap.put(tag.getId(), tag.getId());
        }
        if (contactIds == null || contactIds.size() == 0) {
            return;
        }
        for (String contact : contactIds) {
            Node contactNode = this.getContactNode(username, contact);
            if (contactNode == null) {
                if (contactIds.get(0).equals(contact) && newTag != null) {
                    tagHomeNode.getNode(newTag).remove();
                    tagHomeNode.getSession().save();
                }
                throw new PathNotFoundException();
            }
            HashMap<String, String> thisTagMap = new HashMap<String, String>();
            thisTagMap.putAll(tagMap);
            Value[] values = null;
            if (contactNode.hasProperty("exo:tags")) {
                for (Value value : values = contactNode.getProperty("exo:tags").getValues()) {
                    thisTagMap.put(value.getString(), value.getString());
                }
            }
            contactNode.setProperty("exo:tags", thisTagMap.values().toArray(new String[0]));
            contactNode.save();
        }
    }

    @Override
    public void removeTagInContacts(NodeIterator it, String tagId) throws Exception {
        while (it.hasNext()) {
            Node contactNode = it.nextNode();
            if (!contactNode.hasProperty("exo:tags")) continue;
            String[] tagIds = Utils.valuesToStringArray(contactNode.getProperty("exo:tags").getValues());
            ArrayList<String> newTagIds = new ArrayList<String>();
            for (String id : tagIds) {
                if (id.equals(tagId)) continue;
                newTagIds.add(id);
            }
            contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
            contactNode.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tag removeTag(String username, String tagId) throws Exception {
        Node tagHomeNode = this.getTagsHome(username);
        Node tagNode = tagHomeNode.getNode(tagId);
        Tag tag = this.getTag(tagNode);
        tagNode.remove();
        tagHomeNode.save();
        Node contactHome = this.getPersonalContactsHome(username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        this.removeTagInContacts(query.execute().getNodes(), tagId);
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        Node publicContactHome = this.getPublicContactsHome();
        qm = publicContactHome.getSession().getWorkspace().getQueryManager();
        queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("' and @exo:isOwner='true'] ");
        query = qm.createQuery(queryString.toString(), "xpath");
        this.removeTagInContacts(query.execute().getNodes(), tagId);
        Node sharedContact = this.getSharedContact(username);
        PropertyIterator sIter = sharedContact.getReferences();
        while (sIter.hasNext()) {
            try {
                Node contactNode = sIter.nextProperty().getParent();
                if (!contactNode.hasProperty("exo:tags")) continue;
                String[] tagIds = Utils.valuesToStringArray(contactNode.getProperty("exo:tags").getValues());
                ArrayList<String> newTagIds = new ArrayList<String>();
                for (String id : tagIds) {
                    if (id.equals(tagId)) continue;
                    newTagIds.add(id);
                }
                contactNode.setProperty("exo:tags", newTagIds.toArray(new String[0]));
                contactNode.save();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Exception in method removeTag", (Throwable)e);
            }
        }
        Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
        PropertyIterator iter = sharedAddressBookMock.getReferences();
        qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
        while (iter.hasNext()) {
            Node addressBook = iter.nextProperty().getParent();
            Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
            queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:tags='").append(tagId).append("']");
            query = qm.createQuery(queryString.toString(), "xpath");
            this.removeTagInContacts(query.execute().getNodes(), tagId);
        }
        return tag;
    }

    @Override
    public void removeContactTag(String username, List<String> contactIds, List<String> tags) throws Exception {
        for (String contact : contactIds) {
            Node contactNode = this.getContactNode(username, contact);
            if (contactNode == null) {
                throw new PathNotFoundException();
            }
            if (!contactNode.hasProperty("exo:tags")) continue;
            Value[] values = contactNode.getProperty("exo:tags").getValues();
            ArrayList<String> tagList = new ArrayList<String>();
            for (Value value : values) {
                tagList.add(value.getString());
            }
            for (String tag : tags) {
                if (!tagList.contains(tag)) continue;
                tagList.remove(tag);
            }
            contactNode.setProperty("exo:tags", tagList.toArray(new String[0]));
            contactNode.save();
        }
    }

    @Override
    public DataPageList searchContact(String username, ContactFilter filter) throws Exception {
        LinkedHashMap<String, Contact> contacts = new LinkedHashMap<String, Contact>();
        filter.setUsername(username);
        QueryManager qm = this.getSession(this.createSystemProvider()).getWorkspace().getQueryManager();
        Query query = null;
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        if (filter.getType() == null || filter.getType().equals(PUBLIC)) {
            usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            filter.setAccountPath(usersPath);
            filter.setOwner("true");
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator itpublic = query.execute().getNodes();
            while (itpublic.hasNext()) {
                Contact contact = Utils.getContact(itpublic.nextNode(), PUBLIC);
                contacts.put(contact.getId(), contact);
            }
        }
        filter.setOwner(null);
        if ((filter.getType() == null || filter.getType().equals(PERSONAL)) && username != null && username.length() > 0) {
            Node contactHome = this.getPersonalContactsHome(username);
            filter.setAccountPath(contactHome.getPath());
            qm = contactHome.getSession().getWorkspace().getQueryManager();
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Contact contact = Utils.getContact(it.nextNode(), PERSONAL);
                contacts.put(contact.getId(), contact);
            }
        }
        if (filter.getType() == null || filter.getType().equals(SHARED)) {
            PropertyIterator iter;
            block22: {
                try {
                    Node sharedContact = this.getSharedContact(username);
                    iter = sharedContact.getReferences();
                    List<Contact> sharedContacts = this.getSharedContacts(username).getAll();
                    ArrayList<String> sharedContactIds = new ArrayList<String>();
                    for (Contact contact : sharedContacts) {
                        sharedContactIds.add(contact.getId());
                    }
                    while (iter.hasNext()) {
                        try {
                            Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                            filter.setAccountPath(sharedContactHomeNode.getPath());
                            String split = "/";
                            String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                            String userId = temp.split(split)[1];
                            filter.setUsername(userId);
                            query = qm.createQuery(filter.getStatement(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            while (it.hasNext()) {
                                Node contactNode = it.nextNode();
                                if (!contactNode.hasProperty("exo:id") || !sharedContactIds.contains(contactNode.getProperty("exo:id").getString())) continue;
                                Contact contact = Utils.getContact(contactNode, SHARED);
                                if (!contacts.containsKey(contact.getId())) {
                                    contacts.put(contact.getId(), contact);
                                } else {
                                    ((Contact)contacts.get(contact.getId())).setContactType(DataStorage.SHARED);
                                }
                                sharedContactIds.remove(contact.getId());
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Exception in method searchContact", (Throwable)e);
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    if (!log.isDebugEnabled()) break block22;
                    log.debug((Object)"Failed to get item by path", (Throwable)e);
                }
            }
            if (!filter.isSearchSharedContacts()) {
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                iter = sharedAddressBookMock.getReferences();
                boolean searchByAddress = false;
                if (filter.getCategories() != null && filter.getCategories().length > 0) {
                    searchByAddress = true;
                }
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contactHomeNode.getPath());
                    if (!searchByAddress) {
                        filter.setCategories(new String[]{addressBook.getName()});
                    }
                    filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                    qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Contact contact = Utils.getContact(it.nextNode(), SHARED);
                        contacts.put(contact.getId(), contact);
                    }
                }
            }
        }
        List<Contact> contactList = new ArrayList<Contact>();
        String tagId = "";
        if (filter.getTag() != null) {
            if (filter.getTag().length > 0) {
                tagId = filter.getTag()[0];
            }
            if (!Utils.isEmpty(tagId)) {
                DataPageList dpl = this.getContactPageListByTag(username, tagId);
                contactList = dpl.getAll();
            }
        }
        contactList.addAll(contacts.values());
        return new DataPageList(contactList, 10L, null, false);
    }

    @Override
    public Map<String, String> findEmailsByFilter(String username, ContactFilter filter) throws Exception {
        Query query;
        LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
        filter.setUsername(username);
        filter.setHasEmails(true);
        QueryManager qm = this.getContactUserDataHome(username).getSession().getWorkspace().getQueryManager();
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        if (filter.getType() == null || filter.getType().equals(PUBLIC)) {
            filter.setAccountPath(usersPath);
            filter.setOwner("true");
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator itpublic = query.execute().getNodes();
            while (itpublic.hasNext()) {
                Node contactNode = itpublic.nextNode();
                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) break;
                this.feedEmailResult(emails, contactNode);
            }
            filter.setOwner(null);
        }
        if ((filter.getType() == null || filter.getType().equals(PERSONAL)) && username != null && username.length() > 0) {
            Node contactHome = this.getPersonalContactsHome(username);
            filter.setAccountPath(contactHome.getPath());
            qm = contactHome.getSession().getWorkspace().getQueryManager();
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node contactNode = it.nextNode();
                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) break;
                this.feedEmailResult(emails, contactNode);
            }
        }
        if (filter.getType() == null || filter.getType().equals(SHARED)) {
            PropertyIterator iter;
            block15: {
                try {
                    Node sharedContact = this.getSharedContact(username);
                    iter = sharedContact.getReferences();
                    block6: while (iter.hasNext()) {
                        try {
                            Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                            filter.setAccountPath(sharedContactHomeNode.getPath());
                            String split = "/";
                            String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                            String userId = temp.split(split)[1];
                            filter.setUsername(userId);
                            qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                            query = qm.createQuery(filter.getStatement(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            while (it.hasNext()) {
                                Node contactNode = it.nextNode();
                                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) continue block6;
                                this.feedEmailResult(emails, contactNode);
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Exception in method findEmailsByFilter", (Throwable)e);
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug((Object)"Failed to get item by path", (Throwable)e);
                }
            }
            if (!filter.isSearchSharedContacts()) {
                boolean hasGroup;
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                iter = sharedAddressBookMock.getReferences();
                boolean bl = hasGroup = filter.getCategories() != null && filter.getCategories().length > 0;
                block8: while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contactHomeNode.getPath());
                    if (!hasGroup) {
                        filter.setCategories(new String[]{addressBook.getName()});
                    }
                    filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                    qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Node contactNode = it.nextNode();
                        if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) continue block8;
                        this.feedEmailResult(emails, contactNode);
                    }
                }
            }
        }
        return emails;
    }

    @Override
    public void feedEmailResult(Map<String, String> emails, Node contactNode) throws Exception {
        String id = contactNode.getProperty("exo:id").getString();
        String fullName = contactNode.getProperty("exo:fullName").getString();
        String emailAddresses = Utils.valuesToString(contactNode.getProperty("exo:emailAddress").getValues());
        emails.put(id, fullName + Utils.SPLIT + emailAddresses);
    }

    @Override
    public List<String> searchEmailsByFilter(String username, ContactFilter filter) throws Exception {
        Query query;
        LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
        filter.setUsername(username);
        filter.setHasEmails(true);
        QueryManager qm = this.getContactUserDataHome(username).getSession().getWorkspace().getQueryManager();
        String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
        if (filter.getType() == null || filter.getType().equals(PUBLIC)) {
            filter.setAccountPath(usersPath);
            filter.setOwner("true");
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator itpublic = query.execute().getNodes();
            while (itpublic.hasNext()) {
                Node contactNode = itpublic.nextNode();
                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) {
                    return new ArrayList<String>(emails.values());
                }
                this.calculateEmailResult(contactNode, filter, emails);
            }
            filter.setOwner(null);
        }
        if ((filter.getType() == null || filter.getType().equals(PERSONAL)) && username != null && username.length() > 0) {
            Node contactHome = this.getPersonalContactsHome(username);
            filter.setAccountPath(contactHome.getPath());
            qm = contactHome.getSession().getWorkspace().getQueryManager();
            query = qm.createQuery(filter.getStatement(), "xpath");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node contactNode = it.nextNode();
                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) {
                    return new ArrayList<String>(emails.values());
                }
                this.calculateEmailResult(contactNode, filter, emails);
            }
        }
        if (filter.getType() == null || filter.getType().equals(SHARED)) {
            PropertyIterator iter;
            block19: {
                try {
                    Node sharedContact = this.getSharedContact(username);
                    iter = sharedContact.getReferences();
                    while (iter.hasNext()) {
                        try {
                            Node sharedContactHomeNode = iter.nextProperty().getParent().getParent();
                            filter.setAccountPath(sharedContactHomeNode.getPath());
                            String split = "/";
                            String temp = sharedContactHomeNode.getPath().split(usersPath)[1];
                            String userId = temp.split(split)[1];
                            filter.setUsername(userId);
                            qm = sharedContactHomeNode.getSession().getWorkspace().getQueryManager();
                            query = qm.createQuery(filter.getStatement(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            while (it.hasNext()) {
                                Node contactNode = it.nextNode();
                                if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) {
                                    return new ArrayList<String>(emails.values());
                                }
                                this.calculateEmailResult(contactNode, filter, emails);
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Exception in method searchEmailsByFilter", (Throwable)e);
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    if (!log.isDebugEnabled()) break block19;
                    log.debug((Object)"Failed to get item by path", (Throwable)e);
                }
            }
            if (!filter.isSearchSharedContacts()) {
                boolean hasGroup;
                Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
                iter = sharedAddressBookMock.getReferences();
                boolean bl = hasGroup = filter.getCategories() != null && filter.getCategories().length > 0;
                while (iter.hasNext()) {
                    Node addressBook = iter.nextProperty().getParent();
                    Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                    filter.setAccountPath(contactHomeNode.getPath());
                    if (!hasGroup) {
                        filter.setCategories(new String[]{addressBook.getName()});
                    }
                    filter.setUsername(addressBook.getProperty("exo:sharedUserId").getString());
                    qm = contactHomeNode.getSession().getWorkspace().getQueryManager();
                    query = qm.createQuery(filter.getStatement(), "xpath");
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        Node contactNode = it.nextNode();
                        if (filter.getLimit() > 0 && filter.getLimit() <= emails.size()) {
                            return new ArrayList<String>(emails.values());
                        }
                        this.calculateEmailResult(contactNode, filter, emails);
                    }
                }
            }
        }
        return new ArrayList<String>(emails.values());
    }

    private void calculateEmailResult(Node contactNode, ContactFilter filter, Map<String, String> emails) throws Exception {
        block4: {
            String emailAddresses = "";
            String fullName = contactNode.getProperty("exo:fullName").getString();
            try {
                Value[] values = contactNode.getProperty("exo:emailAddress").getValues();
                int i = 0;
                for (Value value : values) {
                    String email = value.getString().trim();
                    if (email.length() <= 0 || emails.containsKey(fullName + email)) continue;
                    if (i <= 2 && filter.getLimit() > emails.size()) {
                        String classCss = emails.isEmpty() ? "<div class='AutoCompleteItem AutoCompleteOver'>" : "<div class='AutoCompleteItem'>";
                        emailAddresses = classCss + StringUtils.replace((String)fullName, (String)filter.getNickName(), (String)("<b>" + filter.getNickName() + "</b>")) + "&lt;" + StringUtils.replace((String)email, (String)filter.getNickName(), (String)("<b>" + filter.getNickName() + "</b>")) + "&gt;" + "</div>";
                        emails.put(fullName + email, emailAddresses);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Failed to calculate email result", (Throwable)e);
            }
        }
    }

    @Override
    public void copyNodes(String username, Node srcHomeNode, NodeIterator iter, String destAddress, String destType) throws Exception {
        if (destType.equals(PERSONAL)) {
            Node contactHomeNode = this.getPersonalContactsHome(username);
            while (iter.hasNext()) {
                ExtendedNode extNode;
                Node oldNode = iter.nextNode();
                String newId = "Contact" + IdGenerator.generate();
                try {
                    contactHomeNode.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                }
                catch (AccessDeniedException ex) {
                    Node userContactHome = this.getPersonalContactsHome(oldNode.getProperty("exo:id").getString());
                    userContactHome.getSession().getWorkspace().copy(oldNode.getPath(), contactHomeNode.getPath() + "/" + newId);
                }
                try {
                    extNode = (ExtendedNode)contactHomeNode.getNode(newId);
                }
                catch (Exception e) {
                    extNode = (ExtendedNode)this.getPersonalContactsHome(username).getNode(newId);
                }
                if (extNode.canAddMixin("exo:privilegeable")) {
                    extNode.addMixin("exo:privilegeable");
                }
                String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                extNode.setPermission(username, arrayPers);
                extNode.save();
                this.createContactNote(destAddress, contactHomeNode, newId);
            }
            contactHomeNode.getSession().save();
        } else if (destType.equals(SHARED)) {
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            PropertyIterator proIter = sharedAddressBookMock.getReferences();
            while (proIter.hasNext()) {
                Node addressBook = proIter.nextProperty().getParent();
                if (!addressBook.getName().equals(destAddress)) continue;
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                while (iter.hasNext()) {
                    String newId = "Contact" + IdGenerator.generate();
                    Node oldNode = iter.nextNode();
                    contactHomeNode.getSession().getWorkspace().copy(srcHomeNode.getPath() + "/" + oldNode.getProperty("exo:id").getString(), contactHomeNode.getPath() + "/" + newId);
                    this.createContactNote(destAddress, contactHomeNode, newId);
                }
                contactHomeNode.getSession().save();
                break;
            }
        }
    }

    private void createContactNote(String destAddress, Node contactHomeNode, String newId) throws Exception {
        Node newNode = contactHomeNode.getNode(newId);
        newNode.setProperty(PROP_ADDRESSBOOK_REFS, new String[]{destAddress});
        newNode.setProperty("exo:id", newId);
        newNode.setProperty("exo:isOwner", false);
        newNode.setProperty("exo:editPermissionUsers", new String[0]);
        newNode.setProperty("exo:viewPermissionUsers", new String[0]);
        newNode.setProperty("exo:editPermissionGroups", new String[0]);
        newNode.setProperty("exo:viewPermissionGroups", new String[0]);
    }

    @Override
    public void pasteAddressBook(String username, String srcAddress, String srcType, String destAddress, String destType) throws Exception {
        if (destType.equals(SHARED) && !this.haveEditPermissionOnAddressBook(username, destAddress)) {
            throw new AccessDeniedException();
        }
        if (srcType.equals(PERSONAL)) {
            Node contactHome = this.getPersonalContactsHome(username);
            QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            this.copyNodes(username, contactHome, iter, destAddress, destType);
        } else if (srcType.equals(SHARED)) {
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            PropertyIterator proIter = sharedAddressBookMock.getReferences();
            QueryManager qm = sharedAddressBookMock.getSession().getWorkspace().getQueryManager();
            while (proIter.hasNext()) {
                Node addressBook = proIter.nextProperty().getParent();
                if (!addressBook.getName().equals(srcAddress)) continue;
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                StringBuffer queryString = new StringBuffer("/jcr:root" + contactHomeNode.getPath() + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                this.copyNodes(username, contactHomeNode, iter, destAddress, destType);
                break;
            }
        } else {
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(USERS_PATH);
            Node publicContactHome = this.getPublicContactsHome();
            QueryManager qm = publicContactHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:categories='").append(srcAddress).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            this.copyNodes(username, publicContactHome, iter, destAddress, destType);
        }
    }

    @Override
    public List<Contact> pasteContacts(String username, String destAddress, String destType, Map<String, String> contactsMap) throws Exception {
        if (destType.equals(SHARED) && !this.haveEditPermissionOnAddressBook(username, destAddress)) {
            throw new AccessDeniedException();
        }
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        ArrayList<Contact> pastedContacts = new ArrayList<Contact>();
        for (String contactId : contactsMap.keySet()) {
            String type = contactsMap.get(contactId);
            Contact contact = null;
            if (type.equals(PERSONAL)) {
                contact = this.loadPersonalContact(username, contactId);
            } else if (type.equals(PUBLIC)) {
                contact = this.loadPublicContactByUser(contactId);
            } else {
                contact = this.getSharedContact(username, contactId);
                if (contact == null) {
                    contact = this.getSharedContactAddressBook(username, contactId);
                }
                if (contact != null && !this.haveEditPermissionOnContact(username, contact) && !this.haveEditPermissionOnAddressBook(username, contact.getAddressBookIds()[0])) {
                    log.error((Object)"do not have permission");
                    throw new AccessDeniedException();
                }
            }
            if (contact == null) continue;
            contacts.add(contact);
        }
        block1: for (Contact contact : contacts) {
            if (destType.equals(PERSONAL)) {
                Node contactHomeNode = this.getPersonalContactsHome(username);
                pastedContacts.add(Utils.getContact(this.saveCopyContact(contactHomeNode, contact, destAddress, destType), destType));
                continue;
            }
            if (!destType.equals(SHARED)) continue;
            Node sharedAddressBookMock = this.getSharedAddressBooksHome(username);
            PropertyIterator iter = sharedAddressBookMock.getReferences();
            while (iter.hasNext()) {
                Node addressBook = iter.nextProperty().getParent();
                if (!addressBook.getName().equals(destAddress)) continue;
                Node contactHomeNode = addressBook.getParent().getParent().getNode(CONTACTS);
                pastedContacts.add(Utils.getContact(this.saveCopyContact(contactHomeNode, contact, destAddress, destType), destType));
                continue block1;
            }
        }
        return pastedContacts;
    }

    @Override
    public Node saveCopyContact(Node contactHomeNode, Contact contact, String destAddress, String destType) throws Exception {
        String newId = "Contact" + IdGenerator.generate();
        Node contactNode = contactHomeNode.addNode(newId, "exo:contact");
        contactNode.setProperty("exo:id", newId);
        contact.setAddressBookIds(new String[]{destAddress});
        contact.setViewPermissionUsers(null);
        contact.setViewPermissionGroups(null);
        contact.setEditPermissionUsers(null);
        contact.setEditPermissionGroups(null);
        contactNode = this.setContactNodeProperties(contactNode, contact);
        contactHomeNode.getSession().save();
        return contactNode;
    }

    @Override
    public void registerNewUser(User user, boolean isNew) throws Exception {
        Contact contact = null;
        contact = isNew ? new Contact() : this.loadPublicContactByUser(user.getUserName());
        if (contact != null) {
            contact.setFullName(user.getFirstName() + " " + user.getLastName());
            contact.setFirstName(user.getFirstName());
            contact.setLastName(user.getLastName());
            contact.setEmailAddress(user.getEmail());
            GregorianCalendar cal = new GregorianCalendar();
            contact.setLastUpdated(cal.getTime());
        }
        if (isNew) {
            Object[] groupsOfUser;
            Node addressHome = this.getPersonalAddressBooksHome(user.getUserName());
            AddressBook addressbook = new AddressBook();
            addressbook.setId(NewUserListener.DEFAULTGROUP + user.getUserName());
            addressbook.setName(NewUserListener.DEFAULTGROUPNAME);
            addressbook.setDescription(NewUserListener.DEFAULTGROUPDES);
            Node groupNode = addressHome.addNode(addressbook.getId(), "exo:contactGroup");
            groupNode.setProperty("exo:id", addressbook.getId());
            groupNode.setProperty("exo:name", addressbook.getName());
            groupNode.setProperty("exo:description", addressbook.getDescription());
            groupNode.setProperty("exo:editPermissionUsers", addressbook.getEditPermissionUsers());
            groupNode.setProperty("exo:viewPermissionUsers", addressbook.getViewPermissionUsers());
            groupNode.setProperty("exo:editPermissionGroups", addressbook.getEditPermissionGroups());
            groupNode.setProperty("exo:viewPermissionGroups", addressbook.getViewPermissionGroups());
            Node addressesGroup = addressHome.addNode(NewUserListener.ADDRESSESGROUP + user.getUserName(), "exo:contactGroup");
            addressesGroup.setProperty("exo:id", NewUserListener.ADDRESSESGROUP + user.getUserName());
            addressesGroup.setProperty("exo:name", NewUserListener.ADDRESSESGROUPNAME);
            addressHome.getSession().save();
            contact.setId(user.getUserName());
            HashSet<String> groupIds = new HashSet<String>();
            groupIds.add(addressbook.getId());
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            for (Object object : groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(user.getUserName()).toArray()) {
                String id = ((Group)object).getId();
                groupIds.add(id);
            }
            contact.setAddressBookIds(groupIds.toArray(new String[0]));
            contact.setOwner(true);
            contact.setOwnerId(user.getUserName());
            this.saveContactUser(user.getUserName(), contact, true);
            QueryManager qm = this.getSession(this.createSystemProvider()).getWorkspace().getQueryManager();
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(DataStorage.USERS_PATH);
            ArrayList<String> recievedUser = new ArrayList<String>();
            recievedUser.add(user.getUserName());
            for (Object object : groupsOfUser) {
                String groupId = ((Group)object).getId();
                StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(groupId + "']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node addressBook = nodes.nextNode();
                    this.shareAddressBook(addressBook.getProperty("exo:sharedUserId").getString(), addressBook.getProperty("exo:id").getString(), recievedUser);
                }
                queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(groupId + "']");
                query = qm.createQuery(queryString.toString(), "xpath");
                result = query.execute();
                nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node contactNode = nodes.nextNode();
                    String split = "/";
                    String temp = contactNode.getPath().split(usersPath)[1];
                    String userId = temp.split(split)[1];
                    this.shareContact(userId, new String[]{contactNode.getProperty("exo:id").getString()}, recievedUser);
                }
            }
            Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(this.createSystemProvider(), user.getUserName());
            userApp.getSession().save();
        } else if (contact != null) {
            this.saveContactUser(user.getUserName(), contact, false);
        }
    }

    @Override
    public SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    @Override
    public void saveAddress(String username, String emailAddress) throws Exception {
        ContactFilter filter = new ContactFilter();
        for (String email : Utils.parseEmails(emailAddress)) {
            filter.setEmailAddress(email);
            if (this.searchContact(username, filter).getAll().size() != 0) continue;
            Contact contact = new Contact();
            String name = email.split("@")[0];
            contact.setLastName(name);
            contact.setFullName(name);
            contact.setEmailAddress(email);
            contact.setAddressBookIds(new String[]{NewUserListener.ADDRESSESGROUP + username});
            this.saveContactUser(username, contact, true);
        }
    }

    @Override
    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    @Override
    public boolean haveEditPermissionOnAddressBook(String username, String addressBookId) throws Exception {
        AddressBook addressbook = this.getSharedAddressBookById(username, addressBookId);
        if (addressbook == null) {
            return false;
        }
        if (addressbook.getEditPermissionUsers() != null && Arrays.asList(addressbook.getEditPermissionUsers()).contains(username + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = addressbook.getEditPermissionGroups();
        if (editPerGroups != null) {
            Object[] groupsOfUser;
            ArrayList<String> groupIds = new ArrayList<String>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            for (Object object : groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(username).toArray()) {
                String groupId = ((Group)object).getId();
                groupIds.add(groupId);
            }
            for (String editPer : editPerGroups) {
                if (!groupIds.contains(editPer)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean haveEditPermissionOnContact(String username, Contact contact) throws Exception {
        Object[] groupsOfUser;
        if (contact.getEditPermissionUsers() != null && Arrays.asList(contact.getEditPermissionUsers()).contains(username + DataStorage.HYPHEN)) {
            return true;
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        for (Object object : groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(username).toArray()) {
            String groupId = ((Group)object).getId();
            groupIds.add(groupId);
        }
        String[] editPerGroups = contact.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!groupIds.contains(editPer)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    @Override
    public Node getContactApplicationDataHome() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node applicationDataHome = this.getNodeByPath(this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider).getPath(), sProvider);
        try {
            return applicationDataHome.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node contactApplicationDataHome = applicationDataHome.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            applicationDataHome.save();
            return contactApplicationDataHome;
        }
    }

    @Override
    public Node getContactUserDataHome(String username) throws Exception {
        SessionProvider sessionProvider = this.createSystemProvider();
        Node userDataHome = this.getNodeByPath(this.nodeHierarchyCreator_.getUserApplicationNode(sessionProvider, username).getPath(), sessionProvider);
        try {
            return userDataHome.getNode(CONTACT_APP);
        }
        catch (PathNotFoundException ex) {
            Node contactUserDataHome = userDataHome.addNode(CONTACT_APP, NT_UNSTRUCTURED);
            userDataHome.getSession().save();
            return contactUserDataHome;
        }
    }

    @Override
    public Node getPersonalAddressBooksHome(String username) throws Exception {
        Node userDataHome = this.getContactUserDataHome(username);
        try {
            return userDataHome.getNode(PERSONAL_ADDRESS_BOOKS);
        }
        catch (PathNotFoundException ex) {
            Node padHome = userDataHome.addNode(PERSONAL_ADDRESS_BOOKS, NT_UNSTRUCTURED);
            userDataHome.save();
            return padHome;
        }
    }

    @Override
    public Node getPersonalContactsHome(String username) throws Exception {
        Node userDataHome = this.getContactUserDataHome(username);
        try {
            return userDataHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node personalContactsHome = userDataHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            userDataHome.save();
            return personalContactsHome;
        }
    }

    @Override
    public List<GroupContactData> getPublicContacts(String[] groupIds) throws Exception {
        ArrayList<GroupContactData> contactByGroup = new ArrayList<GroupContactData>();
        for (String groupId : groupIds) {
            List<Contact> contacts = this.getPublicContactsByAddressBook(groupId).getAll();
            if (contacts.size() <= 0) continue;
            contactByGroup.add(new GroupContactData(groupId, contacts));
        }
        return contactByGroup;
    }

    @Override
    public Node getPublicContactsHome() throws Exception {
        Node contactServiceHome = this.getContactApplicationDataHome();
        try {
            return contactServiceHome.getNode(CONTACTS);
        }
        catch (PathNotFoundException ex) {
            Node publicHome = contactServiceHome.addNode(CONTACTS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return publicHome;
        }
    }

    public Node getPublicAddressHome() throws Exception {
        Node contactServiceHome = this.getContactApplicationDataHome();
        try {
            return contactServiceHome.getNode(GROUP_ADDRESS_BOOKS);
        }
        catch (PathNotFoundException ex) {
            Node publicHome = contactServiceHome.addNode(GROUP_ADDRESS_BOOKS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return publicHome;
        }
    }

    @Override
    public Node getTagsHome(String username) throws Exception {
        Node contactServiceHome = this.getContactUserDataHome(username);
        try {
            return contactServiceHome.getNode(TAGS);
        }
        catch (PathNotFoundException ex) {
            Node tagHome = contactServiceHome.addNode(TAGS, NT_UNSTRUCTURED);
            contactServiceHome.save();
            return tagHome;
        }
    }

    @Override
    public List<String> getUserContactNodesByGroup(String username, String groupId) throws Exception {
        Node contactHome = this.getPersonalContactsHome(username);
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        ArrayList<String> contactIds = new ArrayList<String>();
        while (it.hasNext()) {
            contactIds.add(it.nextNode().getProperty("exo:id").getString());
        }
        return contactIds;
    }

    @Override
    public boolean hasContacts(String groupId) throws Exception {
        StringBuffer queryString;
        Node contactHome = this.getPublicContactsHome();
        QueryManager qm = contactHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + contactHome.getPath() + "//element(*,exo:contact)[@exo:categories='").append(groupId).append("']")).toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes().getSize() > 0L;
    }

    @Override
    public Node getSharedContactsHome(String user) throws Exception {
        Node sharedHome;
        Node contactHome = this.getContactUserDataHome(user);
        try {
            sharedHome = contactHome.getNode(SHARED_HOME);
        }
        catch (PathNotFoundException ex) {
            sharedHome = contactHome.addNode(SHARED_HOME, NT_UNSTRUCTURED);
            contactHome.save();
        }
        return sharedHome;
    }
}

