/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.MissingResourceException;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.webui.popup.UIExportForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UIExportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIExportForm
extends UIForm
implements UIPopupComponent {
    private static final String NAME = "name".intern();
    private static final String TYPE = "type".intern();
    public static String fullName = "fullName".intern();
    public boolean viewContactsList = true;
    private String selectedTag_ = null;
    private LinkedHashMap<String, Contact> contactMap = new LinkedHashMap();
    private String selectedGroup = null;
    private String sortedBy_ = null;
    private boolean isAscending_ = true;
    private String viewQuery_ = null;
    private Contact[] contacts_ = null;

    public UIExportForm() throws Exception {
        this.setId("UIExportForm");
        this.sortedBy_ = fullName;
    }

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setAscending(boolean isAsc) {
        this.isAscending_ = isAsc;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setSortedBy(String s) {
        this.sortedBy_ = s;
    }

    public String getSortedBy() {
        return this.sortedBy_;
    }

    public String getViewQuery() {
        return this.viewQuery_;
    }

    public void setViewQuery(String view) {
        this.viewQuery_ = view;
    }

    public void setContacts(Contact[] contacts) throws Exception {
        this.contacts_ = contacts;
    }

    public Contact[] getContacts() throws Exception {
        return this.contactMap.values().toArray(new Contact[0]);
    }

    public void setSelectedGroup(String s) throws Exception {
        this.selectedGroup = s;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setViewContactsList(boolean list) {
        this.viewContactsList = list;
    }

    public boolean getViewContactsList() {
        return this.viewContactsList;
    }

    public void updateList() throws Exception {
        this.getChildren().clear();
        this.contactMap.clear();
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        ContactService contactService = ContactUtils.getContactService();
        for (String string : contactService.getImportExportType()) {
            options.add(new SelectItemOption(string, (Object)string));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
        for (String string : this.contacts_) {
            UIFormCheckBoxInput checkbox = new UIFormCheckBoxInput(string.getId(), string.getId(), (Object)true);
            this.addUIFormInput((UIFormInput)checkbox);
            this.contactMap.put(string.getId(), string);
        }
    }

    public List<String> getCheckedContacts() throws Exception {
        ArrayList<String> checkedContacts = new ArrayList<String>();
        for (Contact contact : this.getContacts()) {
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checkedContacts.add(contact.getId());
        }
        return checkedContacts;
    }

    public String getSelectedTag() {
        return this.selectedTag_;
    }

    public void setSelectedTag(String tagName) {
        this.selectedTag_ = tagName;
    }

    static /* synthetic */ String access$000() {
        return TYPE;
    }

    static /* synthetic */ String access$100() {
        return NAME;
    }

    static /* synthetic */ LinkedHashMap access$200(UIExportForm x0) {
        return x0.contactMap;
    }
}

