/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.contact.Colors;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormColorPicker
extends UIFormInputBase<String> {
    private int items_ = 12;
    private String onchange_;
    public static final String ON_CHANGE = "onchange".intern();
    public static final String ON_BLUR = "onblur".intern();
    public static final String ON_FOCUS = "onfocus".intern();
    public static final String ON_KEYUP = "onkeyup".intern();
    public static final String ON_KEYDOWN = "onkeydown".intern();
    public static final String ON_CLICK = "onclick".intern();
    private Map<String, String> jsActions_ = new HashMap();
    private Colors.Color[] colors_ = null;

    public UIFormColorPicker(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
        this.setColors(Colors.COLORS);
    }

    public UIFormColorPicker(String name, String bindingExpression, Colors.Color[] colors) {
        super(name, bindingExpression, null);
        this.setColors(colors);
    }

    public void setJsActions(Map<String, String> jsActions) {
        if (jsActions != null) {
            this.jsActions_ = jsActions;
        }
    }

    public Map<String, String> getJsActions() {
        return this.jsActions_;
    }

    public void addJsActions(String action, String javaScript) {
        this.jsActions_.put(action, javaScript);
    }

    public UIFormColorPicker(String name, String bindingExpression, Colors.Color[] colors, Map<String, String> jsActions) {
        super(name, bindingExpression, null);
        this.setColors(colors);
        this.setJsActions(jsActions);
    }

    public UIFormColorPicker(String name, String value) {
        this(name, null, value);
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).trim().length() == 0) {
            this.value_ = null;
        }
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    private UIForm getUIform() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    private String renderJsActions() {
        StringBuffer sb = new StringBuffer("");
        for (String k : this.jsActions_.keySet()) {
            if (sb != null && sb.length() > 0) {
                sb.append(" ");
            }
            if (this.jsActions_.get(k) == null) continue;
            sb.append(k).append("=\"").append((String)this.jsActions_.get(k)).append("\"");
        }
        return sb.toString();
    }

    private Colors.Color[] getColors() {
        return this.colors_;
    }

    private void setColors(Colors.Color[] colors) {
        this.colors_ = colors;
        this.value_ = this.colors_[0].getName();
    }

    private int items() {
        return this.items_;
    }

    private int size() {
        return this.colors_.length;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<div class='UIFormColorPicker'>");
        w.write("<div class=\"UIColorPickerInput\" onclick=\"eXo.contact.UIColorPicker.show(this)\">");
        w.write("<span class=\" DisplayValue " + this.encodeValue((String)this.value_).toString() + "\"></span>");
        w.write("</div>");
        w.write("<div class=\"ContactTableColor\" selectedColor=\"" + this.encodeValue((String)this.value_).toString() + " \">");
        boolean index = false;
        int count = 0;
        for (int i = 0; i <= this.size() / this.items(); ++i) {
            w.write("<div class='UIColorLine'>");
            for (int j = 0; j <= this.items() && count < this.size(); ++count, ++j) {
                Colors.Color color = this.getColors()[count];
                String actionLink = "javascript:eXo.contact.UIColorPicker.setColor('" + color.getName() + "')";
                w.write("<a href=\"" + actionLink + "\" class=\"" + color.getName() + " ColorCell \" onmousedown=\"event.cancelBubble=true\"><img src=\"/eXoResources/skin/sharedImages/Blank.gif\" /></a>");
            }
            w.write("</div>");
        }
        w.write("</div>");
        w.write("<input class='UIColorPickerValue' name='" + this.getId() + "' type='hidden'" + " id='" + this.getId() + "' " + this.renderJsActions());
        if (this.value_ != null && ((String)this.value_).trim().length() > 0) {
            w.write(" value='" + (String)this.value_ + "'");
        }
        w.write(" \\>");
        w.write("</div>");
    }

    public UIFormInput setValue(String arg0) {
        if (arg0 == null) {
            arg0 = this.colors_[0].getName();
        }
        return super.setValue((Object)arg0);
    }

    private StringBuilder encodeValue(String value) {
        char[] chars = new char[]{'\'', '\"'};
        String[] refs = new String[]{"&#39;", "&#34;"};
        StringBuilder builder = new StringBuilder(value);
        for (int i = 0; i < chars.length; ++i) {
            int idx = this.indexOf(builder, chars[i], 0);
            while (idx > -1) {
                builder = builder.replace(idx, idx + 1, refs[i]);
                idx = this.indexOf(builder, chars[i], idx);
            }
        }
        return builder;
    }

    private int indexOf(StringBuilder builder, char c, int from) {
        for (int i = from; i < builder.length(); ++i) {
            if (builder.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

