/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ContactUtils {
    public static final String COMMA = ",".intern();
    public static final String SEMI_COMMA = ";".intern();
    public static final String HTTP = "http://";
    public static String[] specialString = new String[]{"!", "#", "%", "&", ":", ">", "<", "~", "`", "]", "'", "/", "-"};
    public static String[] specialString2 = new String[]{"?", "[", "(", "|", ")", "*", "\\", "+", "}", "{", "^", "$", "\"", "!", "#", "%", "&", ":", ">", "<", "~", "`", "]", "'", "/", "-"};

    public static String getDisplayAdddressShared(String sharedUserId, String addressName) {
        return sharedUserId + " - " + addressName;
    }

    public static String encodeJCRText(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static boolean isNameValid(String name, String[] regex) {
        if (ContactUtils.isEmpty((String)name)) {
            return true;
        }
        for (String c : regex) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static String encodeHTML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static ContactService getContactService() throws Exception {
        return (ContactService)PortalContainer.getComponent(ContactService.class);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static List<String> getUserGroups() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(ContactUtils.getCurrentUser()).toArray();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            groupIds.add(((Group)object).getId());
        }
        return groupIds;
    }

    public static String getPublicGroupName(String groupId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getGroupHandler().findGroupById(groupId).getGroupName();
    }

    public static boolean isPublicGroup(String groupId) throws Exception {
        return ContactUtils.getUserGroups().contains(groupId);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)date);
    }

    public static List<Account> getAccounts() throws Exception {
        MailService mailSvr = (MailService)PortalContainer.getComponent(MailService.class);
        try {
            return mailSvr.getAccounts(ContactUtils.getCurrentUser());
        }
        catch (RepositoryException e) {
            return null;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static String emptyName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("ContactUtils.label.emptyName");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return "(empty name)";
        }
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String fullName = user.getFullName();
        return fullName;
    }

    public static void sendMessage(Message message) throws Exception {
        org.exoplatform.services.mail.MailService mService = (org.exoplatform.services.mail.MailService)PortalContainer.getComponent(org.exoplatform.services.mail.MailService.class);
        mService.sendMessage(message);
    }

    public static boolean isCollectedAddressBook(String addressId) {
        return addressId.contains(NewUserListener.ADDRESSESGROUP);
    }

    public static String reduceSpace(String s) {
        if (ContactUtils.isEmpty((String)s)) {
            return "";
        }
        String[] words = s.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (builder.length() > 0 && word.trim().length() > 0) {
                builder.append(" ");
            }
            builder.append(word.trim());
        }
        return builder.toString();
    }

    public static String listToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String str : list) {
            if (builder.length() > 0) {
                builder.append("; " + str);
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }
}

