/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactPageList;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.JCRPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.contact.webui.UIAddressBooks;
import org.exoplatform.contact.webui.UIContactContainer;
import org.exoplatform.contact.webui.UIContactPortlet;
import org.exoplatform.contact.webui.UIContactPreview;
import org.exoplatform.contact.webui.UIContacts;
import org.exoplatform.contact.webui.UISearchForm;
import org.exoplatform.contact.webui.UITags;
import org.exoplatform.contact.webui.UIWorkingContainer;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/UIContacts.gtmpl", events={@EventConfig(listeners={EditContactActionListener.class}), @EventConfig(listeners={SendEmailActionListener.class}), @EventConfig(listeners={TagActionListener.class}), @EventConfig(listeners={MoveContactsActionListener.class}), @EventConfig(listeners={DNDContactsActionListener.class}), @EventConfig(listeners={DNDContactsToTagActionListener.class}), @EventConfig(listeners={DeleteContactsActionListener.class}, confirm="UIContacts.msg.confirm-delete"), @EventConfig(listeners={SelectedContactActionListener.class}), @EventConfig(listeners={CopyContactActionListener.class}), @EventConfig(listeners={ViewDetailsActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={FirstPageActionListener.class}), @EventConfig(listeners={PreviousPageActionListener.class}), @EventConfig(listeners={NextPageActionListener.class}), @EventConfig(listeners={LastPageActionListener.class}), @EventConfig(listeners={ExportContactActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectTagActionListener.class}), @EventConfig(listeners={SharedContactsActionListener.class}), @EventConfig(listeners={CloseSearchActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={PrintDetailsActionListener.class})})
public class UIContacts
extends UIForm
implements UIPopupComponent {
    public boolean viewContactsList = true;
    public boolean viewListBeforePrint = false;
    private String selectedTag_ = null;
    private LinkedHashMap<String, Contact> contactMap = new LinkedHashMap();
    private String selectedGroup = null;
    private String selectedContact = null;
    private JCRPageList pageList_ = null;
    private String sortedBy_ = null;
    private boolean isAscending_ = true;
    private String viewQuery_ = null;
    public static String fullName = "fullName".intern();
    public static String emailAddress = "emailAddress".intern();
    public static String jobTitle = "jobTitle".intern();
    private boolean isSearchResult = false;
    private boolean defaultNameSorted = true;
    private boolean isPrintForm = false;
    private boolean isPrintDetail = false;
    private boolean isSelectSharedContacts = false;
    private List<Contact> listBeforePrint = new ArrayList();
    private String selectedTagBeforeSearch_ = null;
    private String selectedGroupBeforeSearch = null;
    private boolean isSelectSharedContactsBeforeSearch = false;
    private boolean viewListBeforeSearch = true;
    private String checkedAll = "";

    public void setCheckedAll(String checkedAll) {
        this.checkedAll = checkedAll;
    }

    public String isCheckAll() {
        return this.checkedAll;
    }

    public void setListBeforePrint(List<Contact> contacts) {
        this.listBeforePrint = contacts;
    }

    public String[] getActions() {
        return new String[]{"Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public boolean canChat() {
        try {
            Class.forName("org.exoplatform.services.xmpp.rest.RESTXMPPService");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void refreshData() throws Exception {
        if (this.isDisplaySearchResult() || this.isPrintForm) {
            return;
        }
        long currentPage = 1L;
        if (this.selectedGroup != null) {
            if (this.pageList_ != null) {
                currentPage = this.pageList_.getCurrentPage();
            }
            ContactPageList pageList = null;
            if (this.getPrivateGroupMap().containsKey(this.selectedGroup)) {
                pageList = ContactUtils.getContactService().getPersonalContactsByAddressBook(ContactUtils.getCurrentUser(), this.selectedGroup);
            } else if (ContactUtils.getUserGroups().contains(this.selectedGroup)) {
                pageList = ContactUtils.getContactService().getPublicContactsByAddressBook(this.selectedGroup);
            } else if (this.getSharedGroupMap().containsKey(this.selectedGroup)) {
                UIAddressBooks uiAddressBooks = (UIAddressBooks)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIAddressBooks.class);
                pageList = ContactUtils.getContactService().getSharedContactsByAddressBook(ContactUtils.getCurrentUser(), (SharedAddressBook)uiAddressBooks.getSharedGroups().get(this.selectedGroup));
            } else {
                this.selectedGroup = null;
            }
            if (pageList != null) {
                pageList.setCurrentPage(currentPage);
            }
            this.setContacts((JCRPageList)pageList);
        } else if (this.selectedTag_ != null) {
            DataPageList pageList;
            if (this.pageList_ != null) {
                currentPage = this.pageList_.getCurrentPage();
            }
            if ((pageList = ContactUtils.getContactService().getContactPageListByTag(ContactUtils.getCurrentUser(), this.selectedTag_)) != null) {
                List contacts = new ArrayList();
                contacts = pageList.getAll();
                if (this.getSortedBy().equals(fullName)) {
                    Collections.sort(contacts, new FullNameComparator());
                } else if (this.getSortedBy().equals(emailAddress)) {
                    Collections.sort(contacts, new EmailComparator());
                } else if (this.getSortedBy().equals(jobTitle)) {
                    Collections.sort(contacts, new JobTitleComparator());
                }
                pageList.setList(contacts);
                pageList.setCurrentPage(currentPage);
            }
            this.setContacts((JCRPageList)pageList);
        } else if (this.isSelectSharedContacts) {
            this.setContacts((JCRPageList)ContactUtils.getContactService().getSharedContacts(ContactUtils.getCurrentUser()));
        }
    }

    public void setSelectSharedContacts(boolean selected) {
        this.isSelectSharedContacts = selected;
    }

    public boolean isSelectSharedContacts() {
        return this.isSelectSharedContacts;
    }

    public boolean havePermissionAdd(Contact contact) throws Exception {
        if (!contact.getContactType().equals(DataStorage.SHARED)) {
            return false;
        }
        Map sharedGroupMap = ((UIAddressBooks)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIAddressBooks.class)).getSharedGroups();
        String currentUser = ContactUtils.getCurrentUser();
        for (String address : contact.getAddressBookIds()) {
            SharedAddressBook add = (SharedAddressBook)sharedGroupMap.get(address);
            if (add == null) continue;
            if (add.getEditPermissionUsers() != null && Arrays.asList(add.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
                return true;
            }
            String[] editPerGroups = add.getEditPermissionGroups();
            if (editPerGroups != null) {
                for (String editPer : editPerGroups) {
                    if (!ContactUtils.getUserGroups().contains(editPer)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean havePermission(Contact contact) throws Exception {
        if (!contact.getContactType().equals(DataStorage.SHARED)) {
            return true;
        }
        String currentUser = ContactUtils.getCurrentUser();
        if (contact.getEditPermissionUsers() != null && Arrays.asList(contact.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = contact.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!ContactUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        Map sharedGroupMap = ((UIAddressBooks)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIAddressBooks.class)).getSharedGroups();
        for (String address : contact.getAddressBookIds()) {
            try {
                SharedAddressBook add = (SharedAddressBook)sharedGroupMap.get(address);
                if (add.getEditPermissionUsers() != null && Arrays.asList(add.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
                    return true;
                }
                editPerGroups = add.getEditPermissionGroups();
                if (editPerGroups == null) continue;
                for (String editPer : editPerGroups) {
                    if (!ContactUtils.getUserGroups().contains(editPer)) continue;
                    return true;
                }
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isSharedAddress(Contact contact) throws Exception {
        if (this.isSelectSharedContacts) {
            return false;
        }
        for (String add : contact.getAddressBookIds()) {
            if (!this.getSharedGroupMap().containsKey(add)) continue;
            return true;
        }
        return false;
    }

    public void setPrintForm(boolean isPrint) {
        this.isPrintForm = isPrint;
    }

    public boolean isPrintForm() {
        return this.isPrintForm;
    }

    public void setPrintDetail(boolean isDetail) {
        this.isPrintDetail = isDetail;
    }

    public boolean isDisplaySearchResult() {
        if (!this.isSearchResult) {
            ((UIFormStringInput)((UISearchForm)((UIContactPortlet)this.getAncestorOfType(UIContactPortlet.class)).findFirstComponentOfType(UISearchForm.class)).getChild(UIFormStringInput.class)).setValue(null);
        }
        return this.isSearchResult;
    }

    public void setDisplaySearchResult(boolean search) {
        this.isSearchResult = search;
    }

    public void setViewListBeforePrint(boolean isList) {
        this.viewListBeforePrint = isList;
    }

    public void setAscending(boolean isAsc) {
        this.isAscending_ = isAsc;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setSortedBy(String s) {
        this.sortedBy_ = s;
    }

    public String getSortedBy() {
        return this.sortedBy_;
    }

    public String getViewQuery() {
        return this.viewQuery_;
    }

    public void setViewQuery(String view) {
        this.viewQuery_ = view;
    }

    public void setContacts(JCRPageList pageList) throws Exception {
        this.pageList_ = pageList;
        this.updateList();
    }

    public JCRPageList getContactPageList() {
        return this.pageList_;
    }

    public boolean isAscName() {
        return FullNameComparator.isAsc;
    }

    public boolean isAscEmail() {
        return EmailComparator.access$000();
    }

    public boolean isAscJob() {
        return JobTitleComparator.access$100();
    }

    public void setDefaultNameSorted(boolean name) {
        this.defaultNameSorted = name;
    }

    public boolean isNameSorted() {
        return this.defaultNameSorted;
    }

    public void setContact(List<Contact> contacts, boolean isUpdate) throws Exception {
        if (this.pageList_ != null) {
            this.pageList_.setContact(contacts, isUpdate);
        }
    }

    public void updateList() throws Exception {
        ArrayList<String> checkedList = new ArrayList<String>();
        for (String contactId : this.contactMap.keySet()) {
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(contactId);
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checkedList.add(contactId);
        }
        this.getChildren().clear();
        this.contactMap.clear();
        UIContactPreview contactPreview = (UIContactPreview)((UIContactContainer)this.getAncestorOfType(UIContactContainer.class)).getChild(UIContactPreview.class);
        if (this.pageList_ != null) {
            List contactList = this.pageList_.getPage(this.pageList_.getCurrentPage(), ContactUtils.getCurrentUser());
            if (contactList.size() == 0 && this.pageList_.getCurrentPage() > 1L) {
                contactList = this.pageList_.getPage(this.pageList_.getCurrentPage() - 1L, ContactUtils.getCurrentUser());
            }
            for (Contact contact : contactList) {
                UIFormCheckBoxInput checkbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
                if (checkedList.contains(contact.getId())) {
                    checkbox.setChecked(true);
                }
                this.addUIFormInput((UIFormInput)checkbox);
                this.contactMap.put(contact.getId(), contact);
            }
            this.checkedAll = "checked";
            if (checkedList.size() != this.contactMap.size()) {
                this.checkedAll = "";
            } else {
                for (String id : this.contactMap.keySet()) {
                    if (checkedList.contains(id)) continue;
                    this.checkedAll = "";
                    break;
                }
            }
            Contact[] array = this.contactMap.values().toArray(new Contact[0]);
            if (array.length > 0) {
                if (!ContactUtils.isEmpty((String)this.selectedContact) && this.contactMap.containsKey(this.selectedContact)) {
                    contactPreview.setContact((Contact)this.contactMap.get(this.selectedContact));
                } else {
                    Contact firstContact = array[0];
                    contactPreview.setContact(firstContact);
                    this.selectedContact = firstContact.getId();
                }
            } else {
                contactPreview.setContact(null);
            }
        } else {
            contactPreview.setContact(null);
        }
    }

    public Contact[] getContacts() throws Exception {
        return this.contactMap.values().toArray(new Contact[0]);
    }

    public LinkedHashMap<String, Contact> getContactMap() {
        return this.contactMap;
    }

    public void setContactMap(LinkedHashMap<String, Contact> map) {
        this.contactMap = map;
    }

    public void setSelectedContact(String s) {
        this.selectedContact = s;
    }

    public String getSelectedContact() {
        return this.selectedContact;
    }

    public void setSelectedGroup(String s) {
        this.selectedGroup = s;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setViewContactsList(boolean list) {
        this.viewContactsList = list;
    }

    public boolean getViewContactsList() {
        if (this.viewContactsList) {
            ((UIContactPreview)((UIContactContainer)this.getAncestorOfType(UIContactContainer.class)).getChild(UIContactPreview.class)).setRendered(true);
        } else {
            ((UIContactPreview)((UIContactContainer)this.getAncestorOfType(UIContactContainer.class)).getChild(UIContactPreview.class)).setRendered(false);
        }
        return this.viewContactsList;
    }

    public List<String> getCheckedContacts() throws Exception {
        ArrayList<String> checkedContacts = new ArrayList<String>();
        for (String contactId : this.contactMap.keySet()) {
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(contactId);
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checkedContacts.add(contactId);
        }
        return checkedContacts;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getSelectedTag() {
        return this.selectedTag_;
    }

    public void setSelectedTag(String tagId) {
        this.selectedTag_ = tagId;
    }

    public Map<String, Tag> getTagMap() {
        return ((UITags)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UITags.class)).getTagMap();
    }

    public Map<String, String> getPrivateGroupMap() {
        return ((UIAddressBooks)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIAddressBooks.class)).getPrivateGroupMap();
    }

    public Map<String, SharedAddressBook> getSharedGroupMap() throws Exception {
        return ((UIAddressBooks)((UIWorkingContainer)this.getAncestorOfType(UIWorkingContainer.class)).findFirstComponentOfType(UIAddressBooks.class)).getSharedGroups();
    }

    public List<String> getPublicContactGroups() throws Exception {
        return Arrays.asList(ContactUtils.getUserGroups().toArray(new String[0]));
    }

    public String getDefaultGroup() {
        return NewUserListener.DEFAULTGROUP;
    }

    public String getSelectedTagBeforeSearch_() {
        return this.selectedTagBeforeSearch_;
    }

    public void setSelectedTagBeforeSearch_(String selectedTagBeforeSearch_) {
        this.selectedTagBeforeSearch_ = selectedTagBeforeSearch_;
    }

    public String getSelectedGroupBeforeSearch() {
        return this.selectedGroupBeforeSearch;
    }

    public void setSelectedGroupBeforeSearch(String selectedGroupBeforeSearch) {
        this.selectedGroupBeforeSearch = selectedGroupBeforeSearch;
    }

    public boolean isSelectSharedContactsBeforeSearch() {
        return this.isSelectSharedContactsBeforeSearch;
    }

    public void setSelectSharedContactsBeforeSearch(boolean isSelectSharedContactsBeforeSearch) {
        this.isSelectSharedContactsBeforeSearch = isSelectSharedContactsBeforeSearch;
    }

    public boolean isViewListBeforeSearch() {
        return this.viewListBeforeSearch;
    }

    public void setViewListBeforeSearch(boolean viewListBeforeSearch) {
        this.viewListBeforeSearch = viewListBeforeSearch;
    }

    private static void showWarnCanNotMove(UIContacts uiContacts, UIApplication uiApplication, Event<UIContacts> event) {
        uiApplication.addMessage(new ApplicationMessage("UIContacts.msg.cannot-move", null, 1));
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
        event.getRequestContext().addUIComponentToUpdateByAjax(uiContacts.getParent());
    }

    static /* synthetic */ LinkedHashMap access$200(UIContacts x0) {
        return x0.contactMap;
    }

    static /* synthetic */ void access$300(UIContacts x0, UIApplication x1, Event x2) {
        UIContacts.showWarnCanNotMove((UIContacts)x0, (UIApplication)x1, (Event)x2);
    }

    static /* synthetic */ boolean access$400(UIContacts x0) {
        return x0.isSearchResult;
    }

    static /* synthetic */ JCRPageList access$500(UIContacts x0) {
        return x0.pageList_;
    }

    static /* synthetic */ boolean access$600(UIContacts x0) {
        return x0.isSelectSharedContacts;
    }

    static /* synthetic */ String access$700(UIContacts x0) {
        return x0.selectedGroup;
    }

    static /* synthetic */ String access$800(UIContacts x0) {
        return x0.selectedTag_;
    }

    static /* synthetic */ boolean access$902(UIContacts x0, boolean x1) {
        x0.isPrintDetail = x1;
        return x0.isPrintDetail;
    }

    static /* synthetic */ boolean access$1000(UIContacts x0) {
        return x0.isAscending_;
    }

    static /* synthetic */ String access$1100(UIContacts x0) {
        return x0.selectedGroupBeforeSearch;
    }

    static /* synthetic */ String access$1200(UIContacts x0) {
        return x0.selectedTagBeforeSearch_;
    }

    static /* synthetic */ boolean access$1300(UIContacts x0) {
        return x0.isSelectSharedContactsBeforeSearch;
    }

    static /* synthetic */ boolean access$1400(UIContacts x0) {
        return x0.viewListBeforeSearch;
    }

    static /* synthetic */ void access$1500(UIContacts x0) throws Exception {
        x0.refreshData();
    }

    static /* synthetic */ LinkedHashMap access$202(UIContacts x0, LinkedHashMap x1) {
        x0.contactMap = x1;
        return x0.contactMap;
    }

    static /* synthetic */ boolean access$1602(UIContacts x0, boolean x1) {
        x0.isPrintForm = x1;
        return x0.isPrintForm;
    }

    static /* synthetic */ List access$1700(UIContacts x0) {
        return x0.listBeforePrint;
    }

    static /* synthetic */ String access$1802(UIContacts x0, String x1) {
        x0.selectedContact = x1;
        return x0.selectedContact;
    }
}

