/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.Tag;
import org.exoplatform.contact.webui.UIContactPortlet;
import org.exoplatform.contact.webui.UITags;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.contact.webui.popup.UITagForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormColorPicker;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UITagForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITagForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TAGNAME_INPUT = "tagName";
    public static final String NO_TAG_INFO = "no Tag";
    public static final String FIELD_COLOR = "color";
    private Map<String, String> tags = new LinkedHashMap();
    private List<Contact> contacts_ = new ArrayList();
    private String[] tagNames = null;
    private String[] contactNames = null;

    public UITagForm() throws Exception {
        this.setId("UITagForm");
    }

    public void setContacts(List<Contact> contacts) throws Exception {
        this.getChildren().clear();
        this.contacts_ = contacts;
        int i = 0;
        this.contactNames = new String[this.contacts_.size()];
        this.tagNames = new String[this.contacts_.size()];
        Map tapMap = ((UITags)((UIContactPortlet)this.getAncestorOfType(UIContactPortlet.class)).findFirstComponentOfType(UITags.class)).getTagMap();
        for (Tag tag : tapMap.values()) {
            this.tags.put(tag.getId(), tag.getName());
        }
        for (Contact contact : this.contacts_) {
            String fullName;
            String[] tagIds = null;
            if (contact == null) continue;
            tagIds = contact.getTags();
            StringBuffer buffer = new StringBuffer();
            if (tagIds != null && tagIds.length > 0) {
                for (int j = 0; j < tagIds.length; ++j) {
                    Tag tag = (Tag)tapMap.get(tagIds[j]);
                    if (tag != null && buffer.length() < 1) {
                        buffer.append(tag.getName());
                        continue;
                    }
                    if (tag == null) continue;
                    buffer.append(", " + tag.getName());
                }
            }
            if (ContactUtils.isEmpty((String)buffer.toString())) {
                buffer.append(NO_TAG_INFO);
            }
            this.contactNames[i] = ContactUtils.isEmpty((String)(fullName = contact.getFullName())) ? ContactUtils.emptyName() : ContactUtils.encodeHTML((String)fullName);
            this.tagNames[i] = buffer.toString();
            ++i;
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TAGNAME_INPUT, FIELD_TAGNAME_INPUT, null).addValidator(SpecialCharacterValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{1, 40}));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(FIELD_COLOR, FIELD_COLOR));
        for (String tagId : this.tags.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(tagId, tagId, (Object)false));
        }
    }

    public List<Contact> getContacts() {
        return this.contacts_;
    }

    public void setValues(String tagName) throws Exception {
        this.getUIStringInput(FIELD_TAGNAME_INPUT).setValue((Object)tagName);
    }

    public String[] getActions() {
        return new String[]{"Add", "Remove", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return id;
        }
    }

    public List<String> getCheckedTags() throws Exception {
        ArrayList<String> checkedTags = new ArrayList<String>();
        for (String tagId : this.tags.keySet()) {
            if (!this.getUIFormCheckBoxInput(tagId).isChecked()) continue;
            checkedTags.add(tagId);
        }
        return checkedTags;
    }

    protected String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    protected void setSelectedColor(String value) {
        ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setValue(value);
    }

    static /* synthetic */ List access$000(UITagForm x0) {
        return x0.contacts_;
    }
}

