/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.contact.webui.popup.UIPublicAddressPermission;
import org.exoplatform.contact.webui.popup.UISelectPermissionsForm;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIPublicAddressPermission.msg.confirm-delete")})
public class UIPublicAddressPermission
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"viewPermission", "editPermission"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};
    private String groupId_;

    public UIPublicAddressPermission() throws Exception {
        this.setName("UIPublicAddressPermission");
        UIGrid permissionList = (UIGrid)this.addChild(UIGrid.class, null, "PermissionList");
        permissionList.configure("viewPermission", BEAN_FIELD, ACTION);
        permissionList.getUIPageIterator().setId("PermissionListIterator");
        this.addChild(UISelectPermissionsForm.class, null, null);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void initGroup(AddressBook group) throws Exception {
        this.groupId_ = group.getId();
        this.updateGroupGrid(group);
        ((UISelectPermissionsForm)this.getChild(UISelectPermissionsForm.class)).init();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ((UIGrid)this.getChild(UIGrid.class)).setRendered(true);
        context.getWriter().append("<span class=\"").append(this.getId()).append("\" id=\"").append(this.getId()).append("\">");
        this.renderChildren(context);
        context.getWriter().append("</span>");
    }

    public void updateGroupGrid(AddressBook group) throws Exception {
        ArrayList<data> dataRow = new ArrayList<data>();
        if (group.getViewPermissionUsers() != null) {
            for (String username : group.getViewPermissionUsers()) {
                dataRow.add(new data(this, username, group.getEditPermissionUsers() != null && Arrays.asList(group.getEditPermissionUsers()).contains(username)));
            }
        }
        if (group.getViewPermissionGroups() != null) {
            for (String groupId : group.getViewPermissionGroups()) {
                dataRow.add(new data(this, groupId, group.getEditPermissionGroups() != null && Arrays.asList(group.getEditPermissionGroups()).contains(groupId)));
            }
        }
        UIGrid permissionList = (UIGrid)this.getChild(UIGrid.class);
        int currentPage = 1;
        try {
            currentPage = permissionList.getUIPageIterator().getPageList().getCurrentPage();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(data.class, dataRow), 10);
        permissionList.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > 1 && currentPage <= permissionList.getUIPageIterator().getAvailablePage()) {
            permissionList.getUIPageIterator().setCurrentPage(currentPage);
        }
        ((UISelectPermissionsForm)this.getChild(UISelectPermissionsForm.class)).setGroup(group);
    }

    static /* synthetic */ String access$000(UIPublicAddressPermission x0) {
        return x0.groupId_;
    }
}

