/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.impl.NewUserListener;
import org.exoplatform.contact.webui.UIContactPortlet;
import org.exoplatform.contact.webui.popup.PermissionData;
import org.exoplatform.contact.webui.popup.UIPopupContainer;
import org.exoplatform.contact.webui.popup.UISelectComponent;
import org.exoplatform.contact.webui.popup.UISelectPermissionsForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.organization.account.UIGroupSelector;
import org.exoplatform.webui.organization.account.UIUserSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ContactUtils {
    private static final Log log = ExoLogger.getExoLogger(ContactUtils.class);
    public static final String COMMA = ",".intern();
    public static final String SEMI_COMMA = ";".intern();
    public static final String HTTP = "http://";
    public static String[] specialString2 = new String[]{"'"};
    public static final String FIELD_USER = "user".intern();
    public static final String FIELD_GROUP = "group".intern();
    public static final String FIELD_EDIT_PERMISSION = "canEdit".intern();
    public static final String NAME = "fileName".intern();
    public static final String TYPE = "type".intern();
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;

    public static String getDisplayAdddressShared(String sharedUserId, String addressName) {
        return sharedUserId + " - " + addressName;
    }

    public static String encodeJCRText(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static boolean isNameValid(String name, String[] regex) {
        if (ContactUtils.isEmpty((String)name)) {
            return true;
        }
        for (String c : regex) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static String encodeHTML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static ContactService getContactService() throws Exception {
        return (ContactService)PortalContainer.getComponent(ContactService.class);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static List<String> getUserGroups() throws Exception {
        Identity identity = ConversationState.getCurrent().getIdentity();
        ArrayList<String> groupIds = new ArrayList<String>(identity.getGroups());
        return groupIds;
    }

    public static String getPublicGroupName(String groupId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getGroupHandler().findGroupById(groupId).getGroupName();
    }

    public static boolean isPublicGroup(String groupId) throws Exception {
        return ContactUtils.getUserGroups().contains(groupId);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format((Object)date);
    }

    public static List<Account> getAccounts() throws Exception {
        MailService mailSvr = (MailService)PortalContainer.getComponent(MailService.class);
        try {
            return mailSvr.getAccounts(ContactUtils.getCurrentUser());
        }
        catch (RepositoryException e) {
            return null;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static String emptyName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("ContactUtils.label.emptyName");
        }
        catch (MissingResourceException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"MissingResourceException in method emptyName", (Throwable)e);
            }
            return "(empty name)";
        }
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String fullName = user.getFullName();
        return fullName;
    }

    public static void sendMessage(Message message) throws Exception {
        org.exoplatform.services.mail.MailService mService = (org.exoplatform.services.mail.MailService)PortalContainer.getComponent(org.exoplatform.services.mail.MailService.class);
        mService.sendMessage(message);
    }

    public static boolean isCollectedAddressBook(String addressId) {
        return addressId.contains(NewUserListener.ADDRESSESGROUP);
    }

    public static String reduceSpace(String s) {
        if (ContactUtils.isEmpty((String)s)) {
            return "";
        }
        String[] words = s.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (builder.length() > 0 && word.trim().length() > 0) {
                builder.append(" ");
            }
            builder.append(word.trim());
        }
        return builder.toString();
    }

    public static String listToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String str : list) {
            if (builder.length() > 0) {
                builder.append("; " + str);
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static int getAge(Contact contact) {
        if (contact == null) {
            return 0;
        }
        GregorianCalendar birthday = new GregorianCalendar();
        birthday.setTime(contact.getBirthday());
        GregorianCalendar now = new GregorianCalendar();
        return now.get(1) - birthday.get(1);
    }

    public static Map<String, String> getIMs(Contact contact) {
        LinkedHashMap<String, String> ims = new LinkedHashMap<String, String>();
        if (!ContactUtils.isEmpty((String)contact.getExoId())) {
            ims.put("exoChat", contact.getExoId());
        }
        if (!ContactUtils.isEmpty((String)contact.getGoogleId())) {
            ims.put("google", contact.getGoogleId());
        }
        if (!ContactUtils.isEmpty((String)contact.getMsnId())) {
            ims.put("msn", contact.getMsnId());
        }
        if (!ContactUtils.isEmpty((String)contact.getAolId())) {
            ims.put("aol-aim", contact.getAolId());
        }
        if (!ContactUtils.isEmpty((String)contact.getYahooId())) {
            ims.put("yahoo", contact.getYahooId());
        }
        if (!ContactUtils.isEmpty((String)contact.getIcrId())) {
            ims.put("icr", contact.getIcrId());
        }
        if (!ContactUtils.isEmpty((String)contact.getSkypeId())) {
            ims.put("skype", contact.getSkypeId());
        }
        if (!ContactUtils.isEmpty((String)contact.getIcqId())) {
            ims.put("icq", contact.getIcqId());
        }
        return ims;
    }

    public static Map<String, String> getPhones(Contact contact) {
        LinkedHashMap<String, String> phones = new LinkedHashMap<String, String>();
        if (!ContactUtils.isEmpty((String)contact.getWorkPhone1())) {
            phones.put(contact.getWorkPhone1(), "work");
        }
        if (!ContactUtils.isEmpty((String)contact.getWorkPhone2())) {
            phones.put(contact.getWorkPhone2(), "work");
        }
        if (!ContactUtils.isEmpty((String)contact.getHomePhone1())) {
            phones.put(contact.getHomePhone1(), "home");
        }
        if (!ContactUtils.isEmpty((String)contact.getHomePhone2())) {
            phones.put(contact.getHomePhone2(), "home");
        }
        if (!ContactUtils.isEmpty((String)contact.getMobilePhone())) {
            phones.put(contact.getMobilePhone(), "home");
        }
        return phones;
    }

    public static boolean isNullArray(String[] array) {
        return array.length < 1;
    }

    public static UIFormInputWithActions initSelectPermissions(UIFormInputWithActions inputset) throws Exception {
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_USER, FIELD_USER, null));
        ArrayList<UIFormInputWithActions.ActionData> actionUser = new ArrayList<UIFormInputWithActions.ActionData>();
        actionUser = new ArrayList();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setActionType(0);
        selectUserAction.setCssIconClass("SelectUserIcon");
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER);
        actionUser.add(selectUserAction);
        inputset.setActionField(FIELD_USER, actionUser);
        UIFormStringInput groupField = new UIFormStringInput(FIELD_GROUP, FIELD_GROUP, null);
        inputset.addUIFormInput((UIFormInput)groupField);
        ArrayList<UIFormInputWithActions.ActionData> actionGroup = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectGroupAction = new UIFormInputWithActions.ActionData();
        selectGroupAction.setActionListener("SelectPermission");
        selectGroupAction.setActionName("SelectGroup");
        selectGroupAction.setActionType(0);
        selectGroupAction.setCssIconClass("SelectGroupIcon");
        selectGroupAction.setActionParameter(UISelectComponent.TYPE_GROUP);
        actionGroup.add(selectGroupAction);
        inputset.setActionField(FIELD_GROUP, actionGroup);
        inputset.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_EDIT_PERMISSION, FIELD_EDIT_PERMISSION, null));
        return inputset;
    }

    public static void updateSelect(UIFormStringInput fieldInput, String selectField, String value) throws Exception {
        StringBuilder sb = new StringBuilder("");
        if (!ContactUtils.isEmpty((String)((String)fieldInput.getValue()))) {
            sb.append((String)fieldInput.getValue());
        }
        if (sb.indexOf(value) == -1) {
            if (sb.length() == 0) {
                sb.append(value);
            } else {
                sb.append("," + value);
            }
            fieldInput.setValue((Object)sb.toString());
        }
    }

    public static AddressBook setViewPermissionAddress(AddressBook contactGroup, Map<String, String> receiveUsers, Map<String, String> receiveGroups) {
        String[] viewPerUsers = contactGroup.getViewPermissionUsers();
        LinkedHashMap<String, String> viewMapUsers = new LinkedHashMap<String, String>();
        if (viewPerUsers != null) {
            for (String view : viewPerUsers) {
                viewMapUsers.put(view, view);
            }
        }
        for (String user : receiveUsers.keySet()) {
            viewMapUsers.put(user, user);
        }
        contactGroup.setViewPermissionUsers(viewMapUsers.keySet().toArray(new String[0]));
        String[] viewPerGroups = contactGroup.getViewPermissionGroups();
        LinkedHashMap<String, String> viewMapGroups = new LinkedHashMap<String, String>();
        if (viewPerGroups != null) {
            for (String view : viewPerGroups) {
                viewMapGroups.put(view, view);
            }
        }
        for (String user : receiveGroups.keySet()) {
            viewMapGroups.put(user, user);
        }
        contactGroup.setViewPermissionGroups(viewMapGroups.keySet().toArray(new String[0]));
        return contactGroup;
    }

    public static AddressBook removeEditPermissionAddress(AddressBook contactGroup, Map<String, String> receiveUsers, Map<String, String> receiveGroups) {
        ArrayList<String> newPerUsers = new ArrayList<String>();
        if (contactGroup.getEditPermissionUsers() != null) {
            for (String edit : contactGroup.getEditPermissionUsers()) {
                if (receiveUsers.keySet().contains(edit)) continue;
                newPerUsers.add(edit);
            }
        }
        contactGroup.setEditPermissionUsers(newPerUsers.toArray(new String[newPerUsers.size()]));
        ArrayList<String> newPerGroups = new ArrayList<String>();
        if (contactGroup.getEditPermissionGroups() != null) {
            for (String edit : contactGroup.getEditPermissionGroups()) {
                if (receiveGroups.keySet().contains(edit)) continue;
                newPerGroups.add(edit);
            }
        }
        contactGroup.setEditPermissionGroups(newPerGroups.toArray(new String[newPerGroups.size()]));
        return contactGroup;
    }

    public static AddressBook setEditPermissionAddress(AddressBook contactGroup, Map<String, String> receiveUsers, Map<String, String> receiveGroups) {
        String[] editPerUsers = contactGroup.getEditPermissionUsers();
        LinkedHashMap<String, String> editMapUsers = new LinkedHashMap<String, String>();
        if (editPerUsers != null) {
            for (String edit : editPerUsers) {
                editMapUsers.put(edit, edit);
            }
        }
        for (String user : receiveUsers.keySet()) {
            editMapUsers.put(user, user);
        }
        contactGroup.setEditPermissionUsers(editMapUsers.keySet().toArray(new String[0]));
        String[] editPerGroups = contactGroup.getEditPermissionGroups();
        LinkedHashMap<String, String> editMapGroups = new LinkedHashMap<String, String>();
        if (editPerGroups != null) {
            for (String edit : editPerGroups) {
                editMapGroups.put(edit, edit);
            }
        }
        for (String group : receiveGroups.keySet()) {
            editMapGroups.put(group, group);
        }
        contactGroup.setEditPermissionGroups(editMapGroups.keySet().toArray(new String[0]));
        return contactGroup;
    }

    public static void selectPermissions(UIForm uiForm, Event<?> event) throws Exception {
        String permType = event.getRequestContext().getRequestParameter("objectId");
        UIPopupContainer uiContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
        uiContainer.removeChild(UIPopupWindow.class);
        uiForm.removeChild(UIPopupWindow.class);
        if (permType.equals(UISelectComponent.TYPE_USER)) {
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiContainer.getChild(UIPopupWindow.class);
            if (uiPopupWindow == null) {
                uiPopupWindow = (UIPopupWindow)uiContainer.addChild(UIPopupWindow.class, "UIPopupWindowUserSelect", "UIPopupWindowUserSelect");
            }
            UIUserSelector uiUserSelector = (UIUserSelector)uiContainer.createUIComponent(UIUserSelector.class, null, null);
            uiUserSelector.setShowSearch(true);
            uiUserSelector.setShowSearchUser(true);
            uiUserSelector.setShowSearchGroup(true);
            uiPopupWindow.setUIComponent((UIComponent)uiUserSelector);
            uiPopupWindow.setShow(true);
            uiPopupWindow.setWindowSize(740, 400);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        } else {
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.addChild(UIPopupWindow.class, null, "UIPopupGroupSelector");
            uiPopup.setWindowSize(540, 0);
            UIGroupSelector uiGroup = (UIGroupSelector)uiForm.createUIComponent(UIGroupSelector.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiGroup);
            uiGroup.setId("UIGroupSelector");
            ((UITree)uiGroup.getChild(UITree.class)).setId("TreeGroupSelector");
            ((UIBreadcumbs)uiGroup.getChild(UIBreadcumbs.class)).setId("BreadcumbsGroupSelector");
            ((UIPopupWindow)uiForm.getChild(UIPopupWindow.class)).setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static void updateGroupGrid(UIContainer uiContainer, AddressBook group) throws Exception {
        UISelectPermissionsForm uiSelectPermissionsForm;
        ArrayList<PermissionData> dataRow = new ArrayList<PermissionData>();
        if (group.getViewPermissionUsers() != null) {
            for (String username : group.getViewPermissionUsers()) {
                dataRow.add(new PermissionData(username, group.getEditPermissionUsers() != null && Arrays.asList(group.getEditPermissionUsers()).contains(username)));
            }
        }
        if (group.getViewPermissionGroups() != null) {
            for (String groupId : group.getViewPermissionGroups()) {
                dataRow.add(new PermissionData(groupId, group.getEditPermissionGroups() != null && Arrays.asList(group.getEditPermissionGroups()).contains(groupId)));
            }
        }
        UIGrid permissionList = (UIGrid)uiContainer.getChild(UIGrid.class);
        int currentPage = 1;
        try {
            currentPage = permissionList.getUIPageIterator().getPageList().getCurrentPage();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(PermissionData.class, dataRow), 10);
        permissionList.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > 1 && currentPage <= permissionList.getUIPageIterator().getAvailablePage()) {
            permissionList.getUIPageIterator().setCurrentPage(currentPage);
        }
        if ((uiSelectPermissionsForm = (UISelectPermissionsForm)uiContainer.getChild(UISelectPermissionsForm.class)) != null) {
            uiSelectPermissionsForm.setGroup(group);
        }
    }

    public static void exportData(UIForm uiForm, Event<?> event, OutputStream out) throws Exception {
        String exportFormat = (String)uiForm.getUIFormSelectBox(TYPE).getValue();
        String fileName = (String)uiForm.getUIStringInput(NAME).getValue();
        String contentType = null;
        String extension = null;
        if (exportFormat.equals("x-vcard")) {
            contentType = "text/x-vcard";
            extension = ".vcf";
        }
        ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
        InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)is, contentType);
        DownloadService dservice = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
        if (fileName != null && fileName.length() > 0) {
            if (fileName.length() > 4 && fileName.endsWith(extension)) {
                dresource.setDownloadName(fileName);
            } else {
                dresource.setDownloadName(fileName + extension);
            }
        } else {
            dresource.setDownloadName("eXoExported.vcf");
        }
        String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        ((UIContactPortlet)uiForm.getAncestorOfType(UIContactPortlet.class)).cancelAction();
    }

    public static int getLimitUploadSize() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        int limitMB = -1;
        try {
            limitMB = Integer.parseInt(portletPref.getValue("uploadFileSizeLimitMB", "").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return limitMB;
    }
}

