/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.content.model.ContentNavigation;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.content.webui.UIContentNavigation;
import org.exoplatform.content.webui.UIContentWorkingArea;
import org.exoplatform.content.webui.UIDetailContent;
import org.exoplatform.content.webui.UIRSSReaderPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/rssreader/webui/UIContentNavigation.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={UpLevelActionListener.class}), @EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={EditNodeActionListener.class}), @EventConfig(listeners={RemoveNodeActionListener.class}, confirm="UIContentNavigation.removeNode"), @EventConfig(listeners={GetNodeInfoActionListener.class})})
public class UIContentNavigation
extends UIContainer {
    private ContentNode selectedNode_;
    private ContentNode parentNode_;
    private ContentNavigation nav_;
    private ContentNode grandNode_;
    private static final String anonymous_ = "anonymous";

    void refresh() throws Exception {
        ContentDAO contentService = (ContentDAO)this.getApplicationComponent(ContentDAO.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        this.nav_ = contentService.get(userName);
        if (this.nav_ == null) {
            this.nav_ = new ContentNavigation();
            if (userName == null) {
                userName = anonymous_;
            }
            this.nav_.setOwner(userName);
        }
        if (this.nav_.getNodes() != null && this.nav_.getNodes().size() > 0) {
            this.setSelectedNode(this.nav_.getNode(0).getId());
            return;
        }
        this.setSelectedNode(null);
    }

    void save(ContentNode node) throws Exception {
        ContentDAO service = (ContentDAO)this.getApplicationComponent(ContentDAO.class);
        ContentNode tempNode = this.selectedNode_;
        this.parentNode_ = null;
        this.grandNode_ = null;
        this.selectedNode_ = this.findNode(node.getId());
        if (this.parentNode_ != null) {
            int idx = this.parentNode_.getChildren().indexOf(this.selectedNode_);
            this.parentNode_.getChildren().set(idx, node);
            node.setChildren((ArrayList)this.selectedNode_.getChildren());
        } else if (this.selectedNode_ != null) {
            int idx = this.nav_.getNodes().indexOf(this.selectedNode_);
            this.nav_.getNodes().set(idx, node);
            node.setChildren((ArrayList)this.selectedNode_.getChildren());
        } else if (tempNode == null) {
            this.nav_.addNode(node);
        } else {
            tempNode.addChild(node);
        }
        service.save(this.nav_);
        this.setSelectedNode(node.getId());
    }

    public ContentNode getSelectedNode() {
        return this.selectedNode_;
    }

    public void setSelectedNode(String id) {
        this.parentNode_ = null;
        this.grandNode_ = null;
        this.selectedNode_ = this.findNode(id);
        UIRSSReaderPortlet uiParent = (UIRSSReaderPortlet)this.getParent();
        UIContentWorkingArea uiWorkingArea = (UIContentWorkingArea)uiParent.getChild(UIContentWorkingArea.class);
        if (this.selectedNode_ == null) {
            uiWorkingArea.setRenderedChild(UIDescription.class);
            return;
        }
        UIDetailContent uiDetail = (UIDetailContent)uiWorkingArea.getChild(UIDetailContent.class);
        uiDetail.setContentNode(this.selectedNode_);
        uiWorkingArea.setRenderedChild(UIDetailContent.class);
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)uiDetail.getChild(UIBreadcumbs.class);
        uiBreadcumbs.setPath(this.getPath(null, this.selectedNode_.getId()));
        this.parentNode_ = null;
        this.grandNode_ = null;
        this.selectedNode_ = this.findNode(id);
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> pathList, String nodeId) {
        if (pathList == null) {
            pathList = new ArrayList<UIBreadcumbs.LocalPath>();
        }
        if (nodeId == null) {
            return pathList;
        }
        this.parentNode_ = null;
        this.grandNode_ = null;
        ContentNode node = this.findNode(nodeId);
        pathList.add(0, new UIBreadcumbs.LocalPath(node.getId(), node.getLabel()));
        if (this.parentNode_ != null) {
            this.getPath(pathList, this.parentNode_.getId());
        }
        return pathList;
    }

    boolean isSelectedNode(ContentNode node) {
        if (this.selectedNode_ == null) {
            return false;
        }
        return this.selectedNode_.getId().equals(node.getId());
    }

    List<ContentNode> getSibbingNodes() {
        if (this.grandNode_ != null) {
            return this.grandNode_.getChildren();
        }
        if (this.parentNode_ != null) {
            return this.parentNode_.getChildren();
        }
        return this.nav_.getNodes();
    }

    public ContentNode getParentNode() {
        return this.parentNode_;
    }

    boolean isParentNode(ContentNode node) {
        if (this.parentNode_ == null) {
            return false;
        }
        return this.parentNode_.getId().equals(node.getId());
    }

    public ContentNavigation getContentNavigation() {
        return this.nav_;
    }

    public ContentNode findNode(String nodeId) {
        if (nodeId == null || this.nav_.getNodes() == null) {
            return null;
        }
        for (ContentNode node : this.nav_.getNodes()) {
            ContentNode value = this.findNode(nodeId, node);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private ContentNode findNode(String nodeId, ContentNode node) {
        if (node.getId().equals(nodeId)) {
            return node;
        }
        List children = node.getChildren();
        if (children == null) {
            return null;
        }
        for (ContentNode child : children) {
            ContentNode value;
            if (child == null || (value = this.findNode(nodeId, child)) == null) continue;
            if (this.parentNode_ == null) {
                this.parentNode_ = node;
            } else if (this.grandNode_ == null) {
                this.grandNode_ = node;
            }
            return value;
        }
        return null;
    }

    public boolean isLogon() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser() != null && context.getRemoteUser().length() >= 1;
    }
}

