/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.content.webui.UIContentForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContentForm
extends UIForm {
    public static final String FIELD_ID = "id";
    public static final String FIELD_URL = "url";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_TYPE = "type";
    private ContentNode contentNode;
    private List<SelectItemOption<String>> option_ = new ArrayList();

    public UIContentForm() throws Exception {
        ContentDAO service = (ContentDAO)PortalContainer.getComponent(ContentDAO.class);
        List types = service.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            this.option_.add(new SelectItemOption(((String)types.get(i)).toUpperCase(), (Object)((String)types.get(i)).toString()));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_ID, FIELD_ID, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_URL, FIELD_URL, null).addValidator(URLValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{1, 20}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION, FIELD_DESCRIPTION, null)).addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, this.option_).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public void setContentNode(ContentNode node) throws Exception {
        this.contentNode = node;
        if (node != null) {
            this.invokeGetBindingBean((Object)node);
            this.getUIStringInput(FIELD_ID).setEditable(false);
            return;
        }
        this.getUIStringInput(FIELD_ID).setEditable(true).setValue(null);
        this.getUIStringInput(FIELD_URL).setValue(null);
        this.getUIStringInput(FIELD_LABEL).setValue(null);
        this.getUIFormTextAreaInput(FIELD_DESCRIPTION).setValue(null);
    }

    public ContentNode getContentNode() {
        return this.contentNode;
    }
}

