/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.smtp.SMTPSendFailedException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.AccountData;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.ServerConfiguration;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.impl.EMLImportExport;
import org.exoplatform.mail.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceImpl
implements MailService {
    private static final Log logger = LogFactory.getLog(MailServiceImpl.class);
    private JCRDataStorage storage_;
    private EMLImportExport emlImportExport_;
    private Map<String, CheckingInfo> checkingLog_;

    public MailServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
        this.emlImportExport_ = new EMLImportExport(this.storage_);
        this.checkingLog_ = new HashMap<String, CheckingInfo>();
    }

    @Override
    public void removeCheckingInfo(String username, String accountId) throws Exception {
        String key = username + ":" + accountId;
        this.checkingLog_.remove(key);
    }

    @Override
    public CheckingInfo getCheckingInfo(String username, String accountId) throws Exception {
        String key = username + ":" + accountId;
        return this.checkingLog_.get(key);
    }

    @Override
    public List<Account> getAccounts(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getAccounts(sProvider, username);
    }

    @Override
    public Account getAccountById(SessionProvider sProvider, String username, String id) throws Exception {
        return this.storage_.getAccountById(sProvider, username, id);
    }

    public void saveAccount(SessionProvider sProvider, String username, Account account, boolean isNew) throws Exception {
        this.storage_.saveAccount(sProvider, username, account, isNew);
    }

    @Override
    public void updateAccount(SessionProvider sProvider, String username, Account account) throws Exception {
        this.saveAccount(sProvider, username, account, false);
    }

    @Override
    public void removeAccount(SessionProvider sProvider, String username, String accountId) throws Exception {
        this.storage_.removeAccount(sProvider, username, accountId);
    }

    @Override
    public Folder getFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        return this.storage_.getFolder(sProvider, username, accountId, folderId);
    }

    @Override
    public String getFolderParentId(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        return this.storage_.getFolderParentId(sProvider, username, accountId, folderId);
    }

    @Override
    public boolean isExistFolder(SessionProvider sProvider, String username, String accountId, String parentId, String folderName) throws Exception {
        return this.storage_.isExistFolder(sProvider, username, accountId, parentId, folderName);
    }

    @Override
    public void saveFolder(SessionProvider sProvider, String username, String accountId, Folder folder) throws Exception {
        this.storage_.saveFolder(sProvider, username, accountId, folder);
    }

    @Override
    public void removeUserFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        this.storage_.removeUserFolder(sProvider, username, accountId, folderId);
    }

    @Override
    public List<MessageFilter> getFilters(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.storage_.getFilters(sProvider, username, accountId);
    }

    @Override
    public MessageFilter getFilterById(SessionProvider sProvider, String username, String accountId, String filterId) throws Exception {
        return this.storage_.getFilterById(sProvider, username, accountId, filterId);
    }

    @Override
    public void saveFilter(SessionProvider sProvider, String username, String accountId, MessageFilter filter) throws Exception {
        this.storage_.saveFilter(sProvider, username, accountId, filter);
    }

    @Override
    public void removeFilter(SessionProvider sProvider, String username, String accountId, String filterId) throws Exception {
        this.storage_.removeFilter(sProvider, username, accountId, filterId);
    }

    @Override
    public Message getMessageById(SessionProvider sProvider, String username, String accountId, String msgId) throws Exception {
        return this.storage_.getMessageById(sProvider, username, accountId, msgId);
    }

    @Override
    public void removeMessage(SessionProvider sProvider, String username, String accountId, Message message) throws Exception {
        this.storage_.removeMessage(sProvider, username, accountId, message);
    }

    @Override
    public void removeMessages(SessionProvider sProvider, String username, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        this.storage_.removeMessages(sProvider, username, accountId, messages, moveReference);
    }

    @Override
    public void moveMessages(SessionProvider sProvider, String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        this.storage_.moveMessages(sProvider, username, accountId, msgList, currentFolderId, destFolderId);
    }

    @Override
    public void moveMessage(SessionProvider sProvider, String username, String accountId, Message msg, String currentFolderId, String destFolderId) throws Exception {
        this.storage_.moveMessage(sProvider, username, accountId, msg, currentFolderId, destFolderId);
    }

    @Override
    public MessagePageList getMessagePageList(SessionProvider sProvider, String username, MessageFilter filter) throws Exception {
        return this.storage_.getMessagePageList(sProvider, username, filter);
    }

    @Override
    public void saveMessage(SessionProvider sProvider, String username, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(sProvider, username, accountId, targetMsgPath, message, isNew);
    }

    @Override
    public List<Message> getMessagesByTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Tag");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{tagId});
        return this.getMessages(sProvider, username, filter);
    }

    @Override
    public List<Message> getMessagesByFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessages(sProvider, username, filter);
    }

    @Override
    public List<Message> getMessages(SessionProvider sProvider, String username, MessageFilter filter) throws Exception {
        return this.storage_.getMessages(sProvider, username, filter);
    }

    @Override
    public void saveMessage(SessionProvider sProvider, String username, String accountId, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(sProvider, username, accountId, message, isNew);
    }

    @Override
    public Message sendMessage(SessionProvider sProvider, String username, String accId, Message message) throws Exception {
        Account acc = this.getAccountById(sProvider, username, accId);
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_INCOMING_SSL);
        Properties props = new Properties();
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put(Utils.SVR_SMTP_AUTH, "true");
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_PORT, outgoingPort);
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
        props.put(Utils.SVR_INCOMING_SSL, isSSl);
        props.put(Utils.SVR_INCOMING_USERNAME, acc.getIncomingUser());
        props.put(Utils.SVR_INCOMING_PASSWORD, acc.getIncomingPassword());
        Session session = Session.getInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        Transport transport = session.getTransport("smtp");
        transport.connect(outgoingHost, smtpUser, acc.getIncomingPassword());
        Message msg = this.send(session, transport, message);
        transport.close();
        return msg;
    }

    @Override
    public Message sendMessage(SessionProvider sProvider, String username, Message message) throws Exception {
        return this.sendMessage(sProvider, username, message.getAccountId(), message);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(message);
        this.sendMessages(msgList, message.getServerConfiguration());
    }

    @Override
    public void sendMessages(List<Message> msgList, ServerConfiguration serverConfig) throws Exception {
        Properties props = new Properties();
        props.put(Utils.SVR_INCOMING_USERNAME, serverConfig.getUserName());
        props.put(Utils.SVR_INCOMING_PASSWORD, serverConfig.getPassword());
        props.put(Utils.SVR_SMTP_USER, serverConfig.getUserName());
        props.put(Utils.SVR_SMTP_HOST, serverConfig.getOutgoingHost());
        props.put(Utils.SVR_SMTP_PORT, serverConfig.getOutgoingPort());
        props.put(Utils.SVR_SMTP_AUTH, "true");
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_PORT, serverConfig.getOutgoingPort());
        if (serverConfig.isSsl()) {
            props.put(Utils.SVR_INCOMING_SSL, String.valueOf(serverConfig.isSsl()));
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        Session session = Session.getInstance((Properties)props, null);
        Transport transport = session.getTransport("smtp");
        transport.connect(serverConfig.getOutgoingHost(), serverConfig.getUserName(), serverConfig.getPassword());
        logger.debug((Object)" #### Sending email ... ");
        int i = 0;
        for (Message msg : msgList) {
            msg.setServerConfiguration(serverConfig);
            try {
                this.send(session, transport, msg);
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)(" #### Info : send fail at message " + i + " \n"));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
            }
        }
        logger.debug((Object)(" #### Info : Sent " + i + " email(s)"));
        transport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message send(Session session, Transport transport, Message message) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        if (message.getMessageCc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)message.getMessageCc(), (boolean)true));
        }
        if (message.getMessageBcc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)message.getMessageBcc(), (boolean)false));
        }
        if (message.getReplyTo() != null) {
            mimeMessage.setReplyTo((Address[])Utils.getInternetAddress(message.getReplyTo()));
        }
        mimeMessage.setSubject(message.getSubject());
        mimeMessage.setSentDate(message.getSendDate());
        MimeMultipart multipPartRoot = new MimeMultipart("mixed");
        MimeMultipart multipPartContent = new MimeMultipart("alternative");
        List<Attachment> attachList = message.getAttachments();
        if (attachList != null && attachList.size() != 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            contentPartRoot.setContent((Multipart)multipPartContent);
            MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)message.getMessageBody(), message.getContentType());
            multipPartContent.addBodyPart((BodyPart)mimeBodyPart1);
            multipPartRoot.addBodyPart((BodyPart)contentPartRoot);
            for (Attachment att : attachList) {
                InputStream is = att.getInputStream();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, att.getMimeType());
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                mimeBodyPart.setDisposition("attachment");
                mimeBodyPart.setFileName(att.getName());
                multipPartRoot.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)multipPartRoot);
        } else if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
            mimeMessage.setText(message.getMessageBody());
        } else {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/html");
        }
        mimeMessage.setHeader("X-Priority", String.valueOf(message.getPriority()));
        String priority = "Normal";
        if (message.getPriority() == 1L) {
            priority = "High";
        } else if (message.getPriority() == 5L) {
            priority = "Low";
        }
        if (message.getPriority() != 0L) {
            mimeMessage.setHeader("Importance", priority);
        }
        Iterator<String> iter = message.getHeaders().keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            mimeMessage.setHeader(key, message.getHeaders().get(key));
        }
        mimeMessage.saveChanges();
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            message.setId(MimeMessageParser.getMessageId((javax.mail.Message)mimeMessage));
            Enumeration enu = mimeMessage.getAllHeaders();
            while (enu.hasMoreElements()) {
                Header header = (Header)enu.nextElement();
                message.setHeader(header.getName(), header.getValue());
            }
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry,There was an error sending the message. Sending Failed !" + e.getMessage();
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
        }
        logger.debug((Object)(" #### Info : " + status));
        return message;
    }

    @Override
    public void checkMail(String username, String accountId) throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
        Class<?> clazz = Class.forName("org.exoplatform.mail.service.CheckMailJob");
        JobInfo info = new JobInfo(username + ":" + accountId, "CollaborationSuite-webmail", clazz);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        Utils.setMailService(mailService);
        Utils.setScheduleService(schedulerService);
        schedulerService.addPeriodJob(info, periodInfo);
    }

    @Override
    public List<Message> checkNewMessage(SessionProvider sProvider, String username, String accountId) throws Exception {
        Account account = this.getAccountById(sProvider, username, accountId);
        CheckingInfo info = new CheckingInfo();
        String key = username + ":" + accountId;
        this.checkingLog_.put(key, info);
        if (Utils.isEmptyField(account.getIncomingPassword())) {
            info.setStatusCode(103);
        }
        logger.warn((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
        info.setStatusMsg("Getting mail from " + account.getIncomingHost() + " ... !");
        ArrayList<Message> messageList = new ArrayList<Message>();
        int totalNew = -1;
        String protocol = account.getProtocol();
        boolean isPop3 = account.getProtocol().equals(Utils.POP3);
        boolean isImap = account.getProtocol().equals(Utils.IMAP);
        Date lastCheckedDate = account.getLastCheckedDate();
        try {
            String[] incomingFolders;
            Properties props = System.getProperties();
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            String socketFactoryClass = "javax.net.SocketFactory";
            if (account.isIncomingSsl()) {
                socketFactoryClass = Utils.SSL_FACTORY;
            }
            if (protocol.equals(Utils.POP3)) {
                props.setProperty("mail.pop3.socketFactory.fallback", "false");
                props.setProperty("mail.pop3.socketFactory.class", socketFactoryClass);
            } else if (protocol.equals(Utils.IMAP)) {
                props.setProperty("mail.imap.socketFactory.fallback", "false");
                props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
            }
            Session session = Session.getDefaultInstance((Properties)props);
            for (String incomingFolder : incomingFolders = account.getIncomingFolder().split(",")) {
                javax.mail.Message[] messages;
                incomingFolder = incomingFolder.trim();
                URLName storeURL = new URLName(account.getProtocol(), account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), incomingFolder, account.getIncomingUser(), account.getIncomingPassword());
                Store store = session.getStore(storeURL);
                try {
                    store.connect();
                }
                catch (AuthenticationFailedException e) {
                    logger.warn((Object)("Exception while connecting to server : " + e.getMessage()));
                    if (!account.isSavePassword()) {
                        account.setIncomingPassword("");
                        this.updateAccount(sProvider, username, account);
                    }
                    info.setStatusMsg("The username or password may be wrong.");
                    info.setStatusCode(103);
                    return messageList;
                }
                catch (MessagingException e) {
                    logger.warn((Object)("Exception while connecting to server : " + e.getMessage()));
                    info.setStatusMsg("Connecting failed. Please check server configuration.");
                    info.setStatusCode(102);
                    return messageList;
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception while connecting to server : " + e.getMessage()));
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    StringBuffer sb = sw.getBuffer();
                    logger.error((Object)sb.toString());
                    info.setStatusMsg("There was an unexpected error. Connecting failed.");
                    info.setStatusCode(102);
                    return messageList;
                }
                javax.mail.Folder folder = store.getFolder(storeURL.getFile());
                if (!folder.exists()) {
                    logger.warn((Object)(" #### Folder " + incomingFolder + " is not exists !"));
                    info.setStatusMsg("Folder " + incomingFolder + " is not exists");
                    continue;
                }
                logger.warn((Object)(" #### Getting mails from folder " + incomingFolder + " !"));
                info.setStatusMsg("Getting mails from folder " + incomingFolder + " !");
                folder.open(2);
                LinkedHashMap msgMap = new LinkedHashMap();
                FlagTerm searchTerm = null;
                if (lastCheckedDate == null) {
                    messages = folder.getMessages();
                } else {
                    searchTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
                    SentDateTerm dateTerm = new SentDateTerm(5, lastCheckedDate);
                    searchTerm = new OrTerm((SearchTerm)searchTerm, (SearchTerm)dateTerm);
                    messages = folder.search((SearchTerm)searchTerm);
                }
                String folderId = Utils.createFolderId(accountId, incomingFolder, false);
                List<MessageFilter> filters = this.getFilters(sProvider, username, accountId);
                for (MessageFilter filter : filters) {
                    SearchTerm st = this.getSearchTerm((SearchTerm)searchTerm, filter);
                    javax.mail.Message[] fMessages = folder.search(st);
                    for (int k = 0; k < fMessages.length; ++k) {
                        List<String> fl;
                        if (msgMap.containsKey(fMessages[k])) {
                            fl = (List)msgMap.get(fMessages[k]);
                            fl.add(filter.getId());
                            if (lastCheckedDate == null) {
                                msgMap.put(fMessages[k], fl);
                                continue;
                            }
                            if (isImap && !MimeMessageParser.getReceivedDate(fMessages[k]).getTime().after(lastCheckedDate)) continue;
                            msgMap.put(fMessages[k], fl);
                            continue;
                        }
                        fl = new ArrayList<String>();
                        fl.add(filter.getId());
                        if (lastCheckedDate == null) {
                            msgMap.put(fMessages[k], fl);
                            continue;
                        }
                        if (isImap && !MimeMessageParser.getReceivedDate(fMessages[k]).getTime().after(lastCheckedDate)) continue;
                        msgMap.put(fMessages[k], fl);
                    }
                }
                boolean afterTime = false;
                for (int l = 0; l < messages.length; ++l) {
                    if (msgMap.containsKey(messages[l])) continue;
                    if (lastCheckedDate == null) {
                        msgMap.put(messages[l], null);
                        continue;
                    }
                    if (!afterTime && isImap && !MimeMessageParser.getReceivedDate(messages[l]).getTime().after(lastCheckedDate)) continue;
                    afterTime = true;
                    msgMap.put(messages[l], null);
                }
                totalNew = msgMap.size();
                logger.warn((Object)"=============================================================");
                logger.warn((Object)"=============================================================");
                logger.warn((Object)(" #### Folder contains " + totalNew + " messages !"));
                long tt1 = System.currentTimeMillis();
                boolean saved = false;
                if (totalNew > 0) {
                    boolean leaveOnServer = isPop3 && Boolean.valueOf(account.getPopServerProperties().get(Utils.SVR_POP_LEAVE_ON_SERVER)) != false;
                    boolean markAsDelete = isImap && Boolean.valueOf(account.getImapServerProperties().get(Utils.SVR_IMAP_MARK_AS_DELETE)) != false;
                    boolean deleteOnServer = isPop3 && !leaveOnServer || isImap && markAsDelete;
                    info.setTotalMsg(totalNew);
                    int i = 0;
                    SpamFilter spamFilter = this.getSpamFilter(sProvider, username, account.getId());
                    Folder storeFolder = this.storage_.getFolder(sProvider, username, account.getId(), folderId);
                    if (storeFolder == null) {
                        folderId = Utils.createFolderId(accountId, incomingFolder, true);
                        Folder storeUserFolder = this.storage_.getFolder(sProvider, username, account.getId(), folderId);
                        storeFolder = storeUserFolder != null ? storeUserFolder : new Folder();
                        storeFolder.setId(folderId);
                        storeFolder.setName(incomingFolder);
                        storeFolder.setLabel(incomingFolder);
                        storeFolder.setPersonalFolder(true);
                        this.storage_.saveFolder(sProvider, username, account.getId(), storeFolder);
                    }
                    ArrayList msgList = new ArrayList(msgMap.keySet());
                    while (i < totalNew && !info.isRequestStop()) {
                        long t1;
                        block32: {
                            javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                            logger.warn((Object)("Fetching message " + (i + 1) + " ..."));
                            this.checkingLog_.get(key).setFetching(i + 1);
                            this.checkingLog_.get(key).setStatusMsg("Fetching message " + (i + 1) + "/" + totalNew);
                            t1 = System.currentTimeMillis();
                            List filterList = (List)msgMap.get(msg);
                            try {
                                saved = this.storage_.saveMessage(sProvider, username, account.getId(), msg, folderId, spamFilter, filterList);
                                if (!saved) break block32;
                                msg.setFlag(Flags.Flag.SEEN, true);
                                if (deleteOnServer) {
                                    msg.setFlag(Flags.Flag.DELETED, true);
                                }
                                account.setLastCheckedDate(MimeMessageParser.getReceivedDate(msg).getTime());
                            }
                            catch (Exception e) {
                                this.checkingLog_.get(key).setStatusMsg("An error occurs while fetching messsge " + i);
                                e.printStackTrace();
                                ++i;
                                continue;
                            }
                        }
                        long t2 = System.currentTimeMillis();
                        logger.warn((Object)("Message " + ++i + " saved : " + (t2 - t1) + " ms"));
                    }
                    long tt2 = System.currentTimeMillis();
                    logger.warn((Object)(" ### Check mail finished total took: " + (tt2 - tt1) + " ms"));
                }
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                }
                this.updateAccount(sProvider, username, account);
                folder.close(true);
                store.close();
                if (totalNew == 0) {
                    info.setStatusMsg("There is no new messages !");
                } else {
                    info.setStatusMsg("Check mail finished !");
                }
                info.setStatusCode(200);
                logger.warn((Object)"/////////////////////////////////////////////////////////////");
                logger.warn((Object)"/////////////////////////////////////////////////////////////");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public SearchTerm getSearchTerm(SearchTerm sTerm, MessageFilter filter) throws Exception {
        if (!Utils.isEmptyField(filter.getFrom())) {
            FromStringTerm fsTerm = new FromStringTerm(filter.getFrom());
            if (filter.getFromCondition() == 0) {
                sTerm = sTerm == null ? fsTerm : new AndTerm(sTerm, (SearchTerm)fsTerm);
            } else if (filter.getFromCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)fsTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)fsTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getTo())) {
            RecipientStringTerm toTerm = new RecipientStringTerm(MimeMessage.RecipientType.TO, filter.getTo());
            if (filter.getToCondition() == 0) {
                sTerm = sTerm == null ? toTerm : new AndTerm(sTerm, (SearchTerm)toTerm);
            } else if (filter.getToCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)toTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)toTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getSubject())) {
            SubjectTerm subjectTerm = new SubjectTerm(filter.getSubject());
            if (filter.getSubjectCondition() == 0) {
                sTerm = sTerm == null ? subjectTerm : new AndTerm(sTerm, (SearchTerm)subjectTerm);
            } else if (filter.getSubjectCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)subjectTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)subjectTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getBody())) {
            BodyTerm bodyTerm = new BodyTerm(filter.getBody());
            if (filter.getSubjectCondition() == 0) {
                sTerm = sTerm == null ? bodyTerm : new AndTerm(sTerm, (SearchTerm)bodyTerm);
            } else if (filter.getSubjectCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)bodyTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)bodyTerm));
            }
        }
        return sTerm;
    }

    @Override
    public void createAccount(SessionProvider sProvider, String username, Account account) throws Exception {
        this.saveAccount(sProvider, username, account, true);
    }

    @Override
    public List<Folder> getFolders(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.storage_.getFolders(sProvider, username, accountId);
    }

    @Override
    public List<Folder> getFolders(SessionProvider sProvider, String username, String accountId, boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (Folder folder : this.storage_.getFolders(sProvider, username, accountId)) {
            if (isPersonal) {
                if (!folder.isPersonalFolder()) continue;
                folders.add(folder);
                continue;
            }
            if (folder.isPersonalFolder()) continue;
            folders.add(folder);
        }
        return folders;
    }

    @Override
    public void addTag(SessionProvider sProvider, String username, String accountId, Tag tag) throws Exception {
        this.storage_.addTag(sProvider, username, accountId, tag);
    }

    @Override
    public void addTag(SessionProvider sProvider, String username, String accountId, List<Message> messages, List<Tag> tag) throws Exception {
        this.storage_.addTag(sProvider, username, accountId, messages, tag);
    }

    @Override
    public List<Tag> getTags(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.storage_.getTags(sProvider, username, accountId);
    }

    @Override
    public Tag getTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        return this.storage_.getTag(sProvider, username, accountId, tagId);
    }

    @Override
    public void removeTagsInMessages(SessionProvider sProvider, String username, String accountId, List<Message> msgList, List<String> tagIdList) throws Exception {
        this.storage_.removeTagsInMessages(sProvider, username, accountId, msgList, tagIdList);
    }

    @Override
    public void removeTag(SessionProvider sProvider, String username, String accountId, String tag) throws Exception {
        this.storage_.removeTag(sProvider, username, accountId, tag);
    }

    @Override
    public void updateTag(SessionProvider sProvider, String username, String accountId, Tag tag) throws Exception {
        this.storage_.updateTag(sProvider, username, accountId, tag);
    }

    @Override
    public List<Message> getMessageByTag(SessionProvider sProvider, String username, String accountId, String tagName) throws Exception {
        return this.storage_.getMessageByTag(sProvider, username, accountId, tagName);
    }

    @Override
    public MessagePageList getMessagePagelistByTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Tag");
        filter.setAccountId(accountId);
        filter.setTag(new String[]{tagId});
        return this.getMessagePageList(sProvider, username, filter);
    }

    @Override
    public MessagePageList getMessagePageListByFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessagePageList(sProvider, username, filter);
    }

    @Override
    public MailSetting getMailSetting(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getMailSetting(sProvider, username);
    }

    @Override
    public void saveMailSetting(SessionProvider sProvider, String username, MailSetting newSetting) throws Exception {
        this.storage_.saveMailSetting(sProvider, username, newSetting);
    }

    @Override
    public boolean importMessage(SessionProvider sProvider, String username, String accountId, String folderId, InputStream inputStream, String type) throws Exception {
        return this.emlImportExport_.importMessage(sProvider, username, accountId, folderId, inputStream, type);
    }

    @Override
    public OutputStream exportMessage(SessionProvider sProvider, String username, String accountId, Message message) throws Exception {
        return this.emlImportExport_.exportMessage(sProvider, username, accountId, message);
    }

    @Override
    public void runFilter(SessionProvider sProvider, String username, String accountId, MessageFilter filter) throws Exception {
        Tag tag;
        List<Message> msgList = this.getMessagePageList(sProvider, username, filter).getAll(username);
        String applyFolder = filter.getApplyFolder();
        String applyTag = filter.getApplyTag();
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Message msg : msgList) {
            Folder appFolder;
            Folder folder = this.getFolder(sProvider, username, accountId, applyFolder);
            if (folder == null || msg.getFolders()[0] == applyFolder || (appFolder = this.getFolder(sProvider, username, accountId, applyFolder)) == null) continue;
            this.moveMessage(sProvider, username, accountId, msg, msg.getFolders()[0], applyFolder);
        }
        if (!Utils.isEmptyField(applyTag) && (tag = this.getTag(sProvider, username, accountId, applyTag)) != null) {
            tagList.add(tag);
            this.addTag(sProvider, username, accountId, msgList, tagList);
        }
    }

    @Override
    public SpamFilter getSpamFilter(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.storage_.getSpamFilter(sProvider, username, accountId);
    }

    @Override
    public void saveSpamFilter(SessionProvider sProvider, String username, String accountId, SpamFilter spamFilter) throws Exception {
        this.storage_.saveSpamFilter(sProvider, username, accountId, spamFilter);
    }

    @Override
    public void toggleMessageProperty(SessionProvider sProvider, String username, String accountId, List<Message> msgList, String property) throws Exception {
        this.storage_.toggleMessageProperty(sProvider, username, accountId, msgList, property);
    }

    public List<AccountData> getAccountDatas(SessionProvider sProvider) throws Exception {
        return null;
    }

    @Override
    public String getFolderHomePath(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.storage_.getFolderHomePath(sProvider, username, accountId);
    }

    @Override
    public void saveFolder(SessionProvider sProvider, String username, String accountId, String parentId, Folder folder) throws Exception {
        this.storage_.saveFolder(sProvider, username, accountId, parentId, folder);
    }

    @Override
    public List<Folder> getSubFolders(SessionProvider sProvider, String username, String accountId, String parentPath) throws Exception {
        return this.storage_.getSubFolders(sProvider, username, accountId, parentPath);
    }

    @Override
    public List<Message> getReferencedMessages(SessionProvider sProvider, String username, String accountId, String msgPath) throws Exception {
        return this.storage_.getReferencedMessages(sProvider, username, accountId, msgPath);
    }

    @Override
    public Account getDefaultAccount(SessionProvider sProvider, String username) throws Exception {
        MailSetting mailSetting = this.storage_.getMailSetting(sProvider, username);
        String defaultAccount = mailSetting.getDefaultAccount();
        Account account = null;
        if (defaultAccount != null) {
            account = this.getAccountById(sProvider, username, defaultAccount);
        } else {
            List<Account> accList = this.getAccounts(sProvider, username);
            if (accList.size() > 0) {
                account = this.getAccounts(sProvider, username).get(0);
            }
        }
        return account;
    }

    @Override
    public Message loadAttachments(SessionProvider sProvider, String username, String accountId, Message msg) throws Exception {
        return this.storage_.loadAttachments(sProvider, username, accountId, msg);
    }
}

