/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.JCRMessageAttachment;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage {
    private static final Log logger = LogFactory.getLog(Utils.class);
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final String MAIL_SERVICE = "MailApplication";

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator) {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public String getMailHierarchyNode(SessionProvider sProvider) throws Exception {
        return this.nodeHierarchyCreator_.getJcrPath("usersPath");
    }

    private Node getMailHomeNode(SessionProvider sProvider, String username) throws Exception {
        Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username);
        Node mailNode = null;
        try {
            mailNode = userApp.getNode(MAIL_SERVICE);
        }
        catch (PathNotFoundException e) {
            mailNode = userApp.addNode(MAIL_SERVICE, Utils.NT_UNSTRUCTURED);
            if (userApp.isNew()) {
                userApp.getSession().save();
            }
            userApp.save();
        }
        return mailNode;
    }

    public Account getAccountById(SessionProvider sProvider, String username, String id) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        if (mailHome.hasNode(id)) {
            return this.getAccount(mailHome.getNode(id));
        }
        return null;
    }

    public List<Account> getAccounts(SessionProvider sProvider, String username) throws Exception {
        ArrayList<Account> accounts = new ArrayList<Account>();
        Node homeNode = this.getMailHomeNode(sProvider, username);
        NodeIterator it = homeNode.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.isNodeType("exo:account")) continue;
            accounts.add(this.getAccount(node));
        }
        return accounts;
    }

    private Account getAccount(Node accountNode) throws Exception {
        int index;
        String property;
        int i;
        Value[] properties;
        GregorianCalendar cal;
        Account account = new Account();
        account.setId(accountNode.getProperty(Utils.EXO_ID).getString());
        try {
            account.setLabel(accountNode.getProperty(Utils.EXO_LABEL).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setUserDisplayName(accountNode.getProperty(Utils.EXO_USERDISPLAYNAME).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setEmailAddress(accountNode.getProperty(Utils.EXO_EMAILADDRESS).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setEmailReplyAddress(accountNode.getProperty(Utils.EXO_REPLYEMAIL).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setSignature(accountNode.getProperty(Utils.EXO_SIGNATURE).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setDescription(accountNode.getProperty(Utils.EXO_DESCRIPTION).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setCheckedAuto(accountNode.getProperty(Utils.EXO_CHECKMAILAUTO).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setIsSavePassword(accountNode.getProperty(Utils.EXO_IS_SAVE_PASSWORD).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setEmptyTrashWhenExit(accountNode.getProperty(Utils.EXO_EMPTYTRASH).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            account.setPlaceSignature(accountNode.getProperty(Utils.EXO_PLACESIGNATURE).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_LAST_CHECKED_TIME).getLong());
            account.setLastCheckedDate(cal.getTime());
        }
        catch (Exception e) {
            account.setLastCheckedDate(null);
        }
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_LAST_START_CHECKING_TIME).getLong());
            account.setLastStartCheckingTime(cal.getTime());
        }
        catch (Exception e) {
            account.setLastStartCheckingTime(null);
        }
        try {
            account.setCheckAll(accountNode.getProperty(Utils.EXO_CHECK_ALL).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(accountNode.getProperty(Utils.EXO_CHECK_FROM_DATE).getLong());
            account.setCheckFromDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            properties = accountNode.getProperty(Utils.EXO_SERVERPROPERTIES).getValues();
            for (i = 0; i < properties.length; ++i) {
                property = properties[i].getString();
                index = property.indexOf(61);
                if (index == -1) continue;
                account.setServerProperty(property.substring(0, index), property.substring(index + 1));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            properties = accountNode.getProperty(Utils.EXO_POPSERVERPROPERTIES).getValues();
            for (i = 0; i < properties.length; ++i) {
                property = properties[i].getString();
                index = property.indexOf(61);
                if (index == -1) continue;
                account.setPopServerProperty(property.substring(0, index), property.substring(index + 1));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            properties = accountNode.getProperty(Utils.EXO_IMAPSERVERPROPERTIES).getValues();
            for (i = 0; i < properties.length; ++i) {
                property = properties[i].getString();
                index = property.indexOf(61);
                if (index == -1) continue;
                account.setImapServerProperty(property.substring(0, index), property.substring(index + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return account;
    }

    public Message getMessageById(SessionProvider sProvider, String username, String accountId, String msgId) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Session sess = accountNode.getSession();
        QueryManager qm = sess.getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:id='").append(msgId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        Node node = null;
        if (it.hasNext()) {
            node = it.nextNode();
        }
        Message msg = this.getMessage(node);
        return msg;
    }

    public MailSetting getMailSetting(SessionProvider sProvider, String username) throws Exception {
        Node homeNode = this.getMailHomeNode(sProvider, username);
        Node settingNode = null;
        if (homeNode.hasNode(Utils.KEY_MAIL_SETTING)) {
            settingNode = homeNode.getNode(Utils.KEY_MAIL_SETTING);
        }
        MailSetting setting = new MailSetting();
        if (settingNode != null) {
            try {
                setting.setNumberMsgPerPage(settingNode.getProperty(Utils.EXO_NUMBER_MSG_PER_PAGE).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setPeriodCheckAuto(settingNode.getProperty(Utils.EXO_PERIOD_CHECKMAIL_AUTO).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setDefaultAccount(settingNode.getProperty(Utils.EXO_DEFAULT_ACCOUNT).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setUseWysiwyg(settingNode.getProperty(Utils.EXO_USE_WYSIWYG).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setFormatAsOriginal(settingNode.getProperty(Utils.EXO_FORMAT_AS_ORIGINAL).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setReplyWithAttach(settingNode.getProperty(Utils.EXO_REPLY_WITH_ATTACH).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setForwardWithAtt(settingNode.getProperty(Utils.EXO_FORWARD_WITH_ATTACH).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setPrefixMessageWith(settingNode.getProperty(Utils.EXO_PREFIX_MESSAGE_WITH).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                setting.setSaveMessageInSent(settingNode.getProperty(Utils.EXO_SAVE_SENT_MESSAGE).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return setting;
    }

    public MessagePageList getMessagePageList(SessionProvider sProvider, String username, MessageFilter filter) throws Exception {
        Node homeMsg = this.getMessageHome(sProvider, username, filter.getAccountId());
        filter.setAccountPath(homeMsg.getPath());
        QueryManager qm = homeMsg.getSession().getWorkspace().getQueryManager();
        String queryString = filter.getStatement();
        long pageSize = this.getMailSetting(sProvider, username).getNumberMsgPerPage();
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        MessagePageList pageList = new MessagePageList(result.getNodes(), pageSize, queryString, true, filter.hasStructure());
        return pageList;
    }

    public List<Message> getMessages(SessionProvider sProvider, String username, MessageFilter filter) throws Exception {
        Node homeMsg = this.getMessageHome(sProvider, username, filter.getAccountId());
        filter.setAccountPath(homeMsg.getPath());
        QueryManager qm = homeMsg.getSession().getWorkspace().getQueryManager();
        String queryString = filter.getStatement();
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<Message> strList = new ArrayList<Message>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            strList.add(this.getMessage(node));
        }
        return strList;
    }

    public Message getMessage(Node messageNode) throws Exception {
        int i;
        Message msg = new Message();
        try {
            msg.setId(messageNode.getProperty(Utils.EXO_ID).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        msg.setPath(messageNode.getPath());
        try {
            msg.setInReplyToHeader(messageNode.getProperty(Utils.EXO_IN_REPLY_TO_HEADER).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setAccountId(messageNode.getProperty(Utils.EXO_ACCOUNT).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setFrom(messageNode.getProperty(Utils.EXO_FROM).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageTo(messageNode.getProperty(Utils.EXO_TO).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setSubject(messageNode.getProperty(Utils.EXO_SUBJECT).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageCc(messageNode.getProperty(Utils.EXO_CC).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageBcc(messageNode.getProperty(Utils.EXO_BCC).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setReplyTo(messageNode.getProperty(Utils.EXO_REPLYTO).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setContentType(messageNode.getProperty(Utils.EXO_CONTENT_TYPE).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageBody(messageNode.getProperty(Utils.EXO_BODY).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setSize(messageNode.getProperty(Utils.EXO_SIZE).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setHasAttachment(messageNode.getProperty(Utils.EXO_HASATTACH).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setHasStar(messageNode.getProperty(Utils.EXO_STAR).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setPriority(messageNode.getProperty(Utils.EXO_PRIORITY).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setUnread(messageNode.getProperty(Utils.EXO_ISUNREAD).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] propFolders = messageNode.getProperty(Utils.EXO_FOLDERS).getValues();
            String[] folders = new String[propFolders.length];
            for (i = 0; i < propFolders.length; ++i) {
                folders[i] = propFolders[i].getString();
            }
            msg.setFolders(folders);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] propTags = messageNode.getProperty(Utils.EXO_TAGS).getValues();
            String[] tags = new String[propTags.length];
            for (i = 0; i < propTags.length; ++i) {
                tags[i] = propTags[i].getString();
            }
            msg.setTags(tags);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] properties = messageNode.getProperty(Utils.EXO_HEADERS).getValues();
            for (int i2 = 0; i2 < properties.length; ++i2) {
                String property = properties[i2].getString();
                int index = property.indexOf(61);
                if (index == -1) continue;
                msg.setHeader(property.substring(0, index), property.substring(index + 1));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.setTimeInMillis(messageNode.getProperty(Utils.EXO_RECEIVEDDATE).getLong());
            msg.setReceivedDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cal.setTimeInMillis(messageNode.getProperty(Utils.EXO_SENDDATE).getLong());
            msg.setSendDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        return msg;
    }

    public void removeAccount(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node homeNode = this.getMailHomeNode(sProvider, username);
        if (homeNode.hasNode(accountId)) {
            homeNode.getNode(accountId).remove();
            homeNode.getSession().save();
        }
    }

    public void removeMessage(SessionProvider sProvider, String username, String accountId, Message message) throws Exception {
        Node msgStoreNode = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
        try {
            Node node = msgStoreNode.getNode(message.getId());
            if (node != null) {
                node = this.moveReference(accountId, node);
                NodeType[] nts = node.getMixinNodeTypes();
                for (int i = 0; i < nts.length; ++i) {
                    node.removeMixin(nts[i].getName());
                }
                node.remove();
                msgStoreNode.getSession().save();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    public void removeMessages(SessionProvider sProvider, String username, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        Node msgHome = this.getMessageHome(sProvider, username, accountId);
        for (Message message : messages) {
            Node msgStoreNode = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
            try {
                Node node = msgStoreNode.getNode(message.getId());
                if (node == null) continue;
                if (moveReference) {
                    node = this.moveReference(accountId, node);
                }
                NodeType[] nts = node.getMixinNodeTypes();
                for (int i = 0; i < nts.length; ++i) {
                    node.removeMixin(nts[i].getName());
                }
                node.remove();
            }
            catch (PathNotFoundException e) {}
        }
        msgHome.getSession().save();
    }

    public void moveMessages(SessionProvider sProvider, String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        Node messageHome = this.getMessageHome(sProvider, username, accountId);
        Node currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, currentFolderId);
        Node destFolderNode = this.getFolderNodeById(sProvider, username, accountId, destFolderId);
        int inUnreadNumber = 0;
        int deUnreadNumber = 0;
        int inTotalMessage = 0;
        int deTotalMessage = 0;
        for (Message msg : msgList) {
            try {
                Node msgNode = (Node)messageHome.getSession().getItem(msg.getPath());
                boolean isUnread = msgNode.getProperty(Utils.EXO_ISUNREAD).getBoolean();
                String sentFolderId = Utils.createFolderId(accountId, Utils.FD_SENT, false);
                Value[] propFolders = msgNode.getProperty(Utils.EXO_FOLDERS).getValues();
                boolean moveReference = true;
                String[] folderIds = new String[propFolders.length];
                if (propFolders.length == 1) {
                    if (destFolderId.equals(sentFolderId)) {
                        folderIds[0] = sentFolderId;
                        if (!propFolders[0].getString().equals(sentFolderId)) {
                            if (isUnread) {
                                ++inUnreadNumber;
                                ++deUnreadNumber;
                            }
                            ++deTotalMessage;
                            ++inTotalMessage;
                        } else {
                            if (isUnread) {
                                ++inUnreadNumber;
                            }
                            ++inTotalMessage;
                        }
                        moveReference = false;
                    } else {
                        folderIds[0] = destFolderId;
                        if (propFolders[0].getString().equals(sentFolderId)) {
                            if (isUnread) {
                                ++inUnreadNumber;
                            }
                            ++inTotalMessage;
                        } else if (!currentFolderId.equals(destFolderId)) {
                            if (isUnread) {
                                ++inUnreadNumber;
                                ++deUnreadNumber;
                            }
                            ++deTotalMessage;
                            ++inTotalMessage;
                        }
                    }
                } else {
                    for (int i = 0; i < propFolders.length; ++i) {
                        String folderId = propFolders[i].getString();
                        folderIds[i] = currentFolderId.equals(folderId) ? destFolderId : folderId;
                    }
                    if (isUnread) {
                        ++inUnreadNumber;
                        ++deUnreadNumber;
                    }
                    ++deTotalMessage;
                    ++inTotalMessage;
                }
                msgNode.setProperty(Utils.EXO_FOLDERS, folderIds);
                if (moveReference) {
                    msgNode = this.moveReference(accountId, msgNode);
                }
                msgNode.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (currentFolderNode != null) {
                currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - (long)deUnreadNumber);
            }
            if (destFolderNode != null) {
                destFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, destFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + (long)inUnreadNumber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (currentFolderNode != null) {
                currentFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, currentFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() - (long)deTotalMessage);
            }
            if (destFolderNode != null) {
                destFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, destFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + (long)inTotalMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (currentFolderNode != null) {
            currentFolderNode.save();
        }
        if (destFolderNode != null) {
            destFolderNode.save();
        }
    }

    public void moveMessage(SessionProvider sProvider, String username, String accountId, Message msg, String currentFolderId, String destFolderId) throws Exception {
        Node messageHome = this.getMessageHome(sProvider, username, accountId);
        Node msgNode = (Node)messageHome.getSession().getItem(msg.getPath());
        if ((msgNode = this.moveReference(accountId, msgNode)).hasProperty(Utils.EXO_FOLDERS)) {
            Boolean isUnread = msgNode.getProperty(Utils.EXO_ISUNREAD).getBoolean();
            Node currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, currentFolderId);
            Node destFolderNode = this.getFolderNodeById(sProvider, username, accountId, destFolderId);
            Value[] propFolders = msgNode.getProperty(Utils.EXO_FOLDERS).getValues();
            String[] folderIds = new String[propFolders.length];
            for (int i = 0; i < propFolders.length; ++i) {
                String folderId = propFolders[i].getString();
                folderIds[i] = currentFolderId.equals(folderId) ? destFolderId : folderId;
            }
            msgNode.setProperty(Utils.EXO_FOLDERS, folderIds);
            msgNode.save();
            if (isUnread.booleanValue()) {
                try {
                    currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - 1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    destFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, destFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + 1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                currentFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, currentFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() - 1L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                destFolderNode.setProperty(Utils.EXO_TOTALMESSAGE, destFolderNode.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + 1L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (currentFolderNode != null) {
                currentFolderNode.save();
            }
            destFolderNode.save();
        }
    }

    public void saveAccount(SessionProvider sProvider, String username, Account account, boolean isNew) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        Node newAccount = null;
        String accId = account.getId();
        if (isNew) {
            newAccount = mailHome.addNode(accId, Utils.EXO_ACCOUNT);
            mailHome.save();
            newAccount.setProperty(Utils.EXO_ID, accId);
        } else {
            try {
                newAccount = mailHome.getNode(accId);
            }
            catch (Exception e) {
                return;
            }
        }
        if (newAccount != null) {
            String key;
            newAccount.setProperty(Utils.EXO_LABEL, account.getLabel());
            newAccount.setProperty(Utils.EXO_USERDISPLAYNAME, account.getUserDisplayName());
            newAccount.setProperty(Utils.EXO_EMAILADDRESS, account.getEmailAddress());
            newAccount.setProperty(Utils.EXO_REPLYEMAIL, account.getEmailReplyAddress());
            newAccount.setProperty(Utils.EXO_SIGNATURE, account.getSignature());
            newAccount.setProperty(Utils.EXO_DESCRIPTION, account.getDescription());
            newAccount.setProperty(Utils.EXO_CHECKMAILAUTO, account.checkedAuto());
            newAccount.setProperty(Utils.EXO_IS_SAVE_PASSWORD, account.isSavePassword());
            newAccount.setProperty(Utils.EXO_EMPTYTRASH, account.isEmptyTrashWhenExit());
            newAccount.setProperty(Utils.EXO_PLACESIGNATURE, account.getPlaceSignature());
            if (account.getLastCheckedDate() != null) {
                newAccount.setProperty(Utils.EXO_LAST_CHECKED_TIME, account.getLastCheckedDate().getTime());
            } else {
                newAccount.setProperty(Utils.EXO_LAST_CHECKED_TIME, (Value)null);
            }
            if (account.getLastStartCheckingTime() != null) {
                newAccount.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, account.getLastStartCheckingTime().getTime());
            } else {
                newAccount.setProperty(Utils.EXO_LAST_START_CHECKING_TIME, (Value)null);
            }
            newAccount.setProperty(Utils.EXO_CHECK_ALL, account.isCheckAll());
            if (account.getCheckFromDate() != null) {
                newAccount.setProperty(Utils.EXO_CHECK_FROM_DATE, account.getCheckFromDate().getTime());
            } else {
                newAccount.setProperty(Utils.EXO_CHECK_FROM_DATE, (Value)null);
            }
            Iterator<String> it = account.getServerProperties().keySet().iterator();
            ArrayList<String> values = new ArrayList<String>(account.getServerProperties().size());
            while (it.hasNext()) {
                key = it.next().toString();
                values.add(key + "=" + account.getServerProperties().get(key));
            }
            newAccount.setProperty(Utils.EXO_SERVERPROPERTIES, values.toArray(new String[account.getServerProperties().size()]));
            if (account.getPopServerProperties() != null) {
                it = account.getPopServerProperties().keySet().iterator();
                values = new ArrayList(account.getPopServerProperties().size());
                while (it.hasNext()) {
                    key = it.next().toString();
                    values.add(key + "=" + account.getPopServerProperties().get(key));
                }
                newAccount.setProperty(Utils.EXO_POPSERVERPROPERTIES, values.toArray(new String[account.getPopServerProperties().size()]));
            }
            if (account.getImapServerProperties() != null) {
                it = account.getImapServerProperties().keySet().iterator();
                values = new ArrayList(account.getImapServerProperties().size());
                while (it.hasNext()) {
                    key = it.next().toString();
                    values.add(key + "=" + account.getImapServerProperties().get(key));
                }
                newAccount.setProperty(Utils.EXO_IMAPSERVERPROPERTIES, values.toArray(new String[account.getImapServerProperties().size()]));
            }
            if (isNew) {
                mailHome.getSession().save();
            } else {
                mailHome.save();
            }
        }
    }

    public void saveMailSetting(SessionProvider sProvider, String username, MailSetting newSetting) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        Node settingNode = null;
        try {
            settingNode = mailHome.getNode(Utils.KEY_MAIL_SETTING);
        }
        catch (PathNotFoundException e) {
            settingNode = mailHome.addNode(Utils.KEY_MAIL_SETTING, Utils.EXO_MAIL_SETTING);
            mailHome.save();
        }
        if (settingNode != null) {
            settingNode.setProperty(Utils.EXO_NUMBER_MSG_PER_PAGE, newSetting.getNumberMsgPerPage());
            settingNode.setProperty(Utils.EXO_PERIOD_CHECKMAIL_AUTO, newSetting.getPeriodCheckAuto());
            settingNode.setProperty(Utils.EXO_DEFAULT_ACCOUNT, newSetting.getDefaultAccount());
            settingNode.setProperty(Utils.EXO_FORMAT_AS_ORIGINAL, newSetting.formatAsOriginal());
            settingNode.setProperty(Utils.EXO_USE_WYSIWYG, newSetting.useWysiwyg());
            settingNode.setProperty(Utils.EXO_REPLY_WITH_ATTACH, newSetting.replyWithAttach());
            settingNode.setProperty(Utils.EXO_FORWARD_WITH_ATTACH, newSetting.forwardWithAtt());
            settingNode.setProperty(Utils.EXO_PREFIX_MESSAGE_WITH, newSetting.getPrefixMessageWith());
            settingNode.setProperty(Utils.EXO_SAVE_SENT_MESSAGE, newSetting.saveMessageInSent());
            settingNode.save();
        }
    }

    public void saveMessage(SessionProvider sProvider, String username, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        Node msgNode = this.saveMessage(sProvider, username, accountId, message, isNew);
        if (targetMsgPath != null && !targetMsgPath.equals("")) {
            Node mailHome = this.getMailHomeNode(sProvider, username);
            Node targetNode = (Node)mailHome.getSession().getItem(targetMsgPath);
            this.createReference(msgNode, targetNode);
        }
    }

    public Node saveMessage(SessionProvider sProvider, String username, String accountId, Message message, boolean isNew) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        Node homeMsg = this.getDateStoreNode(sProvider, username, accountId, message.getReceivedDate());
        Node nodeMsg = null;
        if (isNew) {
            nodeMsg = homeMsg.addNode(message.getId(), Utils.EXO_MESSAGE);
            homeMsg.save();
        } else {
            nodeMsg = (Node)mailHome.getSession().getItem(message.getPath());
        }
        if (nodeMsg != null) {
            nodeMsg.setProperty(Utils.EXO_ID, message.getId());
            nodeMsg.setProperty(Utils.EXO_IN_REPLY_TO_HEADER, message.getInReplyToHeader());
            nodeMsg.setProperty(Utils.EXO_ACCOUNT, accountId);
            nodeMsg.setProperty(Utils.EXO_PATH, message.getPath());
            nodeMsg.setProperty(Utils.EXO_FROM, message.getFrom());
            nodeMsg.setProperty(Utils.EXO_TO, message.getMessageTo());
            nodeMsg.setProperty(Utils.EXO_SUBJECT, message.getSubject());
            nodeMsg.setProperty(Utils.EXO_CC, message.getMessageCc());
            nodeMsg.setProperty(Utils.EXO_BCC, message.getMessageBcc());
            nodeMsg.setProperty(Utils.EXO_BODY, message.getMessageBody());
            nodeMsg.setProperty(Utils.EXO_REPLYTO, message.getReplyTo());
            nodeMsg.setProperty(Utils.EXO_SIZE, message.getSize());
            nodeMsg.setProperty(Utils.EXO_STAR, message.hasStar());
            nodeMsg.setProperty(Utils.EXO_PRIORITY, message.getPriority());
            nodeMsg.setProperty(Utils.EXO_ISUNREAD, message.isUnread());
            nodeMsg.setProperty(Utils.EXO_IS_ROOT, message.isRootConversation());
            nodeMsg.setProperty(Utils.EXO_CONTENT_TYPE, message.getContentType());
            if (message.getSendDate() != null) {
                nodeMsg.setProperty(Utils.EXO_SENDDATE, message.getSendDate().getTime());
            }
            if (message.getReceivedDate() != null) {
                nodeMsg.setProperty(Utils.EXO_RECEIVEDDATE, message.getReceivedDate().getTime());
            }
            String[] tags = message.getTags();
            nodeMsg.setProperty(Utils.EXO_TAGS, tags);
            String[] folders = message.getFolders();
            nodeMsg.setProperty(Utils.EXO_FOLDERS, folders);
            Iterator<String> ith = message.getHeaders().keySet().iterator();
            ArrayList<String> values = new ArrayList<String>(message.getHeaders().size());
            while (ith.hasNext()) {
                String key = ith.next().toString();
                values.add(key + "=" + message.getHeaders().get(key));
            }
            nodeMsg.setProperty(Utils.EXO_HEADERS, values.toArray(new String[message.getHeaders().size()]));
            List<Attachment> attachments = message.getAttachments();
            if (!isNew) {
                NodeIterator nit = nodeMsg.getNodes();
                while (nit.hasNext()) {
                    Node attNode = nit.nextNode();
                    try {
                        attNode.remove();
                    }
                    catch (PathNotFoundException e) {}
                }
                nodeMsg.setProperty(Utils.EXO_HASATTACH, false);
            }
            if (attachments != null && attachments.size() > 0) {
                Iterator<Attachment> it = attachments.iterator();
                boolean makeNewAtt = isNew;
                while (it.hasNext()) {
                    Attachment file = it.next();
                    Node nodeFile = null;
                    Session session = mailHome.getSession();
                    try {
                        if (!isNew) {
                            nodeFile = (Node)session.getItem(file.getId());
                        }
                    }
                    catch (Exception e) {
                        makeNewAtt = true;
                    }
                    if (makeNewAtt) {
                        Node attHome = null;
                        try {
                            attHome = nodeMsg.getNode(Utils.KEY_ATTACHMENT);
                        }
                        catch (Exception pne) {
                            attHome = nodeMsg.addNode(Utils.KEY_ATTACHMENT, Utils.NT_UNSTRUCTURED);
                        }
                        nodeFile = attHome.addNode("attachment" + IdGenerator.generate(), Utils.EXO_MAIL_ATTACHMENT);
                        nodeFile.setProperty(Utils.EXO_ATT_NAME, file.getName());
                    }
                    Node nodeContent = null;
                    nodeContent = !nodeFile.hasNode(Utils.JCR_CONTENT) ? nodeFile.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE) : nodeFile.getNode(Utils.JCR_CONTENT);
                    nodeContent.setProperty(Utils.JCR_MIMETYPE, file.getMimeType());
                    nodeContent.setProperty(Utils.JCR_DATA, file.getInputStream());
                    nodeContent.setProperty(Utils.JCR_LASTMODIFIED, Calendar.getInstance().getTimeInMillis());
                    nodeMsg.setProperty(Utils.EXO_HASATTACH, true);
                }
            }
            if (nodeMsg.canAddMixin("mix:referenceable")) {
                nodeMsg.addMixin("mix:referenceable");
            }
            nodeMsg.setProperty(Utils.EXO_SUBJECT, message.getSubject());
            nodeMsg.save();
        }
        return nodeMsg;
    }

    public boolean saveMessage(SessionProvider sProvider, String username, String accId, javax.mail.Message msg, String[] folderIds, List<String> tagList, SpamFilter spamFilter) throws Exception {
        String msgId = MimeMessageParser.getMessageId(msg);
        logger.warn((Object)("MessageId = " + msgId));
        Calendar gc = MimeMessageParser.getReceivedDate(msg);
        Node msgHomeNode = this.getDateStoreNode(sProvider, username, accId, gc.getTime());
        try {
            Node msgNode = msgHomeNode.getNode(msgId);
            logger.warn((Object)"Check duplicate ......................................");
            for (int i = 0; i < folderIds.length; ++i) {
                String folderId = folderIds[i];
                byte checkDuplicate = this.checkDuplicateStatus(sProvider, username, msgHomeNode, accId, msgNode, folderId);
                if (checkDuplicate == 2) {
                    return true;
                }
                if (checkDuplicate != 1) continue;
                return false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.warn((Object)"Saving message to JCR ...");
        long t1 = System.currentTimeMillis();
        Node node = null;
        try {
            node = msgHomeNode.addNode(msgId, Utils.EXO_MESSAGE);
        }
        catch (Exception e) {
            msgId = "Message" + IdGenerator.generate();
            logger.warn((Object)("The MessageId is NOT GOOD, generated another one = " + msgId));
            node = msgHomeNode.addNode(msgId, Utils.EXO_MESSAGE);
        }
        try {
            msgHomeNode.save();
            node.setProperty(Utils.EXO_ID, msgId);
            node.setProperty(Utils.EXO_IN_REPLY_TO_HEADER, MimeMessageParser.getInReplyToHeader(msg));
            node.setProperty(Utils.EXO_ACCOUNT, accId);
            node.setProperty(Utils.EXO_FROM, Utils.decodeText(InternetAddress.toString((Address[])msg.getFrom())));
            String to = "";
            try {
                to = InternetAddress.toString((Address[])msg.getRecipients(Message.RecipientType.TO));
            }
            catch (Exception e) {
                String[] tos = msg.getHeader("To");
                for (int i = 0; i < tos.length; ++i) {
                    to = to + tos[i] + ",";
                }
            }
            node.setProperty(Utils.EXO_TO, Utils.decodeText(to));
            String cc = "";
            try {
                cc = InternetAddress.toString((Address[])msg.getRecipients(Message.RecipientType.CC));
            }
            catch (Exception e) {
                String[] ccs = msg.getHeader("Cc");
                for (int i = 0; i < ccs.length; ++i) {
                    cc = cc + ccs[i] + ",";
                }
            }
            node.setProperty(Utils.EXO_CC, Utils.decodeText(cc));
            String bcc = "";
            try {
                bcc = InternetAddress.toString((Address[])msg.getRecipients(Message.RecipientType.BCC));
            }
            catch (Exception e) {
                String[] bccs = msg.getHeader("Cc");
                for (int i = 0; i < bccs.length; ++i) {
                    bcc = bcc + bccs[i] + ",";
                }
            }
            node.setProperty(Utils.EXO_BCC, Utils.decodeText(bcc));
            node.setProperty(Utils.EXO_REPLYTO, Utils.decodeText(InternetAddress.toString((Address[])msg.getReplyTo())));
            String subject = msg.getSubject();
            subject = subject != null ? Utils.decodeText(msg.getSubject()) : "";
            node.setProperty(Utils.EXO_SUBJECT, subject);
            node.setProperty(Utils.EXO_RECEIVEDDATE, gc);
            Calendar sc = GregorianCalendar.getInstance();
            if (msg.getSentDate() != null) {
                sc.setTime(msg.getSentDate());
            } else {
                sc = gc;
            }
            node.setProperty(Utils.EXO_SENDDATE, sc);
            node.setProperty(Utils.EXO_SIZE, (long)Math.abs(msg.getSize()));
            node.setProperty(Utils.EXO_ISUNREAD, true);
            node.setProperty(Utils.EXO_STAR, false);
            node.setProperty(Utils.EXO_PRIORITY, MimeMessageParser.getPriority(msg));
            if (spamFilter != null && spamFilter.checkSpam(msg)) {
                folderIds = new String[]{Utils.createFolderId(accId, Utils.FD_SPAM, false)};
            }
            node.setProperty(Utils.EXO_FOLDERS, folderIds);
            if (tagList != null && tagList.size() > 0) {
                node.setProperty(Utils.EXO_TAGS, tagList.toArray(new String[0]));
            }
            ArrayList<String> values = new ArrayList<String>();
            Enumeration enu = msg.getAllHeaders();
            while (enu.hasMoreElements()) {
                Header header = (Header)enu.nextElement();
                values.add(header.getName() + "=" + header.getValue());
            }
            node.setProperty(Utils.EXO_HEADERS, values.toArray(new String[0]));
            logger.warn((Object)("Saved body and attachment of message .... size : " + Math.abs(msg.getSize()) + " B"));
            long t2 = System.currentTimeMillis();
            MimeMessage cmsg = (MimeMessage)msg;
            Object obj = new Object();
            try {
                obj = msg.getContent();
            }
            catch (MessagingException mex) {
                cmsg = new MimeMessage((MimeMessage)msg);
                try {
                    obj = cmsg.getContent();
                }
                catch (MessagingException mex1) {
                    System.out.println("##### Error when fetch message body");
                }
            }
            String contentType = "text/plain";
            if (cmsg.isMimeType("text/html") || cmsg.isMimeType("multipart/alternative")) {
                contentType = "text/html";
            }
            String body = "";
            body = obj instanceof Multipart ? this.setMultiPart((Multipart)obj, node, body) : this.setPart((Part)cmsg, node, body);
            node.setProperty(Utils.EXO_CONTENT_TYPE, contentType);
            node.setProperty(Utils.EXO_BODY, Utils.decodeText(body));
            long t3 = System.currentTimeMillis();
            logger.warn((Object)("Saved body (and attachments) of message finished : " + (t3 - t2) + " ms"));
            node.save();
            long t4 = System.currentTimeMillis();
            logger.warn((Object)("Saved total message to JCR finished : " + (t4 - t1) + " ms"));
            logger.warn((Object)"Adding message to thread ...");
            t1 = System.currentTimeMillis();
            this.addMessageToThread(sProvider, username, accId, MimeMessageParser.getInReplyToHeader(msg), node);
            t2 = System.currentTimeMillis();
            logger.warn((Object)("Added message to thread finished : " + (t2 - t1) + " ms"));
            logger.warn((Object)"Updating number message to folder ...");
            t1 = System.currentTimeMillis();
            for (int i = 0; i < folderIds.length; ++i) {
                this.increaseFolderItem(sProvider, username, accId, folderIds[i]);
            }
            t2 = System.currentTimeMillis();
            logger.warn((Object)("Updated number message to folder finished : " + (t2 - t1) + " ms"));
            return true;
        }
        catch (Exception e) {
            try {
                msgHomeNode.refresh(true);
            }
            catch (Exception ex) {
                e.printStackTrace();
                logger.warn((Object)" [WARNING] Can't refresh.");
            }
            logger.warn((Object)" [WARNING] Cancel saving message to JCR.");
            return false;
        }
    }

    private void increaseFolderItem(SessionProvider sProvider, String username, String accId, String folderId) throws Exception {
        try {
            Node node = this.getFolderNodeById(sProvider, username, accId, folderId);
            if (node != null) {
                node.setProperty(Utils.EXO_UNREADMESSAGES, node.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + 1L);
                node.setProperty(Utils.EXO_TOTALMESSAGE, node.getProperty(Utils.EXO_TOTALMESSAGE).getLong() + 1L);
                node.save();
            }
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String setMultiPart(Multipart multipart, Node node, String body) {
        try {
            boolean readText = true;
            if (multipart.getContentType().toLowerCase().indexOf("multipart/alternative") > -1) {
                for (int i = 0; i < multipart.getCount(); ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    if (!bodyPart.isMimeType("text/html") && !bodyPart.isMimeType("multipart/related")) continue;
                    body = this.setPart((Part)bodyPart, node, body);
                    readText = false;
                }
            }
            if (readText) {
                int n = multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    body = this.setPart((Part)multipart.getBodyPart(i), node, body);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return body;
    }

    private String setPart(Part part, Node node, String body) {
        block22: {
            try {
                String disposition = part.getDisposition();
                String ct = part.getContentType();
                if (disposition == null) {
                    if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
                        body = this.appendMessageBody(part, node, body);
                    } else if (part.isMimeType("multipart/alternative")) {
                        int i;
                        boolean readText = true;
                        MimeMultipart mimeMultiPart = (MimeMultipart)part.getContent();
                        for (i = 0; i < mimeMultiPart.getCount(); ++i) {
                            BodyPart bodyPart = mimeMultiPart.getBodyPart(i);
                            if (!bodyPart.isMimeType("text/html")) continue;
                            body = this.setPart((Part)bodyPart, node, body);
                            readText = false;
                        }
                        if (readText) {
                            for (i = 0; i < mimeMultiPart.getCount(); ++i) {
                                body = this.setPart((Part)mimeMultiPart.getBodyPart(i), node, body);
                            }
                        }
                    } else if (part.isMimeType("multipart/*")) {
                        MimeMultipart mimeMultiPart = (MimeMultipart)part.getContent();
                        for (int i = 0; i < mimeMultiPart.getCount(); ++i) {
                            body = this.setPart((Part)mimeMultiPart.getBodyPart(i), node, body);
                        }
                    } else if (part.isMimeType("message/rfc822")) {
                        body = this.getNestedMessageBody(part, node, body);
                    }
                    break block22;
                }
                if (disposition.equalsIgnoreCase("inline")) {
                    if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
                        body = this.appendMessageBody(part, node, body);
                    } else if (part.isMimeType("message/rfc822")) {
                        body = this.getNestedMessageBody(part, node, body);
                    }
                    break block22;
                }
                if (!disposition.equalsIgnoreCase("attachment")) break block22;
                Node attHome = null;
                try {
                    attHome = node.getNode(Utils.KEY_ATTACHMENT);
                }
                catch (PathNotFoundException e) {
                    attHome = node.addNode(Utils.KEY_ATTACHMENT, Utils.NT_UNSTRUCTURED);
                }
                Node nodeFile = attHome.addNode("attachment" + IdGenerator.generate(), Utils.EXO_MAIL_ATTACHMENT);
                nodeFile.setProperty(Utils.EXO_ATT_NAME, Utils.decodeText(part.getFileName()));
                Node nodeContent = nodeFile.addNode(Utils.JCR_CONTENT, Utils.NT_RESOURCE);
                if (ct.indexOf(";") > 0) {
                    String[] type = ct.split(";");
                    nodeContent.setProperty(Utils.JCR_MIMETYPE, type[0]);
                } else {
                    nodeContent.setProperty(Utils.JCR_MIMETYPE, ct);
                }
                nodeContent.setProperty(Utils.JCR_DATA, part.getInputStream());
                nodeContent.setProperty(Utils.JCR_LASTMODIFIED, Calendar.getInstance().getTimeInMillis());
                node.setProperty(Utils.EXO_HASATTACH, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    private String getNestedMessageBody(Part part, Node node, String body) throws Exception {
        try {
            body = this.setPart((Part)part.getContent(), node, body);
        }
        catch (ClassCastException e) {
            Object obj = part.getContent();
            if (obj instanceof String) {
                body = body + (String)obj;
            }
            if (obj instanceof InputStream) {
                int c;
                StringBuffer sb = new StringBuffer();
                InputStream is = (InputStream)obj;
                while ((c = is.read()) != -1) {
                    sb.append(c);
                }
                body = body + sb.toString();
            }
            if (obj instanceof Multipart) {
                body = this.setMultiPart((Multipart)obj, node, body);
            }
            logger.warn((Object)"This is a unknown type.");
        }
        return body;
    }

    private String appendMessageBody(Part part, Node node, String body) throws Exception {
        String inputLine;
        String cs;
        StringBuffer messageBody = new StringBuffer();
        InputStream is = part.getInputStream();
        String ct = part.getContentType();
        String charset = "UTF-8";
        if (ct != null && (cs = new ContentType(ct).getParameter("charset")) != null) {
            charset = cs;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
        String breakLine = "";
        if (part.isMimeType("text/plain")) {
            breakLine = "\n";
        }
        while ((inputLine = reader.readLine()) != null) {
            messageBody.append(inputLine + breakLine);
        }
        if (part.isMimeType("text/plain")) {
            body = body != null && !body.equals("") ? body + "\n" + Utils.encodeHTML(messageBody.toString()) : Utils.encodeHTML(messageBody.toString());
        } else if (part.isMimeType("text/html")) {
            body = body != null && !body.equals("") ? body + "<br>" + messageBody.toString() : messageBody.toString();
        }
        return body;
    }

    public String setAddress(String strAddress) throws Exception {
        String str = "";
        try {
            if (strAddress != null && strAddress.trim() != "") {
                InternetAddress[] internetAddress = InternetAddress.parse((String)strAddress);
                if (internetAddress != null && internetAddress.length > 0) {
                    for (int i = 0; i < internetAddress.length; ++i) {
                        String personal = internetAddress[i].getPersonal();
                        String address = internetAddress[i].getAddress();
                        String sender = address + ";" + address;
                        if (personal != null && personal != "") {
                            sender = personal + " ;" + address;
                        }
                        str = str.length() < 1 ? sender : str + "," + sender;
                    }
                }
            }
        }
        catch (Exception e) {
            str = strAddress;
        }
        return str;
    }

    public Folder getFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        Folder folder = null;
        Node node = this.getFolderNodeById(sProvider, username, accountId, folderId);
        if (node != null) {
            folder = new Folder();
            folder.setId(node.getProperty(Utils.EXO_ID).getString());
            folder.setLabel(node.getProperty(Utils.EXO_LABEL).getString());
            folder.setPath(node.getPath());
            folder.setName(node.getProperty(Utils.EXO_NAME).getString());
            folder.setPersonalFolder(node.getProperty(Utils.EXO_PERSONAL).getBoolean());
            folder.setNumberOfUnreadMessage(node.getProperty(Utils.EXO_UNREADMESSAGES).getLong());
            folder.setTotalMessage(node.getProperty(Utils.EXO_TOTALMESSAGE).getLong());
        }
        return folder;
    }

    public String getFolderParentId(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        Node parentNode = this.getFolderNodeById(sProvider, username, accountId, folderId).getParent();
        try {
            if (parentNode != null) {
                return parentNode.getProperty(Utils.EXO_ID).getString();
            }
            return null;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Node getFolderNodeById(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Session sess = accountNode.getSession();
        QueryManager qm = sess.getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:folder)[@exo:id='").append(folderId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        Node node = null;
        if (it.hasNext()) {
            node = it.nextNode();
        }
        return node;
    }

    public Folder getFolder(Node node) throws Exception {
        Folder folder = new Folder();
        folder.setId(node.getProperty(Utils.EXO_ID).getString());
        folder.setLabel(node.getProperty(Utils.EXO_LABEL).getString());
        folder.setPath(node.getPath());
        folder.setName(node.getProperty(Utils.EXO_NAME).getString());
        folder.setPersonalFolder(node.getProperty(Utils.EXO_PERSONAL).getBoolean());
        folder.setNumberOfUnreadMessage(node.getProperty(Utils.EXO_UNREADMESSAGES).getLong());
        folder.setTotalMessage(node.getProperty(Utils.EXO_TOTALMESSAGE).getLong());
        return folder;
    }

    public List<Folder> getFolders(SessionProvider sProvider, String username, String accountId) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        Node folderHomeNode = this.getFolderHome(sProvider, username, accountId);
        NodeIterator iter = folderHomeNode.getNodes();
        while (iter.hasNext()) {
            Node folder = (Node)iter.next();
            folders.add(this.getFolder(sProvider, username, accountId, folder.getName()));
        }
        return folders;
    }

    public void saveFolder(SessionProvider sProvider, String username, String accountId, Folder folder) throws Exception {
        Node home = this.getFolderHome(sProvider, username, accountId);
        Node myFolder = null;
        Node node = this.getFolderNodeById(sProvider, username, accountId, folder.getId());
        myFolder = node != null ? node : home.addNode(folder.getId(), Utils.EXO_FOLDER);
        myFolder.setProperty(Utils.EXO_ID, folder.getId());
        myFolder.setProperty(Utils.EXO_NAME, folder.getName());
        myFolder.setProperty(Utils.EXO_LABEL, folder.getLabel());
        myFolder.setProperty(Utils.EXO_UNREADMESSAGES, folder.getNumberOfUnreadMessage());
        myFolder.setProperty(Utils.EXO_TOTALMESSAGE, folder.getTotalMessage());
        myFolder.setProperty(Utils.EXO_PERSONAL, folder.isPersonalFolder());
        home.getSession().save();
    }

    public boolean isExistFolder(SessionProvider sProvider, String username, String accountId, String parentId, String folderId) throws Exception {
        boolean isExist = false;
        Node parentNode = parentId != null && parentId.trim().length() > 0 ? this.getFolderNodeById(sProvider, username, accountId, parentId) : this.getFolderHome(sProvider, username, accountId);
        NodeIterator nit = parentNode.getNodes();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            String fn = node.getProperty(Utils.EXO_LABEL).getString();
            if (!fn.trim().equals(folderId)) continue;
            isExist = true;
        }
        return isExist;
    }

    public void saveFolder(SessionProvider sProvider, String username, String accountId, String parentId, Folder folder) throws Exception {
        Node home = this.getFolderHome(sProvider, username, accountId);
        Node parentNode = this.getFolderNodeById(sProvider, username, accountId, parentId);
        Node myFolder = null;
        myFolder = parentNode.hasNode(folder.getId()) ? parentNode.getNode(folder.getId()) : parentNode.addNode(folder.getId(), Utils.EXO_FOLDER);
        myFolder.setProperty(Utils.EXO_ID, folder.getId());
        myFolder.setProperty(Utils.EXO_NAME, folder.getName());
        myFolder.setProperty(Utils.EXO_LABEL, folder.getLabel());
        myFolder.setProperty(Utils.EXO_UNREADMESSAGES, folder.getNumberOfUnreadMessage());
        myFolder.setProperty(Utils.EXO_TOTALMESSAGE, folder.getTotalMessage());
        myFolder.setProperty(Utils.EXO_PERSONAL, folder.isPersonalFolder());
        home.getSession().save();
    }

    private void removeFolderInMessages(SessionProvider sProvider, String username, String accountId, List<Node> msgNodes, String folderId) throws Exception {
        for (Node msgNode : msgNodes) {
            try {
                Value[] propFolders = msgNode.getProperty(Utils.EXO_FOLDERS).getValues();
                String[] oldFolderIds = new String[propFolders.length];
                for (int i = 0; i < propFolders.length; ++i) {
                    oldFolderIds[i] = propFolders[i].getString();
                }
                ArrayList<String> folderList = new ArrayList<String>(Arrays.asList(oldFolderIds));
                folderList.remove(folderId);
                msgNode.setProperty(Utils.EXO_FOLDERS, folderList.toArray(new String[folderList.size()]));
                msgNode.save();
            }
            catch (Exception e) {}
        }
    }

    public void removeUserFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        List<Node> msgNodes = this.getMessageNodeByFolder(sProvider, username, accountId, folderId);
        this.removeFolderInMessages(sProvider, username, accountId, msgNodes, folderId);
        Node node = this.getFolderNodeById(sProvider, username, accountId, folderId);
        if (node != null) {
            node.remove();
        }
        node.getSession().save();
    }

    public Node getFilterHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        if (accountHome.hasNode(Utils.KEY_FILTER)) {
            return accountHome.getNode(Utils.KEY_FILTER);
        }
        accountHome.addNode(Utils.KEY_FILTER, Utils.NT_UNSTRUCTURED);
        accountHome.save();
        return accountHome.getNode(Utils.KEY_FILTER);
    }

    public List<MessageFilter> getFilters(SessionProvider sProvider, String username, String accountId) throws Exception {
        ArrayList<MessageFilter> filterList = new ArrayList<MessageFilter>();
        Node filterHomeNode = this.getFilterHome(sProvider, username, accountId);
        NodeIterator iter = filterHomeNode.getNodes();
        while (iter.hasNext()) {
            Node filterNode = (Node)iter.next();
            MessageFilter filter = new MessageFilter("");
            try {
                filter.setId(filterNode.getProperty(Utils.EXO_ID).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setName(filterNode.getProperty(Utils.EXO_NAME).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setFrom(filterNode.getProperty(Utils.EXO_FROM).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setFromCondition((int)filterNode.getProperty(Utils.EXO_FROM_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setTo(filterNode.getProperty(Utils.EXO_TO).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setToCondition((int)filterNode.getProperty(Utils.EXO_TO_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setSubject(filterNode.getProperty(Utils.EXO_SUBJECT).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setSubjectCondition((int)filterNode.getProperty(Utils.EXO_SUBJECT_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setBody(filterNode.getProperty(Utils.EXO_BODY).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setBodyCondition((int)filterNode.getProperty(Utils.EXO_BODY_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String folder = filterNode.getProperty(Utils.EXO_APPLY_FOLDER).getString();
                if (!Utils.isEmptyField(folder) && this.getFolder(sProvider, username, accountId, folder) != null) {
                    filter.setApplyFolder(folder);
                } else {
                    filter.setApplyFolder(Utils.createFolderId(accountId, Utils.FD_INBOX, false));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setApplyTag(filterNode.getProperty(Utils.EXO_APPLY_TAG).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setKeepInInbox(filterNode.getProperty(Utils.EXO_KEEP_IN_INBOX).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setApplyForAll(filterNode.getProperty(Utils.EXO_APPLY_FOR_ALL).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            filterList.add(filter);
        }
        return filterList;
    }

    public MessageFilter getFilterById(SessionProvider sProvider, String username, String accountId, String filterId) throws Exception {
        Node filterHomeNode = this.getFilterHome(sProvider, username, accountId);
        MessageFilter filter = new MessageFilter("");
        if (filterHomeNode.hasNode(filterId)) {
            Node filterNode = filterHomeNode.getNode(filterId);
            try {
                filter.setId(filterNode.getProperty(Utils.EXO_ID).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setName(filterNode.getProperty(Utils.EXO_NAME).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setFrom(filterNode.getProperty(Utils.EXO_FROM).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setFromCondition((int)filterNode.getProperty(Utils.EXO_FROM_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setTo(filterNode.getProperty(Utils.EXO_TO).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setToCondition((int)filterNode.getProperty(Utils.EXO_TO_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setSubject(filterNode.getProperty(Utils.EXO_SUBJECT).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setSubjectCondition((int)filterNode.getProperty(Utils.EXO_SUBJECT_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setBody(filterNode.getProperty(Utils.EXO_BODY).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setBodyCondition((int)filterNode.getProperty(Utils.EXO_BODY_CONDITION).getLong());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String folder = filterNode.getProperty(Utils.EXO_APPLY_FOLDER).getString();
                if (!Utils.isEmptyField(folder) && this.getFolder(sProvider, username, accountId, folder) != null) {
                    filter.setApplyFolder(folder);
                } else {
                    filter.setApplyFolder(Utils.createFolderId(accountId, Utils.FD_INBOX, false));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setApplyTag(filterNode.getProperty(Utils.EXO_APPLY_TAG).getString());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setKeepInInbox(filterNode.getProperty(Utils.EXO_KEEP_IN_INBOX).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                filter.setApplyForAll(filterNode.getProperty(Utils.EXO_APPLY_FOR_ALL).getBoolean());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return filter;
    }

    public void saveFilter(SessionProvider sProvider, String username, String accountId, MessageFilter filter, boolean applyAll) throws Exception {
        Node home = this.getFilterHome(sProvider, username, accountId);
        Node filterNode = null;
        filterNode = home.hasNode(filter.getId()) ? home.getNode(filter.getId()) : home.addNode(filter.getId(), Utils.EXO_FILTER);
        filterNode.setProperty(Utils.EXO_ID, filter.getId());
        filterNode.setProperty(Utils.EXO_NAME, filter.getName());
        filterNode.setProperty(Utils.EXO_FROM, filter.getFrom());
        filterNode.setProperty(Utils.EXO_FROM_CONDITION, (long)filter.getFromCondition());
        filterNode.setProperty(Utils.EXO_TO, filter.getTo());
        filterNode.setProperty(Utils.EXO_TO_CONDITION, (long)filter.getToCondition());
        filterNode.setProperty(Utils.EXO_SUBJECT, filter.getSubject());
        filterNode.setProperty(Utils.EXO_SUBJECT_CONDITION, (long)filter.getSubjectCondition());
        filterNode.setProperty(Utils.EXO_BODY, filter.getBody());
        filterNode.setProperty(Utils.EXO_BODY_CONDITION, (long)filter.getBodyCondition());
        if (!Utils.isEmptyField(filter.getApplyFolder())) {
            filterNode.setProperty(Utils.EXO_APPLY_FOLDER, filter.getApplyFolder());
        } else {
            filterNode.setProperty(Utils.EXO_APPLY_FOLDER, Utils.createFolderId(accountId, Utils.FD_INBOX, false));
        }
        filterNode.setProperty(Utils.EXO_APPLY_TAG, filter.getApplyTag());
        filterNode.setProperty(Utils.EXO_KEEP_IN_INBOX, filter.keepInInbox().booleanValue());
        filterNode.setProperty(Utils.EXO_APPLY_FOR_ALL, filter.applyForAll().booleanValue());
        try {
            if (applyAll) {
                this.runFilter(sProvider, username, accountId, filter);
            }
        }
        catch (Exception e) {
            return;
        }
        home.getSession().save();
    }

    private void runFilter(SessionProvider sProvider, String username, String accountId, MessageFilter filter) throws Exception {
        Tag tag;
        List<Message> msgList = this.getMessagePageList(sProvider, username, filter).getAll(username);
        String applyFolder = filter.getApplyFolder();
        String applyTag = filter.getApplyTag();
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Message msg : msgList) {
            Folder appFolder;
            Folder folder = this.getFolder(sProvider, username, accountId, applyFolder);
            if (folder == null || msg.getFolders()[0] == applyFolder || (appFolder = this.getFolder(sProvider, username, accountId, applyFolder)) == null) continue;
            this.moveMessage(sProvider, username, accountId, msg, msg.getFolders()[0], applyFolder);
        }
        if (!Utils.isEmptyField(applyTag) && (tag = this.getTag(sProvider, username, accountId, applyTag)) != null) {
            tagList.add(tag);
            this.addTag(sProvider, username, accountId, msgList, tagList);
        }
    }

    public void removeFilter(SessionProvider sProvider, String username, String accountId, String filterId) throws Exception {
        Node filterHome = this.getFilterHome(sProvider, username, accountId);
        if (filterHome.hasNode(filterId)) {
            filterHome.getNode(filterId).remove();
        }
        filterHome.getSession().save();
    }

    public Node getMessageHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node msgHome = null;
        try {
            msgHome = accountHome.getNode(Utils.KEY_MESSAGE);
        }
        catch (PathNotFoundException e) {
            msgHome = accountHome.addNode(Utils.KEY_MESSAGE, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return msgHome;
    }

    public Node getFolderHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node folderHome = null;
        try {
            folderHome = accountHome.getNode(Utils.KEY_FOLDERS);
        }
        catch (PathNotFoundException e) {
            folderHome = accountHome.addNode(Utils.KEY_FOLDERS, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return folderHome;
    }

    public Node getTagHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node tagHome = null;
        try {
            tagHome = accountHome.getNode(Utils.KEY_TAGS);
        }
        catch (PathNotFoundException e) {
            tagHome = accountHome.addNode(Utils.KEY_TAGS, Utils.NT_UNSTRUCTURED);
            accountHome.save();
        }
        return tagHome;
    }

    public void addTag(SessionProvider sProvider, String username, String accountId, Tag tag) throws Exception {
        Node tagHome = this.getTagHome(sProvider, username, accountId);
        if (!tagHome.hasNode(tag.getId())) {
            Node tagNode = tagHome.addNode(tag.getId(), Utils.EXO_MAILTAG);
            tagNode.setProperty(Utils.EXO_ID, tag.getId());
            tagNode.setProperty(Utils.EXO_NAME, tag.getName());
            tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
            tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
            tagHome.save();
        }
    }

    public void addTag(SessionProvider sProvider, String username, String accountId, List<Message> messages, List<Tag> tagList) throws Exception {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        Node tagHome = this.getTagHome(sProvider, username, accountId);
        for (Tag tag : tagList) {
            if (!tagHome.hasNode(tag.getId())) {
                Node tagNode = tagHome.addNode(tag.getId(), Utils.EXO_MAILTAG);
                tagNode.setProperty(Utils.EXO_ID, tag.getId());
                tagNode.setProperty(Utils.EXO_NAME, tag.getName());
                tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
                tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
            }
            tagMap.put(tag.getId(), tag.getId());
        }
        tagHome.getSession().save();
        Node mailHome = this.getMailHomeNode(sProvider, username);
        for (Message message : messages) {
            HashMap<String, String> messageTagMap = new HashMap<String, String>();
            Node messageNode = (Node)mailHome.getSession().getItem(message.getPath());
            try {
                Value[] values;
                for (Value value : values = messageNode.getProperty(Utils.EXO_TAGS).getValues()) {
                    messageTagMap.put(value.getString(), value.getString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            messageTagMap.putAll(tagMap);
            messageNode.setProperty(Utils.EXO_TAGS, messageTagMap.values().toArray(new String[0]));
            messageNode.save();
        }
    }

    public List<Tag> getTags(SessionProvider sProvider, String username, String accountId) throws Exception {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
        NodeIterator iter = tagHomeNode.getNodes();
        while (iter.hasNext()) {
            Node tagNode = (Node)iter.next();
            Tag tag = new Tag();
            try {
                tag.setId(tagNode.getProperty(Utils.EXO_ID).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setName(tagNode.getProperty(Utils.EXO_NAME).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setDescription(tagNode.getProperty(Utils.EXO_DESCRIPTION).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setColor(tagNode.getProperty(Utils.EXO_COLOR).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            tags.add(tag);
        }
        return tags;
    }

    public Tag getTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
        Tag tag = new Tag();
        NodeIterator iter = tagHomeNode.getNodes();
        while (iter.hasNext()) {
            Node tagNode = (Node)iter.next();
            if (!tagNode.getProperty(Utils.EXO_ID).getString().equals(tagId)) continue;
            try {
                tag.setId(tagNode.getProperty(Utils.EXO_ID).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setName(tagNode.getProperty(Utils.EXO_NAME).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setDescription(tagNode.getProperty(Utils.EXO_DESCRIPTION).getString());
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                tag.setColor(tagNode.getProperty(Utils.EXO_COLOR).getString());
            }
            catch (PathNotFoundException e) {}
        }
        return tag;
    }

    public void removeTagsInMessages(SessionProvider sProvider, String username, String accountId, List<Message> msgList, List<String> tagIds) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        for (Message msg : msgList) {
            try {
                Node msgNode = (Node)mailHome.getSession().getItem(msg.getPath());
                try {
                    Value[] propTags = msgNode.getProperty(Utils.EXO_TAGS).getValues();
                    String[] oldTagIds = new String[propTags.length];
                    for (int i = 0; i < propTags.length; ++i) {
                        oldTagIds[i] = propTags[i].getString();
                    }
                    ArrayList<String> tagList = new ArrayList<String>(Arrays.asList(oldTagIds));
                    tagList.removeAll(tagIds);
                    String[] newTagIds = tagList.toArray(new String[tagList.size()]);
                    msgNode.setProperty(Utils.EXO_TAGS, newTagIds);
                    msgNode.save();
                }
                catch (Exception e) {
                }
            }
            catch (PathNotFoundException e) {}
        }
    }

    public void removeTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        List<Message> listMessage = this.getMessageByTag(sProvider, username, accountId, tagId);
        ArrayList<String> listTag = new ArrayList<String>();
        listTag.add(tagId);
        this.removeTagsInMessages(sProvider, username, accountId, listMessage, listTag);
        Node tagHomeNode = this.getTagHome(sProvider, username, accountId);
        if (tagHomeNode.hasNode(tagId)) {
            tagHomeNode.getNode(tagId).remove();
        }
        tagHomeNode.getSession().save();
    }

    public void updateTag(SessionProvider sProvider, String username, String accountId, Tag tag) throws Exception {
        Node tagHome = this.getTagHome(sProvider, username, accountId);
        if (tagHome.hasNode(tag.getId())) {
            Node tagNode = tagHome.getNode(tag.getId());
            tagNode.setProperty(Utils.EXO_NAME, tag.getName());
            tagNode.setProperty(Utils.EXO_DESCRIPTION, tag.getDescription());
            tagNode.setProperty(Utils.EXO_COLOR, tag.getColor());
        }
        tagHome.save();
    }

    public List<Message> getMessageByTag(SessionProvider sProvider, String username, String accountId, String tagId) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        QueryManager qm = accountNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:tags='").append(tagId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Message message = this.getMessage(it.nextNode());
            messages.add(message);
        }
        return messages;
    }

    private List<Node> getMessageNodeByFolder(SessionProvider sProvider, String username, String accountId, String folderId) throws Exception {
        ArrayList<Node> msgNodes = new ArrayList<Node>();
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        QueryManager qm = accountNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:folders='").append(folderId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            msgNodes.add(it.nextNode());
        }
        return msgNodes;
    }

    public Node getSpamFilterHome(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountHome = this.getMailHomeNode(sProvider, username).getNode(accountId);
        if (accountHome.hasNode(Utils.KEY_SPAM_FILTER)) {
            return accountHome.getNode(Utils.KEY_SPAM_FILTER);
        }
        return accountHome.addNode(Utils.KEY_SPAM_FILTER, Utils.NT_UNSTRUCTURED);
    }

    public SpamFilter getSpamFilter(SessionProvider sProvider, String username, String accountId) throws Exception {
        Node accountNode = this.getSpamFilterHome(sProvider, username, accountId);
        NodeIterator it = accountNode.getNodes();
        Node spamFilterNode = null;
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.isNodeType(Utils.EXO_SPAM_FILTER)) continue;
            spamFilterNode = node;
            break;
        }
        SpamFilter spamFilter = new SpamFilter();
        if (spamFilterNode != null) {
            try {
                Value[] propFroms = spamFilterNode.getProperty(Utils.EXO_FROMS).getValues();
                String[] froms = new String[propFroms.length];
                for (int i = 0; i < propFroms.length; ++i) {
                    froms[i] = propFroms[i].getString();
                }
                spamFilter.setSenders(froms);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return spamFilter;
    }

    public void saveSpamFilter(SessionProvider sProvider, String username, String accountId, SpamFilter spamFilter) throws Exception {
        Node accountNode = this.getSpamFilterHome(sProvider, username, accountId);
        Node spamFilterNode = null;
        spamFilterNode = accountNode.hasNode(Utils.EXO_SPAM_FILTER) ? accountNode.getNode(Utils.EXO_SPAM_FILTER) : accountNode.addNode(Utils.EXO_SPAM_FILTER, Utils.EXO_SPAM_FILTER);
        spamFilterNode.setProperty(Utils.EXO_FROMS, spamFilter.getSenders());
        accountNode.getSession().save();
    }

    public void toggleMessageProperty(SessionProvider sProvider, String username, String accountId, List<Message> msgList, String property) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        for (Message msg : msgList) {
            Node msgNode = (Node)mailHome.getSession().getItem(msg.getPath());
            if (property.equals(Utils.EXO_STAR)) {
                msgNode.setProperty(Utils.EXO_STAR, !msgNode.getProperty(Utils.EXO_STAR).getBoolean());
                msgNode.save();
                continue;
            }
            if (!property.equals(Utils.EXO_ISUNREAD)) continue;
            Boolean isUnread = msgNode.getProperty(Utils.EXO_ISUNREAD).getBoolean();
            msgNode.setProperty(Utils.EXO_ISUNREAD, isUnread == false);
            msgNode.save();
            Node currentFolderNode = this.getFolderNodeById(sProvider, username, accountId, msgNode.getProperty(Utils.EXO_FOLDERS).getValues()[0].getString());
            if (currentFolderNode == null) continue;
            if (isUnread.booleanValue()) {
                currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() - 1L);
            } else {
                currentFolderNode.setProperty(Utils.EXO_UNREADMESSAGES, currentFolderNode.getProperty(Utils.EXO_UNREADMESSAGES).getLong() + 1L);
            }
            currentFolderNode.save();
        }
    }

    public String getFolderHomePath(SessionProvider sProvider, String username, String accountId) throws Exception {
        return this.getFolderHome(sProvider, username, accountId).getPath();
    }

    public List<Folder> getSubFolders(SessionProvider sProvider, String username, String accountId, String parentPath) throws Exception {
        Node home = this.getFolderHome(sProvider, username, accountId);
        Node parentNode = (Node)home.getSession().getItem(parentPath);
        ArrayList<Folder> childFolders = new ArrayList<Folder>();
        NodeIterator it = parentNode.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.isNodeType(Utils.EXO_FOLDER) || !node.hasProperty(Utils.EXO_PERSONAL) || !node.getProperty(Utils.EXO_PERSONAL).getBoolean()) continue;
            childFolders.add(this.getFolder(node));
        }
        return childFolders;
    }

    public void execActionFilter(SessionProvider sProvider, String username, String accountId, Calendar checkTime) throws Exception {
        List<MessageFilter> msgFilters = this.getFilters(sProvider, username, accountId);
        Node homeMsg = this.getMessageHome(sProvider, username, accountId);
        Session sess = this.getMailHomeNode(sProvider, username).getSession();
        QueryManager qm = sess.getWorkspace().getQueryManager();
        for (MessageFilter filter : msgFilters) {
            String applyFolder = filter.getApplyFolder();
            String applyTag = filter.getApplyTag();
            filter.setAccountPath(homeMsg.getPath());
            filter.setAccountId(accountId);
            filter.setFromDate(checkTime);
            String queryString = filter.getStatement();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Tag tag;
                Folder folder;
                Message msg = this.getMessage(it.nextNode());
                if (!Utils.isEmptyField(applyFolder) && this.getFolder(sProvider, username, accountId, applyFolder) != null && (folder = this.getFolder(sProvider, username, accountId, applyFolder)) != null) {
                    this.moveMessage(sProvider, username, accountId, msg, msg.getFolders()[0], applyFolder);
                }
                if (Utils.isEmptyField(applyTag) || (tag = this.getTag(sProvider, username, accountId, applyTag)) == null) continue;
                ArrayList<Message> msgList = new ArrayList<Message>();
                msgList.add(msg);
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                tagList.add(tag);
                this.addTag(sProvider, username, accountId, msgList, tagList);
            }
        }
    }

    public Node getDateStoreNode(SessionProvider sProvider, String username, String accountId, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        Node msgHome = this.getMessageHome(sProvider, username, accountId);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        String year = "Y" + String.valueOf(calendar.get(1));
        String month = "M" + String.valueOf(calendar.get(2) + 1);
        String day = "D" + String.valueOf(calendar.get(5));
        try {
            yearNode = msgHome.getNode(year);
        }
        catch (Exception e) {
            yearNode = msgHome.addNode(year, Utils.NT_UNSTRUCTURED);
            msgHome.save();
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (Exception e) {
            monthNode = yearNode.addNode(month, Utils.NT_UNSTRUCTURED);
            yearNode.save();
        }
        try {
            return monthNode.getNode(day);
        }
        catch (Exception e) {
            Node dayNode = monthNode.addNode(day, Utils.NT_UNSTRUCTURED);
            monthNode.save();
            return dayNode;
        }
    }

    private List<Node> getMatchingThreadAfter(SessionProvider sProvider, String username, String accountId, Node msg) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        ArrayList<Node> converNodes = new ArrayList<Node>();
        try {
            if (msg.getName().equals(msg.getProperty(Utils.EXO_IN_REPLY_TO_HEADER).getString())) {
                return null;
            }
            Session sess = accountNode.getSession();
            QueryManager qm = sess.getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:inReplyToHeader='").append(msg.getName()).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                converNodes.add(it.nextNode());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return converNodes;
    }

    private Node getMatchingThreadBefore(SessionProvider sProvider, String username, String accountId, String inReplyToHeader, Node msg) throws Exception {
        Node accountNode = this.getMailHomeNode(sProvider, username).getNode(accountId);
        Node converNode = null;
        try {
            StringBuffer queryString;
            if (inReplyToHeader.equals(msg.getName())) {
                return null;
            }
            Session sess = accountNode.getSession();
            QueryManager qm = sess.getWorkspace().getQueryManager();
            Query query = qm.createQuery((queryString = new StringBuffer("/jcr:root" + accountNode.getPath() + "//element(*,exo:message)[@exo:id='").append(inReplyToHeader).append("']")).toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            if (it.hasNext()) {
                converNode = it.nextNode();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return converNode;
    }

    public void addMessageToThread(SessionProvider sProvider, String username, String accountId, String inReplyToHeader, Node msgNode) throws Exception {
        block7: {
            List<Node> converNodeChilds = this.getMatchingThreadAfter(sProvider, username, accountId, msgNode);
            try {
                msgNode.addMixin("mix:referenceable");
                if (converNodeChilds != null && converNodeChilds.size() > 0) {
                    for (Node converChild : converNodeChilds) {
                        this.createReference(converChild, msgNode);
                        converChild = this.setIsRoot(accountId, converChild, msgNode);
                        msgNode.setProperty(Utils.EXO_IS_ROOT, true);
                        converChild.save();
                        msgNode.save();
                    }
                    break block7;
                }
                Node converNodeParent = this.getMatchingThreadBefore(sProvider, username, accountId, inReplyToHeader, msgNode);
                try {
                    if (converNodeParent != null && converNodeParent.isNodeType("exo:message")) {
                        this.createReference(msgNode, converNodeParent);
                        msgNode = this.setIsRoot(accountId, msgNode, converNodeParent);
                        msgNode.save();
                        converNodeParent.save();
                        break block7;
                    }
                    msgNode.setProperty(Utils.EXO_IS_ROOT, true);
                    msgNode.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Node setIsRoot(String accountId, Node msgNode, Node converNode) throws Exception {
        boolean isRoot = true;
        try {
            int i;
            Value[] propFoldersMsgNode = msgNode.getProperty(Utils.EXO_FOLDERS).getValues();
            String[] foldersMsgNode = new String[propFoldersMsgNode.length];
            for (int i2 = 0; i2 < propFoldersMsgNode.length; ++i2) {
                foldersMsgNode[i2] = propFoldersMsgNode[i2].getString();
            }
            Value[] propFoldersConverNode = converNode.getProperty(Utils.EXO_FOLDERS).getValues();
            String[] foldersConverNode = new String[propFoldersConverNode.length];
            for (i = 0; i < propFoldersConverNode.length; ++i) {
                foldersConverNode[i] = propFoldersConverNode[i].getString();
            }
            for (i = 0; i < foldersMsgNode.length; ++i) {
                for (int j = 0; j < foldersConverNode.length; ++j) {
                    if (!foldersConverNode[j].equals(foldersMsgNode[i])) continue;
                    isRoot = false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        msgNode.setProperty(Utils.EXO_IS_ROOT, isRoot);
        return msgNode;
    }

    private Node setIsRoot(String accountId, Node msgNode) throws Exception {
        PropertyIterator iter = msgNode.getReferences();
        msgNode.setProperty(Utils.EXO_IS_ROOT, true);
        while (iter.hasNext()) {
            Node coverNode = iter.nextProperty().getParent();
            coverNode = this.setIsRoot(accountId, coverNode, msgNode);
            coverNode.save();
        }
        Value[] values = new Value[]{};
        if (msgNode.isNodeType("exo:messageMixin")) {
            values = msgNode.getProperty("exo:conversationId").getValues();
        }
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            String uuid = value.getString();
            Node refNode = null;
            try {
                refNode = msgNode.getSession().getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
            if (refNode == null || (msgNode = this.setIsRoot(accountId, msgNode, refNode)).getProperty(Utils.EXO_IS_ROOT).getBoolean()) continue;
            refNode.save();
            break;
        }
        return msgNode;
    }

    private void createReference(Node msgNode, Node converNode) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        Value[] values = new Value[]{};
        if (msgNode.isNodeType("exo:messageMixin")) {
            values = msgNode.getProperty("exo:conversationId").getValues();
        } else {
            msgNode.addMixin("exo:messageMixin");
        }
        boolean isExist = false;
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            String uuid = value.getString();
            Node refNode = converNode.getSession().getNodeByUUID(uuid);
            if (refNode.getPath().equals(converNode.getPath())) {
                isExist = true;
                break;
            }
            valueList.add(value);
        }
        if (!isExist) {
            Value value2add = msgNode.getSession().getValueFactory().createValue(converNode);
            valueList.add(value2add);
        }
        if (valueList.size() > 0) {
            msgNode.setProperty("exo:conversationId", valueList.toArray(new Value[valueList.size()]));
            msgNode.save();
        }
    }

    private Node moveReference(String accountId, Node node) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        Value[] values = new Value[]{};
        PropertyIterator iter = node.getReferences();
        Node firstNode = null;
        if (iter != null) {
            while (iter.hasNext()) {
                Node msgNode = iter.nextProperty().getParent();
                if (!msgNode.isNodeType("exo:messageMixin")) continue;
                values = msgNode.getProperty("exo:conversationId").getValues();
                for (int i = 0; i < values.length; ++i) {
                    valueList.add(values[i]);
                }
                Node parentNode = null;
                try {
                    Value[] currentValues;
                    if (node.hasProperty("exo:conversationId") && (currentValues = node.getProperty("exo:conversationId").getValues()).length > 0) {
                        parentNode = node.getSession().getNodeByUUID(currentValues[0].getString());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (parentNode != null) {
                    valueList.add(msgNode.getSession().getValueFactory().createValue(parentNode));
                } else if (firstNode != null) {
                    valueList.add(msgNode.getSession().getValueFactory().createValue(firstNode));
                }
                if (firstNode == null) {
                    firstNode = msgNode;
                }
                msgNode.save();
            }
            node = this.setIsRoot(accountId, node);
        }
        return node;
    }

    public List<Message> getReferencedMessages(SessionProvider sProvider, String username, String accountId, String msgPath) throws Exception {
        Node mailHome = this.getMailHomeNode(sProvider, username);
        ArrayList<Message> msgList = new ArrayList<Message>();
        Node converNode = (Node)mailHome.getSession().getItem(msgPath);
        PropertyIterator iter = converNode.getReferences();
        while (iter.hasNext()) {
            Node msgNode = iter.nextProperty().getParent();
            msgList.add(this.getMessage(msgNode));
        }
        return msgList;
    }

    public Message loadAttachments(SessionProvider sProvider, String username, String accountId, Message msg) throws Exception {
        try {
            Node messageNode = this.getDateStoreNode(sProvider, username, accountId, msg.getReceivedDate()).getNode(msg.getId());
            NodeIterator msgAttachmentIt = messageNode.getNode(Utils.KEY_ATTACHMENT).getNodes();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            while (msgAttachmentIt.hasNext()) {
                Node node = msgAttachmentIt.nextNode();
                if (!node.isNodeType(Utils.EXO_MAIL_ATTACHMENT)) continue;
                JCRMessageAttachment file = new JCRMessageAttachment();
                file.setId(node.getPath());
                file.setMimeType(node.getNode(Utils.JCR_CONTENT).getProperty(Utils.JCR_MIMETYPE).getString());
                file.setName(node.getProperty(Utils.EXO_ATT_NAME).getString());
                file.setWorkspace(node.getSession().getWorkspace().getName());
                file.setSize(node.getNode(Utils.JCR_CONTENT).getProperty(Utils.JCR_DATA).getLength());
                file.setPath("/" + file.getWorkspace() + node.getPath());
                attachments.add(file);
            }
            msg.setAttachements(attachments);
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        return msg;
    }

    private byte checkDuplicateStatus(SessionProvider sProvider, String username, Node msgHomeNode, String accId, Node msgNode, String folderId) {
        int ret = 0;
        try {
            Value[] propFolders = msgNode.getProperty(Utils.EXO_FOLDERS).getValues();
            for (int i = 0; i < propFolders.length; ++i) {
                if (propFolders[i].getString().indexOf(folderId) <= -1) continue;
                logger.warn((Object)"DUPLICATE MAIL ... removed");
                return 1;
            }
            String[] folders = new String[propFolders.length + 1];
            folders[0] = folderId;
            for (int i = 0; i < propFolders.length; ++i) {
                folders[i + 1] = propFolders[i].getString();
            }
            msgNode.setProperty(Utils.EXO_ISUNREAD, true);
            msgNode.setProperty(Utils.EXO_STAR, false);
            msgNode.setProperty(Utils.EXO_FOLDERS, folders);
            msgHomeNode.save();
            this.increaseFolderItem(sProvider, username, accId, folderId);
            logger.warn((Object)"DUPLICATE MAIL IN ANOTHER FOLDER ... ");
            ret = 2;
        }
        catch (Exception e) {
            // empty catch block
        }
        return (byte)ret;
    }
}

