/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.exoplatform.mail.service.MailImportExport;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.util.IdGenerator;

public class EMLImportExport
implements MailImportExport {
    private JCRDataStorage jcrDataStorage_;

    public EMLImportExport(JCRDataStorage jcrDataStorage) throws Exception {
        this.jcrDataStorage_ = jcrDataStorage;
    }

    public OutputStream exportMessage(String username, String accountId, Message message) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage = Utils.mergeToMimeMessage(message, mimeMessage);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        mimeMessage.writeTo((OutputStream)outputStream);
        return outputStream;
    }

    public boolean importMessage(String username, String accountId, String folderId, InputStream inputStream, String type) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage mimeMessage = new MimeMessage(session, inputStream);
        mimeMessage.setHeader("Message-ID", "Message" + IdGenerator.generate());
        try {
            return this.jcrDataStorage_.saveMessage(username, accountId, (javax.mail.Message)mimeMessage, new String[]{folderId}, null, null, true);
        }
        catch (Exception e) {
            return false;
        }
    }
}

