/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.connection.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.mail.connection.impl.BaseConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapConnector
extends BaseConnector {
    private static final Log logger = LogFactory.getLog(Utils.class);
    private Account account_;

    public ImapConnector(Account account) throws Exception {
        Session session = this.getSession(account);
        IMAPStore imapStore = (IMAPStore)session.getStore("imap");
        this.store_ = imapStore;
        this.account_ = account;
        this.store_.connect(this.account_.getIncomingHost(), Integer.valueOf(this.account_.getIncomingPort()).intValue(), this.account_.getIncomingUser(), this.account_.getIncomingPassword());
    }

    public Store getStore() {
        return this.store_;
    }

    @Override
    public void openStore(Account account) throws Exception {
    }

    @Override
    public javax.mail.Folder createFolder(Folder folder) throws Exception {
        return this.createFolder(null, folder);
    }

    @Override
    public javax.mail.Folder createFolder(Folder parentFolder, Folder folder) throws Exception {
        IMAPFolder imapFolder = null;
        if (parentFolder == null) {
            imapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(folder.getName());
            if (!imapFolder.exists()) {
                imapFolder.create((int)folder.getType());
            }
        } else {
            URLName url = new URLName(parentFolder.getURLName());
            IMAPFolder parentImapFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (parentImapFolder != null && parentImapFolder.exists()) {
                boolean isOpen = parentImapFolder.isOpen();
                if (!isOpen) {
                    parentImapFolder.open(2);
                }
                if (!(imapFolder = (IMAPFolder)parentImapFolder.getFolder(folder.getName())).exists()) {
                    imapFolder.create((int)folder.getType());
                }
                parentImapFolder.close(true);
            }
        }
        return imapFolder;
    }

    @Override
    public Folder renameFolder(String newName, Folder folder) throws Exception {
        try {
            boolean result = false;
            URLName url = new URLName(folder.getURLName());
            IMAPFolder folderToBeRenamed = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (folderToBeRenamed.exists()) {
                if (folderToBeRenamed.isOpen()) {
                    folderToBeRenamed.close(false);
                }
                IMAPFolder f1 = (IMAPFolder)((IMAPStore)this.store_).getFolder(newName);
                result = folderToBeRenamed.renameTo((javax.mail.Folder)f1);
                folder.setURLName(f1.getURLName().toString());
                folder.setName(newName);
                if (!result) {
                    logger.info((Object)"Error while renaming folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return folder;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int emptyFolder(Folder folder) throws Exception {
        IMAPFolder folderToEmpty = (IMAPFolder)((IMAPStore)this.store_).getFolder(folder.getName());
        javax.mail.Message[] messages = folderToEmpty.getMessagesByUID(0L, -1L);
        int messageCount = messages.length;
        for (int i = 0; i < messageCount; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
        folderToEmpty.close(true);
        return messageCount;
    }

    @Override
    public boolean deleteFolder(Folder folder) throws Exception {
        try {
            boolean result = false;
            URLName url = new URLName(folder.getURLName());
            IMAPFolder folderToBeRemoved = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (folderToBeRemoved.exists()) {
                if (folderToBeRemoved.isOpen()) {
                    folderToBeRemoved.close(true);
                }
                if (!(result = folderToBeRemoved.delete(true))) {
                    logger.info((Object)"Error while deleting folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return result;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public List<Message> createMessage(List<Message> msgs, Folder folder) throws Exception {
        try {
            URLName remoteURL = new URLName(folder.getURLName());
            IMAPFolder remoteFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(remoteURL);
            remoteFolder.open(2);
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            javax.mail.Message[] messages = new javax.mail.Message[msgs.size()];
            for (int i = 0; i < msgs.size(); ++i) {
                MimeMessage mimeMessage = new MimeMessage(session);
                mimeMessage = Utils.mergeToMimeMessage(msgs.get(i), mimeMessage);
                messages[i] = mimeMessage;
            }
            javax.mail.Message[] updatedMsgs = remoteFolder.addMessages(messages);
            if (updatedMsgs.length == msgs.size()) {
                String uid = "";
                for (int l = 0; l < updatedMsgs.length; ++l) {
                    uid = String.valueOf(remoteFolder.getUID(updatedMsgs[l]));
                    msgs.get(l).setId(MimeMessageParser.getMessageId(updatedMsgs[l]));
                    msgs.get(l).setUID(uid);
                }
            }
            remoteFolder.close(true);
        }
        catch (Exception e) {
            logger.error((Object)"Error in move messages to remote folder", (Throwable)e);
            return null;
        }
        return msgs;
    }

    @Override
    public boolean deleteMessage(List<Message> msgs, Folder folder) throws Exception {
        try {
            URLName url = new URLName(folder.getURLName());
            IMAPFolder inFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            boolean isOpen = inFolder.isOpen();
            if (!isOpen) {
                inFolder.open(2);
            }
            for (Message msg : msgs) {
                javax.mail.Message message = inFolder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.DELETED, true);
            }
            inFolder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<Message> moveMessage(List<Message> msgs, Folder currentFolder, Folder desFolder) throws Exception {
        if (!desFolder.isPersonalFolder() && !desFolder.getName().equalsIgnoreCase(Utils.FD_INBOX)) {
            return this.moveMessages(msgs, currentFolder, desFolder, true);
        }
        if (desFolder.isPersonalFolder() || desFolder.getName().equalsIgnoreCase(Utils.FD_INBOX)) {
            return this.moveMessages(msgs, currentFolder, desFolder, false);
        }
        return null;
    }

    private List<Message> moveMessages(List<Message> msgs, Folder fF, Folder fT, boolean isLocalF) {
        try {
            URLName fromURL = new URLName(fF.getURLName());
            IMAPFolder fromFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(fromURL);
            IMAPFolder toFolder = null;
            if (isLocalF) {
                toFolder = (IMAPFolder)this.createFolder(fT);
            } else {
                URLName toURL = new URLName(fT.getURLName());
                toFolder = (IMAPFolder)((IMAPStore)this.store_).getFolder(toURL);
            }
            fromFolder.open(2);
            toFolder.open(2);
            ArrayList<javax.mail.Message> copiedMsgs = new ArrayList<javax.mail.Message>();
            for (Message m : msgs) {
                javax.mail.Message msg;
                if (m.getUID() == null || (msg = fromFolder.getMessageByUID(Long.valueOf(m.getUID()).longValue())) == null) continue;
                copiedMsgs.add(msg);
            }
            javax.mail.Message[] updatedMsgs = toFolder.addMessages(copiedMsgs.toArray(new javax.mail.Message[copiedMsgs.size()]));
            for (int k = 0; k < copiedMsgs.size(); ++k) {
                ((javax.mail.Message)copiedMsgs.get(k)).setFlag(Flags.Flag.DELETED, true);
            }
            if (updatedMsgs.length == msgs.size()) {
                String uid = "";
                for (int l = 0; l < updatedMsgs.length; ++l) {
                    uid = String.valueOf(fromFolder.getUID(updatedMsgs[l]));
                    msgs.get(l).setUID(uid);
                }
            }
            fromFolder.close(true);
            toFolder.close(true);
        }
        catch (Exception e) {
            logger.error((Object)"FAIL TO MOVE MESSAGE:", (Throwable)e);
        }
        return msgs;
    }

    @Override
    public boolean markAsRead(List<Message> msgList, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.SEEN, true);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean markAsUnread(List<Message> msgList, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.SEEN, false);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setIsStared(List<Message> msgList, boolean isStared, Folder f) throws Exception {
        try {
            URLName url = new URLName(f.getURLName());
            IMAPFolder folder = (IMAPFolder)((IMAPStore)this.store_).getFolder(url);
            if (!folder.isOpen()) {
                folder.open(2);
            }
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.FLAGGED, isStared);
            }
            folder.close(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

