/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class CheckMailJob
implements Job,
InterruptableJob {
    public static final String CHECKMAIL_GROUP = "CollaborationSuite-webmail";
    public static final String USERNAME = "userName";
    public static final String ACCOUNTID = "acountId";
    public static final String FOLDERID = "folderId";
    public static final String MAILSVR = "mailservice";
    private static Log log = ExoLogger.getLogger((String)"cs.service.job");
    private String username;
    private String accountId;
    private String folderId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        PortalContainer container = CheckMailJob.getPortalContainer(context);
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap dataMap = jobDetail.getJobDataMap();
        this.username = dataMap.getString(USERNAME);
        this.accountId = dataMap.getString(ACCOUNTID);
        this.folderId = dataMap.getString(FOLDERID);
        try {
            if (this.username != null && this.accountId != null) {
                mailService.checkNewMessage(this.username, this.accountId, this.folderId);
            }
        }
        catch (InterruptedException ie) {
            log.warn((Object)"checking new mail message failed", (Throwable)ie);
            this.getMailService().stopCheckMail(this.username, this.accountId);
        }
        catch (Exception e) {
            log.error((Object)"checking new mail message failed", (Throwable)e);
            CheckingInfo info = null;
            try {
                info = mailService.getCheckingInfo(this.username, this.accountId);
            }
            catch (Exception e1) {
                log.error((Object)e1);
            }
            if (info != null) {
                info.setStatusCode(102);
                mailService.updateCheckingMailStatusByCometd(this.username, this.accountId, info);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
            }
        }
    }

    private MailService getMailService() {
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        return mailService;
    }

    private static String getJobName(String userId, String accountId) {
        return userId + ":" + accountId;
    }

    public static JobInfo getJobInfo(String userId, String accountId) {
        String name = CheckMailJob.getJobName(userId, accountId);
        JobInfo info = new JobInfo(name, CHECKMAIL_GROUP, CheckMailJob.class);
        info.setDescription("Check emails for user " + userId + " on acount " + accountId);
        return info;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.getMailService().stopCheckMail(this.username, this.accountId);
    }

    public static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(":") > 0) {
            portalName = portalName.substring(0, portalName.indexOf(":"));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }
}

