/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.mail.webui.SelectItem;
import org.exoplatform.mail.webui.SelectItemOption;
import org.exoplatform.mail.webui.SelectItemOptionGroup;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormSelectBox
extends UIFormStringInput {
    private boolean isMultiple_ = false;
    private int size_ = 1;
    private List<SelectItem> options_;
    private String onchange_;

    public UIFormSelectBox(String name, String bindingExpression, List<SelectItem> options) {
        super(name, bindingExpression, null);
        this.setOptions(options);
    }

    public final UIFormSelectBox setMultiple(boolean bl) {
        this.isMultiple_ = bl;
        return this;
    }

    public final UIFormSelectBox setSize(int i) {
        this.size_ = i;
        return this;
    }

    public UIFormSelectBox setValue(String value) {
        this.value_ = value;
        for (SelectItem option : this.options_) {
            if (option instanceof SelectItemOption) {
                if (((String)((SelectItemOption)option).getValue()).equals(this.value_)) {
                    ((SelectItemOption)option).setSelected(true);
                    continue;
                }
                ((SelectItemOption)option).setSelected(false);
                continue;
            }
            if (!(option instanceof SelectItemOptionGroup)) continue;
            ((SelectItemOptionGroup)option).setValue(value);
        }
        return this;
    }

    public String[] getSelectedValues() {
        if (this.isMultiple_) {
            ArrayList<Object> selectedValues = new ArrayList<Object>();
            for (int i = 0; i < this.options_.size(); ++i) {
                if (this.options_.get(i) instanceof SelectItemOption) {
                    SelectItemOption item = (SelectItemOption)this.options_.get(i);
                    if (!item.isSelected()) continue;
                    selectedValues.add(item.getValue());
                    continue;
                }
                if (!(this.options_.get(i) instanceof SelectItemOptionGroup)) continue;
                selectedValues.addAll(((SelectItemOptionGroup)this.options_.get(i)).getSelectedValues());
            }
            return selectedValues.toArray(new String[0]);
        }
        return new String[]{(String)this.value_};
    }

    public UIFormSelectBox setSelectedValues(String[] values) {
        block0: for (SelectItem option : this.options_) {
            if (option instanceof SelectItemOption) {
                ((SelectItemOption)option).setSelected(false);
                for (String value : values) {
                    if (!value.equals(((SelectItemOption)option).getValue())) continue;
                    ((SelectItemOption)option).setSelected(true);
                    continue block0;
                }
                continue;
            }
            if (!(option instanceof SelectItemOptionGroup)) continue;
            ((SelectItemOptionGroup)option).setSelectedValue(values);
        }
        return this;
    }

    public final List<SelectItem> getOptions() {
        return this.options_;
    }

    public final UIFormSelectBox setOptions(List<SelectItem> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        if (this.options_.get(0) instanceof SelectItemOption) {
            this.value_ = ((SelectItemOption)this.options_.get(0)).getValue();
        }
        return this;
    }

    public void reset() {
        if (this.options_ == null || this.options_.size() < 1) {
            return;
        }
        if (this.options_.get(0) instanceof SelectItemOption) {
            this.value_ = ((SelectItemOption)this.options_.get(0)).getValue();
        }
        for (SelectItem option : this.options_) {
            if (option instanceof SelectItemOption) {
                ((SelectItemOption)option).setSelected(false);
                continue;
            }
            if (!(option instanceof SelectItemOptionGroup)) continue;
            ((SelectItemOptionGroup)option).reset((String)this.value_);
        }
        ((SelectItemOption)this.options_.get(0)).setSelected(true);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public UIFormSelectBox setDisabled(boolean disabled) {
        this.setEnable(!disabled);
        return this;
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String[] values = context.getRequestParameterValues(this.getId());
        if (values == null) {
            this.value_ = null;
            for (SelectItem option : this.options_) {
                if (!(option instanceof SelectItemOption)) continue;
                ((SelectItemOption)option).setSelected(false);
            }
            return;
        }
        int i = 0;
        this.value_ = values[0];
        for (SelectItem item : this.options_) {
            if (!(item instanceof SelectItemOption)) continue;
            if (i > -1 && ((SelectItemOption)item).getValue().equals(values[i])) {
                ((SelectItemOption)item).setSelected(true);
                if (values.length != ++i) continue;
                i = -1;
                continue;
            }
            ((SelectItemOption)item).setSelected(false);
        }
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer w = context.getWriter();
        w.write("<select class=\"selectbox\" name=\"");
        w.write(this.name);
        w.write("\"");
        if (this.onchange_ != null) {
            w.append(" onchange=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isMultiple_) {
            w.write(" multiple=\"true\"");
        }
        if (this.size_ > 1) {
            w.write(" size=\"" + this.size_ + "\"");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.write(">\n");
        for (SelectItem item : this.options_) {
            if (item instanceof SelectItemOptionGroup) {
                w.write(this.processRenderOptionGroup((SelectItemOptionGroup)item));
                continue;
            }
            if (!(item instanceof SelectItemOption)) continue;
            w.write(this.processRenderOption((SelectItemOption)item));
        }
        w.write("</select>\n");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }

    protected UIForm getFrom() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    private String processRenderOptionGroup(SelectItemOptionGroup group) {
        StringBuffer result = new StringBuffer();
        String label = group.getLabel();
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            label = res.getString(this.getFrom().getId() + ".optionGroup.label." + label);
        }
        catch (Exception e) {
            System.out.println("Could not find: " + this.getFrom().getId() + ".optionGroup.label." + label);
        }
        result.append("<optgroup label=\"");
        result.append(label);
        result.append("\">");
        for (SelectItemOption option : group.getOptions()) {
            result.append(this.processRenderOption(option));
        }
        result.append("</optgroup>");
        return result.toString();
    }

    private String processRenderOption(SelectItemOption<String> option) {
        StringBuffer result = new StringBuffer();
        result.append("<option");
        if (option.isSelected()) {
            result.append(" selected=\"selected\"");
        }
        if (option.isDisabled()) {
            result.append(" disabled=\"true\"");
        }
        result.append(" value=\"");
        result.append((String)option.getValue());
        result.append("\">");
        result.append(option.getLabel());
        result.append("</option>\n");
        return result.toString();
    }
}

