/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIMessagePreview.gtmpl", events={@EventConfig(listeners={DownloadAttachmentActionListener.class}), @EventConfig(listeners={AddStarActionListener.class}), @EventConfig(listeners={ReplyActionListener.class}), @EventConfig(listeners={ReplyAllActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMessagePreview.msg.confirm-remove-message"), @EventConfig(listeners={ForwardActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={MoveMessagesActionListener.class}), @EventConfig(listeners={AnswerInvitationActionListener.class}), @EventConfig(listeners={ViewAllHeadersActionListener.class})})
public class UIMessagePreview
extends UIComponent {
    private Message selectedMessage_;
    private List<Message> showedMsgs = new ArrayList();

    public Message getMessage() throws Exception {
        return this.selectedMessage_;
    }

    public void setMessage(Message msg) throws Exception {
        this.selectedMessage_ = msg;
    }

    public List<Message> getShowedMessages() throws Exception {
        return this.showedMsgs;
    }

    public void setShowedMessages(List<Message> msgList) throws Exception {
        this.showedMsgs = msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CalendarEvent getEvent(Message msg) throws Exception {
        CalendarService calendarSrv = (CalendarService)this.getApplicationComponent(CalendarService.class);
        CalendarEvent calEvent = null;
        if (0 != Integer.parseInt(MailUtils.getEventType((Message)msg))) {
            if (1 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                return calEvent;
            }
            if (2 != Integer.parseInt(MailUtils.getEventType((Message)msg))) return calEvent;
            return calendarSrv.getGroupEvent(SessionProviderFactory.createSystemProvider(), MailUtils.getCalendarId((Message)msg), MailUtils.getCalendarEventId((Message)msg));
        }
        ArrayList<String> calIds = new ArrayList<String>();
        calIds.add(MailUtils.getCalendarId((Message)msg));
        Iterator iter = calendarSrv.getUserEventByCalendar(SessionProviderFactory.createSessionProvider(), MailUtils.getEventFrom((Message)msg), calIds).iterator();
        if (!iter.hasNext()) return calEvent;
        calEvent = (CalendarEvent)iter.next();
        if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent.getId())) return calEvent;
        return calEvent;
    }

    public Message getShowedMessageById(String id) throws Exception {
        for (Message msg : this.getShowedMessages()) {
            if (!msg.getId().equals(id)) continue;
            return msg;
        }
        return null;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }
}

