/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataPageList;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.SelectItem;
import org.exoplatform.mail.webui.SelectItemOption;
import org.exoplatform.mail.webui.SelectItemOptionGroup;
import org.exoplatform.mail.webui.UIFormSelectBox;
import org.exoplatform.mail.webui.popup.UIAddressForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddressForm.gtmpl", events={@EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchContactActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    public static final String CONTACT_SEARCH = "contact-search".intern();
    public static final String CONTACT_GROUP = "contact-group".intern();
    public Map<String, Contact> checkedList_ = new HashMap();
    public Map<String, Contact> newCheckedList_ = new HashMap();
    private String selectedAddressId_ = "";
    private String recipientsType_ = "";
    private UIPageIterator uiPageList_;

    public void setRecipientsType(String type) {
        this.recipientsType_ = type;
    }

    public String getRecipientType() {
        return this.recipientsType_;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTACT_SEARCH, CONTACT_SEARCH, null));
        UIFormSelectBox uiSelect = new UIFormSelectBox(CONTACT_GROUP, CONTACT_GROUP, this.getOptions());
        uiSelect.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelect);
        this.uiPageList_ = new UIPageIterator();
        this.uiPageList_.setId("UIMailAddressPage");
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        List groups = contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username);
        if (groups != null && groups.size() > 0) {
            String category = ((ContactGroup)groups.get(0)).getId();
            this.setContactList(category);
        }
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectItemOptionGroup personalContacts = new SelectItemOptionGroup("personal-contacts");
        for (ContactGroup pcg : contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username)) {
            personalContacts.addOption(new SelectItemOption(pcg.getName(), (Object)pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        SelectItemOptionGroup sharedContacts = new SelectItemOptionGroup("shared-contacts");
        for (SharedAddressBook scg : contactSrv.getSharedAddressBooks(SessionProviderFactory.createSystemProvider(), username)) {
            sharedContacts.addOption(new SelectItemOption(scg.getId(), (Object)scg.getName()));
        }
        options.add((SelectItem)sharedContacts);
        SelectItemOptionGroup publicContacts = new SelectItemOptionGroup("public-contacts");
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        Object[] objGroupIds = organizationService.getGroupHandler().findGroupsOfUser(username).toArray();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            groupIds.add(((GroupImpl)object).getId());
        }
        for (String publicCg : groupIds) {
            publicContacts.addOption(new SelectItemOption(publicCg, (Object)publicCg));
        }
        options.add((SelectItem)publicContacts);
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<Contact> getContacts() throws Exception {
        UIFormCheckBoxInput uiInput;
        ArrayList<Contact> contacts = new ArrayList<Contact>(this.uiPageList_.getCurrentPageData());
        for (Contact c : contacts) {
            uiInput = this.getUIFormCheckBoxInput(c.getId());
            if (uiInput != null) continue;
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(c.getId(), c.getId(), null));
        }
        for (Contact c : this.checkedList_.values()) {
            uiInput = this.getUIFormCheckBoxInput(c.getId());
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        return contacts;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageList_;
    }

    public long getAvailablePage() {
        return this.uiPageList_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageList_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageList_.setCurrentPage(page);
    }

    public void setContactList(String groupId) throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ContactFilter filter = new ContactFilter();
        if (!MailUtils.isFieldEmpty((String)groupId)) {
            filter.setCategories(new String[]{groupId});
        }
        DataPageList resultPageList = contactSrv.searchContact(SessionProviderFactory.createSystemProvider(), MailUtils.getCurrentUser(), filter);
        this.setContactList(resultPageList.getAll());
    }

    public void setContactList(List<Contact> contactList) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(contactList, 10);
        this.uiPageList_.setPageList((PageList)objPageList);
    }

    public void setAlreadyCheckedContact(List<Contact> alreadyCheckedContact) throws Exception {
        for (Contact ct : alreadyCheckedContact) {
            this.checkedList_.put(ct.getId(), ct);
        }
    }

    public List<Contact> getCheckedContact() throws Exception {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Contact contact : this.getContacts()) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }

    static /* synthetic */ String access$002(UIAddressForm x0, String x1) {
        x0.selectedAddressId_ = x1;
        return x0.selectedAddressId_;
    }

    static /* synthetic */ String access$000(UIAddressForm x0) {
        return x0.selectedAddressId_;
    }
}

