/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.popup.UIComposeForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIComposeForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DiscardChangeActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class}), @EventConfig(listeners={ToActionListener.class}), @EventConfig(listeners={ToCCActionListener.class}), @EventConfig(listeners={ToBCCActionListener.class}), @EventConfig(listeners={ChangePriorityActionListener.class}), @EventConfig(listeners={UseVisualEdiorActionListener.class}), @EventConfig(listeners={ShowCcActionListener.class}), @EventConfig(listeners={ShowBccActionListener.class})})
public class UIComposeForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_FROM_INPUT = "fromInput";
    public static final String FIELD_FROM = "from";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_TO = "to";
    public static final String FIELD_CC = "cc";
    public static final String FIELD_BCC = "bcc";
    public static final String FIELD_ATTACHMENTS = "attachments";
    public static final String FIELD_MESSAGECONTENT = "messageContent";
    public static final String ACT_TO = "To";
    public static final String ACT_CC = "ToCC";
    public static final String ACT_BCC = "ToBCC";
    public static final String ACT_REMOVE = "remove";
    public static final int MESSAGE_NEW = 0;
    public final int MESSAGE_IN_DRAFT = 1;
    public final int MESSAGE_REPLY = 2;
    public final int MESSAGE_REPLY_ALL = 3;
    public final int MESSAGE_FOWARD = 4;
    private List<Attachment> attachments_ = new ArrayList();
    private Message message_ = null;
    private long priority_ = 3L;
    private Boolean isVisualEditor = true;
    private int composeType_ = 0;
    private String accountId_;
    public String parentPath_;
    private boolean showCc_ = false;
    private boolean showBcc_ = false;
    public List<Contact> toContacts = new ArrayList();
    public List<Contact> ccContacts = new ArrayList();
    public List<Contact> bccContacts = new ArrayList();

    public boolean isVisualEditor() {
        return this.isVisualEditor;
    }

    public void setVisualEditor(boolean b) {
        this.isVisualEditor = b;
    }

    public void init(String accountId, Message msg, int composeType) throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        String username = MailUtils.getCurrentUser();
        this.accountId_ = accountId;
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        for (Account acc : mailSrv.getAccounts(SessionProviderFactory.createSystemProvider(), username)) {
            SelectItemOption itemOption = new SelectItemOption(acc.getUserDisplayName() + " &lt;" + acc.getEmailAddress() + "&gt;", (Object)acc.getId());
            if (acc.getId().equals(accountId)) {
                itemOption.setSelected(true);
            }
            options.add(itemOption);
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FROM, FIELD_FROM, options));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TO, null, null));
        UIFormTextAreaInput textAreaCC = new UIFormTextAreaInput(FIELD_CC, null, null);
        textAreaCC.setId(FIELD_CC);
        textAreaCC.setColumns(2);
        this.addUIFormInput((UIFormInput)textAreaCC);
        UIFormTextAreaInput textAreaBCC = new UIFormTextAreaInput(FIELD_BCC, null, null);
        textAreaBCC.setColumns(2);
        textAreaBCC.setId(FIELD_BCC);
        this.addUIFormInput((UIFormInput)textAreaBCC);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SUBJECT, null, null));
        UIFormInputWithActions inputSet = new UIFormInputWithActions(FIELD_FROM_INPUT);
        inputSet.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
        this.addUIFormInput((UIFormInputSet)inputSet);
        MailSetting mailSetting = mailSrv.getMailSetting(SessionProviderFactory.createSystemProvider(), username);
        this.isVisualEditor = mailSetting.useWysiwyg();
        if (this.isVisualEditor.booleanValue()) {
            this.addUIFormInput((UIFormInput)new UIFormWYSIWYGInput(FIELD_MESSAGECONTENT, null, null, true));
        } else {
            this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGECONTENT, null, null));
        }
        this.setPriority(3L);
        this.setMessage(msg, composeType);
    }

    public List<Contact> getToContacts() {
        return this.toContacts;
    }

    public List<Contact> getCcContacts() {
        return this.ccContacts;
    }

    public List<Contact> getBccContacts() {
        return this.bccContacts;
    }

    public void setToContacts(List<Contact> contactList) {
        this.toContacts = contactList;
    }

    public void setCcContacts(List<Contact> contactList) {
        this.ccContacts = contactList;
    }

    public void setBccContacts(List<Contact> contactList) {
        this.bccContacts = contactList;
    }

    public int getComposeType() {
        return this.composeType_;
    }

    public void setComposeType(int t) {
        this.composeType_ = t;
    }

    public List<UIFormInputWithActions.ActionData> getUploadFileList() throws Exception {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (Attachment attachdata : this.attachments_) {
            UIFormInputWithActions.ActionData fileUpload = new UIFormInputWithActions.ActionData();
            fileUpload.setActionListener("Download");
            fileUpload.setActionParameter(attachdata.getId());
            fileUpload.setActionType(0);
            fileUpload.setCssIconClass("AttachmentIcon");
            fileUpload.setActionName(attachdata.getName() + " (" + MailUtils.convertSize((long)attachdata.getSize()) + ")");
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(ACT_REMOVE);
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setCssIconClass("LabelLink");
            removeAction.setActionType(1);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void refreshUploadFileList() throws Exception {
        UIFormInputWithActions inputSet = (UIFormInputWithActions)this.getChildById(FIELD_FROM_INPUT);
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    public void addToUploadFileList(Attachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(Attachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void removeUploadFileList() {
        this.attachments_.clear();
    }

    public List<Attachment> getAttachFileList() {
        return this.attachments_;
    }

    public Message getMessage() {
        return this.message_;
    }

    public void setMessage(Message message, int composeType) throws Exception {
        this.setComposeType(composeType);
        this.message_ = message;
        this.fillFields(this.message_);
    }

    public void fillFields(Message msg) throws Exception {
        block16: {
            block15: {
                if (msg == null) break block15;
                MailService mailSrv = MailUtils.getMailService();
                MailSetting mailSetting = mailSrv.getMailSetting(SessionProviderFactory.createSystemProvider(), MailUtils.getCurrentUser());
                switch (this.getComposeType()) {
                    case 1: {
                        this.setFieldSubjectValue(msg.getSubject());
                        this.setFieldToValue(msg.getMessageTo());
                        this.setFieldCcValue(msg.getMessageCc());
                        this.setFieldBccValue(msg.getMessageBcc());
                        this.setFieldContentValue(this.formatContent(msg));
                        if (msg == null || !msg.hasAttachment()) break;
                        String username = MailUtils.getCurrentUser();
                        msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                        for (Attachment att : msg.getAttachments()) {
                            this.attachments_.add(att);
                            this.refreshUploadFileList();
                        }
                        break block16;
                    }
                    case 2: {
                        this.setFieldToValue(msg.getReplyTo());
                        this.setFieldSubjectValue("Re: " + msg.getSubject());
                        String content = this.getReplyContent(msg);
                        this.setFieldContentValue(content);
                        if (!mailSetting.replyWithAttach() || msg == null || !msg.hasAttachment()) break;
                        if (msg.getAttachments() == null) {
                            String username = MailUtils.getCurrentUser();
                            msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                        }
                        for (Attachment att : msg.getAttachments()) {
                            this.attachments_.add(att);
                            this.refreshUploadFileList();
                        }
                        break block16;
                    }
                    case 3: {
                        this.setFieldSubjectValue("Re: " + msg.getSubject());
                        String replyAll = msg.getReplyTo();
                        if (msg.getMessageCc() != null) {
                            replyAll = replyAll + "," + msg.getMessageCc();
                        }
                        if (msg.getMessageBcc() != null) {
                            replyAll = replyAll + "," + msg.getMessageBcc();
                        }
                        this.setFieldToValue(replyAll);
                        String replyContent = this.getReplyContent(msg);
                        this.setFieldContentValue(replyContent);
                        if (!mailSetting.replyWithAttach() || msg == null || !msg.hasAttachment()) break;
                        if (msg.getAttachments() == null) {
                            String username = MailUtils.getCurrentUser();
                            msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                        }
                        for (Attachment att : msg.getAttachments()) {
                            this.attachments_.add(att);
                            this.refreshUploadFileList();
                        }
                        break block16;
                    }
                    case 4: {
                        String toAddress = msg.getMessageTo() != null ? msg.getMessageTo() : "";
                        this.setFieldSubjectValue("Fwd: " + msg.getSubject());
                        String forwardedText = "<br><br>-------- Original Message --------<br>Subject: " + MailUtils.encodeHTML((String)msg.getSubject()) + "<br>Date: " + msg.getSendDate() + "<br> From: " + MailUtils.encodeHTML((String)msg.getFrom()) + "<br> To: " + MailUtils.encodeHTML((String)toAddress) + "<br><br>" + MailUtils.encodeHTML((String)this.formatContent(msg));
                        this.setFieldContentValue(forwardedText);
                        this.setFieldToValue("");
                        if (!mailSetting.forwardWithAtt() || msg == null || !msg.hasAttachment()) break;
                        if (msg.getAttachments() == null) {
                            String username = MailUtils.getCurrentUser();
                            msg = mailSrv.loadAttachments(SessionProviderFactory.createSystemProvider(), username, this.accountId_, msg);
                        }
                        for (Attachment att : msg.getAttachments()) {
                            this.attachments_.add(att);
                            this.refreshUploadFileList();
                        }
                        break block16;
                    }
                }
                break block16;
            }
            this.setFieldContentValue("");
        }
    }

    private String getReplyContent(Message msg) throws Exception {
        String msgContent;
        String content = msgContent = this.formatContent(msg);
        if (this.isVisualEditor.booleanValue()) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            Locale locale = context.getParentAppRequestContext().getLocale();
            content = "<br><br><div> On " + MailUtils.formatDate((String)"MMM dd, yyyy HH:mm aaa", (Date)msg.getSendDate(), (Locale)locale) + ", " + msg.getFrom() + " wrote: <br>";
            content = content + "<blockquote style=\"border-left:1px #cccccc solid ; margin-left: 10px; padding-left: 5px;\">" + msgContent + "</blockquote></div>";
        }
        return content;
    }

    private String formatContent(Message msg) throws Exception {
        String msgContent = msg.getMessageBody();
        if (msg.getContentType().indexOf("text/plain") > -1) {
            msgContent = MailUtils.encodeHTML((String)msg.getMessageBody()).replace("\n", "<br>");
        }
        return msgContent;
    }

    public long getPriority() {
        return this.priority_;
    }

    public void setPriority(long priority) {
        this.priority_ = priority;
    }

    public String getFieldFromValue() {
        return (String)this.getUIFormSelectBox(FIELD_FROM).getValue();
    }

    public String getFieldSubjectValue() {
        String subject = (String)this.getUIStringInput(FIELD_SUBJECT).getValue();
        if (subject == null) {
            subject = "(no subject)";
        }
        return subject;
    }

    public void setFieldSubjectValue(String value) {
        this.getUIStringInput(FIELD_SUBJECT).setValue((Object)value);
    }

    public String getFieldToValue() {
        return (String)this.getUIStringInput(FIELD_TO).getValue();
    }

    public void setFieldToValue(String value) {
        this.getUIStringInput(FIELD_TO).setValue((Object)value);
    }

    public String getFieldCcValue() {
        return (String)this.getUIFormTextAreaInput(FIELD_CC).getValue();
    }

    public void setFieldCcValue(String value) {
        this.getUIFormTextAreaInput(FIELD_CC).setValue((Object)value);
    }

    public String getFieldBccValue() {
        return (String)this.getUIFormTextAreaInput(FIELD_BCC).getValue();
    }

    public void setFieldBccValue(String value) {
        this.getUIFormTextAreaInput(FIELD_BCC).setValue((Object)value);
    }

    public String getFieldAttachmentsValue() {
        UIFormInputWithActions inputSet = (UIFormInputWithActions)this.getChildById(FIELD_FROM_INPUT);
        return (String)inputSet.getUIFormInputInfo(FIELD_ATTACHMENTS).getValue();
    }

    public String getFieldContentValue() {
        String content = "";
        content = this.isVisualEditor != false ? (String)((UIFormWYSIWYGInput)this.getChild(UIFormWYSIWYGInput.class)).getValue() : (String)this.getUIFormTextAreaInput(FIELD_MESSAGECONTENT).getValue();
        if (content == null) {
            content = "";
        }
        return content;
    }

    public void setFieldContentValue(String value) throws Exception {
        String username = MailUtils.getCurrentUser();
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        Account account = mailSrv.getAccountById(SessionProviderFactory.createSystemProvider(), username, this.accountId_);
        if (this.isVisualEditor.booleanValue()) {
            if (!MailUtils.isFieldEmpty((String)account.getSignature()) && !this.fromDrafts()) {
                value = value + "<br><br> -- <br >" + account.getSignature().replace("\n", "<br>") + "";
            }
            ((UIFormWYSIWYGInput)this.getChild(UIFormWYSIWYGInput.class)).setValue((Object)value);
        } else {
            if (!MailUtils.isFieldEmpty((String)account.getSignature())) {
                value = value + "\n\n -- \n" + account.getSignature();
            }
            this.getUIFormTextAreaInput(FIELD_MESSAGECONTENT).setValue((Object)value);
        }
    }

    public List<Contact> getContacts() throws Exception {
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        String username = MailUtils.getCurrentUser();
        return contactSrv.getAllContact(SessionProviderFactory.createSystemProvider(), username);
    }

    public void resetFields() {
        this.reset();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private Message getNewMessage() throws Exception {
        String bcc;
        String cc;
        Message message = this.getMessage();
        if (!this.fromDrafts()) {
            if (message != null) {
                this.parentPath_ = message.getPath();
            }
            message = new Message();
        }
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String usename = uiPortlet.getCurrentUser();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        Account account = mailSvr.getAccountById(SessionProviderFactory.createSystemProvider(), usename, this.getFieldFromValue());
        String from = account.getUserDisplayName() + "<" + account.getEmailAddress() + ">";
        String subject = this.getFieldSubjectValue();
        String to = this.getFieldToValue();
        if (to != null && to.indexOf(";") > -1) {
            to = to.replace(';', ',');
        }
        if ((cc = this.getFieldCcValue()) != null && cc.indexOf(";") > -1) {
            cc = cc.replace(';', ',');
        }
        if ((bcc = this.getFieldBccValue()) != null && bcc.indexOf(";") > -1) {
            bcc = bcc.replace(';', ',');
        }
        String body = this.getFieldContentValue();
        Long priority = this.getPriority();
        message.setSendDate(new Date());
        message.setAccountId(this.accountId_);
        message.setFrom(from);
        String contentType = Utils.MIMETYPE_TEXTHTML;
        if (!this.isVisualEditor()) {
            contentType = Utils.MIMETYPE_TEXTPLAIN;
        }
        message.setContentType(contentType);
        message.setSubject(subject);
        message.setMessageTo(to);
        message.setMessageCc(cc);
        if (message.getReceivedDate() == null) {
            message.setReceivedDate(new Date());
        }
        message.setMessageBcc(bcc);
        message.setHasStar(false);
        message.setPriority(priority.longValue());
        message.setAttachements(this.getAttachFileList());
        message.setMessageBody(body);
        message.setUnread(false);
        message.setSize((long)body.getBytes().length);
        message.setReplyTo(account.getEmailReplyAddress());
        if (this.getComposeType() == 2 || this.getComposeType() == 3 || this.getComposeType() == 4) {
            message.setHeader(Utils.HEADER_IN_REPLY_TO, this.getMessage().getId());
        }
        return message;
    }

    public boolean fromDrafts() {
        return this.getMessage() != null && this.getMessage().getFolders()[0].equals(Utils.createFolderId((String)this.accountId_, (String)Utils.FD_DRAFTS, (boolean)false)) || this.getComposeType() == 1;
    }

    static /* synthetic */ Message access$000(UIComposeForm x0) throws Exception {
        return x0.getNewMessage();
    }

    static /* synthetic */ List access$100(UIComposeForm x0) {
        return x0.attachments_;
    }

    static /* synthetic */ boolean access$202(UIComposeForm x0, boolean x1) {
        x0.showCc_ = x1;
        return x0.showCc_;
    }

    static /* synthetic */ boolean access$200(UIComposeForm x0) {
        return x0.showCc_;
    }

    static /* synthetic */ boolean access$302(UIComposeForm x0, boolean x1) {
        x0.showBcc_ = x1;
        return x0.showBcc_;
    }

    static /* synthetic */ boolean access$300(UIComposeForm x0) {
        return x0.showBcc_;
    }
}

