/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFormDateTimePicker;
import org.exoplatform.mail.webui.UIFormInputWithActions;
import org.exoplatform.mail.webui.popup.UIAccountCreation;
import org.exoplatform.mail.webui.popup.UIAccountSetting;
import org.exoplatform.mail.webui.popup.UIFetchOptionsInputSet;
import org.exoplatform.mail.webui.popup.UIOutgoingInputSet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAccountSetting.gtmpl", events={@EventConfig(listeners={SelectAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddNewAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteAccountActionListener.class}, phase=Event.Phase.DECODE, confirm="UIAccountSetting.msg.confirm-remove-account"), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeSSLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOutgoingSSLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CheckFromDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={IsCustomInboxActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAccountSetting
extends UIFormTabPane {
    public static final String TAB_IDENTITY_SETTINGS = "identitySettings";
    public static final String TAB_INCOMING = "incoming";
    public static final String TAB_OUTGOING = "outgoing";
    public static final String TAB_FETCH_OPTIONS = "fetchOptions";
    public static final String FIELD_ACCOUNT_NAME = "accountName";
    public static final String FIELD_DISPLAY_NAME = "display-name".intern();
    public static final String FIELD_INCOMING_USERNAME = "incomingUsername";
    public static final String FIELD_OUTGOING_NAME = "yourOutgoingName";
    public static final String FIELD_EMAIL_ADDRESS = "yourEmailAddress";
    public static final String FIELD_INCOMING_ACCOUNT = "incomingAccount";
    public static final String FIELD_INCOMING_PASSWORD = "incomingPassword";
    public static final String FIELD_REPLYTO_ADDRESS = "replyToAddress";
    public static final String FIELD_MAIL_SIGNATURE = "mailSignature";
    public static final String FIELD_SERVER_TYPE = "serverType";
    public static final String FIELD_INCOMING_SERVER = "incomingServer";
    public static final String FIELD_INCOMING_PORT = "incomingPort";
    public static final String FIELD_OUTGOING_SERVER = "outgoingServer";
    public static final String FIELD_OUTGOING_PORT = "outgoingPort";
    public static final String FIELD_INCOMING_FOLDER = "messageComeInFolder";
    public static final String FIELD_IS_INCOMING_SSL = "isSSL";
    public static final String FIELD_IS_OUTGOING_SSL = "isOutgoingSsl";
    public static final String IS_OUTGOING_AUTHENTICATION = "isOutgoingAuthentication";
    public static final String USE_INCOMINGSETTING_FOR_OUTGOING_AUTHEN = "useIncomingSettingForOutgoingAuthent";
    public static final String OUTGOING_USERNAME = "outgoingUsername";
    public static final String OUTGOING_PASSWORD = "outgoingPassword";
    public static final String FIELD_CHECKMAIL_AUTO = "checkMailAutomatically";
    public static final String FIELD_LEAVE_ON_SERVER = "leaveMailOnServer";
    public static final String FIELD_IS_SAVE_PASSWORD = "isSavePassword";
    private String accountId_ = null;
    UIFormCheckBoxInput<Boolean> leaveOnServer_;
    public static final String CHECK_FROM_DATE = "checkFromDate";
    public static final String FROM_DATE = "fromDate";
    public static final String IS_CUSTOM_INBOX = "isCustomInbox";

    public UIAccountSetting() throws Exception {
        super("UIAccountSetting");
        UIFormInputWithActions identityInputSet = new UIFormInputWithActions(TAB_IDENTITY_SETTINGS);
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_ACCOUNT_NAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_DISPLAY_NAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EMAIL_ADDRESS, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_REPLYTO_ADDRESS, null, null));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MAIL_SIGNATURE, null, null));
        this.addUIFormInput((UIFormInputSet)identityInputSet);
        UIFormInputWithActions incomingInputSet = new UIFormInputWithActions(TAB_INCOMING);
        UIFormSelectBox serverType = new UIFormSelectBox(FIELD_SERVER_TYPE, null, this.getServerTypeValues());
        serverType.setEditable(false);
        serverType.setEnable(false);
        incomingInputSet.addUIFormInput((UIFormInput)serverType);
        incomingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        incomingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_PORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        incomingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_ACCOUNT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormStringInput passwordField = new UIFormStringInput(FIELD_INCOMING_PASSWORD, null, null);
        passwordField.setType((short)1);
        passwordField.addValidator(MandatoryValidator.class, new Object[0]);
        incomingInputSet.addUIFormInput((UIFormInput)passwordField);
        incomingInputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD, null, null));
        UIFormCheckBoxInput ssl = new UIFormCheckBoxInput(FIELD_IS_INCOMING_SSL, null, null);
        ssl.setOnChange("ChangeSSL");
        incomingInputSet.addUIFormInput((UIFormInput)ssl);
        UIOutgoingInputSet outGoingInputSet = new UIOutgoingInputSet(TAB_OUTGOING);
        outGoingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_OUTGOING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        outGoingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_OUTGOING_PORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormCheckBoxInput outgoingssl = new UIFormCheckBoxInput(FIELD_IS_OUTGOING_SSL, null, null);
        outgoingssl.setOnChange("ChangeOutgoingSSL");
        outGoingInputSet.addUIFormInput((UIFormInput)outgoingssl);
        UIFormCheckBoxInput isOutgoingAuthen = new UIFormCheckBoxInput(IS_OUTGOING_AUTHENTICATION, null, null);
        outGoingInputSet.addUIFormInput((UIFormInput)isOutgoingAuthen);
        UIFormCheckBoxInput useIncomingSetting = new UIFormCheckBoxInput(USE_INCOMINGSETTING_FOR_OUTGOING_AUTHEN, null, null);
        outGoingInputSet.addUIFormInput((UIFormInput)useIncomingSetting);
        outGoingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(OUTGOING_USERNAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        outGoingInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(OUTGOING_PASSWORD, null, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]));
        UIFetchOptionsInputSet fetchOptionsInputSet = new UIFetchOptionsInputSet(TAB_FETCH_OPTIONS);
        fetchOptionsInputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO, null, null));
        this.leaveOnServer_ = new UIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER, null, null);
        fetchOptionsInputSet.addUIFormInput((UIFormInput)this.leaveOnServer_);
        UIFormCheckBoxInput checkFromDate = new UIFormCheckBoxInput(CHECK_FROM_DATE, CHECK_FROM_DATE, null);
        checkFromDate.setOnChange("CheckFromDate");
        fetchOptionsInputSet.addUIFormInput((UIFormInput)checkFromDate);
        fetchOptionsInputSet.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FROM_DATE, FROM_DATE, null, true));
        UIFormCheckBoxInput isCustomInbox = new UIFormCheckBoxInput(IS_CUSTOM_INBOX, IS_CUSTOM_INBOX, null);
        isCustomInbox.setOnChange("IsCustomInbox");
        fetchOptionsInputSet.addUIFormInput((UIFormInput)isCustomInbox);
        fetchOptionsInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_FOLDER, null, null));
        this.addUIFormInput((UIFormInputSet)incomingInputSet);
        this.addUIFormInput((UIFormInputSet)outGoingInputSet);
        this.addUIFormInput((UIFormInputSet)fetchOptionsInputSet);
        this.setSelectedTab(identityInputSet.getId());
    }

    private List<SelectItemOption<String>> getServerTypeValues() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(Utils.POP3, (Object)Utils.POP3));
        options.add(new SelectItemOption(Utils.IMAP, (Object)Utils.IMAP));
        return options;
    }

    public String getSelectedAccountId() throws Exception {
        return this.accountId_;
    }

    public void setSelectedAccountId(String accountId) throws Exception {
        this.accountId_ = accountId;
    }

    public String getFieldAccountNameValue() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_ACCOUNT_NAME).getValue();
    }

    public String getDisplayName() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_DISPLAY_NAME).getValue();
    }

    public String getFieldMailAddress() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_EMAIL_ADDRESS).getValue();
    }

    public String getFieldProtocol() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return (String)uiInput.getUIFormSelectBox(FIELD_SERVER_TYPE).getValue();
    }

    public String getFieldIncomingAccount() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_ACCOUNT).getValue();
    }

    public String getFieldIncomingPassword() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_PASSWORD).getValue();
    }

    public String getFieldIncomingServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_SERVER).getValue();
    }

    public String getFieldIncomingPort() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_PORT).getValue();
    }

    public String getFieldOutgoingServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return (String)uiInput.getUIStringInput(FIELD_OUTGOING_SERVER).getValue();
    }

    public String getFieldOutgoingPort() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return (String)uiInput.getUIStringInput(FIELD_OUTGOING_PORT).getValue();
    }

    public String getFieldMailSignature() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_MAIL_SIGNATURE).getValue();
    }

    public String getOutgoingUser() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return (String)uiInput.getUIStringInput(OUTGOING_USERNAME).getValue();
    }

    public String getOutgoingPassword() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return (String)uiInput.getUIStringInput(OUTGOING_PASSWORD).getValue();
    }

    public boolean isOutgoingAuthen() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return uiInput.getUIFormCheckBoxInput(IS_OUTGOING_AUTHENTICATION).isChecked();
    }

    public boolean useIncomingSettingForOutgoingAuthen() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return uiInput.getUIFormCheckBoxInput(USE_INCOMINGSETTING_FOR_OUTGOING_AUTHEN).isChecked();
    }

    public boolean isSavePassword() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return uiInput.getUIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD).isChecked();
    }

    public String getFieldReplyAddress() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_REPLYTO_ADDRESS).getValue();
    }

    public String getFieldIncomingFolder() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_FOLDER).getValue();
    }

    public boolean getFieldIsSSL() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        return uiInput.getUIFormCheckBoxInput(FIELD_IS_INCOMING_SSL).isChecked();
    }

    public boolean getFieldOutgoingSSL() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        return uiInput.getUIFormCheckBoxInput(FIELD_IS_OUTGOING_SSL).isChecked();
    }

    public boolean getFieldCheckMailAuto() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return uiInput.getUIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO).isChecked();
    }

    public boolean getFieldCheckFromDate() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return uiInput.getUIFormCheckBoxInput(CHECK_FROM_DATE).isChecked();
    }

    public boolean isCustomInbox() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return uiInput.getUIFormCheckBoxInput(IS_CUSTOM_INBOX).isChecked();
    }

    public Calendar getFieldCheckFrom() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return ((UIFormDateTimePicker)uiInput.getChildById(FROM_DATE)).getCalendar();
    }

    public boolean getFieldLeaveOnServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        return uiInput.getUIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER).isChecked();
    }

    public void fillField() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        Account account = mailSrv.getAccountById(username, this.getSelectedAccountId());
        UIFormInputWithActions uiIdentityInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        uiIdentityInput.getUIStringInput(FIELD_ACCOUNT_NAME).setValue((Object)account.getLabel());
        uiIdentityInput.getUIStringInput(FIELD_DISPLAY_NAME).setValue((Object)account.getUserDisplayName());
        uiIdentityInput.getUIStringInput(FIELD_EMAIL_ADDRESS).setValue((Object)account.getEmailAddress());
        uiIdentityInput.getUIStringInput(FIELD_REPLYTO_ADDRESS).setValue((Object)account.getEmailReplyAddress());
        uiIdentityInput.getUIStringInput(FIELD_MAIL_SIGNATURE).setValue((Object)account.getSignature());
        UIFormInputWithActions uiIncomingInput = (UIFormInputWithActions)this.getChildById(TAB_INCOMING);
        uiIncomingInput.getUIStringInput(FIELD_INCOMING_SERVER).setValue((Object)account.getIncomingHost());
        uiIncomingInput.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)account.getIncomingPort());
        uiIncomingInput.getUIFormCheckBoxInput(FIELD_IS_INCOMING_SSL).setChecked(account.isIncomingSsl());
        uiIncomingInput.getUIStringInput(FIELD_INCOMING_ACCOUNT).setValue((Object)account.getIncomingUser());
        uiIncomingInput.getUIStringInput(FIELD_INCOMING_PASSWORD).setValue((Object)account.getIncomingPassword());
        uiIncomingInput.getUIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD).setChecked(account.isSavePassword());
        UIFormInputWithActions uiOutgoingInput = (UIFormInputWithActions)this.getChildById(TAB_OUTGOING);
        uiOutgoingInput.getUIStringInput(FIELD_OUTGOING_SERVER).setValue((Object)account.getOutgoingHost());
        uiOutgoingInput.getUIStringInput(FIELD_OUTGOING_PORT).setValue((Object)account.getOutgoingPort());
        uiOutgoingInput.getUIFormCheckBoxInput(FIELD_IS_OUTGOING_SSL).setChecked(account.isOutgoingSsl());
        uiOutgoingInput.getUIFormCheckBoxInput(IS_OUTGOING_AUTHENTICATION).setChecked(account.isOutgoingAuthentication());
        uiOutgoingInput.getUIFormCheckBoxInput(USE_INCOMINGSETTING_FOR_OUTGOING_AUTHEN).setChecked(account.useIncomingSettingForOutgoingAuthent());
        if (account.useIncomingSettingForOutgoingAuthent()) {
            uiOutgoingInput.getUIStringInput(OUTGOING_USERNAME).setEnable(false).setValue((Object)account.getIncomingUser());
            uiOutgoingInput.getUIStringInput(OUTGOING_PASSWORD).setEnable(false).setValue((Object)account.getIncomingPassword());
        } else {
            uiOutgoingInput.getUIStringInput(OUTGOING_USERNAME).setValue((Object)account.getOutgoingUserName());
            uiOutgoingInput.getUIStringInput(OUTGOING_PASSWORD).setValue((Object)account.getOutgoingPassword());
        }
        UIFormInputWithActions uifetchOptionsInput = (UIFormInputWithActions)this.getChildById(TAB_FETCH_OPTIONS);
        uifetchOptionsInput.getUIFormCheckBoxInput(CHECK_FROM_DATE).setChecked(!account.isCheckAll());
        if (account.isCheckAll()) {
            ((UIFormDateTimePicker)uifetchOptionsInput.getChildById(FROM_DATE)).setEditable(false);
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(account.getCheckFromDate());
            ((UIFormDateTimePicker)uifetchOptionsInput.getChildById(FROM_DATE)).setCalendar((Calendar)cal);
        }
        uifetchOptionsInput.getUIFormCheckBoxInput(IS_CUSTOM_INBOX).setChecked(account.isCustomInbox());
        if (this.isCustomInbox()) {
            uifetchOptionsInput.getUIStringInput(FIELD_INCOMING_FOLDER).setEnable(true).setValue((Object)account.getIncomingFolder());
        } else {
            uifetchOptionsInput.getUIStringInput(FIELD_INCOMING_FOLDER).setEnable(false).setValue((Object)account.getIncomingFolder());
        }
        uiIncomingInput.getUIFormSelectBox(FIELD_SERVER_TYPE).setValue(account.getProtocol());
        uifetchOptionsInput.getUIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO).setChecked(account.checkedAuto());
        uifetchOptionsInput.getUIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER).setChecked(Boolean.valueOf((String)account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER)).booleanValue());
    }

    public void setDefaultValue(String serverType, boolean isSSL) {
        if (serverType.equals(Utils.POP3)) {
            if (isSSL) {
                this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_POPSSL_PORT);
            } else {
                this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_POP_PORT);
            }
        } else if (isSSL) {
            this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_IMAPSSL_PORT);
        } else {
            this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_IMAP_PORT);
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public List<Account> getAccounts() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        return mailSrv.getAccounts(username);
    }
}

