/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.WizardStep;
import org.exoplatform.mail.webui.popup.UIAccountCreation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIAccountWizardStep3
extends UIFormInputSet
implements WizardStep {
    public static final String FIELD_SERVERTYPE = "serverType";
    public static final String FIELD_INCOMING_SERVER = "incomingServer";
    public static final String FIELD_INCOMINGPORT = "incomingPort";
    public static final String FIELD_OUTGOING_SERVER = "outgoingServer";
    public static final String FIELD_OUTGOINGPORT = "outgoingPort";
    public static final String FIELD_USESSL = "isSsl".intern();
    public static final String FIELD_OUTGOING_SSL = "outgoingSsl".intern();
    public static final String FIELD_STOREFOLDER = "storeFolder";
    public boolean isValid_ = false;
    private List<String> infoMessage_ = new ArrayList();

    public UIAccountWizardStep3(String id) throws Exception {
        super(id);
        this.setComponentConfig(this.getClass(), null);
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_SERVERTYPE, null, this.getServerTypeValues()));
        UIFormSelectBox uiSelect = this.getUIFormSelectBox(FIELD_SERVERTYPE);
        uiSelect.setOnChange(UIAccountCreation.ACT_CHANGE_TYPE);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_INCOMING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_INCOMINGPORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_USESSL, null, null));
        UIFormCheckBoxInput uiCheckBox = this.getUIFormCheckBoxInput(FIELD_USESSL);
        uiCheckBox.setOnChange(UIAccountCreation.ACT_CHANGE_SSL);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_OUTGOING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_OUTGOINGPORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_OUTGOING_SSL, null, null));
        UIFormCheckBoxInput outgoingSsl = this.getUIFormCheckBoxInput(FIELD_OUTGOING_SSL);
        outgoingSsl.setOnChange(UIAccountCreation.ACT_CHANGE_OUTGOINGSSL);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_STOREFOLDER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.setDefaultValue((String)uiSelect.getValue(), uiCheckBox.isChecked());
        this.resetFields();
        this.infoMessage_.clear();
        this.infoMessage_.add("UIAccountWizardStep3.info.label1");
        this.infoMessage_.add("UIAccountWizardStep3.info.label2");
        this.infoMessage_.add("UIAccountWizardStep3.info.label3");
    }

    public List<String> getInfoMessage() {
        return this.infoMessage_;
    }

    protected void setDefaultValue(String serverType, boolean isSSL) {
        this.getUIStringInput(FIELD_INCOMINGPORT).setRendered(false);
        this.getUIStringInput(FIELD_OUTGOINGPORT).setRendered(false);
        this.getUIStringInput(FIELD_STOREFOLDER).setRendered(false);
        if (serverType.equals(Utils.POP3)) {
            this.getUIStringInput(FIELD_INCOMING_SERVER).setValue((Object)UIAccountCreation.DEFAULT_POP_SERVER);
            if (isSSL) {
                this.getUIStringInput(FIELD_INCOMINGPORT).setValue((Object)UIAccountCreation.DEFAULT_POPSSL_PORT);
            } else {
                this.getUIStringInput(FIELD_INCOMINGPORT).setValue((Object)UIAccountCreation.DEFAULT_POP_PORT);
            }
        } else {
            this.getUIStringInput(FIELD_INCOMING_SERVER).setValue((Object)UIAccountCreation.DEFAULT_IMAP_SERVER);
            if (isSSL) {
                this.getUIStringInput(FIELD_INCOMINGPORT).setValue((Object)UIAccountCreation.DEFAULT_IMAPSSL_PORT);
            } else {
                this.getUIStringInput(FIELD_INCOMINGPORT).setValue((Object)UIAccountCreation.DEFAULT_IMAP_PORT);
            }
        }
    }

    public boolean isFieldsValid() {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        boolean isValid = true;
        if (Utils.isEmptyField((String)this.getIncomingServer())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountCreation.msg.incoming-server-requirement", null, 1));
            isValid = false;
        }
        if (Utils.isEmptyField((String)this.getOutgoingServer())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountCreation.msg.outgoing-server-requirement", null, 1));
            isValid = false;
        }
        if (Utils.isEmptyField((String)this.getStoreFolder())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountCreation.msg.store-folder-requirement", null, 1));
            isValid = false;
        }
        if (!Utils.isNumber((String)this.getIncomingPort())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountCreation.msg.incoming-port-is-not-number", null, 1));
            isValid = false;
        }
        if (!Utils.isNumber((String)this.getOutgoingPort())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountCreation.msg.outgoing-port-is-not-number", null, 1));
            isValid = false;
        }
        return isValid;
    }

    protected void fieldsValid(boolean isValid) {
        this.isValid_ = isValid;
    }

    protected void lockFields(boolean isLock) {
        boolean isEditable = !isLock;
        this.getUIFormSelectBox(FIELD_SERVERTYPE).setEnable(isEditable);
        this.getUIStringInput(FIELD_INCOMING_SERVER).setEditable(isEditable);
        this.getUIStringInput(FIELD_OUTGOING_SERVER).setEditable(isEditable);
        this.getUIStringInput(FIELD_STOREFOLDER).setEditable(isEditable);
    }

    protected void resetFields() {
        this.reset();
        this.setIncomingServer(UIAccountCreation.DEFAULT_IMAP_SERVER);
        this.setIncomingPort(UIAccountCreation.DEFAULT_IMAP_PORT);
        this.setOutgoingServer(UIAccountCreation.DEFAULT_SMTP_SERVER);
        this.setOutgoingPort(UIAccountCreation.DEFAULT_SMTP_PORT);
        this.setStoreFolder(UIAccountCreation.DEFAULT_SERVER_FOLDER);
    }

    protected void fillFields(String serverType, boolean isSsl, String incomingServer, String popPort, String outgoingServer, String smtpPort, boolean outgoingSsl, String storeFolder) {
        this.setServerType(serverType);
        this.setIncomingServer(incomingServer);
        this.setIncomingPort(popPort);
        this.setOutgoingServer(outgoingServer);
        this.setOutgoingPort(smtpPort);
        this.setOutgoingSsl(outgoingSsl);
        this.setStoreFolder(storeFolder);
        this.setIsSSL(isSsl);
    }

    protected String getServerType() {
        return (String)this.getUIFormSelectBox(FIELD_SERVERTYPE).getValue();
    }

    protected void setServerType(String value) {
        this.getUIFormSelectBox(FIELD_SERVERTYPE).setValue(value);
    }

    protected String getIncomingServer() {
        return (String)this.getUIStringInput(FIELD_INCOMING_SERVER).getValue();
    }

    protected void setIncomingServer(String value) {
        this.getUIStringInput(FIELD_INCOMING_SERVER).setValue((Object)value);
    }

    protected String getIncomingPort() {
        return (String)this.getUIStringInput(FIELD_INCOMINGPORT).getValue();
    }

    protected void setIncomingPort(String value) {
        this.getUIStringInput(FIELD_INCOMINGPORT).setValue((Object)value);
    }

    protected String getOutgoingServer() {
        return (String)this.getUIStringInput(FIELD_OUTGOING_SERVER).getValue();
    }

    protected void setOutgoingServer(String value) {
        this.getUIStringInput(FIELD_OUTGOING_SERVER).setValue((Object)value);
    }

    protected String getOutgoingPort() {
        return (String)this.getUIStringInput(FIELD_OUTGOINGPORT).getValue();
    }

    protected boolean getOutgoingSsl() {
        return this.getUIFormCheckBoxInput(FIELD_OUTGOING_SSL).isChecked();
    }

    protected void setOutgoingPort(String value) {
        this.getUIStringInput(FIELD_OUTGOINGPORT).setValue((Object)value);
    }

    protected boolean getIsSSL() {
        return this.getUIFormCheckBoxInput(FIELD_USESSL).isChecked();
    }

    protected void setIsSSL(boolean value) {
        this.getUIFormCheckBoxInput(FIELD_USESSL).setChecked(value);
    }

    protected void setOutgoingSsl(boolean value) {
        this.getUIFormCheckBoxInput(FIELD_OUTGOING_SSL).setChecked(value);
    }

    protected String getStoreFolder() {
        return (String)this.getUIStringInput(FIELD_STOREFOLDER).getValue();
    }

    protected void setStoreFolder(String value) {
        this.getUIStringInput(FIELD_STOREFOLDER).setValue((Object)value);
    }

    private List<SelectItemOption<String>> getServerTypeValues() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(Utils.IMAP, (Object)Utils.IMAP));
        options.add(new SelectItemOption(Utils.POP3, (Object)Utils.POP3));
        return options;
    }

    public void fillFields(Account acc) {
        boolean isSSL = false;
        boolean isOutgoingSsl = false;
        String serverType = acc.getProtocol();
        String storeFolder = acc.getIncomingFolder();
        isSSL = Boolean.parseBoolean((String)acc.getServerProperties().get(Utils.SVR_INCOMING_SSL));
        String incomingServer = (String)acc.getServerProperties().get(Utils.SVR_INCOMING_HOST);
        String popPort = (String)acc.getServerProperties().get(Utils.SVR_INCOMING_PORT);
        String outgoingServer = (String)acc.getServerProperties().get(Utils.SVR_SMTP_HOST);
        isOutgoingSsl = Boolean.parseBoolean((String)acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL));
        String smtpPort = (String)acc.getServerProperties().get(Utils.SVR_SMTP_PORT);
        this.fillFields(serverType, isSSL, incomingServer, popPort, outgoingServer, smtpPort, isOutgoingSsl, storeFolder);
    }
}

